/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.yura.grasshopper.util.StdOutErrLevel;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger("LOS");
    private Level level;

    public LoggingOutputStream(Level level) {
        this.level = level;
    }

    public synchronized void flush() throws IOException {
        String record = this.toString();
        if (record.endsWith("\r\n") || record.endsWith("\n") || record.endsWith(lineSeparator)) {
            super.reset();
            record = record.endsWith("\r\n") ? record.substring(0, record.length() - 2) : (record.endsWith("\n") ? record.substring(0, record.length() - 1) : record.substring(0, record.length() - lineSeparator.length()));
            StackTraceElement source = this.level == StdOutErrLevel.STDERR ? LoggingOutputStream.findSourceStackElement() : null;
            logger.logp(this.level, source == null ? null : source.getClassName(), source == null ? null : source.getMethodName(), record);
        }
    }

    private static StackTraceElement findSourceStackElement() {
        try {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            boolean printStackTraceFound = false;
            boolean printStreamFound = false;
            StackTraceElement printElement = null;
            for (int c = 0; c < stackTraceElements.length; ++c) {
                StackTraceElement stackTraceElement = stackTraceElements[c];
                if ("java.lang.Throwable".equals(stackTraceElement.getClassName()) && "printStackTrace".equals(stackTraceElement.getMethodName())) {
                    printStackTraceFound = true;
                } else if (printStackTraceFound) {
                    return stackTraceElement;
                }
                boolean lastPrintStreamFound = printStreamFound;
                printStreamFound = "java.io.PrintStream".equals(stackTraceElement.getClassName());
                if (!lastPrintStreamFound || printStreamFound) continue;
                printElement = stackTraceElement;
            }
            return printElement;
        }
        catch (Throwable th) {
            return null;
        }
    }
}

