/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.util;

import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.submitter.BugSubmitter;
import net.yura.grasshopper.util.ReallySimpleFormatter;
import net.yura.grasshopper.util.StdOutErrLevel;

public class TextHandler
extends Handler {
    private boolean doneHeader;
    private Writer writer;
    private Level pushLevel;
    private BugManager sps;
    private boolean printStackTrace;

    public TextHandler(Writer writer, Level pushLevel, BugManager sps) {
        this.writer = writer;
        this.pushLevel = pushLevel;
        this.sps = sps;
        this.setFormatter(new ReallySimpleFormatter());
    }

    public void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(msg);
            this.writer.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
        boolean previousPrintStackTrace = this.printStackTrace;
        this.printStackTrace = StdOutErrLevel.STDERR.equals(record.getLevel());
        if (record.getLevel().intValue() >= this.pushLevel.intValue()) {
            try {
                if (previousPrintStackTrace && this.printStackTrace && record.getMessage() != null && (record.getMessage().startsWith("\tat ") || record.getMessage().matches("\\t\\.\\.\\. \\d+ more"))) {
                    return;
                }
                if (BugSubmitter.shouldIgnoreError(record)) {
                    return;
                }
            }
            catch (Exception ex) {
                this.reportError(null, ex, 0);
            }
            String errorSignature = null;
            try {
                errorSignature = this.generateErrorSignature(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 0);
            }
            try {
                this.sps.fireAction(errorSignature);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 0);
            }
        }
    }

    String generateErrorSignature(LogRecord record) {
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            StringBuilder sig = new StringBuilder();
            for (int c = 0; c < stackTrace.length; ++c) {
                StackTraceElement line = stackTrace[c];
                if (line.getLineNumber() <= 0 || this.isSystemClass(line.getClassName())) continue;
                sig.append(line);
                sig.append(" ");
            }
            if (sig.length() > 0) {
                return sig.substring(0, Math.min(1000, sig.length() - 1));
            }
        }
        String sourceClassName = record.getSourceClassName();
        String sourceMethodName = record.getSourceMethodName();
        Object[] param = record.getParameters();
        return record.getLoggerName() + " " + (sourceClassName != null || sourceMethodName != null ? "(" + sourceClassName + " " + sourceMethodName + ") " : "") + record.getLevel() + " " + record.getMessage() + (param == null ? "" : " " + Arrays.asList(param).toString()) + " " + record.getResourceBundleName();
    }

    boolean isSystemClass(String aClass) {
        return aClass.startsWith("java.") || aClass.startsWith("javax.swing.") || aClass.startsWith("android.") || aClass.startsWith("com.android.") || aClass.startsWith("libcore.") || aClass.startsWith("dalvik.");
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 3);
        }
        this.writer = null;
    }
}

