/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Component;

public class ImageManager {
    public final Map images = Collections.synchronizedMap(new WeakHashMap());
    public final int w;
    public final int h;

    public ImageManager(int width, int height) {
        this.w = width;
        this.h = height;
    }

    private void put(Object key, LazyIcon icon) {
        this.images.put(key, icon);
    }

    public LazyIcon get(Object key) {
        LazyIcon icon = (LazyIcon)((Object)this.images.get(key));
        if (icon != null) {
            this.put(key, icon);
        }
        return icon;
    }

    public Icon newIcon(Object key) {
        LazyIcon icon = new LazyIcon(this.w, this.h);
        this.put(key, icon);
        return icon;
    }

    public void gotImg(Object key, Image img) {
        LazyIcon icon = this.get(key);
        if (icon != null) {
            if (img != null) {
                icon.setImage(img);
            } else {
                System.out.println("ERROR: got null responce for key: " + key);
                this.images.remove(key);
            }
        } else {
            System.out.println("ERROR: gotImg, but have no LazyIcon for key: " + key + " in " + this.images);
            Thread.dumpStack();
        }
    }

    public static class LazyIcon
    extends Icon {
        Image img;

        public LazyIcon(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public void setImage(Image img) {
            this.img = img;
        }

        public Image getImage() {
            return this.img;
        }

        public void paintIcon(Component c, Graphics2D g, int x, int y) {
            if (this.img != null) {
                g.drawScaledImage(this.img, x, y, this.width, this.height);
            }
        }
    }
}

