/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.audio;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yura.domination.audio.AudioSystem;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GameSound
extends RiskAdapter {
    private static final Logger LOGGER = Logger.getLogger(GameSound.class.getName());
    public static final GameSound INSTANCE = new GameSound();
    public static final String MUSIC_MENU = "music_menu";
    public static final String MUSIC_SETUP = "music_setup";
    public static final String MUSIC_LOBBY = "music_lobby";
    public static final String MUSIC_MY_TURN = "music_my_turn";
    public static final String MUSIC_OTHER_TURN = "music_other_turn";
    public static final String MUSIC_BATTLE = "music_battle";
    public static final String MUSIC_VICTORY = "music_victory";
    public static final String MUSIC_DEFEAT = "music_defeat";
    public static final String MENU_BUTTON = "menu_button";
    public static final String BUTTON = "button";
    public static final String BACK_BUTTON = "back_button";
    public static final String BUTTON_START_GAME = "button_start_game";
    public static final String CARDS_RECEIVE = "cards_receive";
    public static final String CARDS_TRADE = "cards_trade";
    public static final String PLACE_ARMY = "place_army";
    public static final String PLACE_ARMIES = "place_armies";
    public static final String ATTACK = "attack";
    public static final String BATTLE_RETREAT = "battle_retreat";
    public static final String DICE_ROLL = "dice_roll";
    public static final String DICE_WIN = "dice_win";
    public static final String DICE_LOSE = "dice_lose";
    public static final String DICE_DRAW = "dice_draw";
    public static final String BATTLE_WIN = "battle_win";
    public static final String BATTLE_DEFEAT = "battle_defeat";
    public static final String BATTLE_DEFENSE_WIN = "battle_defense_win";
    public static final String BATTLE_DEFENSE_DEFEAT = "battle_defense_defeat";
    public static final String MOVE_ARMIES = "move_armies";
    public static final String MOVE_TACTICAL = "move_tactical";
    public static final String LOBBY_START = "lobby_start";
    public static final String LOBBY_JOIN = "lobby_join";
    public static final String LOBBY_LEAVE = "lobby_leave";
    public static final String LOBBY_PLAY = "lobby_play";
    public static final String LOBBY_WATCH = "lobby_watch";
    public static final String LOBBY_SET_NICK = "lobby_set_nick";
    private boolean soundEnabled = true;
    private boolean musicEnabled = true;
    private AudioSystem audioSystem;
    private Map<String, String> currentTheme;
    private String currentMusicId;
    boolean lobbyOpen;
    boolean gameWon;
    boolean gameLost;

    public void setAudioSystem(Risk risk, AudioSystem audio) {
        this.audioSystem = audio;
        risk.addRiskListener(this);
        this.currentMusicId = MUSIC_MENU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String theme) {
        try {
            if (this.currentMusicId != null) {
                this.stopPlayingLoopedSound();
            }
            String folder = "sound";
            InputStream in = RiskUtil.openStream("sound/" + theme + ".xml");
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            this.currentTheme = new HashMap<String, String>();
            parser.parse(in, new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("sound".equals(qName)) {
                        String key = attributes.getValue("name");
                        String filename = attributes.getValue("file");
                        GameSound.this.currentTheme.put(key, "sound/" + filename);
                    }
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "unable to load theme: " + theme, ex);
        }
        finally {
            if (this.currentMusicId != null) {
                this.playCurrentLoopedSound();
            }
        }
    }

    public void setSoundEnabled(boolean on) {
        this.soundEnabled = on;
    }

    public void setMusicEnabled(boolean on) {
        boolean musicOld = this.musicEnabled;
        this.musicEnabled = on;
        if (this.currentMusicId != null) {
            if (musicOld && !this.musicEnabled) {
                this.stopPlayingLoopedSound();
            } else if (!musicOld && this.musicEnabled) {
                this.playCurrentLoopedSound();
            }
        }
    }

    public void playSound(String audioId) {
        String audioFile;
        LOGGER.fine("Playing sound with id: " + audioId);
        if (this.soundEnabled && this.audioSystem != null && this.currentTheme != null && (audioFile = this.currentTheme.get(audioId)) != null) {
            this.audioSystem.play(audioFile);
        }
    }

    public void playMusic(String audioId) {
        this.currentMusicId = audioId;
        this.playCurrentLoopedSound();
    }

    public void stopMusic() {
        if (this.musicEnabled) {
            this.stopPlayingLoopedSound();
        }
        this.currentMusicId = null;
    }

    private void playCurrentLoopedSound() {
        String audioFile;
        LOGGER.fine("Playing music with id: " + this.currentMusicId);
        if (this.musicEnabled && this.audioSystem != null && this.currentTheme != null && (audioFile = this.currentTheme.get(this.currentMusicId)) != null) {
            this.audioSystem.start(audioFile);
        }
    }

    private void stopPlayingLoopedSound() {
        String audioFile;
        LOGGER.fine("Stopping music with id: " + this.currentMusicId);
        if (this.audioSystem != null && this.currentTheme != null && (audioFile = this.currentTheme.get(this.currentMusicId)) != null) {
            this.audioSystem.stop(audioFile);
        }
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public boolean isMusicEnabled() {
        return this.musicEnabled;
    }

    private void switchToMusic(String id) {
        if (!id.equals(this.currentMusicId)) {
            if (this.currentMusicId != null) {
                this.stopMusic();
            }
            this.playMusic(id);
        }
    }

    public void setLobbyOpen(boolean open) {
        this.lobbyOpen = open;
        this.switchToMusic(this.getOutOfGameMusic());
    }

    public void setGameWon(boolean won) {
        this.gameWon = won;
        this.switchToMusic(this.getMyTurnGameMusic());
    }

    public void setGameLost(boolean lost) {
        this.gameLost = lost;
        this.switchToMusic(this.getOtherTurnGameMusic());
    }

    private String getOutOfGameMusic() {
        return this.lobbyOpen ? MUSIC_LOBBY : MUSIC_MENU;
    }

    private String getMyTurnGameMusic() {
        return this.gameWon ? MUSIC_VICTORY : MUSIC_MY_TURN;
    }

    private String getOtherTurnGameMusic() {
        return this.gameLost ? MUSIC_DEFEAT : MUSIC_OTHER_TURN;
    }

    public void needInput(int s) {
        if (s > 0 && s != 4 && s != 10 && s != 8) {
            this.switchToMusic(this.getMyTurnGameMusic());
        }
    }

    public void noInput() {
        this.switchToMusic(this.getOtherTurnGameMusic());
    }

    public void newGame(boolean t) {
        this.switchToMusic(MUSIC_SETUP);
    }

    public void startGame(boolean localGame) {
        this.playSound(BUTTON_START_GAME);
        this.switchToMusic(this.getOtherTurnGameMusic());
    }

    public void gameOver(boolean bln) {
        if (bln) {
            this.setGameWon(true);
        } else {
            this.setGameLost(true);
        }
    }

    public void closeGame() {
        this.gameWon = false;
        this.gameLost = false;
        this.switchToMusic(this.getOutOfGameMusic());
    }

    public void openBattle(int c1num, int c2num) {
        this.switchToMusic(MUSIC_BATTLE);
    }

    public void closeBattle() {
        this.switchToMusic(this.getOtherTurnGameMusic());
    }

    public void showDiceResults(int[] atti, int[] defi, boolean weAreAttacker, int result) {
        int out = 0;
        int fights = Math.min(atti.length, defi.length);
        for (int c = 0; c < fights; ++c) {
            out += atti[0] > defi[0] ? 1 : -1;
        }
        if (!weAreAttacker) {
            out = -out;
            result = -result;
        }
        if (result >= 1) {
            if (weAreAttacker) {
                this.playSound(BATTLE_WIN);
            } else {
                this.playSound(BATTLE_DEFENSE_WIN);
            }
            if (result == 2) {
                // empty if block
            }
        } else if (result <= -1) {
            if (weAreAttacker) {
                this.playSound(BATTLE_DEFEAT);
            } else {
                this.playSound(BATTLE_DEFENSE_DEFEAT);
            }
            if (result == -2) {
                this.setGameLost(true);
            }
        } else if (out == 0) {
            this.playSound(DICE_DRAW);
        } else if (out > 0) {
            this.playSound(DICE_WIN);
        } else {
            this.playSound(DICE_LOSE);
        }
    }

    public void playerGotCard() {
        this.playSound(CARDS_RECEIVE);
    }
}

