/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;

public class RiskSettings {
    private static final Logger logger = Logger.getLogger(RiskUtil.class.getName());
    public static final String SHOW_DICE_KEY = "game.dice.show";
    public static final String AI_WAIT_KEY = "ai.wait";
    public static final String SOUND_KEY = "audio.sound";
    public static final String MUSIC_KEY = "audio.music";
    public static final String SHOW_TOASTS_KEY = "show_toasts";
    public static final String COLOR_BLIND_KEY = "color_blind";
    public static final String FULL_SCREEN_KEY = "fullscreen";
    public static final String LANGUAGE_KEY = "lang";
    public static final String EXTERNAL_MAPS_KEY = "externalMapsDirUrl";
    public static final String DEFAULT_GAME_TYPE_KEY = "default.gametype";
    public static final String DEFAULT_CARD_TYPE_KEY = "default.cardtype";
    public static final String DEFAULT_AUTO_PLACE_ALL_KEY = "default.autoplaceall";
    public static final String DEFAULT_RECYCLE_CARDS_KEY = "default.recycle";
    public static final String DEFAULT_MAP_KEY = "default.map";
    public static final String DEFAULT_CARDS_KEY = "default.cards";

    public static Preferences getPreferences(Class uiclass) {
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(uiclass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return prefs;
    }

    public static void savePlayers(Risk risk, Class uiclass) {
        Preferences prefs = RiskSettings.getPreferences(uiclass);
        if (prefs != null) {
            Vector players = risk.getGame().getPlayers();
            for (int cc = 1; cc <= RiskGame.MAX_PLAYERS; ++cc) {
                Player player;
                String nameKey = "default.player" + cc + ".name";
                String colorKey = "default.player" + cc + ".color";
                String typeKey = "default.player" + cc + ".type";
                String name = "";
                String color = "";
                String type = "";
                Player player2 = player = cc <= players.size() ? (Player)players.get(cc - 1) : null;
                if (player != null) {
                    name = player.getName();
                    color = ColorUtil.getStringForColor(player.getColor());
                    type = risk.getType(player.getType());
                }
                prefs.put(nameKey, name);
                prefs.put(colorKey, color);
                prefs.put(typeKey, type);
            }
            RiskSettings.flushPreferences(prefs);
        }
    }

    public static void savePlayers(List players, Class uiclass) {
        Preferences prefs = RiskSettings.getPreferences(uiclass);
        if (prefs != null) {
            for (int cc = 1; cc <= RiskGame.MAX_PLAYERS; ++cc) {
                String[] player;
                String nameKey = "default.player" + cc + ".name";
                String colorKey = "default.player" + cc + ".color";
                String typeKey = "default.player" + cc + ".type";
                String name = "";
                String color = "";
                String type = "";
                String[] stringArray = player = cc <= players.size() ? (String[])players.get(cc - 1) : null;
                if (player != null) {
                    name = player[0];
                    color = player[1];
                    type = player[2];
                }
                prefs.put(nameKey, name);
                prefs.put(colorKey, color);
                prefs.put(typeKey, type);
            }
            RiskSettings.flushPreferences(prefs);
        }
    }

    public static Properties getPlayerSettings(final Risk risk, Class uiclass) {
        final Preferences theprefs = RiskSettings.getPreferences(uiclass);
        return new Properties(){

            public String getProperty(String key) {
                String value = risk.getRiskConfig(key);
                if (theprefs != null) {
                    value = theprefs.get(key, value);
                }
                return value;
            }
        };
    }

    public static void loadPlayers(Risk risk, Class uiclass) {
        if (!risk.isReplay()) {
            Properties playerSettings = RiskSettings.getPlayerSettings(risk, uiclass);
            for (int cc = 1; cc <= RiskGame.MAX_PLAYERS; ++cc) {
                String name = playerSettings.getProperty("default.player" + cc + ".name");
                String color = playerSettings.getProperty("default.player" + cc + ".color");
                String type = playerSettings.getProperty("default.player" + cc + ".type");
                if (name == null || color == null || type == null || "".equals(name) || "".equals(color) || "".equals(type)) continue;
                risk.parser("newplayer " + type + " " + color + " " + name);
            }
        }
    }

    public static void saveGameSettings(Preferences appPreferences, String gameTypeCommand, String cardTypeCommand, boolean autoPlaceAllBoolean, boolean recycleCardsBoolean) {
        if (appPreferences != null) {
            appPreferences.put(DEFAULT_GAME_TYPE_KEY, gameTypeCommand);
            appPreferences.put(DEFAULT_CARD_TYPE_KEY, cardTypeCommand);
            appPreferences.putBoolean(DEFAULT_AUTO_PLACE_ALL_KEY, autoPlaceAllBoolean);
            appPreferences.putBoolean(DEFAULT_RECYCLE_CARDS_KEY, recycleCardsBoolean);
            RiskSettings.flushPreferences(appPreferences);
        }
    }

    public static void loadSettingsFromPrefs(Preferences appPreferences) {
        if (appPreferences != null) {
            AIManager.setWait(appPreferences.getInt(AI_WAIT_KEY, AIManager.getWait()));
            Risk.setShowDice(appPreferences.getBoolean(SHOW_DICE_KEY, Risk.isShowDice()));
            GameSound.INSTANCE.setSoundEnabled(appPreferences.getBoolean(SOUND_KEY, GameSound.INSTANCE.isSoundEnabled()));
            GameSound.INSTANCE.setMusicEnabled(appPreferences.getBoolean(MUSIC_KEY, GameSound.INSTANCE.isMusicEnabled()));
        }
    }

    public static void saveSettingsToPrefs(Preferences preferences) {
        if (preferences != null) {
            preferences.putBoolean(SHOW_DICE_KEY, Risk.isShowDice());
            preferences.putInt(AI_WAIT_KEY, AIManager.getWait());
            preferences.putBoolean(SOUND_KEY, GameSound.INSTANCE.isSoundEnabled());
            preferences.putBoolean(MUSIC_KEY, GameSound.INSTANCE.isMusicEnabled());
            RiskSettings.flushPreferences(preferences);
        }
    }

    private static void flushPreferences(Preferences prefs) {
        try {
            prefs.flush();
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "can not flush prefs", ex);
        }
    }
}

