/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.guishared;

import collisionphysics.BallWorld;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JPanel;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.MapPanel;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.swing.GraphicsUtil;

public class PicturePanel
extends JPanel
implements MapPanel {
    public static final int NO_COUNTRY = 255;
    public static final int PP_X = 677;
    public static final int PP_Y = 425;
    public static final int VIEW_CONTINENTS = 0;
    public static final int VIEW_OWNERSHIP = 1;
    public static final int VIEW_BORDER_THREAT = 2;
    public static final int VIEW_CARD_OWNERSHIP = 3;
    public static final int VIEW_TROOP_STRENGTH = 4;
    public static final int VIEW_CONNECTED_EMPIRE = 5;
    private CountryImage[] countryImages;
    private Risk myrisk;
    private BufferedImage original;
    private BufferedImage img;
    private BufferedImage tempimg;
    private byte[][] map;
    private int c1;
    private int c2;
    private int cc;
    private String strCountry;
    private RescaleOp HighLight;
    public int BALL_SIZE = 20;
    BallWorld ballWorld;
    int oldState;
    public static final int PREVIEW_WIDTH = 203;
    public static final int PREVIEW_HEIGHT = 127;

    public PicturePanel(Risk r) {
        this.myrisk = r;
        this.strCountry = TranslationBundle.getBundle().getString("picturepanel.country");
        this.img = null;
        this.map = null;
        this.HighLight = new RescaleOp(1.5f, 1.0f, null);
        Dimension size = GraphicsUtil.newDimension(677, 425);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 500 && this.myrisk.getGame().getState() == 8) {
            if (this.ballWorld == null) {
                this.startAni();
            } else {
                this.stopAni();
            }
        }
    }

    public void load() throws IOException {
        RiskGame game = this.myrisk.getGame();
        this.original = null;
        this.countryImages = null;
        this.memoryLoad(RiskUIUtil.read(RiskUtil.openMapStream(game.getImageMap())), RiskUIUtil.read(RiskUtil.openMapStream(game.getImagePic())));
    }

    public void memoryLoad(BufferedImage m, BufferedImage O) {
        int mWidth = m.getWidth();
        int mHeight = m.getHeight();
        RiskGame game = this.myrisk.getGame();
        this.BALL_SIZE = game.getCircleSize();
        this.setFont(new Font("Arial", 0, (this.BALL_SIZE + 2) / 2));
        this.original = O;
        this.cc = 255;
        this.c1 = 255;
        this.c2 = 255;
        int noc = game.getCountries().length;
        int[] pixels = m.getRGB(0, 0, mWidth, mHeight, null, 0, mWidth);
        m = null;
        if (this.map == null || this.map.length != mWidth || this.map[0].length != mHeight) {
            this.img = null;
            this.tempimg = null;
            this.map = null;
            this.img = new BufferedImage(mWidth, mHeight, 1);
            this.tempimg = new BufferedImage(mWidth, mHeight, 1);
            this.map = new byte[mWidth][mHeight];
        }
        Graphics zg = this.img.getGraphics();
        zg.drawImage(this.original, 0, 0, this);
        zg.dispose();
        this.countryImages = new CountryImage[noc];
        for (int c = 0; c < noc; ++c) {
            this.countryImages[c] = new CountryImage();
        }
        for (int x = 0; x < mWidth; ++x) {
            for (int y = 0; y < mHeight; ++y) {
                int num = pixels[mWidth * y + x] & 0xFF;
                this.map[x][y] = (byte)(num - 128);
                if (num == 255) continue;
                CountryImage cci = this.countryImages[num - 1];
                if (x < cci.getX1()) {
                    cci.setX1(x);
                }
                if (x > cci.getX2()) {
                    cci.setX2(x);
                }
                if (y < cci.getY1()) {
                    cci.setY1(y);
                }
                if (y <= cci.getY2()) continue;
                cci.setY2(y);
            }
        }
        pixels = null;
        for (int c = 0; c < this.countryImages.length; ++c) {
            CountryImage cci = this.countryImages[c];
            int x1 = cci.getX1();
            int y1 = cci.getY1();
            int w = cci.getWidth();
            int h = cci.getHeight();
            try {
                BufferedImage source = this.original.getSubimage(x1, y1, w, h);
                BufferedImage gray = new BufferedImage(w, h, 10);
                Graphics zg2 = gray.getGraphics();
                zg2.drawImage(source, 0, 0, this);
                zg2.dispose();
                cci.setSourceImage(source);
                cci.setGrayImage(gray);
                cci.setNormalImage(new BufferedImage(w, h, 2));
                cci.setHighLightImage(new BufferedImage(w, h, 2));
                cci.setTemp1(new BufferedImage(w, h, 1));
                cci.setTemp2(new BufferedImage(w, h, 1));
                continue;
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Error in Map: " + (cci.getWidth() < 0 || cci.getHeight() < 0 ? "CountryNotFound" : "Error creating CountryImages") + " index=" + c + " color=" + (c + 1) + " " + cci, ex);
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            if (this.img != null) {
                Graphics2D g2 = (Graphics2D)g;
                double s = this.getScale();
                g2.translate(this.getDrawImageX(s), this.getDrawImageY(s));
                g2.scale(s, s);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage((Image)this.img, 0, 0, this);
                int c1 = this.c1;
                int c2 = this.c2;
                int cc = this.cc;
                if (c1 != 255) {
                    this.drawHighLightImage(g2, c1);
                }
                if (c2 != 255) {
                    this.drawHighLightImage(g2, c2);
                }
                if (cc != 255) {
                    this.drawHighLightImage(g2, cc);
                }
                if (this.myrisk.getGame().getState() == 1 && this.myrisk.showHumanCurrentPlayerInfo()) {
                    Player me = this.myrisk.getGame().getCurrentPlayer();
                    Vector cards = me.getCards();
                    for (Card card : cards) {
                        Country country = card.getCountry();
                        if (country == null || country.getOwner() != me) continue;
                        this.drawHighLightImage(g2, country.getColor());
                    }
                }
                this.drawArmies(g2);
                if (cc != 255) {
                    int offset = 5;
                    TextLayout tl = new TextLayout(this.strCountry + " " + this.myrisk.getCountryName(cc), g2.getFont(), g2.getFontRenderContext());
                    int w = (int)tl.getAdvance();
                    int h = (int)tl.getAscent() + (int)tl.getDescent();
                    g2.setColor(new Color(255, 255, 255, 150));
                    g2.fill(new Rectangle2D.Float(offset, offset, w + 3, h + 1));
                    g2.setColor(Color.black);
                    tl.draw(g2, (float)offset + 1.0f, (float)offset + tl.getAscent());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getDrawImageX(double ratio) {
        return (int)((double)this.getWidth() - (double)this.getMapWidth() * ratio) / 2;
    }

    private int getDrawImageY(double ratio) {
        return (int)((double)this.getHeight() - (double)this.getMapHeight() * ratio) / 2;
    }

    private double getScale() {
        return Math.min((double)this.getHeight() / (double)this.getMapHeight(), (double)this.getWidth() / (double)this.getMapWidth());
    }

    public int getMapWidth() {
        return this.map.length;
    }

    public int getMapHeight() {
        return this.map[0].length;
    }

    public void drawArmies(Graphics2D g2) {
        RiskGame game = this.myrisk.getGame();
        Country[] v = game.getCountries();
        int state = game.getState();
        if (state == 4 || state == 5 || state == 10) {
            int a = game.getAttacker().getColor();
            int b = game.getDefender().getColor();
            this.drawHighLightImage(g2, a);
            this.drawHighLightImage(g2, b);
            Color ac = new Color(game.getAttacker().getOwner().getColor());
            g2.setColor(new Color(ac.getRed(), ac.getGreen(), ac.getBlue(), 150));
            if (Math.abs(game.getAttacker().getX() - game.getDefender().getX()) > this.map.length / 2) {
                if (game.getAttacker().getX() > this.map.length / 2) {
                    g2.fillPolygon(this.makeArrow(game.getAttacker().getX(), game.getAttacker().getY(), game.getDefender().getX() + this.map.length, game.getDefender().getY(), this.BALL_SIZE));
                    g2.fillPolygon(this.makeArrow(game.getAttacker().getX() - this.map.length, game.getAttacker().getY(), game.getDefender().getX(), game.getDefender().getY(), this.BALL_SIZE));
                } else {
                    g2.fillPolygon(this.makeArrow(game.getAttacker().getX(), game.getAttacker().getY(), game.getDefender().getX() - this.map.length, game.getDefender().getY(), this.BALL_SIZE));
                    g2.fillPolygon(this.makeArrow(game.getAttacker().getX() + this.map.length, game.getAttacker().getY(), game.getDefender().getX(), game.getDefender().getY(), this.BALL_SIZE));
                }
            } else {
                g2.fillPolygon(this.makeArrow(game.getAttacker().getX(), game.getAttacker().getY(), game.getDefender().getX(), game.getDefender().getY(), this.BALL_SIZE));
            }
        }
        if (this.oldState != state) {
            this.oldState = state;
            if (state == 8) {
                this.startAni();
            } else {
                this.stopAni();
            }
        }
        HashMap<Country, Player> capitals = Collections.EMPTY_MAP;
        if (game.getGameMode() == 2 && game.getSetupDone() && state != 9) {
            capitals = new HashMap<Country, Player>(game.getNoPlayers());
            Vector players = game.getPlayers();
            for (int c = 0; c < players.size(); ++c) {
                Player player = (Player)players.get(c);
                Country capital = player.getCapital();
                if (capital == null) continue;
                capitals.put(capital, player);
            }
        }
        for (int c = 0; c < v.length; ++c) {
            int y;
            int x;
            Country t = v[c];
            g2.setFont(this.getFont());
            if (t.getOwner() == null) continue;
            if (this.ballWorld == null) {
                x = t.getX();
                y = t.getY();
            } else {
                x = (int)this.ballWorld.balls[c].x;
                y = (int)this.ballWorld.balls[c].y;
            }
            this.drawArmy(g2, t.getOwner().getColor(), t.getArmies(), x, y, this.BALL_SIZE, (Player)capitals.get(t));
        }
    }

    public void drawArmy(Graphics2D g2, int countryOwnerColor, int armies, int x, int y, int ballSize, Player capital) {
        int r = ballSize / 2;
        String noa = String.valueOf(armies);
        Color textColor = new Color(ColorUtil.getTextColorFor(countryOwnerColor));
        int textX = x - g2.getFontMetrics().stringWidth(noa) / 2;
        int textY = y + g2.getFontMetrics().getAscent() * 2 / 5;
        Image icon = RiskUIUtil.getIconForColor(countryOwnerColor);
        if (icon == null) {
            g2.setColor(new Color(countryOwnerColor));
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            ((RectangularShape)ellipse).setFrame(x - r, y - r, ballSize, ballSize);
            g2.fill(ellipse);
            g2.setColor(textColor);
            g2.drawString(noa, textX, textY);
        } else {
            int w = (int)((double)ballSize * 1.1);
            int h = (int)((double)icon.getHeight(this) * ((double)w / (double)icon.getWidth(this)));
            g2.drawImage(icon, x - w / 2, y - w / 2, w, h, this);
            g2.setColor(textColor);
            Color outlineColor = Color.WHITE.equals(textColor) ? Color.BLACK : Color.WHITE;
            GraphicsUtil.drawStringWithOutline(g2, new TextLayout(noa, g2.getFont(), g2.getFontRenderContext()), textX, textY, outlineColor);
        }
        if (capital != null) {
            int stroke = ballSize / 10;
            Stroke old = g2.getStroke();
            g2.setStroke(new BasicStroke(stroke));
            g2.setColor(new Color(ColorUtil.getTextColorFor(capital.getColor())));
            Ellipse2D.Double ellipse1 = new Ellipse2D.Double();
            ((RectangularShape)ellipse1).setFrame(x - r, y - r, ballSize - 1, ballSize - 1);
            g2.draw(ellipse1);
            g2.setColor(new Color(capital.getColor()));
            Ellipse2D.Double ellipse2 = new Ellipse2D.Double();
            int size = ballSize + stroke * 2;
            ((RectangularShape)ellipse2).setFrame(x - size / 2, y - size / 2, size - 1, size - 1);
            g2.draw(ellipse2);
            g2.setStroke(old);
        }
    }

    public void startAni() {
        if (this.ballWorld == null) {
            this.ballWorld = new BallWorld(this.myrisk, this, this.BALL_SIZE / 2);
        }
    }

    public void stopAni() {
        if (this.ballWorld != null) {
            this.ballWorld.stop();
            this.ballWorld = null;
            this.repaint();
        }
    }

    private void drawHighLightImage(Graphics g, int id) {
        g.drawImage(this.countryImages[id - 1].getHighLightImage(), this.countryImages[id - 1].getX1(), this.countryImages[id - 1].getY1(), this);
    }

    public Polygon makeArrow(int x1i, int y1i, int x2i, int y2i, int d) {
        Polygon arrow;
        double x1 = x1i;
        double y1 = y1i;
        double x2 = x2i;
        double y2 = y2i;
        double xd = x2 - x1;
        double yd = y1 - y2;
        double r = d / 2;
        double l = Math.sqrt(Math.pow(xd, 2.0) + Math.pow(yd, 2.0));
        double a = Math.acos(r / l);
        double b = Math.atan(yd / xd);
        double c = Math.atan(xd / yd);
        double x3 = r * Math.cos(a - b);
        double y3 = r * Math.sin(a - b);
        double x4 = r * Math.sin(a - c);
        double y4 = r * Math.cos(a - c);
        if (x2 >= x1 && y2 <= y1) {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 + x3), (int)x2, (int)Math.round(x1 - x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 + y3), (int)y2, (int)Math.round(y1 - y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        } else if (x2 >= x1 && y2 >= y1) {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 + x3), (int)x2, (int)Math.round(x1 + x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 + y3), (int)y2, (int)Math.round(y1 + y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        } else if (x2 <= x1 && y2 <= y1) {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 - x3), (int)x2, (int)Math.round(x1 - x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 - y3), (int)y2, (int)Math.round(y1 - y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        } else {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 - x3), (int)x2, (int)Math.round(x1 + x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 - y3), (int)y2, (int)Math.round(y1 + y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        }
        return arrow;
    }

    public synchronized void repaintCountries(int view) {
        if (this.tempimg == null) {
            return;
        }
        RiskGame game = this.myrisk.getGame();
        Graphics zg = this.tempimg.getGraphics();
        zg.drawImage(this.original, 0, 0, this);
        zg.dispose();
        ArrayList allConnectedEmpires = null;
        boolean showHumanCurrentPlayerInfo = false;
        if (view == 5) {
            Vector players = game.getPlayers();
            allConnectedEmpires = new ArrayList();
            for (int c = 0; c < players.size(); ++c) {
                allConnectedEmpires.addAll(game.getConnectedEmpire((Player)players.get(c)));
            }
        } else if (view == 3) {
            showHumanCurrentPlayerInfo = this.myrisk.showHumanCurrentPlayerInfo();
        }
        for (int c = 0; c < this.countryImages.length; ++c) {
            Color val = null;
            if (view == 0) {
                val = new Color(0, true);
            } else if (view == 1) {
                val = game.getCountryInt(c + 1).getOwner() != null ? new Color(game.getCountryInt(c + 1).getOwner().getColor()) : Color.GRAY;
                val = new Color(val.getRed(), val.getGreen(), val.getBlue(), 100);
            } else if (view == 2) {
                Player player = game.getCountryInt(c + 1).getOwner();
                if (player != game.getCurrentPlayer()) {
                    val = Color.gray;
                } else {
                    Vector neighbours = game.getCountryInt(c + 1).getNeighbours();
                    int threat = 0;
                    for (int j = 0; j < neighbours.size(); ++j) {
                        if (((Country)neighbours.get(j)).getOwner() == player) continue;
                        ++threat;
                    }
                    if ((threat *= 40) > 255) {
                        threat = 255;
                    }
                    val = new Color(threat, 0, 0);
                }
                val = new Color(val.getRed(), val.getGreen(), val.getBlue(), 200);
            } else if (view == 3) {
                boolean mine;
                boolean bl = mine = game.getCountryInt(c + 1).getOwner() == game.getCurrentPlayer();
                if (showHumanCurrentPlayerInfo) {
                    List cards = this.myrisk.getCurrentCards();
                    for (int j = 0; j < cards.size(); ++j) {
                        if (((Card)cards.get(j)).getCountry() != game.getCountryInt(c + 1)) continue;
                        val = mine ? Color.BLUE : Color.YELLOW;
                    }
                    if (val == null) {
                        val = mine ? Color.DARK_GRAY : Color.LIGHT_GRAY;
                    }
                } else {
                    val = Color.LIGHT_GRAY;
                }
                val = new Color(val.getRed(), val.getGreen(), val.getBlue(), 100);
            } else if (view == 4) {
                Country country = game.getCountryInt(c + 1);
                int armies = country.getArmies();
                if ((armies *= 25) > 255) {
                    armies = 255;
                }
                val = country.getOwner() == null ? Color.GRAY : (country.getOwner() != game.getCurrentPlayer() ? new Color(255, 255 - armies, 255 - armies) : new Color(0, armies, 0));
                val = new Color(val.getRed(), val.getGreen(), val.getBlue(), 200);
            } else if (view == 5) {
                Country thecountry = game.getCountryInt(c + 1);
                val = thecountry.getOwner() == null ? Color.LIGHT_GRAY : (allConnectedEmpires.contains(thecountry) ? new Color(thecountry.getOwner().getColor()) : Color.DARK_GRAY);
                val = new Color(val.getRed(), val.getGreen(), val.getBlue(), 100);
            }
            CountryImage ci = this.countryImages[c];
            int x1 = ci.getX1();
            int y1 = ci.getY1();
            BufferedImage normalB = ci.getNormalImage();
            if (ci.checkChange(val)) {
                Graphics zg2;
                int y2 = ci.getY2();
                int w = ci.getWidth();
                int h = ci.getHeight();
                BufferedImage normalA = ci.getTemp1();
                BufferedImage highlightA = ci.getTemp2();
                BufferedImage highlightB = ci.getHighLightImage();
                Graphics tempg = normalA.getGraphics();
                if (view == 0) {
                    tempg.drawImage(ci.getSourceImage(), 0, 0, this);
                } else {
                    tempg.drawImage(ci.getGrayImage(), 0, 0, this);
                    tempg.setColor(val);
                    tempg.fillRect(0, 0, w, h);
                }
                tempg.dispose();
                this.HighLight.filter(normalA, highlightA);
                if (view != 0) {
                    zg2 = normalB.getGraphics();
                    zg2.drawImage(normalA, 0, 0, this);
                    zg2.dispose();
                }
                zg2 = highlightB.getGraphics();
                zg2.drawImage(highlightA, 0, 0, this);
                zg2.dispose();
                for (int y = y1; y <= y2; ++y) {
                    for (int x = 0; x < w; ++x) {
                        if (this.map[x + x1][y] + 128 == c + 1) continue;
                        normalB.setRGB(x, y - y1, 0);
                        highlightB.setRGB(x, y - y1, 0);
                    }
                }
            }
            if (view == 0) continue;
            Graphics zg3 = this.tempimg.getGraphics();
            zg3.drawImage(normalB, x1, y1, this);
            zg3.dispose();
        }
        BufferedImage newback = this.img;
        this.img = this.tempimg;
        this.tempimg = newback;
    }

    public int getCountryNumber(int x, int y) {
        if (this.map == null) {
            return 255;
        }
        double s = this.getScale();
        x -= this.getDrawImageX(s);
        y -= this.getDrawImageY(s);
        x = (int)((double)x / s);
        y = (int)((double)y / s);
        if (x < 0 || y < 0 || x >= this.map.length || y >= this.map[0].length) {
            return 255;
        }
        return this.map[x][y] + 128;
    }

    public void setHighLight(int a) {
        this.cc = a;
    }

    public int getHighLight() {
        return this.cc;
    }

    public void setC1(int a) {
        this.c1 = a;
    }

    public void setC2(int a) {
        this.c2 = a;
    }

    public int getC1() {
        return this.c1;
    }

    public int getC2() {
        return this.c2;
    }

    public BufferedImage getCountryImage(int num, boolean incolor) {
        int i = num - 1;
        CountryImage ci = this.countryImages[i];
        int x1 = ci.getX1();
        int y1 = ci.getY1();
        int y2 = ci.getY2();
        int w = ci.getWidth();
        int h = ci.getHeight();
        try {
            BufferedImage pictureA = new BufferedImage(w, h, ci.getGrayImage().getType());
            RescaleOp HighLight = new RescaleOp(0.5f, -1.0f, null);
            try {
                HighLight.filter(ci.getGrayImage(), pictureA);
            }
            catch (UnsatisfiedLinkError err) {
                pictureA = ci.getGrayImage();
                System.out.println("unable to filter " + HighLight + " " + w + "x" + h + " " + ci.getGrayImage().getType());
                RiskUtil.printStackTrace(err);
            }
            catch (NoClassDefFoundError err) {
                pictureA = ci.getGrayImage();
                System.out.println("unable to filter " + HighLight + " " + w + "x" + h + " " + ci.getGrayImage().getType());
                RiskUtil.printStackTrace(err);
            }
            BufferedImage pictureB = new BufferedImage(w, h, 2);
            Graphics g = pictureB.getGraphics();
            g.drawImage(pictureA, 0, 0, this);
            if (incolor) {
                Color ownerColor = new Color(this.myrisk.getGame().getCountryInt(num).getOwner().getColor());
                g.setColor(new Color(ownerColor.getRed(), ownerColor.getGreen(), ownerColor.getBlue(), 100));
                g.fillRect(0, 0, w, h);
            }
            for (int y = y1; y <= y2; ++y) {
                for (int x = 0; x <= w - 1; ++x) {
                    if (this.map[x + x1][y] + 128 == i + 1) continue;
                    pictureB.setRGB(x, y - y1, 0);
                }
            }
            g.dispose();
            return pictureB;
        }
        catch (OutOfMemoryError error) {
            Logger.getLogger(PicturePanel.class.getName()).info("error in getCountryImage " + error);
            return incolor ? ci.getSourceImage() : ci.getGrayImage();
        }
    }

    public static Image getImage(RiskGame game) throws IOException {
        BufferedImage s;
        String previewName = game.getPreviewPic();
        String name = game.getMapName();
        Image img = null;
        int width = -1;
        int height = -1;
        boolean error = false;
        if (previewName != null) {
            try {
                s = RiskUIUtil.read(RiskUtil.openMapStream("preview/" + previewName));
                img = s;
                width = s.getWidth();
                height = s.getHeight();
            }
            catch (IOException ex) {
                Logger.getLogger(PicturePanel.class.getName()).info("error loading prv file " + previewName + " " + ex);
                error = true;
            }
        }
        if (img == null) {
            s = RiskUIUtil.read(RiskUtil.openMapStream(game.getImagePic()));
            img = s.getScaledInstance(203, 127, 4);
            width = 203;
            height = 127;
        }
        if (name != null || width != 203 || height != 127 || error) {
            BufferedImage tmpimg = new BufferedImage(203, 127, 1);
            Graphics2D g = tmpimg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawImage(img, 0, 0, 203, 127, null);
            if (name != null) {
                g.setColor(new Color(255, 255, 255, 150));
                g.fillRect(0, 0, 203, 20);
                g.setColor(Color.BLACK);
                g.drawString(name, 5, 15);
            }
            if (error) {
                g.setColor(Color.RED);
                g.fillOval(183, 5, 10, 10);
            }
            g.dispose();
            return tmpimg;
        }
        return img;
    }

    public Image getImage() {
        return this.img;
    }

    class CountryImage {
        private int x1 = Integer.MAX_VALUE;
        private int y1 = Integer.MAX_VALUE;
        private int x2 = 0;
        private int y2 = 0;
        private BufferedImage SourceImage = null;
        private BufferedImage GrayImage = null;
        private BufferedImage normalImage = null;
        private BufferedImage HighLightImage = null;
        private BufferedImage temp1;
        private BufferedImage temp2;
        private Color color;

        public boolean checkChange(Color b) {
            if (!b.equals(this.color)) {
                this.color = b;
                return true;
            }
            return false;
        }

        public void setTemp1(BufferedImage a) {
            this.temp1 = a;
        }

        public void setTemp2(BufferedImage a) {
            this.temp2 = a;
        }

        public BufferedImage getTemp1() {
            return this.temp1;
        }

        public BufferedImage getTemp2() {
            return this.temp2;
        }

        public void setSourceImage(BufferedImage a) {
            this.SourceImage = a;
        }

        public void setGrayImage(BufferedImage a) {
            this.GrayImage = a;
        }

        public void setHighLightImage(BufferedImage a) {
            this.HighLightImage = a;
        }

        public void setNormalImage(BufferedImage a) {
            this.normalImage = a;
        }

        public void setX1(int a) {
            this.x1 = a;
        }

        public void setY1(int a) {
            this.y1 = a;
        }

        public void setX2(int a) {
            this.x2 = a;
        }

        public void setY2(int a) {
            this.y2 = a;
        }

        public BufferedImage getSourceImage() {
            return this.SourceImage;
        }

        public BufferedImage getGrayImage() {
            return this.GrayImage;
        }

        public BufferedImage getHighLightImage() {
            return this.HighLightImage;
        }

        public BufferedImage getNormalImage() {
            return this.normalImage;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public int getWidth() {
            return this.x2 - this.x1 + 1;
        }

        public int getHeight() {
            return this.y2 - this.y1 + 1;
        }

        public String toString() {
            return "CountryImage{x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", w=" + this.getWidth() + ", h=" + this.getHeight() + ", highlight=" + (this.color == null ? "none" : ColorUtil.getStringForColor(this.color.getRGB())) + '}';
        }
    }
}

