/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.guishared;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.translation.TranslationBundle;

public class RiskFileFilter
extends FileFilter
implements FilenameFilter {
    public static final String RISK_MAP_FILES = "map";
    public static final String RISK_CARDS_FILES = "cards";
    public static final String RISK_SAVE_FILES = "save";
    public static final String RISK_SCRIPT_FILES = "risk";
    public static final String RISK_LOG_FILES = "log";
    private final String[] extensions;

    public RiskFileFilter(String ... ext) {
        this.extensions = ext;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = RiskFileFilter.getExtension(f);
        if (ext != null) {
            for (String e : this.extensions) {
                if (!ext.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        ResourceBundle resb = TranslationBundle.getBundle();
        String name = this.extensions[0].equals(RISK_MAP_FILES) ? resb.getString("riskfilefilter.map") : (this.extensions[0].equals(RISK_CARDS_FILES) ? resb.getString("riskfilefilter.cards") : (this.extensions[0].equals(RISK_SAVE_FILES) ? resb.getString("riskfilefilter.save") : (this.extensions[0].equals(RISK_SCRIPT_FILES) ? resb.getString("riskfilefilter.script") : (this.extensions[0].equals(RISK_LOG_FILES) ? resb.getString("riskfilefilter.log") : resb.getString("riskfilefilter.files")))));
        ArrayList<String> types = new ArrayList<String>();
        for (String e : this.extensions) {
            types.add("*." + e);
        }
        return name + " (" + JavaCompatUtil.join(types, ", ") + ")";
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }
}

