/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.guishared;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import net.yura.domination.audio.GameSound;
import net.yura.domination.audio.SimpleAudio;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskIO;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.AboutDialog;
import net.yura.domination.guishared.PicturePanel;
import net.yura.domination.guishared.RiskFileFilter;
import net.yura.domination.guishared.SwingMEWrapper;
import net.yura.domination.mapstore.GetMap;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.swing.BrowserLauncher;
import net.yura.swing.GraphicsUtil;

public class RiskUIUtil {
    public static URL mapsdir;
    public static Applet applet;
    private static String webstart;
    private static boolean nosandbox;
    private static Map UIImagesReferences;
    public static final String SAVES_DIR = "saves/";
    private static String lobbyAppletURL;
    private static String lobbyURL;
    private static final String GTK_PLAF_CLASS = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static String maps;
    private static String cards;
    private static HashMap fileio;
    private static File gameDir;
    private static File mapsDir;
    private static boolean colorBlind;
    static Map<Integer, Image> icons;

    public static boolean checkForNoSandbox() {
        return nosandbox;
    }

    public static Image getUIImage(Class cls, String name) {
        try {
            if (RiskUIUtil.isMac() && GraphicsUtil.density > 1.0) {
                Class<?> multiResolutionImageClass = Class.forName("sun.awt.image.MultiResolutionImage");
                Image img = Toolkit.getDefaultToolkit().getImage(cls.getResource(name));
                GraphicsUtil.waitForImage(img);
                if (multiResolutionImageClass.isInstance(img)) {
                    return img;
                }
            }
        }
        catch (Throwable multiResolutionImageClass) {
            // empty catch block
        }
        BufferedImage img = RiskUIUtil.getUIImageCached(cls, name);
        if (GraphicsUtil.density > 1.0) {
            int dot = name.lastIndexOf(46);
            if (dot > 0) {
                String scale2x = name.substring(0, dot) + "@2x" + name.substring(dot);
                try {
                    BufferedImage img2x = RiskUIUtil.getUIImageCached(cls, scale2x);
                    Image[] imgList = new Image[]{img, img2x};
                    return GraphicsUtil.newBaseMultiResolutionImage(imgList);
                }
                catch (Throwable img2x) {
                    // empty catch block
                }
            }
            if (name.startsWith("/")) {
                String xhdpi = "/drawable-xhdpi" + name;
                try {
                    BufferedImage img2x = RiskUIUtil.getUIImageCached(cls, xhdpi);
                    Image[] imgList = new Image[]{img, img2x};
                    return GraphicsUtil.newBaseMultiResolutionImage(imgList);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return img;
    }

    private static BufferedImage getUIImageCached(Class c, String name) {
        try {
            BufferedImage img;
            String id = c + " - " + name;
            WeakReference wr = (WeakReference)UIImagesReferences.get(id);
            if (wr != null && (img = (BufferedImage)wr.get()) != null) {
                return img;
            }
            try {
                img = ImageIO.read(c.getResource(name));
            }
            catch (IIOException ex) {
                if (ImageIO.getUseCache()) {
                    Logger.getLogger(RiskUIUtil.class.getName()).log(Level.INFO, "could not load UI image " + c + " " + name, ex);
                    ImageIO.setUseCache(false);
                    img = ImageIO.read(c.getResource(name));
                }
                throw ex;
            }
            UIImagesReferences.put(id, new WeakReference<BufferedImage>(img));
            return img;
        }
        catch (Exception e) {
            throw new RuntimeException("error loading UI Image " + c + " " + name, e);
        }
    }

    private static void riskOpenURL(URL docs) throws Exception {
        if (applet != null) {
            applet.getAppletContext().showDocument(docs, "_blank");
        } else if (webstart != null) {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            boolean good = bs.showDocument(docs);
            if (!good) {
                throw new Exception("unable to open URL: " + docs);
            }
        } else {
            BrowserLauncher.openURL(docs.toString());
        }
    }

    private static URL getRiskFileURL(String a) {
        try {
            if (applet != null) {
                return new URL(applet.getCodeBase(), a);
            }
            if (webstart != null) {
                BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                return new URL(bs.getCodeBase(), a);
            }
            File file = new File(a);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            return new File(System.getProperty("user.dir"), a).toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to get url for: " + a, e);
        }
    }

    public static void setupMapsDir(Applet a) {
        block9: {
            applet = a;
            if (mapsdir == null) {
                if (applet == null && (webstart = System.getProperty("javawebstart.version")) == null) {
                    nosandbox = true;
                    RiskUIUtil.setupLookAndFeel();
                }
                try {
                    if (RiskUIUtil.checkForNoSandbox()) {
                        final AtomicReference<File> mapsdir1 = new AtomicReference<File>(new File("maps"));
                        final String dmname = RiskGame.getDefaultMap();
                        if (!new File(mapsdir1.get(), dmname).exists()) {
                            try {
                                URL url = RiskUIUtil.class.getProtectionDomain().getCodeSource().getLocation();
                                File jarFile = new File(url.toURI());
                                mapsdir1.set(new File(jarFile.getParentFile(), "maps"));
                            }
                            catch (Throwable th) {
                                Logger.getLogger(RiskUIUtil.class.getName()).info("failed to get maps dir from jar " + th);
                            }
                            while (!new File(mapsdir1.get(), dmname).exists()) {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Can not find map: " + dmname);
                                        JFileChooser fc = new JFileChooser(new File("."));
                                        fc.setFileSelectionMode(1);
                                        fc.setDialogTitle("Select maps directory");
                                        int returnVal = fc.showOpenDialog(null);
                                        if (returnVal == 0) {
                                            mapsdir1.set(fc.getSelectedFile());
                                        } else {
                                            System.exit(0);
                                        }
                                    }
                                });
                            }
                            System.setProperty("user.dir", mapsdir1.get().getParent());
                        }
                        mapsdir = mapsdir1.get().toURI().toURL();
                        break block9;
                    }
                    mapsdir = RiskUIUtil.getRiskFileURL("maps/");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static Frame findParentFrame(Container c) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, c);
    }

    public static void center(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = window.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        window.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static int unscale(int size) {
        return (int)Math.ceil((double)size * GraphicsUtil.scale / GraphicsUtil.density);
    }

    private static List getFileList(final String a) {
        ArrayList<String> namesvector;
        block11: {
            block10: {
                File file2;
                namesvector = new ArrayList<String>();
                if (!RiskUIUtil.checkForNoSandbox()) break block10;
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith("." + a);
                    }
                };
                File file = RiskUIUtil.getSaveMapDir();
                File[] mapsList = file.listFiles(filter);
                if (mapsList != null) {
                    for (int c = 0; c < mapsList.length; ++c) {
                        namesvector.add(mapsList[c].getName());
                    }
                }
                if (file.equals(file2 = RiskUIUtil.getFile(mapsdir))) break block11;
                mapsList = file2.listFiles(filter);
                for (int c = 0; c < mapsList.length; ++c) {
                    String name = mapsList[c].getName();
                    if (namesvector.contains(name)) continue;
                    namesvector.add(name);
                }
                break block11;
            }
            String names = null;
            if (applet != null) {
                names = applet.getParameter(a);
            } else if (webstart != null) {
                if ("map".equals(a)) {
                    names = maps;
                } else if ("cards".equals(a)) {
                    names = cards;
                }
            }
            StringTokenizer tok = new StringTokenizer(names, ",");
            while (tok.hasMoreTokens()) {
                namesvector.add(tok.nextToken());
            }
        }
        return namesvector;
    }

    public static String getNewMap(Frame f) {
        try {
            if (RiskUIUtil.checkForNoSandbox()) {
                List mapsList = RiskUIUtil.getFileList("map");
                return SwingMEWrapper.showMapChooser(f, mapsList);
            }
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        return RiskUIUtil.getNewMapsFile(f, "map");
    }

    public static String getNewMapsFile(Frame f, String ... extension) {
        if (RiskUIUtil.checkForNoSandbox()) {
            return RiskUIUtil.getNewMapsFileNoSandbox(f, extension);
        }
        return RiskUIUtil.getNewFileInSandbox(f, extension[0]);
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.startsWith("mac");
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.startsWith("windows");
    }

    public static String getNewMapsFileNoSandbox(Frame f, String ... extension) {
        File md = RiskUIUtil.getFile(mapsdir);
        File file = RiskUIUtil.getFileOpenDialog(f, md, extension);
        if (file == null) {
            return null;
        }
        if (file.getParentFile().equals(md)) {
            return file.getName();
        }
        return file.getPath();
    }

    public static File getFileOpenDialog(Frame parent, File directory, String ... extension) {
        File file;
        RiskFileFilter filter = new RiskFileFilter(extension);
        if (RiskUIUtil.isMac()) {
            file = RiskUIUtil.getAWTFileDialogFile(parent, directory, filter, 0);
        } else {
            JFileChooser fc = new JFileChooser(directory);
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog(parent);
            if (returnVal == 0) {
                file = fc.getSelectedFile();
                if (file == null) {
                    file = RiskUIUtil.getAWTFileDialogFile(parent, directory, filter, 0);
                }
            } else {
                file = null;
            }
        }
        return file;
    }

    private static File getAWTFileDialogFile(Frame f, File md, FilenameFilter filter, int mode) {
        FileDialog fileDialog = new FileDialog(f);
        fileDialog.setMode(mode);
        if (md != null) {
            fileDialog.setDirectory(md.getAbsolutePath());
        }
        fileDialog.setFilenameFilter(filter);
        fileDialog.setVisible(true);
        String filename = fileDialog.getFile();
        if (filename == null) {
            return null;
        }
        return new File(fileDialog.getDirectory(), filename);
    }

    public static String getNewFileInSandbox(Frame f, String type) {
        List namesvector = RiskUIUtil.getFileList(type);
        JComboBox combobox = new JComboBox(JavaCompatUtil.asVector(namesvector));
        Object[] message = new Object[]{TranslationBundle.getBundle().getString("core.error.applet"), combobox};
        Object[] options = new String[]{"OK", "Cancel"};
        int result = JOptionPane.showOptionDialog(f, message, "select " + type, 2, 3, null, options, options[0]);
        if (result == 0) {
            return combobox.getSelectedItem() + "";
        }
        return null;
    }

    public static String getLoadFileName(Frame frame) {
        if (applet != null) {
            RiskUIUtil.showAppletWarning(frame);
            return null;
        }
        String extension = "save";
        if (webstart != null) {
            try {
                FileOpenService fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
                FileContents fc = fos.openFileDialog(SAVES_DIR, new String[]{extension});
                if (fc != null) {
                    fileio.put(fc.getName(), fc);
                    return fc.getName();
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        File dir = RiskUIUtil.getSaveGameDir();
        RiskFileFilter filter = new RiskFileFilter(extension);
        if (RiskUIUtil.isMac()) {
            File file = RiskUIUtil.getAWTFileDialogFile(frame, dir, filter, 0);
            if (file == null) {
                return null;
            }
            return file.getAbsolutePath();
        }
        JFileChooser fc = new JFileChooser(dir);
        fc.setFileFilter(filter);
        int returnVal = fc.showDialog(frame, TranslationBundle.getBundle().getString("mainmenu.loadgame.loadbutton"));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    public static InputStream getLoadFileInputStream(String file) throws Exception {
        if (webstart != null) {
            FileContents fc = (FileContents)fileio.remove(file);
            return fc.getInputStream();
        }
        return new java.io.FileInputStream(file);
    }

    public static String getSaveFileName(Frame frame) {
        File file;
        if (applet != null) {
            RiskUIUtil.showAppletWarning(frame);
            return null;
        }
        String extension = "save";
        if (webstart != null) {
            JOptionPane.showMessageDialog(frame, "Please make sure to select a file name ending with \"." + extension + "\"");
            return "saves/filename." + extension;
        }
        File dir = RiskUIUtil.getSaveGameDir();
        RiskFileFilter filter = new RiskFileFilter(extension);
        if (RiskUIUtil.isMac()) {
            file = RiskUIUtil.getAWTFileDialogFile(frame, dir, filter, 1);
        } else {
            JFileChooser fc = new JFileChooser(dir);
            fc.setFileFilter(filter);
            int returnVal = fc.showSaveDialog(frame);
            if (returnVal == 0) {
                file = fc.getSelectedFile();
                if (file == null) {
                    file = RiskUIUtil.getAWTFileDialogFile(frame, dir, filter, 1);
                }
            } else {
                file = null;
            }
        }
        if (file == null) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        if (!fileName.endsWith("." + extension)) {
            fileName = fileName + "." + extension;
        }
        return fileName;
    }

    public static void saveFile(String name, RiskGame obj) throws Exception {
        if (webstart != null) {
            ByteArrayOutputStream stor = new ByteArrayOutputStream();
            obj.saveGame(stor);
            ByteArrayInputStream stream = new ByteArrayInputStream(stor.toByteArray());
            FileSaveService fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            FileContents fileContents = fss.saveFileDialog(name.substring(0, name.indexOf(47) + 1), new String[]{name.substring(name.indexOf(46) + 1)}, (InputStream)stream, name.substring(name.indexOf(47) + 1, name.indexOf(46)));
        } else {
            FileOutputStream fileout = new FileOutputStream(name);
            obj.saveGame(fileout);
        }
    }

    public static void showAppletWarning(Frame frame) {
        JOptionPane.showMessageDialog(frame, TranslationBundle.getBundle().getString("core.error.applet"));
    }

    public static String getSystemInfoText() {
        String displayInfo;
        String netInfo;
        String info;
        String environment;
        String cpu;
        String home;
        ResourceBundle resb;
        block7: {
            resb = TranslationBundle.getBundle();
            if (RiskUIUtil.checkForNoSandbox()) {
                home = System.getProperty("java.home");
                cpu = System.getProperty("sun.cpu.isalist");
                if (cpu == null) {
                    cpu = "?";
                }
                environment = System.getProperty("java.runtime.name") + " (" + System.getProperty("java.runtime.version") + ")";
                info = System.getProperty("java.vm.info");
                try {
                    InetAddress localAddress = RiskUtil.getLocalHost();
                    netInfo = localAddress.getHostAddress() + " (" + localAddress.getHostName() + ")";
                }
                catch (UnknownHostException e) {
                    netInfo = resb.getString("about.nonetwork");
                }
            } else {
                home = "?";
                cpu = "?";
                info = "?";
                environment = applet != null ? "applet" : (webstart != null ? "web start (" + webstart + ")" : "?");
                netInfo = "?";
            }
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                AffineTransform dat = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                double scaleX = dat.getScaleX();
                double scaleY = dat.getScaleY();
                Object gnomeDpi = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
                displayInfo = toolkit.getScreenSize().width + "x" + toolkit.getScreenSize().height + " (" + toolkit.getScreenResolution() + "dpi " + (gnomeDpi == null ? "" : gnomeDpi + "gnome/dpi ") + "scaleX=" + scaleX + " scaleY=" + scaleY + ") density=" + GraphicsUtil.density + " scale=" + GraphicsUtil.scale;
            }
            catch (HeadlessException ex) {
                displayInfo = ex.getMessage();
                if (displayInfo == null) break block7;
                displayInfo = JavaCompatUtil.replaceAll(displayInfo, "\n", " ");
            }
        }
        return " " + RiskUtil.RISK_VERSION + " (save: " + RiskGame.SAVE_VERSION + " network: " + "14" + ") " + (RiskUtil.isOldVersion() ? "OLD VERSION" : "") + "\n system:" + Locale.getDefault() + " current:" + resb.getLocale() + " \n " + netInfo + " \n " + RiskUIUtil.getOSString() + " \n " + cpu + " \n " + UIManager.getLookAndFeel() + " \n " + displayInfo + " \n " + System.getProperty("java.vendor") + " \n " + System.getProperty("java.vendor.url") + " \n " + environment + " \n " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + ", " + info + ") \n " + System.getProperty("java.specification.version") + " (" + System.getProperty("java.version") + ") \n " + home + " \n " + System.getProperty("java.class.version");
    }

    public static String getOSString() {
        String patchAndArch;
        if (RiskUIUtil.checkForNoSandbox()) {
            String patch = System.getProperty("sun.os.patch.level");
            patchAndArch = (patch == null ? "" : patch + " ") + "(" + System.getProperty("sun.arch.data.model") + "bit)";
        } else {
            patchAndArch = "?";
        }
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + patchAndArch + " on " + System.getProperty("os.arch");
    }

    public static void openAbout(Frame frame, String product, String version) {
        AboutDialog aboutDialog = new AboutDialog(frame, true, product, version);
        Dimension frameSize = frame.getSize();
        Dimension aboutSize = aboutDialog.getSize();
        int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
        int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        aboutDialog.setLocation(x, y);
        aboutDialog.setVisible(true);
    }

    public static boolean getAddLobby() {
        boolean canlobby = false;
        if (RiskUIUtil.checkForNoSandbox()) {
            try {
                URL url = new URL(RiskUtil.RISK_LOBBY_URL);
                BufferedReader bufferin = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer buffer = new StringBuffer();
                String input = bufferin.readLine();
                while (input != null) {
                    buffer.append(input + "\n");
                    input = bufferin.readLine();
                }
                String[] lobbyinfo = buffer.toString().split("\\n");
                if (lobbyinfo.length >= 1 && lobbyinfo[0].equals("LOBBYOK")) {
                    if (lobbyinfo.length >= 2) {
                        lobbyAppletURL = lobbyinfo[1];
                        canlobby = true;
                    }
                    if (lobbyinfo.length >= 3) {
                        lobbyURL = lobbyinfo[2];
                        canlobby = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return canlobby;
    }

    public static void checkForUpdates(Risk risk) {
        if (RiskUIUtil.checkForNoSandbox()) {
            String v = RiskUtil.getNewVersionCheck();
            if (v != null) {
                ResourceBundle resb = TranslationBundle.getBundle();
                v = JavaCompatUtil.replaceAll(resb.getString("mainmenu.new-version.text"), "{0}", RiskUtil.GAME_NAME) + " " + v;
                String link = RiskUIUtil.getURL(v);
                if (link != null) {
                    int result = JOptionPane.showConfirmDialog(null, v, resb.getString("mainmenu.new-version.title"), 2);
                    if (result == 0) {
                        try {
                            RiskUtil.streamOpener.openURL(new URL(link));
                        }
                        catch (Throwable th) {
                            RiskUtil.printStackTrace(th);
                        }
                    }
                } else {
                    risk.showMessageDialog(v);
                }
            }
            try {
                MapUpdateService.getInstance().init(RiskUIUtil.getFileList("map"), MapServerClient.MAP_PAGE);
            }
            catch (Throwable th) {
                RiskUtil.printStackTrace("unable to check for map updates", th);
            }
        }
    }

    public static String getURL(String v) {
        int site = v.indexOf("http://");
        if (site >= 0) {
            int end = v.length();
            String chars = " \n\r\t";
            for (int c = 0; c < chars.length(); ++c) {
                int r = v.indexOf(chars.charAt(c), site);
                if (r < 0 || r >= end) continue;
                end = r;
            }
            return v.substring(site, end);
        }
        return null;
    }

    public static void runLobby(Risk risk) {
        try {
            if (lobbyURL != null) {
                URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{new URL("jar:" + lobbyURL + "/LobbyClient.jar!/")});
                Class<?> lobbyclass = ucl.loadClass("org.lobby.client.LobbyClientGUI");
                final JPanel panel = (JPanel)lobbyclass.getConstructor(URL.class).newInstance(new URL(lobbyURL));
                JFrame gui = new JFrame("yura.net Lobby");
                gui.setContentPane(panel);
                gui.setSize(800, 600);
                gui.setVisible(true);
                gui.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent evt) {
                        panel.setVisible(false);
                    }
                });
                panel.setVisible(true);
            } else {
                RiskUtil.openURL(new URL(lobbyAppletURL));
            }
        }
        catch (Exception e) {
            risk.showMessageDialog("unable to run the lobby: " + e.toString());
        }
    }

    private static File getFile(URL url) {
        File md;
        String dir = url.toString();
        try {
            md = new File(new URI(dir));
        }
        catch (IllegalArgumentException e) {
            if (dir.startsWith("file://")) {
                md = new File(dir.substring(5, dir.length()).replaceAll("\\%20", " "));
            } else {
                System.err.println("this should never happen! bad file: " + dir);
                md = new File("maps/");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cant create file: " + dir, e);
        }
        return md;
    }

    private static void setupLookAndFeel() {
        try {
            AffineTransform dat;
            String systemLookAndFeel = UIManager.getSystemLookAndFeelClassName();
            String os = System.getProperty("os.name");
            if (os != null && os.startsWith("Linux") && !systemLookAndFeel.equals(GTK_PLAF_CLASS) && RiskUIUtil.isPLAFInstalled(GTK_PLAF_CLASS)) {
                systemLookAndFeel = GTK_PLAF_CLASS;
            }
            if ((dat = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform()).getScaleX() != 1.0 && GTK_PLAF_CLASS.equals(systemLookAndFeel)) {
                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
                UIManager.put("ToolBar:Button[Disabled].textForeground", UIManager.getColor("nimbusDisabledText"));
                UIManager.put("ToolBar:ToggleButton[Disabled].textForeground", UIManager.getColor("nimbusDisabledText"));
            } else {
                UIManager.setLookAndFeel(systemLookAndFeel);
                if (GTK_PLAF_CLASS.equals(systemLookAndFeel) && !RiskUIUtil.canDrawTabs()) {
                    UIManager.put("TabbedPaneUI", BasicTabbedPaneUI.class.getName());
                }
            }
        }
        catch (Exception e) {
            RiskUtil.printStackTrace(e);
        }
        if (RiskUIUtil.checkForNoSandbox()) {
            try {
                new JFileChooser();
            }
            catch (Throwable th) {
                Logger.getLogger(RiskUIUtil.class.getName()).log(Level.INFO, "PLAF JFileChooser FAIL, falling back to metal", th);
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e) {
                    RiskUtil.printStackTrace(e);
                }
            }
        }
    }

    private static boolean isPLAFInstalled(String className) {
        UIManager.LookAndFeelInfo[] plafs = UIManager.getInstalledLookAndFeels();
        for (int c = 0; c < plafs.length; ++c) {
            if (!className.equals(plafs[c].getClassName())) continue;
            return true;
        }
        return false;
    }

    private static boolean canDrawTabs() {
        try {
            int[] out;
            JTabbedPane component = new JTabbedPane();
            Region id = Region.TABBED_PANE_TAB;
            SynthStyle style = SynthLookAndFeel.getStyle(component, id);
            SynthContext context = new SynthContext(component, id, style, 1);
            SynthPainter painter = style.getPainter(context);
            BufferedImage img = new BufferedImage(50, 25, 6);
            painter.paintTabbedPaneTabBackground(context, img.getGraphics(), 0, 0, img.getWidth(), img.getHeight(), 0);
            for (int a : out = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth())) {
                if (a == 0) continue;
                return true;
            }
            return false;
        }
        catch (Throwable th) {
            return true;
        }
    }

    public static void fontSize(int szIncr) {
        if ("Nimbus".equals(UIManager.getLookAndFeel().getName())) {
            try {
                Font font = (Font)UIManager.get("defaultFont");
                UIManager.setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
                UIManager.getLookAndFeelDefaults().put("defaultFont", new FontUIResource(font.getName(), font.getStyle(), font.getSize() + szIncr));
                return;
            }
            catch (Exception font) {
                // empty catch block
            }
        }
        HashMap<Object, Object> uidefCopy = new HashMap<Object, Object>(UIManager.getDefaults());
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        HashMap<Font, FontUIResource> newFonts = new HashMap<Font, FontUIResource>();
        for (Map.Entry e : uidefCopy.entrySet()) {
            Object val = e.getValue();
            if (String.valueOf(e.getKey()).toLowerCase().endsWith("font")) {
                Object av;
                if (val instanceof UIDefaults.ActiveValue) {
                    av = (UIDefaults.ActiveValue)val;
                    val = av.createValue(lookAndFeelDefaults);
                } else if (val instanceof UIDefaults.LazyValue) {
                    av = (UIDefaults.LazyValue)val;
                    val = av.createValue(lookAndFeelDefaults);
                }
            }
            if (!(val instanceof Font)) continue;
            Font fui = (Font)val;
            FontUIResource newFont = (FontUIResource)newFonts.get(fui);
            if (newFont == null) {
                newFont = new FontUIResource(fui.getName(), fui.getStyle(), fui.getSize() + szIncr);
                newFonts.put(fui, newFont);
            }
            lookAndFeelDefaults.put(e.getKey(), newFont);
        }
    }

    public static Color getColorFromColorUIResource(Color colorUIResource) {
        return colorUIResource instanceof UIResource ? new Color(colorUIResource.getRGB(), true) : colorUIResource;
    }

    public static void parseArgs(String[] args) {
        TranslationBundle.parseArgs(args);
        for (int nA = 0; nA < args.length; ++nA) {
            if (args[nA].length() > 5 && args[nA].substring(0, 5).equals("maps=")) {
                maps = args[nA].substring(5);
            }
            if (args[nA].length() <= 6 || !args[nA].substring(0, 6).equals("cards=")) continue;
            cards = args[nA].substring(6);
        }
        RiskUIUtil.setupMapsDir(null);
    }

    public static void openFile(String[] argv, Risk r) {
        ArrayList<String> files = new ArrayList<String>();
        for (int c = 0; c < argv.length; ++c) {
            String arg = argv[c];
            if (arg.indexOf(61) >= 0 || arg.length() <= 0 || arg.charAt(0) == '-') continue;
            files.add(arg);
        }
        if (files.size() == 1) {
            r.parser("loadgame " + files.get(0));
        } else if (files.size() > 1) {
            JOptionPane.showMessageDialog(null, "unknown command: " + files);
        }
    }

    public static Color getTextColorFor(Color color) {
        return new Color(ColorUtil.getTextColorFor(color.getRGB()));
    }

    public static void donate(Component parent) {
        try {
            RiskUtil.donate();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "Unable to open web browser: " + e.getMessage(), "Error", 0);
        }
    }

    public static boolean canWriteTo(File dir) {
        try {
            File tmp = new File(dir, "del.me");
            tmp.createNewFile();
            tmp.deleteOnExit();
            tmp.delete();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static File getSaveGameDir() {
        File savedGames;
        if (gameDir != null) {
            return gameDir;
        }
        File saveDir = new File(SAVES_DIR);
        if (RiskUIUtil.canWriteTo(saveDir)) {
            gameDir = saveDir;
            return saveDir;
        }
        File userHome = new File(System.getProperty("user.home"));
        File userMaps = new File(userHome, RiskUtil.GAME_NAME + " Saves");
        if (RiskUIUtil.isWindows() && !userMaps.exists() && (savedGames = new File(userHome, "Saved Games")).exists() && savedGames.isDirectory()) {
            userMaps = new File(savedGames, userMaps.getName());
        }
        if (!userMaps.isDirectory() && !userMaps.mkdirs()) {
            throw new RuntimeException("can not create dir " + userMaps);
        }
        gameDir = userMaps;
        return userMaps;
    }

    public static File getSaveMapDir() {
        if (mapsDir != null) {
            return mapsDir;
        }
        File saveDir = RiskUIUtil.getFile(mapsdir);
        if (RiskUIUtil.canWriteTo(saveDir)) {
            mapsDir = saveDir;
            return saveDir;
        }
        File userHome = new File(System.getProperty("user.home"));
        File userMaps = new File(userHome, RiskUtil.GAME_NAME + " Maps");
        if (!userMaps.isDirectory() && !userMaps.mkdirs()) {
            throw new RuntimeException("can not create dir " + userMaps + " exists=" + userMaps.exists() + " isDirectory=" + userMaps.isDirectory() + " userHome.exists=" + userHome.exists() + " userHome.canWrite=" + userHome.canWrite());
        }
        mapsDir = userMaps;
        return userMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(InputStream in) throws IOException {
        try {
            BufferedImage img = ImageIO.read(in);
            if (img == null) {
                throw new IOException("ImageIO.read returned null");
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setMinimumSize(Window window, Dimension size) {
        block3: {
            try {
                window.setMinimumSize(size);
            }
            catch (NoSuchMethodError ex) {
                if (window instanceof Dialog) {
                    ((Dialog)window).setResizable(false);
                }
                if (!(window instanceof Frame)) break block3;
                ((Frame)window).setResizable(false);
            }
        }
    }

    public static void initAudio(Risk risk) {
        try {
            GameSound.INSTANCE.setAudioSystem(risk, new SimpleAudio());
            GameSound.INSTANCE.load("medieval");
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace("SimpleAudio not loaded", th);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            boolean appActive = true;
            boolean oldValue;

            public void eventDispatched(AWTEvent event) {
                if (event instanceof WindowEvent) {
                    WindowEvent we = (WindowEvent)event;
                    if (we.getID() == 207 && !this.appActive) {
                        if (this.oldValue) {
                            GameSound.INSTANCE.setMusicEnabled(this.oldValue);
                        }
                        this.appActive = true;
                    } else if (we.getID() == 208 && we.getOppositeWindow() == null && Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(207) == null) {
                        RiskUIUtil.invokeLater(200, new Runnable(){

                            public void run() {
                                if (FocusManager.getCurrentManager().getActiveWindow() != null) {
                                    return;
                                }
                                oldValue = GameSound.INSTANCE.isMusicEnabled();
                                GameSound.INSTANCE.setMusicEnabled(false);
                                appActive = false;
                            }
                        });
                    }
                }
            }
        }, 524288L);
    }

    public static void invokeLater(int delay, final Runnable run) {
        new Timer(delay, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    run.run();
                }
                finally {
                    ((Timer)e.getSource()).stop();
                }
            }
        }).start();
    }

    public static void openOptions(Component parentComponent, Risk myrisk, boolean myTurn, Preferences preferences) {
        int result;
        ResourceBundle resB = TranslationBundle.getBundle();
        JCheckBox showDice = new JCheckBox("Show dice", Risk.isShowDice());
        JSpinner aiwait = new JSpinner(new SpinnerNumberModel(AIManager.getWait(), 0, 10000, 100));
        JPanel aiWaitPanel = new JPanel();
        aiWaitPanel.add(new JLabel("AI wait time:"));
        aiWaitPanel.add(aiwait);
        aiWaitPanel.add(new JLabel("milliseconds"));
        JCheckBox colorBlindEnabled = new JCheckBox(resB.getString("game.menu.colorblind"), colorBlind);
        JCheckBox soundEnabled = new JCheckBox(resB.getString("game.menu.sound"), GameSound.INSTANCE.isSoundEnabled());
        JCheckBox musicEnabled = new JCheckBox(resB.getString("game.menu.music"), GameSound.INSTANCE.isMusicEnabled());
        JCheckBox autoEndGo = new JCheckBox("Auto End Go", myrisk.getAutoEndGo());
        JCheckBox autoDefend = new JCheckBox("Auto Defend", myrisk.getAutoDefend());
        if (!myTurn) {
            autoEndGo.setEnabled(false);
            autoDefend.setEnabled(false);
        }
        if ((result = JOptionPane.showConfirmDialog(parentComponent, new Component[]{showDice, aiWaitPanel, colorBlindEnabled, soundEnabled, musicEnabled, autoEndGo, autoDefend}, "Options", 2, -1)) == 0) {
            Risk.setShowDice(showDice.isSelected());
            AIManager.setWait((Integer)aiwait.getValue());
            GameSound.INSTANCE.setSoundEnabled(soundEnabled.isSelected());
            GameSound.INSTANCE.setMusicEnabled(musicEnabled.isSelected());
            colorBlind = colorBlindEnabled.isSelected();
            preferences.putBoolean("color_blind", colorBlind);
            RiskSettings.saveSettingsToPrefs(preferences);
            if (autoEndGo.isEnabled()) {
                boolean autoendgo = autoEndGo.isSelected();
                if (myrisk.getAutoEndGo() != autoendgo) {
                    myrisk.parser("autoendgo " + (autoendgo ? "on" : "off"));
                }
            }
            if (autoDefend.isEnabled()) {
                boolean autodefend = autoDefend.isSelected();
                if (myrisk.getAutoDefend() != autodefend) {
                    myrisk.parser("autodefend " + (autodefend ? "on" : "off"));
                }
            }
        }
    }

    public static Image getIconForColor(int color) {
        return colorBlind ? icons.get(color) : null;
    }

    public static void setColorBlindMode(Preferences prefs) {
        if (prefs != null) {
            colorBlind = prefs.getBoolean("color_blind", false);
        }
    }

    static {
        if (RiskUtil.streamOpener == null) {
            RiskUtil.streamOpener = new RiskIO(){

                public InputStream openStream(String name) throws IOException {
                    return RiskUIUtil.getRiskFileURL(name).openStream();
                }

                public InputStream openMapStream(String name) throws IOException {
                    try {
                        File mapsDir = RiskUIUtil.getSaveMapDir();
                        return new FileInputStream(new File(mapsDir, name));
                    }
                    catch (Throwable th) {
                        try {
                            return new URL(mapsdir, name.contains(":") ? "/" + name : name).openStream();
                        }
                        catch (Throwable ex) {
                            IOException exception = new IOException("openMap error \"" + name + "\" " + ex);
                            exception.initCause(th);
                            throw exception;
                        }
                    }
                }

                public ResourceBundle getResourceBundle(Class c, String n, Locale l) {
                    return ResourceBundle.getBundle(c.getPackage().getName() + "." + n, l);
                }

                public void openURL(URL url) throws Exception {
                    RiskUIUtil.riskOpenURL(url);
                }

                public void openDocs(String doc) throws Exception {
                    RiskUIUtil.riskOpenURL(RiskUIUtil.getRiskFileURL(doc));
                }

                public void saveGameFile(String name, RiskGame obj) throws Exception {
                    RiskUIUtil.saveFile(name, obj);
                }

                public InputStream loadGameFile(String file) throws Exception {
                    return RiskUIUtil.getLoadFileInputStream(file);
                }

                public OutputStream saveMapFile(String fileName) throws Exception {
                    return RiskUtil.getOutputStream(RiskUIUtil.getSaveMapDir(), fileName);
                }

                public void getMap(String filename, Observer observer) {
                    GetMap.getMap(filename, observer);
                }

                public void renameMapFile(String oldName, String newName) {
                    File oldFile = new File(RiskUIUtil.getSaveMapDir(), oldName);
                    File newFile = new File(RiskUIUtil.getSaveMapDir(), newName);
                    RiskUtil.rename(oldFile, newFile);
                }

                public boolean deleteMapFile(String mapUID) {
                    File mapFile = new File(RiskUIUtil.getSaveMapDir(), mapUID);
                    if (mapFile.exists()) {
                        return mapFile.delete();
                    }
                    return false;
                }
            };
        }
        UIImagesReferences = new HashMap();
        fileio = new HashMap();
        icons = new HashMap<Integer, Image>();
        icons.put(-65536, RiskUIUtil.getUIImage(PicturePanel.class, "/color_red.png"));
        icons.put(-16776961, RiskUIUtil.getUIImage(PicturePanel.class, "/color_blue.png"));
        icons.put(-256, RiskUIUtil.getUIImage(PicturePanel.class, "/color_yellow.png"));
        icons.put(-16711681, RiskUIUtil.getUIImage(PicturePanel.class, "/color_cyan.png"));
        icons.put(-16711936, RiskUIUtil.getUIImage(PicturePanel.class, "/color_green.png"));
        icons.put(-65281, RiskUIUtil.getUIImage(PicturePanel.class, "/color_magenta.png"));
    }

    public static class FileInputStream
    extends java.io.FileInputStream {
        private final File file;

        private FileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

