/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.client;

import java.awt.Component;
import java.awt.Graphics;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.microedition.lcdui.Image;
import javax.swing.Icon;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.lobby.mini.MapPreviewClient;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.swing.GraphicsUtil;

public class RiskMap {
    private static final Logger logger = Logger.getLogger(RiskMap.class.getName());
    private static MapPreviewClient mapPreviewClient = new MapPreviewClient(){

        public void publishMap(net.yura.domination.mapstore.Map map) {
            RiskMap.setMapMetaData(map);
        }

        public void publishImg(String mapUID) {
            RiskMap riskMap = RiskMap.getRiskMap(mapUID);
            for (int c = 0; c < riskMap.components.size(); ++c) {
                ((Component)riskMap.components.get(c)).repaint();
            }
            riskMap.components = null;
        }
    };
    private static Map<String, RiskMap> mapUIDToIcon = Collections.synchronizedMap(new WeakHashMap());
    private final String mapUID;
    private net.yura.domination.mapstore.Map lazyMapMetadata;
    private net.yura.mobile.gui.Icon lazyMapIcon;
    private String[] lazyMapMissions;
    private final Map<Long, Icon> swingIconMap = new HashMap<Long, Icon>();
    private List<Component> components = new ArrayList<Component>();

    private RiskMap(String mapUID) {
        this.mapUID = mapUID;
    }

    public static void setMapMetaData(net.yura.domination.mapstore.Map map) {
        RiskMap.getRiskMap((String)MapPreview.getFileUID((String)map.getMapUrl())).lazyMapMetadata = map;
    }

    public static RiskMap getRiskMap(String mapUID) {
        RiskMap icon = mapUIDToIcon.get(mapUID);
        if (icon == null) {
            icon = new RiskMap(mapUID);
            mapUIDToIcon.put(mapUID, icon);
        }
        return icon;
    }

    public Icon getIcon(int w, int h, Component comp) {
        List<Component> comps;
        final int width = GraphicsUtil.scale(w);
        final int height = GraphicsUtil.scale(h);
        long id = ByteBuffer.allocate(8).putInt(width).putInt(height).getLong(0);
        Icon icon = this.swingIconMap.get(id);
        if (icon == null) {
            icon = new Icon(){

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Image img;
                    if (RiskMap.this.lazyMapIcon == null) {
                        RiskMap.this.lazyMapIcon = mapPreviewClient.getIconForMap(RiskMap.this.mapUID);
                        if (RiskMap.this.lazyMapIcon.getImage() != null) {
                            RiskMap.this.components = null;
                        }
                    }
                    if ((img = RiskMap.this.lazyMapIcon.getImage()) != null) {
                        g.drawImage(img._image, x, y, width, height, c);
                    }
                }

                public int getIconWidth() {
                    return width;
                }

                public int getIconHeight() {
                    return height;
                }
            };
            this.swingIconMap.put(id, icon);
        }
        if ((comps = this.components) != null) {
            comps.add(comp);
        }
        return icon;
    }

    public boolean isLocalMap() {
        return MapPreview.haveLocalMap(this.mapUID) && !MapUpdateService.getInstance().contains(this.mapUID);
    }

    public String toString() {
        return this.lazyMapMetadata == null ? this.mapUID : this.lazyMapMetadata.getName();
    }

    public String getID() {
        return this.mapUID;
    }

    public String[] getMissions() {
        if (this.lazyMapMissions != null) {
            return this.lazyMapMissions;
        }
        Map mapinfo = RiskUtil.loadInfo(this.mapUID, false);
        String cardsFile = (String)mapinfo.get("crd");
        if (cardsFile != null) {
            Map cardsinfo = RiskUtil.loadInfo(cardsFile, true);
            this.lazyMapMissions = (String[])cardsinfo.get("missions");
        } else {
            logger.warning("no crd file in " + this.mapUID);
            this.lazyMapMissions = new String[0];
        }
        return this.lazyMapMissions;
    }

    net.yura.domination.mapstore.Map getMap() {
        return this.lazyMapMetadata;
    }
}

