/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;

public class GetMap
extends Observable
implements MapServerListener {
    MapServerClient client;
    String filename;

    private GetMap() {
    }

    public static void getMap(String filename, Observer gml) {
        GetMap get = new GetMap();
        get.filename = filename;
        get.addObserver(gml);
        get.client = new MapServerClient(get);
        get.client.start();
        get.client.makeRequestXML(MapServerClient.MAP_PAGE, "mapfile", filename);
    }

    public void gotResultMaps(String url, List maps) {
        if (maps.size() == 1) {
            Map themap = (Map)maps.get(0);
            this.client.downloadMap(MapPreview.getURL(MapPreview.getContext(url), themap.mapUrl));
        } else {
            String error = "wrong number of maps on server: " + maps.size() + " for map: " + this.filename;
            System.err.println("invalid responce from MapStore: " + error);
            this.onError(error);
        }
    }

    private void onError(String error) {
        System.out.println("GetMap Error: " + error);
        this.notifyListeners(RiskUtil.ERROR);
    }

    private void notifyListeners(Object arg) {
        this.client.kill();
        this.setChanged();
        this.notifyObservers(arg);
    }

    public void downloadFinished(String mapUID) {
        this.notifyListeners(RiskUtil.SUCCESS);
    }

    public void onXMLError(String string) {
        this.onError(string);
    }

    public void onDownloadError(String string) {
        this.onError(string);
    }

    public void gotResultCategories(String url, List categories) {
    }

    public void publishImg(Object param) {
    }
}

