/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.BadgeButton;
import net.yura.domination.mapstore.Category;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapRenderer;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.RadioButton;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.gui.plaf.LookAndFeel;
import net.yura.mobile.gui.plaf.SynthLookAndFeel;
import net.yura.mobile.io.ClipboardManager;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Properties;
import net.yura.swingme.core.CoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapChooser
implements ActionListener,
MapServerListener {
    private Properties resBundle = CoreUtil.wrap(TranslationBundle.getBundle());
    private XULLoader loader;
    private ActionListener al;
    protected MapServerClient client;
    private List<String> localMaps;
    private Set<String> allowedMaps;
    private net.yura.mobile.gui.components.List list;
    private String selectedMap;

    public static void loadThemeExtension() {
        InputStream themeData = Application.getResourceAsStream((String)"/ms_tabbar.xml");
        try {
            LookAndFeel laf = DesktopPane.getDesktopPane().getLookAndFeel();
            if (laf instanceof SynthLookAndFeel) {
                ((SynthLookAndFeel)laf).load(themeData);
            } else {
                System.err.println("LookAndFeel not SynthLookAndFeel " + laf);
            }
        }
        catch (Exception ex) {
            RiskUtil.printStackTrace(ex);
        }
        finally {
            RiskUtil.close(themeData);
        }
    }

    public MapChooser(ActionListener al, List<String> localMaps, Set<String> allowedMaps) {
        this.al = al;
        this.localMaps = localMaps;
        this.allowedMaps = allowedMaps;
        try {
            this.loader = XULLoader.inflate((Reader)new InputStreamReader(Application.getResourceAsStream((String)"/ms_maps.xml"), RiskUtil.UTF_8), (ActionListener)this, (Properties)this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Panel TabBar = (Panel)this.loader.find("TabBar");
        if (TabBar != null) {
            int count = 0;
            if (allowedMaps != null) {
                for (String localMap : localMaps) {
                    if (!allowedMaps.contains(localMap)) continue;
                    ++count;
                }
            }
            if (allowedMaps != null && count == allowedMaps.size()) {
                TabBar.setVisible(false);
            } else {
                Vector buttons = TabBar.getComponents();
                Icon on = new Icon("/ms_bar_on.png");
                Icon off = new Icon("/ms_bar_off.png");
                int w = off.getIconWidth() / buttons.size();
                for (int c = 0; c < buttons.size(); ++c) {
                    RadioButton b = (RadioButton)buttons.get(c);
                    Icon oni = on.getSubimage(c * w, 0, w, off.getIconHeight());
                    Icon offi = off.getSubimage(c * w, 0, w, off.getIconHeight());
                    b.setIcon(offi);
                    b.setSelectedIcon(oni);
                    b.setRolloverIcon(offi);
                    b.setRolloverSelectedIcon(oni);
                    b.setToolTipText(b.getText());
                    b.setText("");
                    b.setMargin(0);
                }
            }
        }
        this.list = (net.yura.mobile.gui.components.List)this.loader.find("ResultList");
        if (Application.getPlatform() == 8) {
            this.list.setDoubleClick(true);
        }
        MapRenderer r = new MapRenderer(this);
        this.list.setCellRenderer((ListCellRenderer)r);
        this.list.setFixedCellHeight(Math.max(XULLoader.adjustSizeToDensity((int)100), r.getFixedCellHeight()));
        this.list.setFixedCellWidth(10);
        this.client = new MapServerClient(this);
        this.client.start();
        this.activateGroup("MapView");
        MapUpdateService.getInstance().addObserver((BadgeButton)this.loader.find("updateButton"));
    }

    public void destroy() {
        MapUpdateService.getInstance().deleteObserver((BadgeButton)this.loader.find("updateButton"));
        this.client.kill();
        this.client = null;
    }

    @Override
    public void publishImg(Object key) {
        if (this.client != null) {
            this.list.repaint();
        }
    }

    void makeRequestForMap(String key, String value) {
        this.client.makeRequestXML(MapServerClient.MAP_PAGE, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(String actionCommand) {
        if ("local".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            new Thread(){

                public void run() {
                    Vector<Map> riskmaps = new Vector<Map>(MapChooser.this.localMaps.size());
                    for (int c = 0; c < MapChooser.this.localMaps.size(); ++c) {
                        final String file = (String)MapChooser.this.localMaps.get(c);
                        try {
                            Map map = MapPreview.createMap(file);
                            riskmaps.add(map);
                            continue;
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("error creating map: " + file), (Throwable)ex);
                            Map map = new Map();
                            map.setMapUrl(file);
                            map.setName(file);
                            riskmaps.add(map);
                            OptionPane.showConfirmDialog((ActionListener)new ActionListener(){

                                public void actionPerformed(String actionCommand) {
                                    if ("ok".equals(actionCommand)) {
                                        RiskUtil.streamOpener.deleteMapFile(file);
                                    }
                                }
                            }, (Object)("Error in file: " + file + ". Delete?"), (String)"Map Error", (int)2);
                        }
                    }
                    Collections.sort(riskmaps, new Comparator(){

                        public int compare(Object t1, Object t2) {
                            Map m1 = (Map)t1;
                            Map m2 = (Map)t2;
                            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
                        }
                    });
                    MapChooser.this.setListData(null, riskmaps);
                }
            }.start();
        } else if ("catagories".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.client.makeRequestXML(MapServerClient.CATEGORIES_PAGE, null, null);
        } else if ("top25".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.activateGroup("Top25View");
        } else if ("search".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.actionPerformed("doMapSearch");
        } else if ("update".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            List<Map> mapsToUpdate = MapUpdateService.getInstance().mapsToUpdate;
            Component updateAll = this.loader.find("updateAll");
            if (mapsToUpdate.isEmpty()) {
                updateAll.setVisible(false);
                this.show("AllUpToDate");
            } else {
                updateAll.setVisible(true);
                this.setListData(MapServerClient.MAP_PAGE, new Vector<Map>(mapsToUpdate));
            }
        } else if ("updateall".equals(actionCommand)) {
            List<Map> mapsToUpdate;
            List<Map> updateAll = mapsToUpdate = MapUpdateService.getInstance().mapsToUpdate;
            synchronized (updateAll) {
                for (int c = 0; c < mapsToUpdate.size(); ++c) {
                    this.click(mapsToUpdate.get(c));
                }
            }
        } else if ("TOP_NEW".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_NEW");
        } else if ("TOP_RATINGS".equals(actionCommand)) {
            if ("true".equals(System.getProperty("debug"))) {
                System.err.println("no ratings :-(");
            }
            this.clearList();
            this.makeRequestForMap("sort", "TOP_RATINGS");
        } else if ("TOP_DOWNLOADS".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_DOWNLOADS");
        } else if ("listSelect".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Category) {
                Category cat = (Category)value;
                this.clearList();
                this.makeRequestForMap("category", cat.getId());
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.click(map);
            }
        } else if ("mapInfo".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                OptionPane.showMessageDialog(null, (Object)MapChooser.getMapInfo(map), (String)map.toString(), (int)1);
            }
        } else if ("sameAuthor".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.getAuthorId() == null) {
                    this.client.makeRequestMap(MapServerClient.MAP_PAGE, MapPreview.getFileUID(map.getMapUrl()), new Observer(){

                        public void update(Observable o, Object map) {
                            if (map != null) {
                                MapChooser.this.client.makeRequestXML(MapServerClient.MAP_PAGE, "author", ((Map)map).getAuthorId());
                            } else {
                                MapChooser.this.setListData(null, Collections.EMPTY_LIST);
                            }
                        }
                    });
                } else {
                    this.makeRequestForMap("author", map.getAuthorId());
                }
            }
        } else if ("copyId".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Map) {
                ClipboardManager.getInstance().setText(((Map)value).getId());
            }
        } else if ("delMap".equals(actionCommand)) {
            Map map;
            String mapUID;
            Object value = this.list.getSelectedValue();
            if (value instanceof Map && this.localMaps.contains(mapUID = MapPreview.getFileUID((map = (Map)value).getMapUrl()))) {
                this.client.makeRequestMap(MapServerClient.MAP_PAGE, mapUID, new Observer(){

                    public void update(Observable o, Object map) {
                        if (map != null) {
                            try {
                                java.util.Map mapinfo = RiskUtil.loadInfo(mapUID, false);
                                String cardsFile = (String)mapinfo.get("crd");
                                String prvFile = (String)mapinfo.get("prv");
                                String picFile = (String)mapinfo.get("pic");
                                String mapFile = (String)mapinfo.get("map");
                                RiskUtil.streamOpener.deleteMapFile(mapFile);
                                RiskUtil.streamOpener.deleteMapFile(picFile);
                                if (prvFile != null) {
                                    RiskUtil.streamOpener.deleteMapFile("preview/" + prvFile);
                                }
                                if (!"risk.cards".equals(cardsFile) && !"nomission.cards".equals(cardsFile)) {
                                    RiskUtil.streamOpener.deleteMapFile(cardsFile);
                                }
                            }
                            catch (Exception ex) {
                                Logger.warn((String)("unable to delete supplementary map files for: " + mapUID), (Throwable)ex);
                            }
                            if (RiskUtil.streamOpener.deleteMapFile(mapUID)) {
                                MapChooser.this.localMaps.remove(mapUID);
                                String context = ((MapRenderer)MapChooser.this.list.getCellRenderer()).getContext();
                                if (context == null) {
                                    MapChooser.this.actionPerformed("local");
                                } else {
                                    MapChooser.this.list.repaint();
                                }
                            } else {
                                OptionPane.showMessageDialog(null, (Object)"could not delete this map", (String)"error", (int)0);
                            }
                        } else {
                            OptionPane.showMessageDialog(null, (Object)"can not delete bundled map", (String)"message", (int)0);
                        }
                    }
                });
            }
        } else if ("defaultMap".equals(actionCommand)) {
            this.chosenMap(RiskGame.getDefaultMap());
        } else if ("cancel".equals(actionCommand)) {
            this.al.actionPerformed(null);
        } else if ("doMapSearch".equals(actionCommand)) {
            TextComponent.closeNativeEditor();
            String text = ((TextComponent)this.loader.find("mapSearchBox")).getText();
            this.clearList();
            if (text != null && !"".equals(text)) {
                this.makeRequestForMap("search", text);
            } else {
                this.setListData(null, null);
            }
        } else {
            System.out.println("MapChooser unknown command " + actionCommand);
        }
    }

    public void click(Map map) {
        String fileUID = MapPreview.getFileUID(map.getMapUrl());
        String context = ((MapRenderer)this.list.getCellRenderer()).getContext();
        if (context != null) {
            if (this.client.isDownloading(fileUID)) {
                OptionPane.showMessageDialog(null, (Object)"already downloading", (String)"message", (int)0);
            } else if (this.localMaps.contains(fileUID)) {
                java.util.Map info = RiskUtil.loadInfo(fileUID, false);
                String ver = (String)info.get("ver");
                if (map.needsUpdate(ver)) {
                    this.client.downloadMap(MapPreview.getURL(context, map.mapUrl));
                    this.list.repaint();
                    return;
                }
                String pic = (String)info.get("pic");
                String crd = (String)info.get("crd");
                String imap = (String)info.get("map");
                String prv = (String)info.get("prv");
                if (!MapPreview.fileExists(pic) || !MapPreview.fileExists(crd) || !MapPreview.fileExists(imap) || prv != null && !MapPreview.fileExists("preview/" + prv)) {
                    this.client.downloadMap(MapPreview.getURL(context, map.mapUrl));
                    this.list.repaint();
                    return;
                }
                this.chosenMap(fileUID);
            } else {
                this.client.downloadMap(MapPreview.getURL(context, map.mapUrl));
                this.list.repaint();
            }
        } else {
            this.chosenMap(fileUID);
        }
    }

    private void chosenMap(String mapName) {
        this.selectedMap = mapName;
        this.al.actionPerformed(null);
    }

    public void mainCatList(String actionCommand) {
        Enumeration group = ((ButtonGroup)this.loader.getGroups().get("MapView")).getElements();
        while (group.hasMoreElements()) {
            Button button = (Button)group.nextElement();
            String action = button.getActionCommand();
            Component panel = this.loader.find(action + "Bar");
            panel.setVisible(action.equals(actionCommand));
        }
        this.clearList();
    }

    void clearList() {
        this.show("Loading");
    }

    public Panel getRoot() {
        return (Panel)this.loader.getRoot();
    }

    public String getSelectedMap() {
        return this.selectedMap;
    }

    @Override
    public void gotResultCategories(String url, List items) {
        this.setListData(url, items);
    }

    @Override
    public void gotResultMaps(String url, List maps) {
        this.setListData(url, maps);
    }

    @Override
    public void onXMLError(String error) {
        ((Label)this.loader.find("errorMessage")).setText(error);
        this.show("Error");
    }

    @Override
    public void onDownloadError(String error) {
        OptionPane.showMessageDialog(null, (Object)error, (String)"Error!", (int)0);
    }

    @Override
    public void downloadFinished(String download) {
        if (!this.localMaps.contains(download)) {
            this.localMaps.add(download);
        }
        if (((Button)this.loader.find("updateButton")).isSelected() && MapUpdateService.getInstance().mapsToUpdate.isEmpty()) {
            this.loader.find("updateAll").setVisible(false);
            this.getRoot().revalidate();
            this.getRoot().repaint();
        }
    }

    private void setListData(String url, List items) {
        Vector result;
        ((MapRenderer)this.list.getCellRenderer()).setContext(MapPreview.getContext(url));
        if (items == null) {
            result = new Vector(0);
        } else if (this.allowedMaps == null) {
            result = JavaCompatUtil.asVector(items);
        } else {
            result = new Vector();
            for (Object item : items) {
                if (item instanceof Map) {
                    if (!this.allowedMaps.contains(MapPreview.getFileUID(((Map)item).getMapUrl()))) continue;
                    result.add(item);
                    continue;
                }
                result.add(item);
            }
        }
        this.list.setListData(result);
        boolean showNoMatch = items != null && result.isEmpty();
        this.show(showNoMatch ? "NoMatches" : "ResultList");
    }

    private void show(String name) {
        Component loading = this.loader.find("Loading");
        Component noMatches = this.loader.find("NoMatches");
        Component allUpToDate = this.loader.find("AllUpToDate");
        Component error = this.loader.find("Error");
        this.list.setSelectedIndex(-1);
        if (this.list.getSize() > 0) {
            this.list.ensureIndexIsVisible(0);
        }
        this.list.setVisible("ResultList".equals(name));
        noMatches.setVisible("NoMatches".equals(name));
        allUpToDate.setVisible("AllUpToDate".equals(name));
        loading.setVisible("Loading".equals(name));
        error.setVisible("Error".equals(name));
        this.getRoot().revalidate();
        this.getRoot().repaint();
    }

    private void activateGroup(String string) {
        String mincat = ((ButtonGroup)this.loader.getGroups().get(string)).getSelection().getActionCommand();
        this.actionPerformed(mincat);
    }

    public boolean willDownload(Map map) {
        String mapUID = MapPreview.getFileUID(map.getMapUrl());
        if (!this.localMaps.contains(mapUID)) {
            return true;
        }
        return MapUpdateService.getInstance().mapsToUpdate.contains(map);
    }

    public static String getMapInfo(Map map) {
        String author = map.getAuthorName();
        String noOfDownloads = map.getNumberOfDownloads();
        return "By: " + (author == null ? "?" : author) + "\n" + JavaCompatUtil.replaceAll(TranslationBundle.getBundle().getString("mapchooser.map.numberOfDownloads"), "{0}", noOfDownloads == null ? "?" : noOfDownloads) + "\nVersion: " + map.getVersion() + "\n" + map.getDescription();
    }
}

