/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.gen.XMLMapAccess;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.util.Url;

public class MapUpdateService
extends Observable {
    static final Logger logger = Logger.getLogger(MapUpdateService.class.getName());
    static MapUpdateService updateService;
    public final List<Map> mapsToUpdate = new Vector<Map>();

    private MapUpdateService() {
    }

    public static MapUpdateService getInstance() {
        if (updateService == null) {
            updateService = new MapUpdateService();
        }
        return updateService;
    }

    void notifyListeners() {
        this.setChanged();
        this.notifyObservers(new Integer(this.mapsToUpdate.size()));
    }

    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
        o.update(this, new Integer(this.mapsToUpdate.size()));
    }

    public void init(List mapsUIDs, String url) {
        List gotMaps = MapUpdateService.getMaps(url, mapsUIDs);
        for (int c = 0; c < mapsUIDs.size(); ++c) {
            String uid = (String)mapsUIDs.get(c);
            ArrayList<Map> theMaps = new ArrayList<Map>(1);
            for (int i = 0; i < gotMaps.size(); ++i) {
                Map themap = (Map)gotMaps.get(i);
                String mapUID = MapPreview.getFileUID(themap.getMapUrl());
                if (!mapUID.equals(uid)) continue;
                theMaps.add(themap);
            }
            if (theMaps.size() == 1) {
                boolean needsUpdate;
                Map remoteMap = (Map)theMaps.get(0);
                try {
                    needsUpdate = remoteMap.needsUpdate(MapPreview.createMap(uid).getVersion());
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "error loading version info from local map: " + uid + " of " + mapsUIDs.size(), ex);
                    needsUpdate = true;
                }
                if (!needsUpdate) continue;
                this.mapsToUpdate.add(remoteMap);
                this.notifyListeners();
                continue;
            }
            if (theMaps.size() <= 1) continue;
            logger.warning("found more then 1 results for " + uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getMaps(String url, List mapsUIDs) {
        List list;
        StringBuffer payload = new StringBuffer();
        for (int c = 0; c < mapsUIDs.size(); ++c) {
            String uid = (String)mapsUIDs.get(c);
            if (payload.length() != 0) {
                payload.append('&');
            }
            payload.append(Url.encode((String)"mapfile"));
            payload.append('=');
            payload.append(Url.encode((String)uid));
        }
        logger.fine("URL: " + url + " payload: " + payload);
        URLConnection conn = null;
        InputStreamReader re = null;
        try {
            conn = new URL(url).openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(payload.toString());
            wr.close();
            re = new InputStreamReader(conn.getInputStream(), "UTF-8");
            ServiceLink.Task task = (ServiceLink.Task)new XMLMapAccess().load(re);
            java.util.Map map = (java.util.Map)task.getObject();
            list = (List)map.get("maps");
        }
        catch (Throwable ex) {
            try {
                if (!logger.isLoggable(Level.FINE)) {
                    logger.info("error with URL: " + url + " payload: " + payload);
                }
                logger.log(Level.INFO, "error in getting map metadata", ex);
                List list2 = Collections.EMPTY_LIST;
                return list2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                RiskUtil.close(re);
            }
        }
        RiskUtil.close(re);
        return list;
    }

    public boolean contains(String mapUID) {
        return this.getIndexOfMap(mapUID) >= 0;
    }

    private int getIndexOfMap(String mapUID) {
        for (int c = 0; c < this.mapsToUpdate.size(); ++c) {
            Map map = this.mapsToUpdate.get(c);
            String amapUID = MapPreview.getFileUID(map.getMapUrl());
            if (!mapUID.equals(amapUID)) continue;
            return c;
        }
        return -1;
    }

    public void downloadFinished(String mapUID) {
        int i = this.getIndexOfMap(mapUID);
        if (i >= 0) {
            this.mapsToUpdate.remove(i);
            this.notifyListeners();
        }
    }

    public static Map getOnlineMap(String uid) {
        String[] names = uid.indexOf(32) >= 0 ? new String[]{uid, JavaCompatUtil.replaceAll(uid, " ", "")} : new String[]{uid};
        List maps = MapUpdateService.getMaps(MapServerClient.MAP_PAGE, Arrays.asList(names));
        return maps.size() > 0 ? (Map)maps.get(0) : null;
    }

    public static void paintBadge(Graphics2D g, String badge, Border border) {
        if (!"0".equals(badge)) {
            int l;
            int r;
            int t;
            int b;
            Font font = g.getFont();
            int tw = font.getWidth(badge.length() == 1 ? " " + badge : badge);
            int th = font.getHeight();
            if (border == null) {
                b = 3;
                t = 3;
                r = 3;
                l = 3;
            } else {
                l = border.getLeft();
                r = border.getRight();
                t = border.getTop();
                b = border.getBottom();
            }
            int w = l + r + tw;
            int h = t + b + th;
            int x = -w;
            int y = 0;
            int[] clip = g.getClip();
            g.setClip(x, y, w, h);
            if (border == null) {
                g.setColor(-65536);
                g.fillOval(x, y, w, h);
            } else {
                g.translate(x + border.getLeft(), y + border.getTop());
                border.paintBorder(null, g, w - border.getLeft() - border.getRight(), h - border.getTop() - border.getBottom());
                g.translate(-x - border.getLeft(), -y - border.getTop());
            }
            g.setColor(-1);
            g.drawString(badge, x + (int)Math.round((double)(w - font.getWidth(badge)) / 2.0), y + (int)Math.round((double)(h - font.getHeight()) / 2.0));
            g.setClip(clip);
        }
    }
}

