/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.tools.mapeditor;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.AbstractTableModel;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.tools.mapeditor.ImageUtil;
import net.yura.domination.tools.mapeditor.MapEditor;
import net.yura.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEditorPanel
extends JPanel
implements MouseInputListener,
MouseWheelListener {
    public static final int MODE_MOVE = 0;
    public static final int MODE_MOVEALL = 1;
    public static final int MODE_JOIN = 2;
    public static final int MODE_JOIN1WAY = 3;
    public static final int MODE_DISJOIN = 4;
    public static final int MODE_DRAW = 5;
    public static final int DEFAULT_BRUSH_SIZE = 5;
    private RiskGame myMap;
    private BufferedImage pic;
    private BufferedImage map;
    private BufferedImage drawImage;
    private Rectangle drawRect;
    private Country selected;
    private Rectangle box;
    private int mode;
    private int brush = 5;
    private float alpha;
    private float zoom = 1.0f;
    MapEditor editor;
    private ListSelectionListener selectionListener;
    private int smartDrawTolerance = 20;
    private Point dragpoint;
    private boolean xdrag;
    private Point[] countryPositions;
    int badness;

    public MapEditorPanel(MapEditor a) {
        this.editor = a;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.mode = 0;
    }

    public void setSelectionListener(ListSelectionListener listener) {
        this.selectionListener = listener;
    }

    public Country getSelectedCountry() {
        return this.selected;
    }

    public BufferedImage getImageMap() {
        return this.map;
    }

    public BufferedImage getImagePic() {
        return this.pic;
    }

    public void zoom(float a) {
        this.zoom = a;
        if (this.pic != null) {
            Dimension size = new Dimension((int)((float)this.pic.getWidth() * this.zoom), (int)((float)this.pic.getHeight() * this.zoom));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.revalidate();
            this.repaint();
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setImagePic(BufferedImage a, boolean checkmap) {
        this.pic = a;
        if (a.getWidth() != 677 || a.getHeight() != 425) {
            // empty if block
        }
        if (checkmap && (this.pic.getWidth() != this.map.getWidth() || this.pic.getHeight() != this.map.getHeight())) {
            if (this.myMap.getCountries().length == 0) {
                this.resizeAndSetImageMap(this.map, false);
            } else {
                Object[] options = new String[]{"Stretch", "Resize", "No"};
                int result = JOptionPane.showOptionDialog(this, "This ImagePic does not match the ImageMap size!\nImagePic: " + this.pic.getWidth() + "x" + this.pic.getHeight() + "\nImageMap: " + this.map.getWidth() + "x" + this.map.getHeight() + "\nThey should match for the game to work!\nwould you like to update the ImageMap size?", "?", 1, 3, null, options, options[0]);
                if (result == 0 || result == 1) {
                    this.resizeAndSetImageMap(this.map, result == 0);
                }
            }
        }
        this.zoom(this.zoom);
    }

    private void resizeAndSetImageMap(BufferedImage imageMap, boolean stretch) {
        BufferedImage newmap = new BufferedImage(this.pic.getWidth(), this.pic.getHeight(), imageMap.getType());
        Graphics g = newmap.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, newmap.getWidth(), newmap.getHeight());
        if (stretch) {
            double scale = Math.max((double)newmap.getWidth() / (double)imageMap.getWidth(), (double)newmap.getHeight() / (double)imageMap.getHeight());
            int newWidth = (int)((double)imageMap.getWidth() * scale);
            int newHeight = (int)((double)imageMap.getHeight() * scale);
            g.drawImage(imageMap, (newmap.getWidth() - newWidth) / 2, (newmap.getHeight() - newHeight) / 2, newWidth, newHeight, this);
        } else {
            g.drawImage(imageMap, 0, 0, this);
        }
        g.dispose();
        this.setImageMap(newmap);
    }

    public void setImageMap(BufferedImage a) {
        int result;
        if ((a.getWidth() != this.pic.getWidth() || a.getHeight() != this.pic.getHeight()) && (result = JOptionPane.showConfirmDialog(this, "This ImageMap does not match the ImagePic size!\nImagePic: " + this.pic.getWidth() + "x" + this.pic.getHeight() + "\nImageMap: " + a.getWidth() + "x" + a.getHeight() + "\nThey should match for the game to work!\nwould you like to update the ImageMap size?", "?", 0)) == 0) {
            this.resizeAndSetImageMap(a, false);
            return;
        }
        this.map = a;
        this.drawImage = new BufferedImage(a.getWidth(), a.getHeight(), 12, new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, 0}, new byte[]{0, 0}, 0));
        this.box = new Rectangle(new Dimension(a.getWidth(), a.getHeight()));
    }

    public void setMap(RiskGame a) {
        this.myMap = a;
    }

    public void update(Map a) {
        int width = this.map.getWidth();
        int height = this.map.getHeight();
        int[] pixels = this.map.getRGB(0, 0, width, height, null, 0, width);
        for (int c = 0; c < pixels.length; ++c) {
            int oldcolor = pixels[c] & 0xFF;
            Object obj = a.get(new Integer(oldcolor));
            int newcolor = obj != null ? (Integer)obj : oldcolor;
            pixels[c] = (newcolor & 0xFF) << 16 | (newcolor & 0xFF) << 8 | (newcolor & 0xFF) << 0;
        }
        this.map.setRGB(0, 0, width, height, pixels, 0, width);
        this.editor.setMapChanged(true);
        this.repaint();
    }

    public void growEdges(Set<Integer> colorsToGrow) {
        int width = this.map.getWidth();
        int height = this.map.getHeight();
        int[] pixels = this.map.getRGB(0, 0, width, height, null, 0, width);
        int[] newpixels = new int[pixels.length];
        for (int position = 0; position < pixels.length; ++position) {
            int bottom;
            int right;
            int left;
            int color = pixels[position];
            int darkestNeighbour = -1;
            if (position >= width) {
                int top;
                darkestNeighbour = top = pixels[position - width];
            }
            if (position % width != 0 && ColorUtil.getBrightness(left = pixels[position - 1]) < ColorUtil.getBrightness(darkestNeighbour)) {
                darkestNeighbour = left;
            }
            if ((position + 1) % width != 0 && ColorUtil.getBrightness(right = pixels[position + 1]) < ColorUtil.getBrightness(darkestNeighbour)) {
                darkestNeighbour = right;
            }
            if (position < pixels.length - width && ColorUtil.getBrightness(bottom = pixels[position + width]) < ColorUtil.getBrightness(darkestNeighbour)) {
                darkestNeighbour = bottom;
            }
            if (color != darkestNeighbour && ColorUtil.getBrightness(darkestNeighbour) < ColorUtil.getBrightness(color) && !colorsToGrow.isEmpty() && colorsToGrow.contains(darkestNeighbour & 0xFF)) {
                color = darkestNeighbour;
            }
            newpixels[position] = color;
        }
        this.map.setRGB(0, 0, width, height, newpixels, 0, width);
        this.editor.setMapChanged(true);
        this.repaintSelected();
        this.repaint();
    }

    public void setSelectedCountry(Country a) {
        if (this.selected != a) {
            this.selected = a;
            this.repaintSelected();
            if (this.selectionListener != null) {
                int index = this.selected == null ? -1 : this.selected.getColor() - 1;
                this.selectionListener.valueChanged(new ListSelectionEvent(this, index, index, false));
            }
        }
    }

    public void repaintSelected() {
        int width = this.map.getWidth();
        int height = this.map.getHeight();
        int[] pixels1 = this.map.getRGB(0, 0, width, height, null, 0, width);
        int[] pixels2 = this.drawImage.getRGB(0, 0, width, height, null, 0, width);
        int redColor = Color.RED.getRGB();
        int startX = Integer.MAX_VALUE;
        int endX = Integer.MIN_VALUE;
        int startY = Integer.MAX_VALUE;
        int endY = Integer.MIN_VALUE;
        for (int c = 0; c < pixels1.length; ++c) {
            if (this.selected != null && this.selected.getColor() == (pixels1[c] & 0xFF)) {
                int x = c % width;
                int y = c / width;
                if (x < startX) {
                    startX = x;
                }
                if (x > endX) {
                    endX = x;
                }
                if (y < startY) {
                    startY = y;
                }
                if (y > endY) {
                    endY = y;
                }
                pixels2[c] = redColor;
                continue;
            }
            pixels2[c] = 0;
        }
        this.drawRect = startX == Integer.MAX_VALUE || endX == Integer.MIN_VALUE || startY == Integer.MAX_VALUE || endY == Integer.MIN_VALUE ? null : new Rectangle(startX - 1, startY - 1, endX - startX + 3, endY - startY + 3);
        this.drawImage.setRGB(0, 0, width, height, pixels2, 0, width);
        this.repaint();
    }

    public void setAlpha(int a) {
        this.alpha = (float)a / 100.0f;
    }

    public void setBrush(int a) {
        this.brush = a == 0 ? 1 : a;
    }

    public void setMode(int a) {
        this.mode = a;
        this.dragpoint = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g0 = (Graphics2D)g;
        g0.scale(this.zoom, this.zoom);
        if (this.myMap != null) {
            if (this.alpha != 1.0f) {
                MapEditorPanel.drawImage(g, this.pic, 0, 0, this);
                this.drawCountries(g);
            }
            if (this.alpha != 0.0f) {
                Graphics2D g2 = (Graphics2D)g.create();
                AlphaComposite ac = AlphaComposite.getInstance(3, this.alpha);
                g2.setComposite(ac);
                MapEditorPanel.drawImage(g2, this.map, 0, 0, this);
                if (this.drawRect != null) {
                    BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
                    g2.setStroke(dashed);
                    g2.setColor(Color.GREEN);
                    g2.drawRect(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                }
                MapEditorPanel.drawImage(g2, this.drawImage, 0, 0, this);
            }
            if (this.mode == 5 && this.dragpoint != null) {
                g.setXORMode(Color.WHITE);
                g.setColor(Color.BLACK);
                g.drawOval(this.dragpoint.x - this.brush / 2, this.dragpoint.y - this.brush / 2, this.brush, this.brush);
                g.setPaintMode();
            }
        }
    }

    public static void drawImage(Graphics g, Image img, int x, int y, ImageObserver io) {
        Rectangle clip = g.getClipBounds();
        clip = clip.intersection(new Rectangle(x, y, img.getWidth(io), img.getHeight(io)));
        int imgX = clip.x - x;
        int imgY = clip.y - y;
        g.drawImage(img, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, imgX, imgY, imgX + clip.width, imgY + clip.height, io);
    }

    private void drawCountries(Graphics g) {
        long time = System.currentTimeMillis();
        int d = this.myMap.getCircleSize();
        int width = this.pic.getWidth();
        Country[] countries = this.myMap.getCountries();
        g.setFont(new Font("Arial", 0, (d + 2) / 2));
        int fontHeight = g.getFontMetrics().getAscent();
        for (int i = 0; i < countries.length; ++i) {
            boolean doXor;
            Country n = countries[i];
            int x = n.getX();
            int y = n.getY();
            g.setColor(new Color(n.getContinent().getColor()));
            int r = d / 2;
            g.fillOval(x - r, y - r, d, d);
            Vector ney = n.getNeighbours();
            for (int j = 0; j < ney.size(); ++j) {
                Country n1 = (Country)ney.get(j);
                int x1 = n1.getX();
                int y1 = n1.getY();
                if (n1.getNeighbours().contains(n)) {
                    g.setColor(Color.BLUE);
                } else {
                    g.setColor(Color.GREEN);
                }
                if (Math.abs(x - x1) > width / 2) {
                    if (x > width / 2) {
                        g.drawLine(x, y, x1 + width, y1);
                        g.drawLine(x - width, y, x1, y1);
                        continue;
                    }
                    g.drawLine(x, y, x1 - width, y1);
                    g.drawLine(x + width, y, x1, y1);
                    continue;
                }
                g.drawLine(x, y, x1, y1);
            }
            if (this.selected == n) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLUE);
            }
            g.drawRect(x - 2, y - 2, 4, 4);
            g.drawRect(x - 3, y - 3, 6, 6);
            boolean bl = doXor = this.badness < 5;
            if (doXor) {
                g.setXORMode(Color.WHITE);
            }
            g.setColor(Color.BLACK);
            g.drawString(n.getIdString(), x, y);
            g.drawString(String.valueOf(i + 1), x, y + fontHeight);
            if (!doXor) continue;
            g.setPaintMode();
        }
        long timeTaken = System.currentTimeMillis() - time;
        if (timeTaken > 100L) {
            ++this.badness;
            System.out.println("XORMode Badness: " + timeTaken + " " + this.badness);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.myMap != null) {
            Country mynode = this.getCountryAt((int)((float)x / this.zoom), (int)((float)y / this.zoom));
            if (mynode != null) {
                String show = "<html><b>" + mynode.getIdString() + " (" + mynode.getColor() + ")</b><br>Location: (x=" + mynode.getX() + ",y=" + mynode.getY() + ")<br>Continent: " + mynode.getContinent();
                Vector ney = mynode.getNeighbours();
                for (int j = 0; j < ney.size(); ++j) {
                    Country n1 = (Country)ney.get(j);
                    show = show + "<br>Neighbour: " + n1.getIdString() + " (" + n1.getColor() + ")";
                }
                show = show + "</html>";
                this.setToolTipText(show);
            } else {
                this.setToolTipText(null);
            }
            return true;
        }
        return false;
    }

    public void drawLine(Point a, Point b, boolean draw) {
        if (!this.box.contains(a) && !this.box.contains(b)) {
            return;
        }
        if (a.y > b.y) {
            Point z = a;
            a = b;
            b = z;
        }
        Graphics2D g1 = (Graphics2D)this.drawImage.getGraphics();
        Graphics2D g2 = (Graphics2D)this.map.getGraphics();
        BasicStroke bs = new BasicStroke(this.brush, 1, 1);
        g1.setStroke(bs);
        g2.setStroke(bs);
        if (this.selected != null && draw) {
            g1.setColor(Color.RED);
            g2.setColor(new Color(this.selected.getColor(), this.selected.getColor(), this.selected.getColor()));
            Rectangle rectA = new Rectangle(a.x - this.brush / 2 - 1, a.y - this.brush / 2 - 1, this.brush + 2, this.brush + 2);
            if (this.drawRect == null) {
                this.drawRect = rectA;
            } else {
                this.drawRect.add(rectA);
            }
            this.drawRect.add(new Rectangle(b.x - this.brush / 2 - 1, b.y - this.brush / 2 - 1, this.brush + 2, this.brush + 2));
        } else {
            g1.setColor(Color.BLACK);
            g2.setColor(Color.WHITE);
        }
        g1.drawLine(a.x, a.y, b.x, b.y);
        g2.drawLine(a.x, a.y, b.x, b.y);
        g1.dispose();
        g2.dispose();
        this.editor.setMapChanged(true);
    }

    public Country getCountryAt(int x, int y) {
        Country[] countries = this.myMap.getCountries();
        int size = 4;
        Country mynode = null;
        for (int i = 0; i < countries.length; ++i) {
            Country n = countries[i];
            int x1 = n.getX();
            int y1 = n.getY();
            if (x1 < x - size || y1 < y - size || x1 > x + size || y1 > y + size) continue;
            mynode = n;
            break;
        }
        return mynode;
    }

    public Point getPointOnImage(MouseEvent e) {
        return new Point((int)((float)e.getX() / this.zoom), (int)((float)e.getY() / this.zoom));
    }

    public void autodraw(Collection<Country> countries, boolean dots) {
        BufferedImage imgMap = this.getImageMap();
        Graphics g = imgMap.getGraphics();
        int size = this.myMap.getCircleSize();
        for (Country country : countries) {
            Color color = new Color(country.getColor(), country.getColor(), country.getColor());
            if (dots) {
                g.setColor(color);
                g.fillOval(country.getX() - size / 2, country.getY() - size / 2, size, size);
                continue;
            }
            ImageUtil.floodFill(imgMap, country.getX(), country.getY(), color.getRGB());
        }
        g.dispose();
        this.editor.setMapChanged(true);
        this.repaintSelected();
    }

    public void smartDraw(Collection<Country> selectedCountries) {
        JSpinner tolerance = new JSpinner(new SpinnerNumberModel(this.smartDrawTolerance, 0, 255, 1));
        int result = JOptionPane.showConfirmDialog(this, new Object[]{MapEditor.getCountiresListMessage(selectedCountries), "Smart Fill will use the color from the Image Pic\nto select the area in the Image Map. Tolerance:", tolerance}, "Smart Fill", 2);
        if (result == 0) {
            this.smartDrawTolerance = ((Number)tolerance.getValue()).intValue();
            for (Country country : selectedCountries) {
                Color color = new Color(country.getColor(), country.getColor(), country.getColor());
                ImageUtil.smartFill(this.getImagePic(), this.getImageMap(), country.getX(), country.getY(), color.getRGB(), this.smartDrawTolerance);
            }
            this.editor.setMapChanged(true);
            this.repaintSelected();
        }
    }

    public void delIslands(Collection<Country> countries) {
        HashSet<Integer> findColors = new HashSet<Integer>();
        for (Country country : countries) {
            Color color = new Color(country.getColor(), country.getColor(), country.getColor());
            findColors.add(color.getRGB());
        }
        long startTime = System.currentTimeMillis();
        BufferedImage map = this.getImageMap();
        int width = map.getWidth();
        int[] pixels = map.getRGB(0, 0, width, map.getHeight(), null, 0, width);
        HashMap<Integer, ArrayList<Integer>> colorToPositions = new HashMap<Integer, ArrayList<Integer>>();
        for (int c = 0; c < pixels.length; ++c) {
            if (!findColors.contains(pixels[c])) continue;
            List<Integer> positions = (List)colorToPositions.get(pixels[c]);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                colorToPositions.put(pixels[c], (ArrayList<Integer>)positions);
            }
            positions.add(c);
        }
        ArrayList allIslands = new ArrayList();
        for (List positions : colorToPositions.values()) {
            Object largestIsland = null;
            ArrayList islands = new ArrayList();
            while (!positions.isEmpty()) {
                ArrayList<Integer> island = new ArrayList<Integer>();
                Stack stack = new Stack();
                stack.push(positions.get(0));
                while (!stack.isEmpty()) {
                    int position = (Integer)stack.pop();
                    int index = positions.indexOf(position);
                    if (index < 0) continue;
                    int pos = (Integer)positions.remove(index);
                    island.add(pos);
                    if (position >= width) {
                        stack.push(position - width);
                    }
                    if (position % width != 0) {
                        stack.push(position - 1);
                    }
                    if ((position + 1) % width != 0) {
                        stack.push(position + 1);
                    }
                    stack.push(position + width);
                }
                islands.add(island);
                if (largestIsland != null && island.size() <= largestIsland.size()) continue;
                largestIsland = island;
            }
            islands.remove(largestIsland);
            allIslands.addAll(islands);
        }
        System.out.println("finished! took " + (System.currentTimeMillis() - startTime));
        if (allIslands.isEmpty()) {
            JOptionPane.showMessageDialog(this, MapEditor.getCountiresListMessage(countries) + "\nNo islands found");
        } else {
            final TreeMap<Integer, Integer> counts = new TreeMap<Integer, Integer>();
            final TreeMap colors = new TreeMap();
            for (List island : allIslands) {
                int islandSize = island.size();
                if (counts.get(islandSize) == null) {
                    counts.put(islandSize, 1);
                    colors.put(islandSize, new TreeSet());
                } else {
                    counts.put(islandSize, (Integer)counts.get(islandSize) + 1);
                }
                ((Set)colors.get(islandSize)).add(pixels[(Integer)island.get(0)] & 0xFF);
            }
            final ArrayList islandSizes = new ArrayList(counts.keySet());
            final boolean[] del = new boolean[islandSizes.size()];
            AbstractTableModel islandsTable = new AbstractTableModel(){
                private static final int BOOL_ROW = 3;
                private final String[] columnNames = new String[]{"size", "count", "Countries", "del"};

                @Override
                public int getColumnCount() {
                    return this.columnNames.length;
                }

                @Override
                public String getColumnName(int col) {
                    return this.columnNames[col];
                }

                @Override
                public int getRowCount() {
                    return islandSizes.size();
                }

                @Override
                public Object getValueAt(int row, int col) {
                    switch (col) {
                        case 0: {
                            return islandSizes.get(row);
                        }
                        case 1: {
                            return counts.get(islandSizes.get(row));
                        }
                        case 2: {
                            return colors.get(islandSizes.get(row));
                        }
                        case 3: {
                            return del[row];
                        }
                    }
                    throw new RuntimeException();
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == 3;
                }

                @Override
                public Class<?> getColumnClass(int col) {
                    return col == 3 ? Boolean.class : super.getColumnClass(col);
                }

                @Override
                public void setValueAt(Object aValue, int row, int col) {
                    if (col != 3) {
                        throw new RuntimeException();
                    }
                    del[row] = (Boolean)aValue;
                }
            };
            final JTable islandsJTable = new JTable(islandsTable);
            islandsJTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting() && islandsJTable.getSelectedRow() != -1) {
                        Set colorsForRow = (Set)colors.get(islandSizes.get(islandsJTable.getSelectedRow()));
                        MapEditorPanel.this.setSelectedCountry(MapEditorPanel.this.myMap.getCountryInt((Integer)colorsForRow.iterator().next()));
                    }
                }
            });
            int result = JOptionPane.showConfirmDialog(this, new Object[]{"<html>" + allIslands.size() + " islands found, are you sure you want to delete them from the map?", new JScrollPane(islandsJTable)}, "Del Islands?", 0);
            if (result == 0) {
                for (List island : allIslands) {
                    if (!del[islandSizes.indexOf(island.size())]) continue;
                    Iterator iterator = island.iterator();
                    while (iterator.hasNext()) {
                        int pos = (Integer)iterator.next();
                        pixels[pos] = -1;
                    }
                }
                map.setRGB(0, 0, width, map.getHeight(), pixels, 0, width);
                this.editor.setMapChanged(true);
                this.repaintSelected();
            }
        }
    }

    public void delPonds(Collection<Country> countries) {
        int countryColor;
        long startTime = System.currentTimeMillis();
        HashSet<Integer> findColors = new HashSet<Integer>();
        for (Country country : countries) {
            Color color = new Color(country.getColor(), country.getColor(), country.getColor());
            findColors.add(color.getRGB());
        }
        BufferedImage map = this.getImageMap();
        int width = map.getWidth();
        int[] pixels = map.getRGB(0, 0, width, map.getHeight(), null, 0, width);
        HashMap colorToStartPositions = new HashMap();
        for (int c = 0; c < pixels.length - width; ++c) {
            if (!findColors.contains(pixels[c])) continue;
            ArrayList<Integer> positions = (ArrayList<Integer>)colorToStartPositions.get(pixels[c]);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                colorToStartPositions.put(pixels[c], positions);
            }
            if (pixels[c + width] != -1) continue;
            positions.add(c + width);
        }
        HashMap allPonds = new HashMap();
        for (Map.Entry countryInfo : colorToStartPositions.entrySet()) {
            countryColor = (Integer)countryInfo.getKey();
            List startPositions = (List)countryInfo.getValue();
            List ponds = new ArrayList();
            block3: while (!startPositions.isEmpty()) {
                ArrayList<Integer> pond = new ArrayList<Integer>();
                Stack stack = new Stack();
                stack.push(startPositions.get(0));
                while (!stack.isEmpty()) {
                    int position = (Integer)stack.pop();
                    if (pixels[position] != -1 && pixels[position] != countryColor) continue block3;
                    if (pixels[position] != -1 || pond.contains(position)) continue;
                    pond.add(position);
                    startPositions.remove((Object)position);
                    if (position < width) continue block3;
                    stack.push(position - width);
                    if (position % width == 0) continue block3;
                    stack.push(position - 1);
                    if ((position + 1) % width == 0) continue block3;
                    stack.push(position + 1);
                    if (position >= pixels.length - width) continue block3;
                    stack.push(position + width);
                }
                ponds.add(pond);
            }
            if (ponds.isEmpty()) continue;
            allPonds.put(countryColor, ponds);
        }
        System.out.println("finished! took " + (System.currentTimeMillis() - startTime));
        if (allPonds.isEmpty()) {
            JOptionPane.showMessageDialog(this, MapEditor.getCountiresListMessage(countries) + "\nNo ponds found");
        } else {
            for (Map.Entry countryPonds : allPonds.entrySet()) {
                countryColor = (Integer)countryPonds.getKey();
                System.out.println("for country " + (countryColor & 0xFF) + " found " + ((List)countryPonds.getValue()).size() + " ponds");
                for (List ponds : (List)countryPonds.getValue()) {
                    Iterator iterator = ponds.iterator();
                    while (iterator.hasNext()) {
                        int pos = (Integer)iterator.next();
                        pixels[pos] = countryColor;
                    }
                }
            }
            map.setRGB(0, 0, width, map.getHeight(), pixels, 0, width);
            this.editor.setMapChanged(true);
            this.repaintSelected();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Point point = e.getPoint();
        if (e.getWheelRotation() < 0) {
            this.editor.zoom(true, point);
        } else if (e.getWheelRotation() > 0) {
            this.editor.zoom(false, point);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.myMap != null) {
            Point point = this.getPointOnImage(e);
            if ((e.getModifiers() & 4) == 4) {
                if (this.mode != 5) {
                    this.setSelectedCountry(null);
                }
            } else if ((e.getModifiers() & 0x10) == 16) {
                if (this.mode == 2) {
                    Country mynode = this.getCountryAt(point.x, point.y);
                    if (mynode != null && this.selected == null) {
                        this.setSelectedCountry(mynode);
                    } else if (mynode != null && mynode == this.selected) {
                        this.setSelectedCountry(null);
                    } else if (mynode != null) {
                        if (!this.selected.getNeighbours().contains(mynode)) {
                            this.selected.addNeighbour(mynode);
                        }
                        if (!mynode.getNeighbours().contains(this.selected)) {
                            mynode.addNeighbour(this.selected);
                        }
                        this.editor.setMapChanged(true);
                        this.repaint();
                    }
                } else if (this.mode == 3) {
                    Country mynode = this.getCountryAt(point.x, point.y);
                    if (mynode != null && this.selected == null) {
                        this.setSelectedCountry(mynode);
                    } else if (mynode != null && mynode == this.selected) {
                        this.setSelectedCountry(null);
                    } else if (mynode != null) {
                        if (!this.selected.getNeighbours().contains(mynode)) {
                            this.selected.addNeighbour(mynode);
                        }
                        this.editor.setMapChanged(true);
                        this.repaint();
                    }
                } else if (this.mode == 4) {
                    Country mynode = this.getCountryAt(point.x, point.y);
                    if (mynode != null && this.selected == null) {
                        this.setSelectedCountry(mynode);
                    } else if (mynode != null && mynode == this.selected) {
                        this.setSelectedCountry(null);
                    } else if (mynode != null) {
                        if (this.selected.getNeighbours().contains(mynode)) {
                            this.selected.getNeighbours().remove(mynode);
                        }
                        if (mynode.getNeighbours().contains(this.selected)) {
                            mynode.getNeighbours().remove(this.selected);
                        }
                        this.editor.setMapChanged(true);
                        this.repaint();
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.myMap != null && ((e.getModifiers() & 0x10) == 16 || (e.getModifiers() & 4) == 4)) {
            Point point = this.getPointOnImage(e);
            if (this.mode == 0) {
                Country mynode = this.getCountryAt(point.x, point.y);
                if (mynode != null) {
                    this.setSelectedCountry(mynode);
                    this.xdrag = true;
                } else {
                    this.dragpoint = e.getPoint();
                    this.xdrag = false;
                }
            } else if (this.mode == 1) {
                this.dragpoint = point;
                if (e.isShiftDown()) {
                    Country[] countries = this.myMap.getCountries();
                    this.countryPositions = new Point[countries.length];
                    for (int i = 0; i < countries.length; ++i) {
                        this.countryPositions[i] = new Point(countries[i].getX(), countries[i].getY());
                    }
                }
            } else if (this.mode == 5) {
                this.dragpoint = point;
                this.drawLine(this.dragpoint, this.dragpoint, (e.getModifiers() & 0x10) == 16);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mode == 0) {
            this.dragpoint = null;
        } else if (this.mode == 1) {
            this.dragpoint = null;
            this.countryPositions = null;
        } else if (this.mode == 5) {
            if (!this.getVisibleRect().contains(e.getPoint())) {
                this.dragpoint = null;
                this.repaint();
            }
            if (this.selected != null && (e.getModifiers() & 0x10) != 16) {
                this.repaintSelected();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.myMap != null) {
            Point point = this.getPointOnImage(e);
            if (this.mode == 0) {
                if (this.xdrag && this.box != null && this.selected != null && this.box.contains(point)) {
                    this.selected.setX(point.x);
                    this.selected.setY(point.y);
                    this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
                    this.editor.setMapChanged(true);
                    this.repaint();
                } else if (!this.xdrag && this.dragpoint != null) {
                    Rectangle r = this.getVisibleRect();
                    r.translate(this.dragpoint.x - e.getX(), this.dragpoint.y - e.getY());
                    this.scrollRectToVisible(r);
                }
            } else if (this.mode == 1 && this.dragpoint != null) {
                Country[] countries = this.myMap.getCountries();
                if (this.countryPositions == null) {
                    int xdif = point.x - this.dragpoint.x;
                    int ydif = point.y - this.dragpoint.y;
                    for (int i = 0; i < countries.length; ++i) {
                        countries[i].setX(countries[i].getX() + xdif);
                        countries[i].setY(countries[i].getY() + ydif);
                    }
                    this.dragpoint = point;
                } else {
                    double xdif = (double)point.x / (double)this.dragpoint.x;
                    double ydif = (double)point.y / (double)this.dragpoint.y;
                    double dif = Math.max(xdif, ydif);
                    for (int i = 0; i < countries.length; ++i) {
                        countries[i].setX((int)Math.round(this.countryPositions[i].getX() * dif));
                        countries[i].setY((int)Math.round(this.countryPositions[i].getY() * dif));
                    }
                }
                this.editor.setMapChanged(true);
                this.repaint();
            } else if (this.mode == 5 && this.dragpoint != null) {
                Point end = point;
                if ((e.getModifiers() & 0x10) == 16 || (e.getModifiers() & 4) == 4) {
                    boolean draw = this.selected != null && (e.getModifiers() & 0x10) == 16;
                    this.drawLine(this.dragpoint, end, draw);
                    if (draw) {
                        this.repaint((int)(this.zoom * (float)this.drawRect.x - 3.0f), (int)(this.zoom * (float)this.drawRect.y - 3.0f), (int)(this.zoom * (float)this.drawRect.width + 6.0f), (int)(this.zoom * (float)this.drawRect.height + 6.0f));
                    } else {
                        int halfBrush = this.brush / 2;
                        Rectangle rect = new Rectangle(this.dragpoint.x - halfBrush, this.dragpoint.y - halfBrush, this.brush, this.brush);
                        rect.add(new Rectangle(end.x - halfBrush, end.y - halfBrush, this.brush, this.brush));
                        rect.grow(3, 3);
                        this.repaint((int)(this.zoom * (float)rect.x), (int)(this.zoom * (float)rect.y), (int)(this.zoom * (float)rect.width), (int)(this.zoom * (float)rect.height));
                    }
                }
                this.dragpoint = end;
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mode == 5 && (e.getModifiers() & 0x10) != 16 && (e.getModifiers() & 4) != 4) {
            this.dragpoint = null;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mode == 5) {
            this.dragpoint = this.getPointOnImage(e);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

