/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.guishared.SwingMEWrapper;
import net.yura.domination.lobby.client.GameSidePanel;
import net.yura.domination.ui.flashgui.FlashBorder;
import net.yura.domination.ui.flashgui.FlashRiskAdapter;
import net.yura.lobby.client.ChatBox;
import net.yura.lobby.client.PlayerList;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.Player;
import net.yura.me4se.ME4SEPanel;
import net.yura.mobile.gui.ActionListener;
import net.yura.swing.GraphicsUtil;

public class FlashMiniLobby {
    private final Risk myrisk;
    private final MiniLobbyClient mlc;
    private final ChatBox inGameChat;
    private final PlayerList playerList;

    public FlashMiniLobby(final FlashRiskAdapter fra, Risk myrisk, RootPaneContainer root, Frame window) {
        this.myrisk = myrisk;
        final ME4SEPanel wrapper = new ME4SEPanel();
        wrapper.getApplicationManager().applet = RiskUIUtil.applet;
        this.inGameChat = new ChatBox();
        this.playerList = new PlayerList(null);
        this.mlc = SwingMEWrapper.makeMiniLobbyClient("lobby.yura.net", myrisk, window, this.inGameChat, this.playerList, "Flash");
        wrapper.add((net.yura.mobile.gui.components.Component)this.mlc.getRoot());
        this.mlc.addCloseListener(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                wrapper.destroy();
                fra.closeMiniLobby();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)wrapper);
        Image img = RiskUIUtil.getUIImage(this.getClass(), "graph.jpg");
        panel.setBorder(new FlashBorder(GraphicsUtil.getSubimage(img, 100, 0, 740, 50), GraphicsUtil.getSubimage(img, 0, 0, 50, 400), GraphicsUtil.getSubimage(img, 100, 350, 740, 50), GraphicsUtil.getSubimage(img, 50, 0, 50, 400)));
        root.setContentPane(panel);
        window.setTitle(this.mlc.getTitle());
        window.setResizable(true);
        window.setSize(GraphicsUtil.scale(500), GraphicsUtil.scale(600));
    }

    Action getOnlineAction() {
        return new AbstractAction(TranslationBundle.getBundle().getString("lobby.resign")){

            public void actionPerformed(ActionEvent e) {
                FlashMiniLobby.this.mlc.resign();
                this.setEnabled(false);
            }

            public boolean isEnabled() {
                net.yura.domination.engine.core.Player player = FlashMiniLobby.this.myrisk.getGame().getPlayer(FlashMiniLobby.this.mlc.whoAmI());
                return super.isEnabled() && player != null && player.isAlive();
            }
        };
    }

    Component getOnlinePanel() {
        Game game = this.mlc.getCurrentOpenGame();
        this.inGameChat.reset(this.mlc.mycom, null, game.getId());
        this.playerList.clearSpectatorList();
        GameSidePanel sidePanel = new GameSidePanel(null, null, (JPanel)this.playerList, (JPanel)this.inGameChat);
        sidePanel.setGameName(game.getName(), String.valueOf(game.getId()));
        boolean darkTheme = ColorUtil.isColorLight(this.playerList.getForeground().getRGB());
        HashMap<Player, Color> playerColors = new HashMap<Player, Color>();
        for (Player player : game.getPlayers()) {
            net.yura.domination.engine.core.Player gamePlayer = this.myrisk.getGame().getPlayer(player.getName());
            if (gamePlayer != null) {
                Color playerColor = new Color(gamePlayer.getColor());
                boolean lightPlayer = ColorUtil.isColorLight(playerColor.getRGB());
                if (!darkTheme && lightPlayer) {
                    playerColor = playerColor.darker();
                }
                if (darkTheme && !lightPlayer) {
                    if (playerColor.equals(playerColor.brighter()) && playerColor.equals(Color.BLUE)) {
                        System.out.println("blue brighter fail");
                        playerColor = new Color(30, 30, 255);
                    }
                    playerColor = playerColor.brighter();
                }
                playerColors.put(player, playerColor);
                continue;
            }
            System.out.println("PLAYER NOT FOUND IN GAME " + player.getName() + " - " + this.myrisk.getGame().getPlayers());
        }
        this.playerList.setPlayers(playerColors);
        return sidePanel;
    }
}

