/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.core.StatType;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.PicturePanel;
import net.yura.domination.guishared.RiskFileFilter;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.guishared.StatsPanel;
import net.yura.domination.tools.mapeditor.MapEditor;
import net.yura.domination.ui.swinggui.BugsPanel;
import net.yura.domination.ui.swinggui.FX3DPanel;
import net.yura.domination.ui.swinggui.GameTab;
import net.yura.domination.ui.swinggui.LobbyTab;
import net.yura.domination.ui.swinggui.PLAF;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.domination.ui.swinggui.TestPanel;
import net.yura.domination.ui.swinggui.TranslationToolPanel;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.info.LogList;
import net.yura.grasshopper.submitter.BugSubmitter;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.HeapView;
import net.yura.swing.ImageIcon;
import net.yura.swingme.core.J2SELogger;

public class SwingGUIPanel
extends JPanel
implements ActionListener {
    public static final String version = "2";
    public static final String product = "Swing GUI for " + RiskUtil.GAME_NAME;
    private ResourceBundle resbundle = TranslationBundle.getBundle();
    private JTabbedPane tabbedpane;
    private JToolBar currentToolbar;
    private JMenuBar gMenuBar;
    private GameTab gameTab;
    private ConsoleTab consoleTab;
    private StatisticsTab statisticsTab;
    private DebugTab debugTab;
    private MapEditor editorTab;
    Risk myrisk;
    int gameState;
    PicturePanel pp;
    JButton lobby;

    public SwingGUIPanel(Risk r) {
        Preferences prefs;
        this.myrisk = r;
        this.gameState = -1;
        this.pp = new PicturePanel(this.myrisk);
        this.setLayout(new BorderLayout());
        this.gMenuBar = new JMenuBar();
        this.tabbedpane = new JTabbedPane();
        this.lobby = new JButton(this.resbundle.getString("lobby.run"));
        this.lobby.setActionCommand("lobby");
        this.lobby.addActionListener(this);
        this.lobby.setBackground(Color.RED);
        this.lobby.setVisible(false);
        this.gameTab = new GameTab(this);
        this.consoleTab = new ConsoleTab();
        this.editorTab = new MapEditor(this.myrisk, this);
        this.addTab(this.gameTab);
        this.addTab(new FX3DPanel(this.pp));
        try {
            this.statisticsTab = new StatisticsTab();
            this.addTab(this.statisticsTab);
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        try {
            if (RiskUIUtil.checkForNoSandbox()) {
                this.addTab(new LobbyTab(this.myrisk));
            }
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        this.addTab(this.consoleTab);
        this.addTab(new TestPanel(this.myrisk, this.pp));
        this.addTab(this.editorTab);
        try {
            if (RiskUIUtil.checkForNoSandbox()) {
                this.addTab(new TranslationToolPanel());
            }
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        try {
            this.debugTab = new DebugTab();
            this.addTab(this.debugTab);
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        this.addTab(new BugsPanel(this));
        this.add((Component)this.tabbedpane, "Center");
        ChangeListener changeMenu = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingGUITab sgt = (SwingGUITab)((Object)SwingGUIPanel.this.tabbedpane.getSelectedComponent());
                if (SwingGUIPanel.this.currentToolbar != null) {
                    SwingGUIPanel.this.remove(SwingGUIPanel.this.currentToolbar);
                }
                SwingGUIPanel.this.currentToolbar = sgt.getToolBar();
                if (SwingGUIPanel.this.currentToolbar != null) {
                    SwingGUIPanel.this.currentToolbar.setOrientation(0);
                    SwingGUIPanel.this.add((Component)SwingGUIPanel.this.currentToolbar, "North");
                }
                SwingGUIPanel.this.revalidate();
                SwingGUIPanel.this.repaint();
            }
        };
        this.tabbedpane.addChangeListener(changeMenu);
        changeMenu.stateChanged(null);
        JMenu gHelp = new JMenu(this.resbundle.getString("swing.menu.help"));
        gHelp.setMnemonic('H');
        JMenuItem gmManual = new JMenuItem(this.resbundle.getString("swing.menu.manual"));
        gmManual.setMnemonic('M');
        gmManual.setActionCommand("manual");
        gmManual.addActionListener(this);
        gHelp.add(gmManual);
        JMenuItem cmCommands = new JMenuItem(this.resbundle.getString("swing.menu.console.commands"));
        cmCommands.setMnemonic('C');
        cmCommands.setActionCommand("commands");
        cmCommands.addActionListener(this);
        gHelp.add(cmCommands);
        JMenuItem gmAbout = new JMenuItem(this.resbundle.getString("swing.menu.about"));
        gmAbout.setMnemonic('A');
        gmAbout.setActionCommand("about");
        gmAbout.addActionListener(this);
        gHelp.add(gmAbout);
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.valueOf("APP_ABOUT"))) {
                JavaCompatUtil.setLambda(Desktop.getDesktop(), "setAboutHandler", "java.awt.desktop.AboutHandler", new Runnable(){

                    public void run() {
                        SwingGUIPanel.this.openAbout();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.gMenuBar.add(gHelp);
        new PLAF(this);
        this.myrisk.addRiskListener(new SwingRiskAdapter());
        if (this.debugTab != null) {
            this.debugTab.start();
        }
        if ((prefs = SwingGUIPanel.getUIPreferences()) == null || prefs.getInt("ai.wait", -1) == -1) {
            AIManager.setWait(5);
        }
        if (prefs == null || !prefs.getBoolean("audio.sound", false)) {
            GameSound.INSTANCE.setSoundEnabled(false);
        }
        if (prefs == null || !prefs.getBoolean("audio.music", false)) {
            GameSound.INSTANCE.setMusicEnabled(false);
        }
    }

    static Preferences getUIPreferences() {
        return RiskSettings.getPreferences(SwingGUIPanel.class);
    }

    public JMenuBar getJMenuBar() {
        return this.gMenuBar;
    }

    public JTabbedPane getJTabbedPane() {
        return this.tabbedpane;
    }

    public void firePropertyChange(String string, Object o, Object o1) {
        super.firePropertyChange(string, o, o1);
    }

    public void checkForUpdates() {
        RiskUIUtil.checkForUpdates(this.myrisk);
        if (RiskUIUtil.getAddLobby()) {
            this.lobby.setVisible(true);
            this.revalidate();
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand().equals("manual")) {
            try {
                RiskUtil.openDocs(this.resbundle.getString("helpfiles.swing"));
            }
            catch (Exception e) {
                this.showError("Unable to open manual: " + e.getMessage());
            }
        } else if (a.getActionCommand().equals("about")) {
            this.openAbout();
        } else if (a.getActionCommand().equals("quit")) {
            System.exit(0);
        } else if (a.getActionCommand().equals("commands")) {
            this.Commands();
        } else {
            System.out.print("command \"" + a.getActionCommand() + "\" is not implemented yet\n");
        }
    }

    public void addTab(SwingGUITab a) {
        this.tabbedpane.add((Component)((Object)a));
        JMenu menu = a.getMenu();
        if (menu != null) {
            this.gMenuBar.add(menu);
        }
    }

    public void setSelectedTab(Class tab) {
        for (int i = 0; i < this.tabbedpane.getTabCount(); ++i) {
            Component c = this.tabbedpane.getComponentAt(i);
            if (!tab.isInstance(c)) continue;
            this.tabbedpane.setSelectedIndex(i);
            return;
        }
        throw new IllegalArgumentException("tab not found " + tab);
    }

    public void go(String input) {
        this.pp.setHighLight(255);
        if (this.gameState != 2 || !this.myrisk.getGame().getSetupDone()) {
            this.blockInput();
        }
        this.myrisk.parser(input);
    }

    public void blockInput() {
        this.gameState = -1;
        this.gameTab.showPanel("nothing");
        this.gameTab.blockInput();
        this.consoleTab.blockInput();
    }

    public void pprepaintCountries() {
        String tmp = this.gameTab.getSelectedMapView();
        int newview = -1;
        if (tmp.equals(this.resbundle.getString("game.tabs.continents"))) {
            newview = 0;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.ownership"))) {
            newview = 1;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.borderthreat"))) {
            newview = 2;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.cardownership"))) {
            newview = 3;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.troopstrength"))) {
            newview = 4;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.connectedempire"))) {
            newview = 5;
        }
        this.pp.repaintCountries(newview);
    }

    public void showMapImage(Icon p) {
        this.gameTab.guiSetup.showMapImage(p, "loaded from memory", this.myrisk.getGame().getVersion());
    }

    public void Commands() {
        String commands = "";
        try {
            BufferedReader bufferin = new BufferedReader(new InputStreamReader(RiskUtil.openStream("commands.txt")));
            String input = bufferin.readLine();
            while (input != null) {
                commands = commands.equals("") ? input : commands + "\n" + input;
                input = bufferin.readLine();
            }
            bufferin.close();
            JOptionPane.showMessageDialog(RiskUIUtil.findParentFrame(this), commands, this.resbundle.getString("swing.message.commands"), -1);
        }
        catch (Exception e) {
            this.showError("error with commands.txt file: " + e.getMessage());
        }
    }

    public void openAbout() {
        RiskUIUtil.openAbout(RiskUIUtil.findParentFrame(this), product, version);
    }

    public void showError(String error) {
        JOptionPane.showMessageDialog(this, this.resbundle.getString("swing.message.error") + " " + error, this.resbundle.getString("swing.title.error"), 0);
    }

    File getNewLogFile() {
        JFileChooser fc = new JFileChooser();
        RiskFileFilter filter = new RiskFileFilter("log");
        fc.setFileFilter(filter);
        int returnVal = fc.showSaveDialog(RiskUIUtil.findParentFrame(this));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String fileName = file.getName();
            if (!fileName.endsWith(".log")) {
                file = new File(file.getParentFile(), fileName + "." + "log");
            }
            return file;
        }
        return null;
    }

    void saveLog(JTextArea textArea) {
        File logFile = this.getNewLogFile();
        if (logFile != null) {
            try {
                FileWriter fileout = new FileWriter(logFile);
                BufferedWriter buffer = new BufferedWriter(fileout);
                PrintWriter printer = new PrintWriter(buffer);
                printer.write(textArea.getText());
                printer.close();
            }
            catch (Exception error) {
                this.showError(error.getMessage());
            }
        }
    }

    public void submitBug(String to, String from, String subjectIn, String messageFromUser, String cause) {
        String subject = RiskUtil.GAME_NAME + " " + RiskUtil.RISK_VERSION + " SwingGUI " + TranslationBundle.getBundle().getLocale().toString() + " " + subjectIn;
        try {
            if (RiskUIUtil.checkForNoSandbox()) {
                boolean success;
                HashMap<String, Object> map = new HashMap<String, Object>();
                RiskGame game = this.myrisk.getGame();
                if (game != null) {
                    map.put("gameLog", new LogList(game.getCommands()));
                }
                if (messageFromUser != null) {
                    map.put("messageFromUser", messageFromUser);
                }
                map.put("lobbyID", MiniLobbyClient.getMyUUID());
                map.put("debugText", this.debugTab.getDebugText());
                map.put("errText", this.debugTab.getErrText());
                if (to != null) {
                    map.put("recipient", to);
                }
                if (success = BugSubmitter.submitBug(map, from, subject, cause, RiskUtil.GAME_NAME, RiskUtil.RISK_VERSION, TranslationBundle.getBundle().getLocale().toString())) {
                    JOptionPane.showMessageDialog(this, "SENT!");
                    return;
                }
            }
        }
        catch (Throwable map) {
            // empty catch block
        }
        try {
            String text = (messageFromUser != null ? messageFromUser : "") + "\n\n\n" + this.debugTab.getDebugText() + "\n" + this.debugTab.getErrText();
            BugsPanel.sendEmailWithNativeClient("yura@yura.net", subject, text);
        }
        catch (Throwable th) {
            JOptionPane.showMessageDialog(this, "Error opening native email: " + th);
        }
    }

    class StatisticsTab
    extends JPanel
    implements SwingGUITab,
    ActionListener {
        private JToolBar toolbarStat;
        private JMenu sStatistics;
        private StatsPanel graph;
        private AbstractButton[] statbuttons;

        public JToolBar getToolBar() {
            return this.toolbarStat;
        }

        public JMenu getMenu() {
            return this.sStatistics;
        }

        public void actionPerformed(ActionEvent a) {
            this.graph.repaintStats(StatType.fromOrdinal(Integer.parseInt(a.getActionCommand())));
            this.graph.repaint();
        }

        public StatisticsTab() {
            this.setName(SwingGUIPanel.this.resbundle.getString("swing.tab.statistics"));
            this.toolbarStat = new JToolBar();
            this.toolbarStat.setRollover(true);
            this.toolbarStat.setFloatable(false);
            this.graph = new StatsPanel(SwingGUIPanel.this.myrisk);
            this.graph.setBorder(BorderFactory.createLoweredBevelBorder());
            this.sStatistics = new JMenu(SwingGUIPanel.this.resbundle.getString("swing.tab.statistics"));
            this.sStatistics.setMnemonic('S');
            StatType[] stats = StatType.values();
            this.statbuttons = new AbstractButton[stats.length * 2];
            for (int a = 0; a < stats.length; ++a) {
                StatType stat = stats[a];
                String text = SwingGUIPanel.this.resbundle.getString("swing.toolbar." + stat.getName());
                JButton button = new JButton(text);
                button.setActionCommand(String.valueOf(stat.ordinal()));
                button.addActionListener(this);
                button.setEnabled(false);
                this.toolbarStat.add(button);
                JMenuItem menuItem = new JMenuItem(text);
                menuItem.setActionCommand(String.valueOf(stat.ordinal()));
                menuItem.addActionListener(this);
                menuItem.setEnabled(false);
                this.sStatistics.add(menuItem);
                this.statbuttons[a] = button;
                this.statbuttons[a + stats.length] = menuItem;
            }
            this.setLayout(new BorderLayout());
            this.add(this.graph);
        }

        public void startGame() {
            for (int a = 0; a < this.statbuttons.length; ++a) {
                this.statbuttons[a].setEnabled(true);
            }
        }

        public void closeGame() {
            for (int a = 0; a < this.statbuttons.length; ++a) {
                this.statbuttons[a].setEnabled(false);
            }
        }
    }

    class DebugTab
    extends JSplitPane
    implements SwingGUITab,
    ActionListener {
        private JTextArea debugText;
        private JTextArea errText;
        private JToolBar toolbarDebug;
        private JMenu mDebug;
        String cause;

        public JToolBar getToolBar() {
            return this.toolbarDebug;
        }

        public JMenu getMenu() {
            return this.mDebug;
        }

        public void sendDebug(String a) {
            this.debugText.append(a + System.getProperty("line.separator"));
            this.debugText.setCaretPosition(this.debugText.getDocument().getLength());
        }

        public DebugTab() {
            super(1);
            this.setName("Debug");
            this.toolbarDebug = new JToolBar();
            this.toolbarDebug.setRollover(true);
            JButton tdSaveDebug = new JButton("Save Debug Log");
            JButton tdPlayDebug = new JButton("Play Debug Log");
            JButton playCommands = new JButton("Play Debug Commands");
            JButton tdClearDebug = new JButton("Clear Debug Log");
            JButton tdSaveError = new JButton("Save Error Log");
            JButton sendError = new JButton("Send Error Log");
            tdSaveDebug.setActionCommand("save debug");
            tdPlayDebug.setActionCommand("play debug");
            playCommands.setActionCommand("play commands");
            tdClearDebug.setActionCommand("clear debug");
            tdSaveError.setActionCommand("save error");
            sendError.setActionCommand("send error");
            tdSaveDebug.addActionListener(this);
            tdPlayDebug.addActionListener(this);
            playCommands.addActionListener(this);
            tdClearDebug.addActionListener(this);
            tdSaveError.addActionListener(this);
            sendError.addActionListener(this);
            JButton cr = new JButton("Clear Error");
            cr.setActionCommand("clear error");
            cr.addActionListener(this);
            JButton gc = new JButton("GC");
            gc.setActionCommand("gc");
            gc.addActionListener(this);
            HeapView hv = new HeapView();
            this.toolbarDebug.add(tdSaveDebug);
            this.toolbarDebug.add(tdPlayDebug);
            this.toolbarDebug.add(playCommands);
            this.toolbarDebug.add(tdClearDebug);
            this.toolbarDebug.addSeparator();
            this.toolbarDebug.add(tdSaveError);
            this.toolbarDebug.add(sendError);
            this.toolbarDebug.add(cr);
            this.toolbarDebug.addSeparator();
            this.toolbarDebug.add(gc);
            this.toolbarDebug.add(hv);
            this.toolbarDebug.setFloatable(false);
            this.mDebug = new JMenu("Debug");
            this.mDebug.setMnemonic('D');
            JMenuItem dSave = new JMenuItem("Save Debug Log");
            dSave.setMnemonic('S');
            dSave.setActionCommand("save debug");
            dSave.addActionListener(this);
            this.mDebug.add(dSave);
            JMenuItem dPlay = new JMenuItem("Play Debug Log");
            dPlay.setMnemonic('P');
            dPlay.setActionCommand("play debug");
            dPlay.addActionListener(this);
            this.mDebug.add(dPlay);
            JMenuItem dClear = new JMenuItem("Clear Debug Log");
            dClear.setMnemonic('C');
            dClear.setActionCommand("clear debug");
            dClear.addActionListener(this);
            this.mDebug.add(dClear);
            this.mDebug.addSeparator();
            JMenuItem dSaveErr = new JMenuItem("Save Error Log");
            dSaveErr.setMnemonic('E');
            dSaveErr.setActionCommand("save error");
            dSaveErr.addActionListener(this);
            this.mDebug.add(dSaveErr);
            JMenuItem send = new JMenuItem("Send Error Log");
            send.setMnemonic('S');
            send.setActionCommand("send error");
            send.addActionListener(this);
            this.mDebug.add(send);
            this.debugText = new JTextArea();
            this.debugText.setEditable(false);
            JScrollPane debugScroll = new JScrollPane(this.debugText);
            debugScroll.setVerticalScrollBarPolicy(22);
            JPanel debugPanel = new JPanel(new BorderLayout());
            debugPanel.add((Component)new JLabel("  Debug Log"), "North");
            debugPanel.add(debugScroll);
            this.errText = new JTextArea();
            this.errText.setEditable(false);
            JScrollPane errScroll = new JScrollPane(this.errText);
            errScroll.setPreferredSize(new Dimension(10, 10));
            JPanel errPanel = new JPanel(new BorderLayout());
            errPanel.add((Component)new JLabel("  Error Log"), "North");
            errPanel.add(errScroll);
            debugPanel.setOpaque(false);
            errPanel.setOpaque(false);
            this.setLeftComponent(debugPanel);
            this.setRightComponent(errPanel);
            this.setContinuousLayout(true);
            this.setOneTouchExpandable(true);
            this.setDividerLocation(GraphicsUtil.scale(400));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
        }

        public void start() {
            int size = 16;
            BufferedImage img = new BufferedImage(size, size, 2);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(Color.RED);
            g.fillOval(0, 0, size, size);
            g.dispose();
            final ImageIcon icon = new ImageIcon(img);
            if (RiskUIUtil.checkForNoSandbox()) {
                try {
                    Preferences.userRoot();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                BugManager.interceptAndAlert(new Writer(){

                    public void write(char[] cbuf, int off, int len) {
                        DebugTab.this.errText.append(String.valueOf(cbuf, off, len));
                    }

                    public void flush() {
                    }

                    public void close() {
                    }
                }, new BugManager(){

                    public void action(String thecause, int actionCount) {
                        DebugTab.this.cause = thecause;
                        int nom = SwingGUIPanel.this.tabbedpane.indexOfComponent(DebugTab.this);
                        if (SwingGUIPanel.this.tabbedpane.getIconAt(nom) == null) {
                            SwingGUIPanel.this.tabbedpane.setIconAt(nom, icon);
                        }
                    }
                });
                try {
                    J2SELogger.setupLogging();
                }
                catch (Throwable th) {
                    RiskUtil.printStackTrace(th);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent a) {
            if (a.getActionCommand().equals("play debug")) {
                File file = RiskUIUtil.getFileOpenDialog(RiskUIUtil.findParentFrame(this), null, "log");
                if (file != null) {
                    String fileName = file.getAbsolutePath();
                    SwingGUIPanel.this.go("play " + fileName);
                }
            } else if (a.getActionCommand().equals("play commands")) {
                JTextArea msg = new JTextArea();
                if (0 == JOptionPane.showConfirmDialog(this, new JScrollPane(msg), "play commands:", 2)) {
                    try {
                        if (SwingGUIPanel.this.myrisk.getGame() != null) {
                            SwingGUIPanel.this.myrisk.parserAndWait("closegame");
                        }
                        SwingGUIPanel.this.myrisk.parserAndWait("newgame");
                        Scanner scanner = new Scanner(msg.getText());
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine().trim();
                            SwingGUIPanel.this.myrisk.getGame().getCommands().add(line);
                        }
                        scanner.close();
                        SwingGUIPanel.this.go("replay");
                    }
                    catch (Exception error) {
                        RiskUtil.printStackTrace("error running commands", error);
                    }
                }
            } else if (a.getActionCommand().equals("save debug")) {
                RiskGame game = SwingGUIPanel.this.myrisk.getGame();
                if (game == null) {
                    SwingGUIPanel.this.saveLog(this.debugText);
                } else {
                    File logFile = SwingGUIPanel.this.getNewLogFile();
                    if (logFile != null) {
                        try {
                            RiskUtil.saveGameLog(logFile, game);
                        }
                        catch (Exception error) {
                            SwingGUIPanel.this.showError(error.getMessage());
                        }
                    }
                }
            } else if (a.getActionCommand().equals("clear debug")) {
                this.debugText.setText("");
            } else if (a.getActionCommand().equals("save error")) {
                SwingGUIPanel.this.saveLog(this.errText);
            } else if (a.getActionCommand().equals("send error")) {
                String email = JOptionPane.showInputDialog(this, (Object)"tell me your e-mail please");
                if (email == null) {
                    email = "none";
                }
                SwingGUIPanel.this.submitBug(null, email, "Bug", null, this.cause);
            } else if (a.getActionCommand().equals("clear error")) {
                this.errText.setText("");
                SwingGUIPanel.this.tabbedpane.setIconAt(SwingGUIPanel.this.tabbedpane.indexOfComponent(this), null);
            } else if (a.getActionCommand().equals("gc")) {
                System.gc();
            } else {
                throw new RuntimeException("command \"" + a.getActionCommand() + "\" is not implemented yet\n");
            }
        }

        private String getDebugText() {
            return this.debugText.getText();
        }

        private String getErrText() {
            return this.errText.getText();
        }
    }

    class ConsoleTab
    extends JPanel
    implements SwingGUITab,
    ActionListener {
        private String temptext;
        private List history;
        private int pointer;
        JMenu cConsole;
        JToolBar toolbarCon;
        private JTextArea Console;
        private JTextField Command;
        private JButton Submit;
        private JLabel statusBar;
        private JScrollPane Con;

        public ConsoleTab() {
            this.setName(SwingGUIPanel.this.resbundle.getString("swing.tab.console"));
            this.history = new Vector();
            this.pointer = -1;
            this.statusBar = new JLabel(SwingGUIPanel.this.resbundle.getString("swing.status.loading"));
            this.Console = new JTextArea();
            this.Con = new JScrollPane(this.Console);
            Dimension conSize = GraphicsUtil.newDimension(677, 485);
            this.Con.setVerticalScrollBarPolicy(22);
            this.Con.setPreferredSize(conSize);
            this.Con.setMinimumSize(conSize);
            this.Console.setEditable(false);
            this.Command = new JTextField("");
            Dimension CommandSize = GraphicsUtil.newDimension(627, 20);
            this.Command.setPreferredSize(CommandSize);
            this.Command.setMinimumSize(CommandSize);
            this.Command.setMaximumSize(CommandSize);
            this.Submit = new JButton(SwingGUIPanel.this.resbundle.getString("swing.button.submit"));
            this.Submit.setActionCommand("read command");
            this.Submit.addActionListener(this);
            this.Command.setActionCommand("read command");
            this.Command.addActionListener(this);
            this.toolbarCon = new JToolBar();
            this.toolbarCon.setRollover(true);
            this.toolbarCon.setFloatable(false);
            JButton cRunScript = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.runscript"));
            JButton cSaveConsole = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.save"));
            JButton cClearConsole = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.clear"));
            JButton cClearHistory = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.histclear"));
            JButton cCommands = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.commands"));
            JButton cManual = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.manual"));
            JButton cAbout = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.about"));
            JButton cQuit = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.quit"));
            cRunScript.setActionCommand("run script");
            cRunScript.addActionListener(this);
            cSaveConsole.setActionCommand("save console");
            cSaveConsole.addActionListener(this);
            cClearConsole.setActionCommand("clear console");
            cClearConsole.addActionListener(this);
            cClearHistory.setActionCommand("clear history");
            cClearHistory.addActionListener(this);
            cCommands.setActionCommand("commands");
            cCommands.addActionListener(this);
            cManual.setActionCommand("manual");
            cManual.addActionListener(this);
            cAbout.setActionCommand("about");
            cAbout.addActionListener(this);
            cQuit.setActionCommand("quit");
            cQuit.addActionListener(this);
            this.toolbarCon.add(cRunScript);
            this.toolbarCon.add(cSaveConsole);
            this.toolbarCon.add(cClearConsole);
            this.toolbarCon.add(cClearHistory);
            this.toolbarCon.addSeparator();
            this.toolbarCon.add(cCommands);
            this.toolbarCon.add(cManual);
            this.toolbarCon.add(cAbout);
            if (RiskUIUtil.checkForNoSandbox()) {
                this.toolbarCon.add(cQuit);
            }
            this.cConsole = new JMenu(SwingGUIPanel.this.resbundle.getString("swing.menu.console"));
            this.cConsole.setMnemonic('C');
            JMenuItem cmRunScript = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.runscript"));
            cmRunScript.setMnemonic('R');
            cmRunScript.setActionCommand("run script");
            cmRunScript.addActionListener(this);
            this.cConsole.add(cmRunScript);
            JMenuItem cmSaveConsole = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.save"));
            cmSaveConsole.setMnemonic('S');
            cmSaveConsole.setActionCommand("save console");
            cmSaveConsole.addActionListener(this);
            this.cConsole.add(cmSaveConsole);
            JMenuItem cmClearConsole = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.clear"));
            cmClearConsole.setMnemonic('C');
            cmClearConsole.setActionCommand("clear console");
            cmClearConsole.addActionListener(this);
            this.cConsole.add(cmClearConsole);
            JMenuItem cmClearHistory = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.histclear"));
            cmClearHistory.setMnemonic('H');
            cmClearHistory.setActionCommand("clear history");
            cmClearHistory.addActionListener(this);
            this.cConsole.add(cmClearHistory);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            this.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)this.Con, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.add((Component)this.Command, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.Submit, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.add((Component)this.statusBar, c);
            this.Command.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent key) {
                    if (key.getKeyCode() == 38) {
                        if (ConsoleTab.this.pointer < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            if (ConsoleTab.this.pointer == ConsoleTab.this.history.size() - 1) {
                                ConsoleTab.this.temptext = ConsoleTab.this.Command.getText();
                            }
                            ConsoleTab.this.Command.setText((String)ConsoleTab.this.history.get(ConsoleTab.this.pointer));
                            ConsoleTab.this.pointer--;
                        }
                    } else if (key.getKeyCode() == 40) {
                        if (ConsoleTab.this.pointer > ConsoleTab.this.history.size() - 2) {
                            Toolkit.getDefaultToolkit().beep();
                        } else if (ConsoleTab.this.pointer == ConsoleTab.this.history.size() - 2) {
                            ConsoleTab.this.Command.setText(ConsoleTab.this.temptext);
                            ConsoleTab.this.pointer++;
                        } else {
                            ConsoleTab.this.pointer = ConsoleTab.this.pointer + 2;
                            ConsoleTab.this.Command.setText((String)ConsoleTab.this.history.get(ConsoleTab.this.pointer));
                            ConsoleTab.this.pointer--;
                        }
                    } else {
                        ConsoleTab.this.pointer = ConsoleTab.this.history.size() - 1;
                    }
                }
            });
            this.setOpaque(false);
            this.statusBar.setText(SwingGUIPanel.this.resbundle.getString("swing.status.ready"));
        }

        private void cgo(String input) {
            if (input.equals("exit")) {
                System.exit(0);
            } else if (input.equals("help")) {
                SwingGUIPanel.this.Commands();
            } else if (input.equals("about")) {
                SwingGUIPanel.this.openAbout();
            } else if (input.equals("clear")) {
                this.Console.setText("");
            } else if (input.equals("manual")) {
                try {
                    RiskUtil.openDocs(SwingGUIPanel.this.resbundle.getString("helpfiles.swing"));
                }
                catch (Exception e) {
                    this.addOutput("Unable to open manual: " + e.getMessage());
                }
            } else {
                SwingGUIPanel.this.go(input);
            }
        }

        public void addOutput(String output) {
            this.Console.append(output + System.getProperty("line.separator"));
            this.Console.setCaretPosition(this.Console.getDocument().getLength());
        }

        public void blockInput() {
            this.statusBar.setText(SwingGUIPanel.this.resbundle.getString("swing.status.working"));
            this.Submit.setEnabled(false);
            this.Command.setEnabled(false);
        }

        public void getInput() {
            this.Submit.setEnabled(true);
            this.Command.setEnabled(true);
            this.Command.requestFocus();
            this.statusBar.setText(SwingGUIPanel.this.resbundle.getString("swing.status.doneready"));
        }

        public void setVisible(boolean v) {
            super.setVisible(v);
            this.Command.requestFocus();
        }

        public JToolBar getToolBar() {
            return this.toolbarCon;
        }

        public JMenu getMenu() {
            return this.cConsole;
        }

        public void actionPerformed(ActionEvent a) {
            if (a.getActionCommand().equals("read command")) {
                String input = this.Command.getText();
                this.Command.setText("");
                this.history.add(input);
                this.pointer = this.history.size() - 1;
                this.cgo(input);
            } else if (a.getActionCommand().equals("run script")) {
                File file = RiskUIUtil.getFileOpenDialog(RiskUIUtil.findParentFrame(this), null, "risk");
                if (file != null) {
                    try {
                        FileReader filein = new FileReader(file);
                        BufferedReader bufferin = new BufferedReader(filein);
                        String input = bufferin.readLine();
                        while (input != null) {
                            SwingGUIPanel.this.go(input);
                            input = bufferin.readLine();
                        }
                        bufferin.close();
                    }
                    catch (Exception error) {
                        RiskUtil.printStackTrace("error running script", error);
                    }
                }
            } else if (a.getActionCommand().equals("save console")) {
                SwingGUIPanel.this.saveLog(this.Console);
            } else if (a.getActionCommand().equals("clear console")) {
                this.Console.setText("");
            } else if (a.getActionCommand().equals("clear history")) {
                this.history.clear();
                this.pointer = -1;
            } else {
                SwingGUIPanel.this.actionPerformed(a);
            }
        }
    }

    class SwingRiskAdapter
    extends RiskAdapter {
        SwingRiskAdapter() {
        }

        public void sendMessage(final String output, boolean redrawNeeded, boolean repaintNeeded) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingGUIPanel.this.consoleTab.addOutput(output);
                }
            });
            if (redrawNeeded) {
                SwingGUIPanel.this.pprepaintCountries();
            }
            if (repaintNeeded) {
                SwingGUIPanel.this.repaint();
            }
        }

        public void sendDebug(String a) {
            if (SwingGUIPanel.this.debugTab != null) {
                SwingGUIPanel.this.debugTab.sendDebug(a);
            }
        }

        public void showMessageDialog(String a) {
            SwingGUIPanel.this.showError(a);
        }

        public void noInput() {
            SwingGUIPanel.this.blockInput();
        }

        public void needInput(int s) {
            SwingGUIPanel.this.gameState = s;
            SwingGUIPanel.this.gameTab.getInput(s);
            SwingGUIPanel.this.consoleTab.getInput();
            SwingGUIPanel.this.repaint();
        }

        public void setGameStatus(String state) {
            SwingGUIPanel.this.gameTab.setGameStatus(state);
        }

        public void showMapPic(RiskGame p) {
            ImageIcon i = null;
            try {
                i = new ImageIcon(PicturePanel.getImage(p));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ((SwingGUIPanel)SwingGUIPanel.this).gameTab.guiSetup.showMapImage(i, p.getMapFile(), p.getVersion());
        }

        public void showCardsFile(String c, boolean m) {
            ((SwingGUIPanel)SwingGUIPanel.this).gameTab.guiSetup.showCardsFile(c, m);
        }

        public void newGame(boolean t) {
            SwingGUIPanel.this.gameTab.setLocalGame(t);
            SwingGUIPanel.this.gameTab.newGame();
        }

        public void startGame(boolean localGame) {
            SwingGUIPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            SwingGUIPanel.this.gameTab.setLocalGame(localGame);
            if (SwingGUIPanel.this.myrisk.getGame().getMapFile() == null && SwingGUIPanel.this.myrisk.getGame().getCardsFile() == null) {
                SwingGUIPanel.this.pp.memoryLoad(SwingGUIPanel.this.editorTab.getImageMap(), SwingGUIPanel.this.editorTab.getImagePic());
            } else {
                try {
                    SwingGUIPanel.this.pp.load();
                }
                catch (IOException e) {
                    RiskUtil.printStackTrace(e);
                }
                catch (OutOfMemoryError e) {
                    SwingGUIPanel.this.showError("load images error " + e);
                }
            }
            SwingGUIPanel.this.blockInput();
            SwingGUIPanel.this.pprepaintCountries();
            SwingGUIPanel.this.gameTab.startGame();
            SwingGUIPanel.this.statisticsTab.startGame();
            SwingGUIPanel.this.setCursor(null);
            if (!localGame && SwingGUIPanel.this.tabbedpane.getSelectedComponent() instanceof LobbyTab) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwingGUIPanel.this.setSelectedTab(GameTab.class);
                    }
                });
            }
        }

        public void closeGame() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingGUIPanel.this.gameTab.closeGame();
                    SwingGUIPanel.this.statisticsTab.closeGame();
                }
            });
        }

        public void showDiceResults(int[] att, int[] def, boolean weAreAttacker, int result) {
            int c;
            String output = SwingGUIPanel.this.resbundle.getString("core.dice.results");
            output = output + " " + SwingGUIPanel.this.resbundle.getString("core.dice.attacker");
            for (c = 0; c < att.length; ++c) {
                output = output + " " + (att[c] + 1);
            }
            output = output + " " + SwingGUIPanel.this.resbundle.getString("core.dice.defender");
            for (c = 0; c < def.length; ++c) {
                output = output + " " + (def[c] + 1);
            }
            ((SwingGUIPanel)SwingGUIPanel.this).gameTab.resultsLabel.setText(output);
            SwingGUIPanel.this.gameTab.showPanel("results");
        }

        public void closeBattle() {
            SwingGUIPanel.this.blockInput();
        }

        public void serverState(boolean s) {
            SwingGUIPanel.this.gameTab.serverState(s);
        }

        public void addPlayer(int t, String name, int color, String ip) {
            ((SwingGUIPanel)SwingGUIPanel.this).gameTab.guiSetup.addPlayer(t, name, color, ip);
        }

        public void delPlayer(String name) {
            ((SwingGUIPanel)SwingGUIPanel.this).gameTab.guiSetup.delPlayer(name);
        }
    }
}

