/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.List;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class GraphicsUtil {
    public static final double density = GraphicsUtil.getDisplayDensity();
    public static final double scale = GraphicsUtil.getScale();
    private static MediaTracker mediaTracker = new MediaTracker(new Component(){});

    public static int scale(int i) {
        return (int)((double)i * density / scale);
    }

    public static boolean insideButton(int x, int y, int bx, int by, int bw, int bh) {
        return x >= GraphicsUtil.scale(bx) && x < GraphicsUtil.scale(bx + bw) && y >= GraphicsUtil.scale(by) && y < GraphicsUtil.scale(by + bh);
    }

    public static void setBounds(Component comp, int x, int y, int w, int h) {
        comp.setBounds(GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(w), GraphicsUtil.scale(h));
    }

    public static Dimension newDimension(int width, int height) {
        return new Dimension(GraphicsUtil.scale(width), GraphicsUtil.scale(height));
    }

    public static Insets newInsets(int top, int left, int bottom, int right) {
        return new Insets(GraphicsUtil.scale(top), GraphicsUtil.scale(left), GraphicsUtil.scale(bottom), GraphicsUtil.scale(right));
    }

    public static Polygon newPolygon(int[] xCoords, int[] yCoords) {
        Polygon polygon = new Polygon();
        for (int c = 0; c < xCoords.length; ++c) {
            polygon.addPoint(GraphicsUtil.scale(xCoords[c]), GraphicsUtil.scale(yCoords[c]));
        }
        return polygon;
    }

    public static RoundRectangle2D newRoundRectangle(int x, int y, int w, int h, int arcw, int arch) {
        return new RoundRectangle2D.Float(GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(w), GraphicsUtil.scale(h), GraphicsUtil.scale(arcw), GraphicsUtil.scale(arch));
    }

    public static FlowLayout newFlowLayout(int align) {
        return new FlowLayout(align, GraphicsUtil.scale(5), GraphicsUtil.scale(5));
    }

    public static void drawImage(Graphics g, Image img, int x, int y, ImageObserver observer) {
        g.drawImage(img, GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(img.getWidth(observer)), GraphicsUtil.scale(img.getHeight(observer)), observer);
    }

    public static void drawImage(Graphics g, Image img, int x, int y, int w, int h, ImageObserver observer) {
        g.drawImage(img, GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(w), GraphicsUtil.scale(h), observer);
    }

    public static void drawImage(Graphics g, Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        g.drawImage(img, GraphicsUtil.scale(dx1), GraphicsUtil.scale(dy1), GraphicsUtil.scale(dx2), GraphicsUtil.scale(dy2), sx1, sy1, sx2, sy2, observer);
    }

    public static void drawImageInRect(Graphics g, Image img, int xPos, int yPos, int maxW, int maxH, ImageObserver observer) {
        int centreX = xPos + maxW / 2;
        int centreY = yPos + maxH / 2;
        int w = img.getWidth(observer);
        int h = img.getHeight(observer);
        if (w > maxW || h > maxH) {
            double scale = Math.min((double)maxW / (double)w, (double)maxH / (double)h);
            w = (int)(scale * (double)w);
            h = (int)(scale * (double)h);
        }
        GraphicsUtil.drawImage(g, img, centreX - w / 2, centreY - h / 2, w, h, observer);
    }

    public static void fillRect(Graphics g, int x, int y, int width, int height) {
        g.fillRect(GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(width), GraphicsUtil.scale(height));
    }

    public static void fillArc(Graphics g, int x, int y, int width, int height, int startAngle, int arcAngle) {
        g.fillArc(GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(width), GraphicsUtil.scale(height), startAngle, arcAngle);
    }

    public static void fillOval(Graphics g, int x, int y, int width, int height) {
        g.fillOval(GraphicsUtil.scale(x), GraphicsUtil.scale(y), GraphicsUtil.scale(width), GraphicsUtil.scale(height));
    }

    public static void drawString(Graphics g, String string, int x, int y) {
        g.drawString(string, GraphicsUtil.scale(x), GraphicsUtil.scale(y));
    }

    public static void drawStringCenteredAt(Graphics g, String text, int x, int y) {
        GraphicsUtil.drawStringCenteredAt(g, text, '\u0000', x, y);
    }

    public static void drawStringCenteredAt(Graphics g, String text, char ch, int x, int y) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        BasicGraphicsUtils.drawString(g, text, ch, GraphicsUtil.scale(x) - metrics.stringWidth(text) / 2, GraphicsUtil.scale(y));
    }

    public static void drawStringCenteredAt(Graphics g, String text, int centerX, int startY, int wrapWidth, Color outline) {
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.FONT, g.getFont());
        AttributedCharacterIterator aci = as.getIterator();
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
        int x = GraphicsUtil.scale(centerX);
        int y = GraphicsUtil.scale(startY);
        int width = GraphicsUtil.scale(wrapWidth);
        lbm.setPosition(0);
        while (lbm.getPosition() < text.length()) {
            TextLayout tl = lbm.nextLayout(width);
            float textX = (float)((double)x - tl.getBounds().getWidth() / 2.0);
            y = (int)((float)y + tl.getAscent());
            float textY = y;
            if (outline == null) {
                tl.draw((Graphics2D)g, textX, textY);
            } else {
                GraphicsUtil.drawStringWithOutline((Graphics2D)g, tl, textX, textY, outline);
            }
            y = (int)((float)y + (tl.getDescent() + tl.getLeading()));
        }
    }

    public static void drawStringWithOutline(Graphics2D g2, TextLayout tl, float x, float y, Color outlineColor) {
        Color textColor = g2.getColor();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(x, y);
        Shape outline = tl.getOutline(transform);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(2.0f, 1, 1));
        g2.setColor(outlineColor);
        g2.draw(outline);
        g2.setColor(textColor);
        g2.setStroke(oldStroke);
        g2.fill(outline);
    }

    private static double getDisplayDensity() {
        try {
            return (Double)Class.forName("javax.microedition.midlet.ApplicationManager").getMethod("getDisplayDensity", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return 1.0;
        }
    }

    private static double getScale() {
        try {
            return (Double)Class.forName("javax.microedition.midlet.ApplicationManager").getMethod("getScale", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return 1.0;
        }
    }

    public static Image getSubimage(Image img, int x, int y, int width, int height) {
        Class<?> multiResolutionImageClass2;
        try {
            multiResolutionImageClass2 = Class.forName("java.awt.image.MultiResolutionImage");
            if (multiResolutionImageClass2.isInstance(img)) {
                int baseWidth = img.getWidth(null);
                List images = (List)multiResolutionImageClass2.getMethod("getResolutionVariants", new Class[0]).invoke((Object)img, new Object[0]);
                Image[] scaledImages = new Image[images.size()];
                for (int c = 0; c < images.size(); ++c) {
                    Image i = (Image)images.get(c);
                    double scale = (double)i.getWidth(null) / (double)baseWidth;
                    scaledImages[c] = GraphicsUtil.getSubimageImpl(i, (int)((double)x * scale), (int)((double)y * scale), (int)((double)width * scale), (int)((double)height * scale));
                }
                return GraphicsUtil.newBaseMultiResolutionImage(scaledImages);
            }
        }
        catch (Throwable multiResolutionImageClass2) {
            // empty catch block
        }
        try {
            multiResolutionImageClass2 = Class.forName("sun.awt.image.MultiResolutionImage");
            if (multiResolutionImageClass2.isInstance(img)) {
                int baseWidth = img.getWidth(null);
                List images = (List)multiResolutionImageClass2.getMethod("getResolutionVariants", new Class[0]).invoke((Object)img, new Object[0]);
                Image[] scaledImages = new Image[images.size()];
                for (int c = 0; c < images.size(); ++c) {
                    Image i = (Image)images.get(c);
                    double scale = (double)i.getWidth(null) / (double)baseWidth;
                    scaledImages[c] = GraphicsUtil.getSubimageImpl(i, (int)((double)x * scale), (int)((double)y * scale), (int)((double)width * scale), (int)((double)height * scale));
                }
                Class<?> baseMultiResolutionImageClass = Class.forName("sun.awt.image.MultiResolutionToolkitImage");
                return (Image)baseMultiResolutionImageClass.getConstructor(Image.class, Image.class).newInstance(scaledImages[0], scaledImages[1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return GraphicsUtil.getSubimageImpl(img, x, y, width, height);
    }

    private static Image getSubimageImpl(Image img, int x, int y, int width, int height) {
        if (img instanceof BufferedImage) {
            return ((BufferedImage)img).getSubimage(x, y, width, height);
        }
        CropImageFilter filter = new CropImageFilter(x, y, width, height);
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        Image croppedImg = Toolkit.getDefaultToolkit().createImage(prod);
        GraphicsUtil.waitForImage(croppedImg);
        return croppedImg;
    }

    public static Image newBaseMultiResolutionImage(Image[] images) throws Exception {
        Class<?> baseMultiResolutionImageClass = Class.forName("java.awt.image.BaseMultiResolutionImage");
        return (Image)baseMultiResolutionImageClass.getConstructor(images.getClass()).newInstance(new Object[]{images});
    }

    public static void waitForImage(Image img) {
        mediaTracker.addImage(img, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException e) {
            System.out.println("Loading of the image was interrupted");
        }
        mediaTracker.removeImage(img);
    }
}

