/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.logging.Logger;
import net.yura.swing.GraphicsUtil;

public class ImageIcon
extends javax.swing.ImageIcon {
    private Image original;

    public ImageIcon(String filename) {
        super(filename);
        this.adjustImage();
    }

    public ImageIcon(URL location) {
        super(location);
        this.adjustImage();
    }

    public ImageIcon(Image image) {
        super(image);
        this.adjustImage();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        try {
            super.paintIcon(c, g, x, y);
        }
        catch (ClassCastException ex) {
            if (this.original != null) {
                Logger.getLogger(ImageIcon.class.getName()).info("getScaledInstance failed, falling back to drawImage for " + this);
                BufferedImage newImg = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 4);
                Graphics g2 = newImg.getGraphics();
                g2.drawImage(this.original, 0, 0, this.getIconWidth(), this.getIconHeight(), 0, 0, this.original.getWidth(c), this.original.getHeight(c), c);
                g2.setColor(Color.RED);
                g2.fillOval(GraphicsUtil.scale(5), GraphicsUtil.scale(5), GraphicsUtil.scale(10), GraphicsUtil.scale(10));
                g2.dispose();
                this.setImage(newImg);
                super.paintIcon(c, g, x, y);
            }
            throw ex;
        }
        this.original = null;
    }

    private void adjustImage() {
        if (GraphicsUtil.scale(this.getIconWidth()) != this.getIconWidth()) {
            this.original = this.getImage();
            int newWidth = GraphicsUtil.scale(this.getIconWidth());
            int newHeight = GraphicsUtil.scale(this.getIconHeight());
            try {
                Class<?> multiResolutionImageClass = Class.forName("java.awt.image.MultiResolutionImage");
                if (multiResolutionImageClass.isInstance(this.original)) {
                    Image image = (Image)multiResolutionImageClass.getMethod("getResolutionVariant", Double.TYPE, Double.TYPE).invoke((Object)this.original, newWidth, newHeight);
                    if (newWidth == image.getWidth(null)) {
                        this.setImage(image);
                    } else {
                        this.setImage(image.getScaledInstance(newWidth, newHeight, image instanceof BufferedImage ? 4 : 1));
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setImage(this.original.getScaledInstance(newWidth, newHeight, this.original instanceof BufferedImage ? 4 : 1));
        }
    }
}

