/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swingme.core;

import java.util.Arrays;
import java.util.Vector;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.gui.layout.BoxLayout;
import net.yura.mobile.gui.layout.FlowLayout;
import net.yura.mobile.gui.layout.Layout;
import net.yura.mobile.util.Option;

public class ViewChooser
extends Panel
implements ActionListener {
    Option[] options;
    ActionListener actionListener;
    String actionCommand;
    boolean stretchCombo;

    public ViewChooser(Option[] pp) {
        this.options = pp;
        Button test = new Button("test");
        test.workoutPreferredSize();
        this.setPreferredSize(10, test.getHeightWithBorder());
    }

    public void setStretchCombo(boolean stretch) {
        this.stretchCombo = stretch;
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = al;
    }

    public void setActionCommand(String com) {
        this.actionCommand = com;
    }

    public void setSize(int width, int height) {
        if (width != this.getWidth() || height != this.getHeight()) {
            Option currentOption = this.getSelectedItem();
            int buttonsWidth = 0;
            Button[] buttons = new Button[this.options.length];
            for (int c = 0; c < buttons.length; ++c) {
                buttons[c] = new Button(this.options[c].getValue());
                if (c == 0) {
                    buttons[c].setName("SegmentedControlLeft");
                } else if (c == buttons.length - 1) {
                    buttons[c].setName("SegmentedControlRight");
                } else {
                    buttons[c].setName("SegmentedControlMiddle");
                }
                buttons[c].workoutPreferredSize();
                buttonsWidth += buttons[c].getWidthWithBorder();
            }
            if (buttonsWidth <= width) {
                this.setLayout((Layout)new FlowLayout(1, 0));
                ButtonGroup group = new ButtonGroup();
                for (int c = 0; c < buttons.length; ++c) {
                    Button b = buttons[c];
                    b.setActionCommand(this.options[c].getKey());
                    if (currentOption == this.options[c]) {
                        b.setSelected(true);
                    }
                    group.add(b);
                    b.addActionListener((ActionListener)this);
                    this.add((Component)b);
                }
                while (this.getComponentCount() > buttons.length) {
                    this.remove(0);
                }
            } else {
                ComboBox combo = new ComboBox(JavaCompatUtil.asVector(Arrays.asList(this.options)));
                combo.setSelectedItem((Object)currentOption);
                combo.workoutPreferredSize();
                combo.addActionListener((ActionListener)this);
                this.setLayout((Layout)(this.stretchCombo || combo.getWidthWithBorder() > width ? new BorderLayout() : new BoxLayout(1)));
                this.insert((Component)combo, 0);
                while (this.getComponentCount() > 1) {
                    this.remove(1);
                }
            }
        }
        super.setSize(width, height);
    }

    public void actionPerformed(String ac) {
        this.actionListener.actionPerformed(this.actionCommand);
    }

    public Option getSelectedItem() {
        Vector components = this.getComponents();
        if (components.isEmpty()) {
            return this.options[0];
        }
        Object one = components.get(0);
        if (one instanceof ComboBox) {
            return (Option)((ComboBox)one).getSelectedItem();
        }
        ButtonGroup bg = ((Button)one).getGroup();
        String id = bg.getSelection().getActionCommand();
        for (int c = 0; c < this.options.length; ++c) {
            if (!id.equals(this.options[c].getKey())) continue;
            return this.options[c];
        }
        throw new RuntimeException("can not find option with id: " + id);
    }

    public void resetMapView() {
        Vector components = this.getComponents();
        if (!components.isEmpty()) {
            if (components.get(0) instanceof ComboBox) {
                ((ComboBox)components.get(0)).setSelectedIndex(0);
            } else {
                ((Button)components.get(0)).setSelected(true);
            }
        }
    }
}

