/*
 * Decompiled with CFR 0.152.
 */
package net.yura.io;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.yura.mobile.io.json.JSONTokener;
import net.yura.mobile.io.json.JSONWriter;

public class JSONUtil
extends net.yura.mobile.io.JSONUtil {
    public JSONUtil() {
        this.useListForArray = true;
    }

    public Object load(String text) {
        try {
            return this.load(new StringReader(text));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("bad json " + text);
        }
    }

    public String save(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer, obj);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("bad object " + obj);
        }
        return writer.toString();
    }

    protected Object readObject(JSONTokener x) throws IOException {
        char c = x.nextClean();
        x.back();
        if (c == '{') {
            x.startObject();
            if (x.nextClean() == '}') {
                return Collections.emptyMap();
            }
            x.back();
            HashMap<String, Object> map = new HashMap<String, Object>();
            boolean end = false;
            while (!end) {
                String key = x.nextKey();
                Object obj = this.readObject(x);
                map.put(key, obj);
                end = x.endObject();
            }
            return map;
        }
        return super.readObject(x);
    }

    protected void saveObject(JSONWriter serializer, Object object) throws IOException {
        if (object instanceof List && !(object instanceof Vector)) {
            List list = (List)object;
            serializer.array();
            for (Object obj : list) {
                this.saveObject(serializer, obj);
            }
            serializer.endArray();
        } else if (object instanceof Map && !(object instanceof Hashtable)) {
            Map map = (Map)object;
            serializer.object();
            for (String key : map.keySet()) {
                Object value = map.get(key);
                serializer.key(key);
                this.saveObject(serializer, value);
            }
            serializer.endObject();
        } else {
            super.saveObject(serializer, object);
        }
    }
}

