/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.logging.DesktopLogger;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.QueueProcessorThread;
import net.yura.mobile.util.Url;

public abstract class Application
extends MIDlet {
    public static final int PLATFORM_NOT_DEFINED = 0;
    public static final int PLATFORM_NOKIA_S40 = 1;
    public static final int PLATFORM_NOKIA_S60 = 2;
    public static final int PLATFORM_SONY_ERICSSON = 3;
    public static final int PLATFORM_SAMSUNG = 4;
    public static final int PLATFORM_MOTOROLA = 5;
    public static final int PLATFORM_SIEMENS = 6;
    public static final int PLATFORM_LG = 7;
    public static final int PLATFORM_ME4SE = 8;
    public static final int PLATFORM_WTK = 9;
    public static final int PLATFORM_ANDROID = 10;
    public static final int PLATFORM_BLACKBERRY = 11;
    public static final int PLATFORM_IOS = 12;
    private static int platform = Application.detectPlatform();
    private DesktopPane rootpane;
    private Hashtable platformReqParams;
    public static String resdir;

    public Application() {
        QueueProcessorThread.CHANGE_PRIORITY = Application.getPlatform() != 12 && Application.getPlatform() != 8 && Application.getPlatform() != 10 && Application.getPlatform() != 11;
        this.rootpane = this.makeNewRootPane();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.rootpane);
        this.rootpane.repaint();
    }

    public static Application getInstance() {
        DesktopPane dp = DesktopPane.getDesktopPane();
        return dp == null ? null : dp.application;
    }

    protected DesktopPane makeNewRootPane() {
        return new DesktopPane(this, -16777216, null);
    }

    protected abstract void initialize(DesktopPane var1);

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.rootpane.kill();
    }

    public static void exit() {
        try {
            Application application = Application.getInstance();
            application.destroyApp(false);
            application.notifyDestroyed();
        }
        catch (Exception ex) {
            Logger.warn(null, ex);
            throw new RuntimeException();
        }
    }

    public static void hide() {
        Display.getDisplay((MIDlet)Application.getInstance()).setCurrent(null);
    }

    protected void pauseApp() {
    }

    protected void startApp() {
    }

    public static void call(String number) {
        try {
            Application.getInstance().platformRequest("tel:" + number);
        }
        catch (Exception e) {
            Logger.warn("can not call: " + number, e);
        }
    }

    public static boolean openURL(String url) {
        try {
            Application application = Application.getInstance();
            if (application != null) {
                application.platformRequest(url);
                return true;
            }
        }
        catch (Exception e) {
            Logger.warn("can not open url: " + url, e);
        }
        return false;
    }

    public static void vibration(int duration) {
        try {
            Display.getDisplay((MIDlet)Application.getInstance()).vibrate(duration);
        }
        catch (Exception e) {
            Logger.warn("can not vibration", e);
        }
    }

    public static int getPlatform() {
        return platform;
    }

    private static int detectPlatform() {
        if (Application.hasClass("net.rim.device.api.ui.UiApplication")) {
            return 11;
        }
        if (Application.hasClass("org.me4se.MIDletRunner")) {
            return 8;
        }
        if (Application.hasClass("apple.uikit.UIView")) {
            return 12;
        }
        if (Application.hasClass("android.app.Activity")) {
            return 10;
        }
        String currentPlatform = System.getProperty("microedition.platform");
        if (currentPlatform == null) {
            currentPlatform = "";
        }
        if (currentPlatform.indexOf("Nokia") >= 0) {
            if (Application.hasClass("com.nokia.mid.impl.isa.ui.gdi.Pixmap")) {
                return 1;
            }
            return 2;
        }
        if (currentPlatform.indexOf("SonyEricsson") >= 0 || System.getProperty("com.sonyericsson.java.platform") != null) {
            return 3;
        }
        if (Application.hasClass("com.samsung.util.Vibration")) {
            return 4;
        }
        if (Application.hasClass("com.motorola.multimedia.Vibrator") || Application.hasClass("com.motorola.graphics.j3d.Effect3D") || Application.hasClass("com.motorola.multimedia.Lighting") || Application.hasClass("com.motorola.multimedia.FunLight") || Application.hasClass("com.motorola.phonebook.PhoneBookRecord")) {
            return 5;
        }
        if (Application.hasClass("com.siemens.mp.io.File")) {
            return 6;
        }
        if (Application.hasClass("mmpp.media.MediaPlayer") || Application.hasClass("mmpp.phone.Phone") || Application.hasClass("mmpp.lang.MathFP") || Application.hasClass("mmpp.media.BackLight")) {
            return 7;
        }
        if (currentPlatform.indexOf("wtk") >= 0) {
            return 9;
        }
        return 0;
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Image createImage(String name) {
        try {
            InputStream is = Application.getInstance().getResourceAsStreamImpl(name);
            if (is != null) {
                return Image.createImage((InputStream)is);
            }
        }
        catch (Throwable th) {
            Logger.warn("cant createImage " + name, th);
        }
        try {
            return Image.createImage((String)name);
        }
        catch (Exception ex) {
            Logger.info("unable to createImage " + name, ex);
            return null;
        }
    }

    public static InputStream getResourceAsStream(String name) {
        Application application = Application.getInstance();
        if (application == null) {
            Logger.warn("application is null inside getResourceAsStream!!! this should never happen");
        } else {
            InputStream is = application.getResourceAsStreamImpl(name);
            if (is != null) {
                return is;
            }
        }
        return Application.class.getResourceAsStream(name);
    }

    protected InputStream getResourceAsStreamImpl(String name) {
        InputStream is;
        if (resdir != null && (is = Application.class.getResourceAsStream(resdir + name)) != null) {
            return is;
        }
        return null;
    }

    public void platformRequestForResult(String url, Object arg, int requestCode) {
        Url u = new Url(url);
        u.addQueryParameter("requestCode", String.valueOf(requestCode));
        this.platformRequest(u.toString(), arg);
    }

    public void platformRequest(String url, Object arg) {
        try {
            if (this.platformReqParams == null) {
                this.platformReqParams = new Hashtable();
            }
            if (arg != null) {
                this.platformReqParams.put(url, arg);
            }
            this.platformRequest(url);
        }
        catch (Exception e) {
            Logger.warn("cant make request " + url + " " + arg, e);
            throw new RuntimeException(e.toString());
        }
    }

    public Object retrievePlatformRequestParam(String url) {
        Object res = this.platformReqParams.remove(url);
        return res;
    }

    public void onResult(int requestCode, int resultCode, Object obj) {
    }

    static {
        if (Application.getPlatform() != 8) {
            Logger.setLogger(new DesktopLogger(2));
        }
        try {
            String rd = System.getProperty("resdir");
            if (rd != null) {
                resdir = rd;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

