/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.logging.Logger;

public class Button
extends Label
implements ActionListener {
    private Button selectButton;
    private ActionListener al;
    private String actionCommand;
    private boolean selected;
    protected ButtonGroup buttonGroup;
    private boolean useSelectButton;
    private int mneonic;
    protected Icon focusedImage;
    protected Icon disabledImage;
    private boolean oldState;

    public Button() {
        this((String)null);
    }

    public Button(String label) {
        super(label);
        this.setHorizontalAlignment(1);
    }

    public Button(String label, Icon img) {
        this(label);
        this.setIcon(img);
    }

    public String getDefaultName() {
        return "Button";
    }

    protected boolean getDefaultEnabled() {
        return true;
    }

    public boolean isVisible() {
        if (this.mneonic == -6 || this.mneonic == -7 || this.mneonic == -5 || this.mneonic == -12 || this.mneonic == -11) {
            DesktopPane dp = this.getDesktopPane();
            if (dp.SOFT_KEYS) {
                return false;
            }
            if (dp.HIDDEN_MENU && this.mneonic == -12) {
                return false;
            }
            if (dp.HIDDEN_BACK && this.mneonic == -11) {
                return false;
            }
        }
        return super.isVisible();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean old = this.selected;
        this.selected = selected;
        if (this.buttonGroup != null && selected) {
            this.buttonGroup.setSelected(this);
        }
        if (old != selected) {
            this.repaint();
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.al != null) {
            Logger.warn("trying to add a ActionListener when there is already one registered " + this);
            Logger.dumpStack();
        }
        if (l == null) {
            Logger.warn("trying to add a null ActionListener " + this);
            Logger.dumpStack();
        }
        this.al = l;
    }

    public void removeActionListener(ActionListener l) {
        if (this.al == l) {
            this.al = null;
        } else {
            Logger.warn("trying to remove a ActionListener that is not registered " + this);
            Logger.dumpStack();
        }
        if (l == null) {
            Logger.warn("trying to remove a null ActionListener " + this);
            Logger.dumpStack();
        }
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] actionListenerArray;
        if (this.al == null) {
            actionListenerArray = new ActionListener[]{};
        } else {
            ActionListener[] actionListenerArray2 = new ActionListener[1];
            actionListenerArray = actionListenerArray2;
            actionListenerArray2[0] = this.al;
        }
        return actionListenerArray;
    }

    public void setActionCommand(String ac) {
        this.actionCommand = ac;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public boolean processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.justPressedAction(8) || keyEvent.justPressedKey(10)) {
            this.fireActionPerformed();
            return true;
        }
        return false;
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (!this.focusable) {
            return;
        }
        int cw = this.getWidthWithBorder();
        int ch = this.getHeightWithBorder();
        Border insets = this.getInsets();
        int cx = -insets.getLeft();
        int cy = -insets.getTop();
        if (type == 1) {
            this.oldState = this.selected;
            this.selected = true;
            this.repaint();
        } else if (x >= cx && x <= cx + cw && y >= cy && y <= cy + ch) {
            if (type == 6 && !this.selected) {
                this.selected = true;
                this.repaint();
            } else if (type == 3 || this.getPopupIfTriggered(type, keys) != null) {
                this.selected = this.oldState;
                this.repaint();
            } else if (type == 2) {
                this.selected = this.oldState;
                this.fireActionPerformed();
                this.repaint();
            }
        } else if (this.selected) {
            this.selected = this.oldState;
            this.repaint();
        }
    }

    public void fireActionPerformed() {
        if (this.buttonGroup != null) {
            if (!this.selected) {
                this.setSelected(true);
            }
        } else {
            this.toggleSelection();
        }
        if (this.al != null) {
            this.al.actionPerformed(this.actionCommand != null ? this.actionCommand : this.getText());
        }
    }

    protected void toggleSelection() {
        this.setSelected(false);
    }

    public void focusLost() {
        super.focusLost();
        if (this.useSelectButton) {
            this.selectButton.getWindow().removeCommand(this.selectButton);
            this.selectButton = null;
        }
    }

    public void focusGained() {
        super.focusGained();
        if (this.useSelectButton) {
            this.selectButton = new Button((String)DesktopPane.get("selectText"));
            this.selectButton.addActionListener(this);
            this.selectButton.setActionCommand("select");
            this.selectButton.setMnemonic(-6);
            this.getWindow().addCommand(this.selectButton);
        }
    }

    public void setGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
    }

    public ButtonGroup getGroup() {
        return this.buttonGroup;
    }

    public void actionPerformed(String actionCommand) {
        if (this.selectButton.getActionCommand().equals(actionCommand)) {
            this.fireActionPerformed();
        } else {
            Logger.warn("whats going on here??? " + actionCommand);
        }
    }

    public boolean isUseSelectButton() {
        return this.useSelectButton;
    }

    public void setUseSelectButton(boolean useSelectButton) {
        this.useSelectButton = useSelectButton;
    }

    protected int getState() {
        int result = super.getState();
        if (this.selected) {
            result |= 8;
        }
        return result;
    }

    public int getMnemonic() {
        return this.mneonic;
    }

    public void setMnemonic(int m) {
        this.mneonic = m;
    }

    public int getXOnScreen() {
        if (!this.isVisible()) {
            return this.posX;
        }
        return super.getXOnScreen();
    }

    public int getYOnScreen() {
        if (!this.isVisible()) {
            return this.posY;
        }
        return super.getYOnScreen();
    }

    public void setValue(Object obj) {
        if (obj instanceof Boolean) {
            this.setSelected(Boolean.TRUE.equals(obj));
        } else {
            super.setValue(obj);
        }
    }

    public Object getValue() {
        return this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void updateUI() {
        super.updateUI();
        if (this.selectButton != null) {
            this.selectButton.updateUI();
        }
    }

    public Icon getRolloverIcon() {
        if (this.focusedImage != null) {
            return this.focusedImage;
        }
        return (Icon)this.theme.getProperty("icon", 4);
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        this.focusedImage = rolloverIcon;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.disabledImage = disabledIcon;
    }

    public Icon getDisabledIcon() {
        if (this.disabledImage != null) {
            return this.disabledImage;
        }
        return (Icon)this.theme.getProperty("icon", 2);
    }

    protected void paintIcon(Graphics2D g, int x, int y) {
        int cState = this.getCurrentState();
        Icon icon = this.getIcon();
        Icon focusedImage = this.getRolloverIcon();
        Icon disabledImage = this.getDisabledIcon();
        if ((cState & 4) != 0 && focusedImage != null) {
            focusedImage.paintIcon(this, g, x + (icon.getIconWidth() - focusedImage.getIconWidth()) / 2, y + (icon.getIconHeight() - focusedImage.getIconHeight()) / 2);
        } else if ((cState & 2) != 0 && disabledImage != null) {
            disabledImage.paintIcon(this, g, x, y);
        } else {
            super.paintIcon(g, x, y);
        }
    }
}

