/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.util.Option;

public class ComboBox
extends Button
implements ActionListener {
    private Icon selectedImage;
    private Icon nonSelectedImage;
    private List list;
    private ScrollPane scroll;
    private Window dropDown;
    int oldIndex = -1;

    public ComboBox() {
        this.setHorizontalAlignment(4);
    }

    public ComboBox(Vector vec) {
        this();
        this.setItems(vec);
    }

    public String getDefaultName() {
        return "ComboBox";
    }

    public void setLoop(boolean b) {
        this.createList();
        this.list.setLoop(b);
    }

    protected void workoutMinimumSize() {
        if (this.list != null && this.list.getSize() > 0) {
            int count = 0;
            int hi = 0;
            int s = this.list.getSize();
            for (int i = 0; i < s; ++i) {
                Object obj = this.list.getElementAt(i);
                Icon img = obj instanceof Option ? ((Option)obj).getIcon() : null;
                String objString = String.valueOf(obj);
                int lenW = this.getCombinedWidth(this.getTextWidth(objString), this.getIconWidth(img));
                int lenH = this.getCombinedHeight(this.getTextHeight(objString), this.getIconHeight(img));
                if (count < lenW) {
                    count = lenW;
                }
                if (hi >= lenH) continue;
                hi = lenH;
            }
            this.width = count + this.padding * 2 + (this.nonSelectedImage == null ? 0 : this.nonSelectedImage.getIconWidth());
            this.height = hi + this.padding * 2;
        } else {
            this.height = this.getFont().getHeight() + this.padding * 2;
            this.width = 10;
        }
    }

    public void fireActionPerformed() {
        this.createList();
        this.createScrollPane();
        if (this.dropDown == null) {
            this.dropDown = new Window();
            this.dropDown.setCloseOnFocusLost(true);
            this.dropDown.setName("Popup");
            this.dropDown.addWindowListener(this);
            Button cancel = new Button((String)DesktopPane.get("cancelText"));
            cancel.setActionCommand("close");
            cancel.addActionListener(this);
            cancel.setMnemonic(-11);
            this.dropDown.addCommand(cancel);
        }
        this.dropDown.removeAll();
        this.dropDown.add(this.scroll);
        this.scroll.removeAll();
        this.scroll.add(this.list);
        this.oldIndex = this.list.getSelectedIndex();
        this.setSelected(true);
        this.dropDown.setDesktopPane(this.getDesktopPane());
        Menu.setupSize(this.dropDown);
        if (this.dropDown.getWidthWithBorder() < this.getWidthWithBorder()) {
            this.dropDown.setBounds(0, 0, this.getWidthWithBorder(), this.dropDown.getHeightWithBorder());
        }
        Menu.positionMenuRelativeTo(this.dropDown, this.getXOnScreen() - this.getInsets().getLeft(), this.getYOnScreen(), this.getWidthWithBorder(), this.getHeight(), 16);
        this.dropDown.setVisible(true);
    }

    private void createList() {
        if (this.list == null) {
            DefaultListCellRenderer render = new DefaultListCellRenderer();
            render.setName("PopupListRenderer");
            List l = new List(render);
            l.setPrototypeCellValue("hello");
            l.setUseSelectButton(true);
            this.setModel(l);
        }
    }

    private void createScrollPane() {
        if (this.scroll == null) {
            this.scroll = new ScrollPane();
        }
    }

    public void setModel(List list) {
        this.list = list;
        list.addActionListener(this);
        list.setActionCommand("listSelect");
    }

    public List getList() {
        return this.list;
    }

    public void paintComponent(Graphics2D g) {
        int right = this.getInsets().getRight();
        if (this.selectedImage != null && this.isSelected()) {
            this.selectedImage.paintIcon(this, g, this.width + right - this.selectedImage.getIconWidth(), (this.height - this.selectedImage.getIconHeight()) / 2);
        } else if (this.nonSelectedImage != null) {
            this.nonSelectedImage.paintIcon(this, g, this.width + right - this.nonSelectedImage.getIconWidth(), (this.height - this.nonSelectedImage.getIconHeight()) / 2);
        }
        super.paintComponent(g);
    }

    public void updateUI() {
        super.updateUI();
        this.nonSelectedImage = (Icon)this.theme.getProperty("arrow", 0);
        this.selectedImage = (Icon)this.theme.getProperty("arrow", 8);
        if (this.dropDown != null) {
            this.dropDown.updateUI();
        }
        if (this.scroll != null) {
            this.scroll.updateUI();
        }
        if (this.list != null) {
            this.list.updateUI();
        }
    }

    public Icon getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(Icon selectedImage) {
        this.selectedImage = selectedImage;
    }

    public Icon getNonSelectedImage() {
        return this.nonSelectedImage;
    }

    public void setNonSelectedImage(Icon nonSelectedImage) {
        this.nonSelectedImage = nonSelectedImage;
    }

    public Vector getItems() {
        this.createList();
        return this.list.getItems();
    }

    public int getItemCount() {
        this.createList();
        return this.list.getSize();
    }

    public void setItems(Vector items) {
        this.createList();
        this.list.setListData(items);
        if (this.list.getSize() > 0) {
            this.setSelectedIndex(0);
        } else {
            super.setText("");
            super.setIcon(null);
        }
    }

    public void actionPerformed(String actionCommand) {
        if ("listSelect".equals(actionCommand)) {
            int index = this.list.getSelectedIndex();
            if (index >= 0) {
                this.dropDown.setVisible(false);
                this.setSelectedIndex(index);
                super.fireActionPerformed();
            } else {
                this.list.setSelectedIndex(this.oldIndex);
            }
        } else if ("close".equals(actionCommand)) {
            this.dropDown.setVisible(false);
            this.setSelected(false);
        } else {
            throw new RuntimeException();
        }
    }

    public void setSelectedItem(Object selected) {
        this.createList();
        this.setSelectedIndex(this.list.indexOf(selected));
    }

    public void setSelectedIndex(int i) {
        this.createList();
        this.list.setSelectedIndex(i);
        ListCellRenderer r = this.list.getCellRenderer();
        Component c = r.getListCellRendererComponent(this.list, this.list.getElementAt(i), i, true, false);
        if (c instanceof Label) {
            Label l = (Label)c;
            super.setText(l.getText());
            super.setIcon(l.getIcon());
        } else {
            super.setValue(this.list.getElementAt(i));
        }
        String t = this.getText();
        if (t == null || "".equals(t)) {
            super.setText(" ");
        }
    }

    public int getSelectedIndex() {
        this.createList();
        if (this.list.isShowing()) {
            return this.oldIndex;
        }
        return this.list.getSelectedIndex();
    }

    public Object getSelectedItem() {
        int index = this.getSelectedIndex();
        return index == -1 ? null : this.list.getElementAt(index);
    }

    public void setScrollMode(int m) {
        this.createScrollPane();
        this.scroll.setMode(m);
    }

    public void setValue(Object obj) {
        this.setSelectedItem(obj);
    }

    public Object getValue() {
        return this.getSelectedItem();
    }

    public void addItem(Object obj) {
        this.createList();
        this.list.addElement(obj);
    }
}

