/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.FrameTitlePane;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.logging.Logger;

public class Frame
extends Window {
    public static final String CMD_MAX = "max";
    public static final String CMD_MIN = "min";
    public static final String CMD_CLOSE = "close";
    protected boolean isMaximum;

    public Frame() {
        this.setUndecorated(false);
        if (this.getDesktopPane().MAX_CLOSE_BUTTONS) {
            this.setMaximizable(true);
            this.setClosable(true);
        }
        this.setContentPane(new Panel(new BorderLayout()));
        this.setLayout(null);
    }

    public Frame(String name) {
        this();
        this.setTitle(name);
    }

    public void setClosable(boolean b) {
        FrameTitlePane title = this.getTitlePane();
        if (title != null) {
            title.setButtonVisable(CMD_CLOSE, b);
        }
    }

    public void setMaximizable(boolean b) {
        FrameTitlePane title = this.getTitlePane();
        if (title != null) {
            title.setButtonVisable(CMD_MAX, b);
        }
    }

    protected String getDefaultName() {
        return "Frame";
    }

    public void setUndecorated(boolean un) {
        FrameTitlePane tb = this.getTitlePane();
        if (tb == null && !un) {
            super.add(new FrameTitlePane());
        } else if (tb != null && un) {
            super.remove(tb);
        }
    }

    public void setTitle(String newTitle) {
        FrameTitlePane tb = this.getTitlePane();
        if (tb != null) {
            tb.setTitle(newTitle);
        }
    }

    public String getTitle() {
        FrameTitlePane tb = this.getTitlePane();
        if (tb != null) {
            return tb.getTitle();
        }
        return null;
    }

    public void setIconImage(Icon icon) {
        FrameTitlePane tb = this.getTitlePane();
        if (tb != null) {
            tb.setIconImage(icon);
        }
    }

    public void setMenuBar(MenuBar menuBar) {
        MenuBar mbar = this.getMenuBar();
        if (mbar != menuBar) {
            if (mbar != null) {
                super.remove(mbar);
            }
            if (menuBar != null) {
                super.add(menuBar);
                menuBar.autoMnemonic();
            }
        }
    }

    public void setContentPane(Panel p) {
        Panel oldCP = this.getContentPane();
        if (oldCP != p) {
            if (oldCP != null) {
                super.remove(oldCP);
            }
            super.insert(p, 0);
        }
    }

    public MenuBar getMenuBar() {
        Vector components = this.getComponents();
        for (int c = 0; c < components.size(); ++c) {
            Object obj = components.elementAt(c);
            if (!(obj instanceof MenuBar)) continue;
            return (MenuBar)obj;
        }
        return null;
    }

    public FrameTitlePane getTitlePane() {
        Vector components = this.getComponents();
        for (int c = 0; c < components.size(); ++c) {
            Object obj = components.elementAt(c);
            if (!(obj instanceof FrameTitlePane)) continue;
            return (FrameTitlePane)obj;
        }
        return null;
    }

    public Panel getContentPane() {
        Vector components = this.getComponents();
        for (int c = 0; c < components.size(); ++c) {
            Object obj = components.elementAt(c);
            if (obj instanceof MenuBar || obj instanceof FrameTitlePane) continue;
            return (Panel)obj;
        }
        return null;
    }

    protected void workoutMinimumSize() {
        Panel contentPane;
        MenuBar menubar;
        int w = 0;
        int h = 0;
        FrameTitlePane titleBar = this.getTitlePane();
        if (titleBar != null && titleBar.isVisible()) {
            titleBar.workoutPreferredSize();
            int tw = titleBar.getWidthWithBorder();
            int th = titleBar.getHeightWithBorder();
            if (tw > w) {
                w = tw;
            }
            h += th;
        }
        if ((menubar = this.getMenuBar()) != null && menubar.isVisible()) {
            menubar.workoutPreferredSize();
            if (this.isMaximum) {
                int mw = menubar.getWidthWithBorder();
                int mh = menubar.getHeightWithBorder();
                if (mw > w) {
                    w = mw;
                }
                h += mh;
            }
        }
        if ((contentPane = this.getContentPane()) != null && contentPane.isVisible()) {
            contentPane.workoutPreferredSize();
            int cw = contentPane.getWidthWithBorder();
            int ch = contentPane.getHeightWithBorder();
            if (cw > w) {
                w = cw;
            }
            h += ch;
        }
        this.width = w;
        this.height = h;
    }

    public void doLayout() {
        Panel contentPane;
        FrameTitlePane titleBar = this.getTitlePane();
        int th = 0;
        if (titleBar != null && titleBar.isVisible()) {
            th = titleBar.getHeightWithBorder();
            titleBar.setBounds(0, 0, this.width, th);
        }
        boolean bottom = this.isMaximum && this.getDesktopPane().SOFT_KEYS;
        MenuBar menubar = this.getMenuBar();
        int mh = 0;
        if (bottom) {
            mh = this.getDesktopPane().getMenuHeight();
        } else if (menubar != null && menubar.isVisible()) {
            mh = menubar.getHeightWithBorder();
        }
        if (menubar != null && menubar.isVisible()) {
            menubar.setBounds(0, bottom ? this.height - mh : th, this.width, mh);
        }
        if ((contentPane = this.getContentPane()) != null && contentPane.isVisible()) {
            contentPane.setBounds(0, th + (bottom ? 0 : mh), this.width, this.height - th - mh);
        }
    }

    public Component getNextComponent(Component component, int direction) {
        return component == null ? this.getContentPane() : null;
    }

    public void add(Component comp) {
        this.getContentPane().add(comp);
        Logger.info("try and avoid using add() on a Frame, use getContentPane().add() instead");
    }

    public void add(Component comp, Object consta) {
        this.getContentPane().add(comp, consta);
        Logger.info("try and avoid using add() on a Frame, use getContentPane().add() instead");
    }

    public void add(Component comp, int consta) {
        this.getContentPane().add(comp, consta);
        Logger.info("try and avoid using add() on a Frame, use getContentPane().add() instead");
    }

    public void setMaximum(boolean a) {
        this.isMaximum = a;
        if (a) {
            this.setLocation(0, 0);
            DesktopPane desktop = this.getDesktopPane();
            this.width = desktop.getWidth();
            this.height = desktop.getHeight();
        }
        this.revalidate();
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }
}

