/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.lang.ref.WeakReference;
import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.components.TextPane;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.BoxLayout;
import net.yura.mobile.gui.layout.FlowLayout;
import net.yura.mobile.gui.layout.GridBagConstraints;
import net.yura.mobile.gui.layout.GridBagLayout;
import net.yura.mobile.logging.Logger;

public class OptionPane
extends Frame
implements Runnable,
ActionListener {
    private static Vector allWindows = new Vector();
    public static final int YES_NO_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private Button defaultCommand;
    private Label icon;
    private ScrollPane scroll;
    private Panel cmdPanel;
    private Panel content;
    private int messageType;
    private Object message;
    private ActionListener actionListener;
    private boolean factory;
    public static Class optionPaneClass = OptionPane.class;

    public static Vector getAllWindows() {
        return allWindows;
    }

    public OptionPane() {
        for (int c = 0; c < allWindows.size(); ++c) {
            if (((WeakReference)allWindows.elementAt(c)).get() != null) continue;
            allWindows.removeElementAt(c);
            --c;
        }
        allWindows.addElement(new WeakReference<OptionPane>(this));
        this.setName("Dialog");
        this.getTitlePane().setName("InternalFrameTitlePane");
        this.setMaximizable(false);
        this.content = new Panel(new GridBagLayout(1, 3, 4, 4, 4, 4));
        Panel panel = this.getContentPane();
        this.icon = new Label();
        this.icon.setHorizontalAlignment(1);
        Panel c = new Panel(new BoxLayout(2));
        if (this.getDesktopPane().VERY_BIG_SCREEN) {
            panel.add((Component)this.icon, 4);
        } else {
            c.add(this.icon);
        }
        c.add(this.content);
        this.scroll = new ScrollPane(c);
        panel.add(this.scroll);
        this.cmdPanel = new Panel();
        panel.add((Component)this.cmdPanel, 32);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void actionPerformed(String actionCommand) {
        this.setVisible(false);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionCommand);
        }
    }

    public boolean processKeyEvent(KeyEvent keypad) {
        if (keypad.justPressedAction(8) || keypad.justPressedKey(-10)) {
            if (this.defaultCommand != null) {
                this.actionPerformed(this.defaultCommand.getActionCommand());
            }
            return true;
        }
        return false;
    }

    public void setMessage(Object newMessage) {
        this.message = newMessage;
        this.content.removeAll();
        this.scroll.getView().setLocation(0, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1;
        if (newMessage instanceof Object[]) {
            Object[] objects = (Object[])newMessage;
            for (int c = 0; c < objects.length; ++c) {
                this.content.add(this.getComponentFromObject(objects[c]), constraints);
            }
        } else if (newMessage instanceof Vector) {
            Vector objects = (Vector)newMessage;
            for (int c = 0; c < objects.size(); ++c) {
                this.content.add(this.getComponentFromObject(objects.elementAt(c)), constraints);
            }
        } else {
            this.content.add(this.getComponentFromObject(newMessage), constraints);
        }
    }

    public Object getMessage() {
        return this.message;
    }

    private Component getComponentFromObject(Object object) {
        String txt;
        int dpw;
        DesktopPane dp = this.getDesktopPane();
        int n = dpw = dp.getWidth() > 0 ? dp.getWidth() : 1024;
        if (object instanceof Component) {
            Component component = (Component)object;
            if (component instanceof TextField && component.getPreferredWidth() == -1) {
                component.setPreferredSize(dpw / 2, component.getPreferredHeight());
            }
            return component;
        }
        if (object instanceof Icon) {
            return new Label((Icon)object);
        }
        Border dialogInsets = this.getInsets();
        int space = dpw - 12 - this.scroll.getBarThickness() - dialogInsets.getLeft() - dialogInsets.getRight();
        if (dp.VERY_BIG_SCREEN) {
            this.icon.workoutPreferredSize();
            space -= this.icon.getWidthWithBorder();
        }
        if ((txt = String.valueOf(object)).startsWith("<html>") || txt.indexOf(10) >= 0) {
            TextPane tp = new TextPane();
            tp.setActionListener(this.actionListener);
            tp.setText(txt);
            Border tpInsets = tp.getInsets();
            tp.setPreferredSize(space - tpInsets.getLeft() - tpInsets.getRight(), -1);
            return tp;
        }
        Label tmp = new Label();
        tmp.setValue(object);
        tmp.workoutPreferredSize();
        if (tmp.getWidthWithBorder() < space) {
            return tmp;
        }
        TextArea tmp2 = new TextArea();
        tmp2.setLineWrap(true);
        tmp2.setFocusable(false);
        tmp2.setName(tmp.getName());
        tmp2.setText(txt);
        Border taInsets = tmp2.getInsets();
        tmp2.setPreferredSize(space - taInsets.getLeft() - taInsets.getRight(), -1);
        return tmp2;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
        Icon icn = null;
        switch (messageType) {
            case 2: {
                icn = (Icon)this.theme.getProperty("WARNING_MESSAGE", 0);
                break;
            }
            case 0: {
                icn = (Icon)this.theme.getProperty("ERROR_MESSAGE", 0);
                break;
            }
            case 1: {
                icn = (Icon)this.theme.getProperty("INFORMATION_MESSAGE", 0);
                break;
            }
            case 3: {
                icn = (Icon)this.theme.getProperty("QUESTION_MESSAGE", 0);
            }
        }
        this.setIcon(icn);
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setInitialValue(Button initialValue) {
        this.defaultCommand = initialValue;
    }

    public Button getInitialValue() {
        return this.defaultCommand;
    }

    public void setOptions(Button[] options) {
        this.cmdPanel.removeAll();
        this.cmdPanel.setLayout(new FlowLayout());
        for (int c = 0; c < options.length; ++c) {
            Button button = options[c];
            ActionListener[] actionListeners = button.getActionListeners();
            for (int i = 0; i < actionListeners.length; ++i) {
                button.removeActionListener(actionListeners[i]);
            }
            button.addActionListener(this);
            this.cmdPanel.add(button);
        }
        if (options.length <= 2) {
            OptionPane.autoMnemonic(this.cmdPanel.getComponents());
        }
        this.cmdPanel.workoutMinimumSize();
        int dpw = this.getDesktopPane().getWidth();
        if (dpw > 0 && this.cmdPanel.getWidth() > dpw) {
            this.cmdPanel.setLayout(new BoxLayout(2));
        }
    }

    public Button[] getOptions() {
        Vector v = this.cmdPanel.getComponents();
        Object[] buttons = new Button[v.size()];
        v.copyInto(buttons);
        return buttons;
    }

    public static void autoMnemonic(Vector items) {
        block4: for (int c = 0; c < items.size(); ++c) {
            Component button = (Component)items.elementAt(c);
            if (!(button instanceof Button) || ((Button)button).getMnemonic() != 0) continue;
            switch (c) {
                case 0: {
                    Logger.debug("Button 1 should already have Mnemonic " + button);
                    ((Button)button).setMnemonic(-6);
                    continue block4;
                }
                case 1: {
                    Logger.debug("Button 2 should already have Mnemonic " + button);
                    ((Button)button).setMnemonic(-7);
                }
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon.setIcon(icon);
    }

    public void run() {
        try {
            this.pack();
            DesktopPane dp = this.getDesktopPane();
            int maxw = dp.getWidth();
            int maxh = dp.getHeight() - dp.getMenuHeight() * 2;
            if (maxh > 0 && this.getHeightWithBorder() > maxh) {
                this.setFocusedComponent(null);
                this.setBounds(0, 0, this.getWidthWithBorder() + this.scroll.getBarThickness(), maxh);
            }
            if (maxw > 0 && this.getWidthWithBorder() > maxw) {
                this.setFocusedComponent(null);
                this.setBounds(0, 0, maxw, this.getHeightWithBorder() + (this.getHeightWithBorder() == maxh ? 0 : this.scroll.getBarThickness()));
            }
            this.getMostRecentFocusOwner();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            if (this.isVisible()) {
                this.factory = true;
            }
        }
        catch (Throwable t) {
            Logger.error(null, t);
        }
    }

    private static Button makeButton(String label, String actionCommand, int m) {
        Button button = new Button((String)DesktopPane.get(label));
        button.setActionCommand(actionCommand);
        button.setMnemonic(m);
        return button;
    }

    public static OptionPane showOptionDialog(ActionListener parent, Object message, String title, int optionType, int messageType, Icon icon, Button[] options, Button initialValue) {
        Vector myselfs = OptionPane.getAllWindows();
        Frame myself = null;
        for (int c = 0; c < myselfs.size(); ++c) {
            Window op = (Window)((WeakReference)myselfs.elementAt(c)).get();
            if (!(op instanceof OptionPane) || !((OptionPane)op).factory || op.isVisible()) continue;
            myself = (OptionPane)op;
            ((OptionPane)myself).factory = false;
            break;
        }
        if (myself == null) {
            try {
                myself = (OptionPane)optionPaneClass.newInstance();
            }
            catch (Throwable th) {
                myself = new OptionPane();
            }
        }
        myself.setTitle(title);
        ((OptionPane)myself).setActionListener(parent);
        ((OptionPane)myself).setMessageType(messageType);
        if (icon != null) {
            ((OptionPane)myself).setIcon(icon);
        }
        ((OptionPane)myself).setMessage(message);
        if (options == null) {
            switch (optionType) {
                case 0: {
                    options = new Button[]{OptionPane.makeButton("yesText", "yes", -6), OptionPane.makeButton("noText", "no", -7)};
                    break;
                }
                case 2: {
                    options = new Button[]{OptionPane.makeButton("okText", "ok", -6), OptionPane.makeButton("cancelText", "cancel", -7)};
                    break;
                }
                default: {
                    options = new Button[]{OptionPane.makeButton("okText", "ok", -7)};
                }
            }
            initialValue = options[0];
        }
        ((OptionPane)myself).setOptions(options);
        ((OptionPane)myself).setInitialValue(initialValue);
        DesktopPane.invokeLater((Runnable)((Object)myself));
        return myself;
    }

    public static OptionPane showMessageDialog(ActionListener parent, Object message, String title, int messageType) {
        return OptionPane.showOptionDialog(parent, message, title, 1, messageType, null, null, null);
    }

    public static OptionPane showConfirmDialog(ActionListener parent, Object message, String title, int optionType) {
        return OptionPane.showOptionDialog(parent, message, title, optionType, 3, null, null, null);
    }
}

