/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.io.ClipboardManager;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

public abstract class TextComponent
extends Component
implements ActionListener,
CommandListener {
    public static final int ANY = 0;
    public static final int CONSTRAINT_MASK = 65535;
    public static final int DECIMAL = 5;
    public static final int EMAILADDR = 1;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int NON_PREDICTIVE = 524288;
    public static final int NUMERIC = 2;
    public static final int PASSWORD = 65536;
    public static final int PHONENUMBER = 3;
    public static final int SENSITIVE = 262144;
    public static final int UNEDITABLE = 131072;
    public static final int URL = 4;
    public static char STAR = (char)42;
    private static TextBox textbox;
    private Button SOFTKEY_CLEAR;
    private boolean showingClearKey;
    private static final int cursorBlinkWait = 500;
    private static final int changeModeChar;
    private static int autoAcceptTimeout;
    protected int padding = 2;
    public static final int MODE_abc = 0;
    public static final int MODE_Abc = 1;
    public static final int MODE_ABC = 2;
    public static final int MODE_123 = 3;
    protected String label = "";
    private int constraints;
    private int mode;
    protected StringBuffer text;
    protected Font font;
    private int maxSize;
    protected int caretPosition;
    protected boolean showCaret;
    protected char tmpChar;
    private long lastKeyEvent;
    private ChangeListener caretListener;
    public String initialInputMode;
    public static ChangeListener staticFocusListener;

    public TextComponent(String initialText, int max, int constraints) {
        this.maxSize = max;
        this.setConstraints(constraints);
        this.setText(initialText);
    }

    protected boolean getDefaultEnabled() {
        return true;
    }

    public int getMargin() {
        return this.padding;
    }

    public void setMargin(int m) {
        this.padding = m;
    }

    public boolean allowChar(char ch) {
        if (Application.getPlatform() == 11 && ch == '\u0080') {
            this.openNativeEditor();
            return false;
        }
        return true;
    }

    private void insertNewCharacter(char ch) {
        this.text.insert(this.caretPosition, ch);
        if (this.mode == 1 && !this.initialCapsConstraint()) {
            this.setMode(0);
        }
    }

    protected void changedUpdate(int offset, int length) {
    }

    protected void autoAccept() {
        if (this.tmpChar != '\u0000') {
            char tmp = this.tmpChar;
            this.tmpChar = '\u0000';
            this.insertNewCharacter(tmp);
            this.setCaretPosition(this.caretPosition + 1);
        }
    }

    private void updateSoftKeys() {
        if (this.isFocusOwner() && this.getDesktopPane().USE_SOFT_KEY_CLEAR) {
            if (this.caretPosition == 0 && this.tmpChar == '\u0000') {
                if (this.showingClearKey) {
                    this.getWindow().removeCommand(this.SOFTKEY_CLEAR);
                    this.showingClearKey = false;
                }
            } else if (!this.showingClearKey) {
                this.getWindow().addCommand(this.SOFTKEY_CLEAR);
                this.showingClearKey = true;
            }
        }
    }

    public void actionPerformed(String actionCommand) {
        if ("cut".equals(actionCommand)) {
            this.actionPerformed("copy");
            this.actionPerformed("delete");
        } else if ("copy".equals(actionCommand)) {
            ClipboardManager.getInstance().setText(this.getText());
        } else if ("paste".equals(actionCommand)) {
            this.paste();
        } else if ("delete".equals(actionCommand)) {
            this.setText("");
        } else if (this.SOFTKEY_CLEAR.getActionCommand().equals(actionCommand)) {
            this.clear(true);
        } else {
            Logger.warn("something not right here?!?!?! " + actionCommand);
        }
    }

    public void paste() {
        String txt = ClipboardManager.getInstance().getText();
        if (txt != null) {
            this.autoAccept();
            this.text.insert(this.caretPosition, txt);
            this.changedUpdate(this.caretPosition, txt.length());
            this.setCaretPosition(this.caretPosition + txt.length());
        }
    }

    private void clear(boolean back) {
        if (this.tmpChar != '\u0000') {
            this.tmpChar = '\u0000';
            this.changedUpdate(this.caretPosition, 1);
            this.updateSoftKeys();
            this.repaint();
        } else if (back && this.caretPosition > 0) {
            if (this.caretPosition > 1 && StringUtil.isHighSurrogate(this.text.charAt(this.caretPosition - 2))) {
                this.text.delete(this.caretPosition - 2, this.caretPosition);
                this.changedUpdate(this.caretPosition - 2, 2);
                this.setCaretPosition(this.caretPosition - 2);
            } else {
                this.text.deleteCharAt(this.caretPosition - 1);
                this.changedUpdate(this.caretPosition - 1, 1);
                this.setCaretPosition(this.caretPosition - 1);
            }
        } else if (!back && this.caretPosition < this.text.length()) {
            if (StringUtil.isHighSurrogate(this.text.charAt(this.caretPosition))) {
                this.text.delete(this.caretPosition, this.caretPosition + 2);
                this.changedUpdate(this.caretPosition, 2);
            } else {
                this.text.deleteCharAt(this.caretPosition);
                this.changedUpdate(this.caretPosition, 1);
            }
            this.repaint();
        }
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        boolean focusOwner = this.isFocusOwner();
        super.processMouseEvent(type, x, y, keys);
        if (focusOwner && type == 1) {
            this.openNativeEditor();
        }
    }

    public boolean processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getJustReleasedKey() != 0) {
            return false;
        }
        int keyCode = keyEvent.getIsDownKey();
        int justPressed = keyEvent.getJustPressedKey();
        if (justPressed != 0) {
            keyCode = justPressed;
        }
        this.lastKeyEvent = System.currentTimeMillis();
        if (keyCode >= 9 && keyCode < 65535 && !keyEvent.isDownKey(-50) && (keyCode != changeModeChar || this.getDesktopPane().QWERTY_KAYPAD || this.allowOnlyNumberConstraint())) {
            if (!this.allowChar((char)keyCode)) {
                return false;
            }
            String chars = this.mode == 3 && !this.allowOnlyNumberConstraint() ? String.valueOf((char)keyCode) : KeyEvent.getChars((char)keyCode, this.constraints);
            keyCode = keyEvent.getKeyChar(keyCode, chars, this.tmpChar == '\u0000');
            if ((this.constraints & 0xFFFF) == 5) {
                if (keyCode == 46 && this.text.toString().indexOf(46) != -1) {
                    keyCode = 0;
                } else if (keyCode == 45 && (this.caretPosition != 0 || this.text.length() == 0 || this.text.charAt(0) == '-')) {
                    keyCode = 0;
                }
            }
            if (this.text.length() < this.maxSize && keyCode != 0) {
                char thechar = (char)keyCode;
                if (keyEvent.acceptOld()) {
                    this.autoAccept();
                } else {
                    this.tmpChar = '\u0000';
                }
                if (this.mode == 2 || this.mode == 1 && this.shouldUseUppercase()) {
                    thechar = Character.toUpperCase(thechar);
                }
                if (keyEvent.acceptNew()) {
                    this.insertNewCharacter(thechar);
                    if (StringUtil.isHighSurrogate(thechar)) {
                        ++this.caretPosition;
                    } else {
                        this.changedUpdate(this.caretPosition, 1);
                        this.setCaretPosition(this.caretPosition + 1);
                    }
                } else {
                    this.tmpChar = thechar;
                    this.changedUpdate(this.caretPosition, 1);
                    this.updateSoftKeys();
                    this.repaint();
                }
            }
            return true;
        }
        if (keyCode == changeModeChar) {
            this.autoAccept();
            if (this.mode != 3) {
                this.setMode(this.mode + 1);
            } else {
                this.setMode(0);
            }
            return true;
        }
        if (keyCode == -8) {
            this.clear(true);
            return true;
        }
        if (keyCode == -9) {
            this.clear(false);
            return true;
        }
        if (keyEvent.isDownKey(-50)) {
            if (keyEvent.isDownKey(22) || keyEvent.isDownKey(118)) {
                this.paste();
            }
        } else {
            if (keyEvent.isDownAction(2)) {
                if (this.caretPosition > 0) {
                    this.autoAccept();
                    int codepointSize = this.caretPosition > 1 && StringUtil.isHighSurrogate(this.text.charAt(this.caretPosition - 2)) ? 2 : 1;
                    this.setCaretPosition(this.caretPosition - codepointSize);
                    return true;
                }
                return !keyEvent.justPressedAction(2);
            }
            if (keyEvent.isDownAction(5)) {
                if (this.tmpChar != '\u0000') {
                    this.autoAccept();
                    return true;
                }
                if (this.caretPosition < this.text.length() || this.tmpChar != '\u0000') {
                    int codepointSize = StringUtil.isHighSurrogate(this.text.charAt(this.caretPosition)) ? 2 : 1;
                    this.setCaretPosition(this.caretPosition + codepointSize);
                    return true;
                }
                return !keyEvent.justPressedAction(5);
            }
            if (keyEvent.justPressedAction(8)) {
                this.openNativeEditor();
                return true;
            }
        }
        return false;
    }

    public void setInitialInputMode(String characterSubset) {
        this.initialInputMode = characterSubset;
    }

    public void openNativeEditor() {
        String hint = this.label == null || "".equals(this.label) ? this.getName() : this.label;
        String text = this.getText();
        if (textbox == null || !textbox.getString().equals(text) || !textbox.getTitle().equals(hint) || textbox.getMaxSize() != this.maxSize || textbox.getConstraints() != this.constraints) {
            textbox = new TextBox(hint, text, this.maxSize, this.constraints);
            Command ok = new Command((String)DesktopPane.get("okText"), 4, 1);
            Command cancel = new Command((String)DesktopPane.get("cancelText"), 3, 1);
            textbox.addCommand(ok);
            textbox.addCommand(cancel);
            if (this.initialInputMode != null) {
                textbox.setInitialInputMode(this.initialInputMode);
            }
        }
        textbox.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)Application.getInstance()).setCurrent((Displayable)textbox);
    }

    public static void closeNativeEditor() {
        if (textbox != null) {
            DesktopPane rp = DesktopPane.getDesktopPane();
            Display.getDisplay((MIDlet)Application.getInstance()).setCurrent((Displayable)rp);
            rp.setFullScreenMode(true);
            textbox = null;
        }
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0.getCommandType() == 4) {
            this.setText(textbox.getString());
        }
        TextComponent.closeNativeEditor();
    }

    private boolean shouldUseUppercase() {
        if (this.initialCapsConstraint()) {
            for (int c = 0; c < this.caretPosition; ++c) {
                char ch = this.text.charAt(this.caretPosition - c - 1);
                if (ch == ' ') {
                    if ((0x100000 & this.constraints) == 0) continue;
                    return true;
                }
                return ch == '\n' || ch == '.' || ch == '!' || ch == '?';
            }
        }
        return true;
    }

    public void setTitle(String s) {
        this.label = s;
    }

    public String getTitle() {
        return this.label;
    }

    public void addCaretListener(ChangeListener listener) {
        if (this.caretListener != null) {
            Logger.warn("trying to add a ChangeListener when there is already one registered " + this);
            Logger.dumpStack();
        }
        if (listener == null) {
            Logger.warn("trying to add a null ChangeListener " + this);
            Logger.dumpStack();
        }
        this.caretListener = listener;
    }

    public void setCaretPosition(int a) {
        if (a != 0 && StringUtil.isHighSurrogate(this.text.charAt(a - 1))) {
            throw new IllegalArgumentException("can not put caret in the middle of SurrogatePair " + a);
        }
        int old = this.caretPosition;
        this.caretPosition = a;
        if (old != this.caretPosition && this.caretListener != null) {
            this.caretListener.changeEvent(this, this.caretPosition);
        }
        this.repaint();
        this.updateSoftKeys();
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        try {
            int newWait = 500;
            while (this.isFocusOwner()) {
                int oldCaret = this.caretPosition;
                this.wait(newWait);
                long timeNow = System.currentTimeMillis();
                if (this.tmpChar != '\u0000' && timeNow > this.lastKeyEvent + (long)autoAcceptTimeout) {
                    this.autoAccept();
                    newWait = 500;
                } else {
                    newWait = this.tmpChar != '\u0000' ? (int)Math.max(1L, this.lastKeyEvent + (long)autoAcceptTimeout - timeNow) : 500;
                }
                this.showCaret = oldCaret == this.caretPosition ? !this.showCaret : true;
                this.repaint();
            }
        }
        finally {
            this.showCaret = false;
            this.repaint();
        }
    }

    protected String getDisplayString() {
        String s = this.text.toString();
        int caret = this.caretPosition > s.length() ? s.length() : this.caretPosition;
        boolean password = (0x10000 & this.constraints) != 0;
        String st1 = s.substring(0, caret);
        String st2 = s.substring(caret, s.length());
        if (password) {
            int c;
            StringBuffer buffer = new StringBuffer();
            for (c = 0; c < st1.length(); ++c) {
                buffer.append(STAR);
            }
            if (this.tmpChar != '\u0000') {
                buffer.append(this.tmpChar);
            }
            for (c = 0; c < st2.length(); ++c) {
                buffer.append(STAR);
            }
            return buffer.toString();
        }
        return st1 + (this.tmpChar != '\u0000' ? String.valueOf(this.tmpChar) : "") + st2;
    }

    public void focusLost() {
        super.focusLost();
        if (staticFocusListener != null) {
            staticFocusListener.changeEvent(this, 1005);
        }
        this.showCaret = false;
        this.autoAccept();
        DesktopPane dp = this.getDesktopPane();
        if (dp.USE_SOFT_KEY_CLEAR) {
            if (this.showingClearKey) {
                this.SOFTKEY_CLEAR.getWindow().removeCommand(this.SOFTKEY_CLEAR);
                this.showingClearKey = false;
            }
            this.SOFTKEY_CLEAR = null;
        }
        dp.setIndicatorText(null);
        this.repaint();
    }

    public void focusGained() {
        super.focusGained();
        this.showCaret = true;
        Window w = this.getWindow();
        this.setMode(this.mode);
        if (w.getDesktopPane().USE_SOFT_KEY_CLEAR) {
            this.SOFTKEY_CLEAR = new Button((String)DesktopPane.get("clearText"));
            this.SOFTKEY_CLEAR.addActionListener(this);
            this.SOFTKEY_CLEAR.setActionCommand("clear");
            this.SOFTKEY_CLEAR.setMnemonic(-7);
            this.updateSoftKeys();
        }
        if (staticFocusListener != null) {
            staticFocusListener.changeEvent(this, 1004);
        }
        if (!Graphics2D.isTransparent(this.getForeground())) {
            w.getDesktopPane().animateComponent(this);
        }
    }

    public void setMode(int m) {
        String i;
        if (m != 3 && this.allowOnlyNumberConstraint()) {
            return;
        }
        switch (m) {
            case 0: {
                i = "abc";
                break;
            }
            case 1: {
                i = "Abc";
                break;
            }
            case 2: {
                i = "ABC";
                break;
            }
            case 3: {
                i = "123";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mode = m;
        if (this.isFocusOwner()) {
            this.getDesktopPane().setIndicatorText(i);
        }
    }

    private boolean allowOnlyNumberConstraint() {
        return (this.constraints & 0xFFFF) == 3 || (this.constraints & 0xFFFF) == 2 || (this.constraints & 0xFFFF) == 5;
    }

    private boolean initialCapsConstraint() {
        return (0x100000 & this.constraints) != 0 || (0x200000 & this.constraints) != 0;
    }

    public void setConstraints(int m) {
        this.constraints = m;
        this.focusable = (0x20000 & this.constraints) == 0;
        DesktopPane dp = this.getDesktopPane();
        if (dp.QWERTY_KAYPAD) {
            this.setMode(3);
        } else if (this.allowOnlyNumberConstraint()) {
            this.setMode(3);
        } else if (this.initialCapsConstraint()) {
            this.setMode(1);
        } else {
            this.setMode(0);
        }
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setText(String str) {
        String old = this.text == null ? "" : this.getText();
        this.text = new StringBuffer(str);
        this.tmpChar = '\u0000';
        if (!str.equals(old)) {
            this.changedUpdate(0, this.text.length());
        }
        this.setCaretPosition(this.text.length());
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getText() {
        String s = this.text.toString();
        if (this.tmpChar == '\u0000') {
            return s;
        }
        return s.substring(0, this.caretPosition) + this.tmpChar + s.substring(this.caretPosition, s.length());
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getLength() {
        return this.text.length() + (this.tmpChar == '\u0000' ? 0 : 1);
    }

    public void updateUI() {
        super.updateUI();
        this.font = this.theme.getFont(0);
        if (this.SOFTKEY_CLEAR != null) {
            this.SOFTKEY_CLEAR.updateUI();
        }
    }

    public static int searchStringCharOffset(String text, Font font, int xPixelOffset) {
        int first = 0;
        int upto = text.length();
        int mid = 0;
        while (first < upto) {
            mid = (first + upto) / 2;
            if (mid > 0 && StringUtil.isHighSurrogate(text.charAt(mid - 1))) {
                --mid;
            }
            int charPos1 = font.getWidth(text.substring(0, mid));
            int sizeOfNextCodepoint = StringUtil.isHighSurrogate(text.charAt(mid)) ? 2 : 1;
            int charPos2 = charPos1 + font.getWidth(text.substring(mid, mid + sizeOfNextCodepoint));
            if (xPixelOffset < charPos1) {
                upto = mid;
                continue;
            }
            if (xPixelOffset <= charPos2) break;
            first = mid + sizeOfNextCodepoint;
        }
        return mid;
    }

    public void setValue(Object obj) {
        this.setText(String.valueOf(obj));
    }

    public Object getValue() {
        String x = this.getText();
        if ((this.constraints & 0xFFFF) == 2) {
            if ("".equals(x)) {
                return null;
            }
            return Integer.valueOf(x);
        }
        return x;
    }

    public Window getPopupMenu() {
        String txt2;
        if (this.popup != null) {
            return this.popup;
        }
        if (!this.isFocusable()) {
            return null;
        }
        Button cut = new Button((String)DesktopPane.get("cutText"));
        Button copy = new Button((String)DesktopPane.get("copyText"));
        Button paste = new Button((String)DesktopPane.get("pasteText"));
        Button delete = new Button((String)DesktopPane.get("deleteText"));
        cut.setActionCommand("cut");
        copy.setActionCommand("copy");
        paste.setActionCommand("paste");
        delete.setActionCommand("delete");
        cut.addActionListener(this);
        copy.addActionListener(this);
        paste.addActionListener(this);
        delete.addActionListener(this);
        Window popup = Menu.makePopup();
        MenuBar menu = Menu.getPopupMenu(popup);
        if (Application.getPlatform() == 12 || Application.getPlatform() == 10) {
            menu.setLayoutOrientation(3);
        }
        menu.add(cut);
        menu.add(copy);
        menu.add(paste);
        menu.add(delete);
        String txt = this.getText();
        if (txt == null || "".equals(txt)) {
            cut.setFocusable(false);
            copy.setFocusable(false);
            delete.setFocusable(false);
        }
        if ((txt2 = ClipboardManager.getInstance().getText()) == null || "".equals(txt2)) {
            paste.setFocusable(false);
        }
        return popup;
    }

    public String toString() {
        return super.toString() + "[" + this.text + "]";
    }

    static {
        changeModeChar = Application.getPlatform() == 3 ? 42 : 35;
        autoAcceptTimeout = 1000;
    }
}

