/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.layout.XHTMLLoader;
import net.yura.mobile.gui.plaf.Style;

public class TextPane
extends Component {
    private String text = "";
    private Vector sortedElemsList = new Vector();
    private Vector lineFragments = new Vector();
    private Vector focusableElems = new Vector();
    private int lastLineX;
    private int focusComponentIdx;
    private ActionListener actionListener;
    int widthUsed = -1;
    int heightUsed = -1;

    protected String getDefaultName() {
        return "TextPane";
    }

    protected boolean getDefaultEnabled() {
        return false;
    }

    public void paintComponent(Graphics2D g) {
        TextStyle focusElem = this.getFocusElementStyle();
        int bgColor = this.getBackground();
        int topClipY = g.getClipY();
        int bottomClipY = topClipY + g.getClipHeight();
        int numLineFrags = this.lineFragments.size();
        for (int i = 0; i < numLineFrags; ++i) {
            LineFragment lineFrag = (LineFragment)this.lineFragments.elementAt(i);
            if (lineFrag.y + lineFrag.h < topClipY || lineFrag.y > bottomClipY) continue;
            TextStyle style = lineFrag.style;
            Icon icon = style.getIcon();
            int fragState = style == focusElem ? 4 : 0;
            int bgStyleColor = style.getBackground(fragState);
            Border boder = style.getBorder(fragState);
            if (boder != null) {
                g.translate(lineFrag.x, lineFrag.y);
                boder.paintBorder(this, g, lineFrag.w, lineFrag.h);
                g.translate(-lineFrag.x, -lineFrag.y);
            }
            if (bgColor != bgStyleColor && bgStyleColor != 0) {
                g.setColor(bgStyleColor);
                g.fillRect(lineFrag.x, lineFrag.y, lineFrag.w, lineFrag.h);
            }
            if (icon == null) {
                String str = this.text.substring(lineFrag.startOffset, lineFrag.endOffset);
                if (str.length() <= 0) continue;
                g.setColor(style.getForeground(fragState));
                Font f = this.getFont(style, fragState);
                g.setFont(f);
                g.drawString(str, lineFrag.x, lineFrag.y);
                continue;
            }
            icon.paintIcon(this, g, lineFrag.x, lineFrag.y);
        }
    }

    protected void workoutMinimumSize() {
        if (this.getPreferredWidth() != -1) {
            this.width = this.getPreferredWidth();
            if (this.width != this.widthUsed) {
                this.heightUsed = this.height = this.doLayout();
            }
            this.height = this.heightUsed;
        } else {
            this.width = 10;
            this.height = this.widthUsed < 0 ? 10 : this.heightUsed;
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.width != this.widthUsed) {
            int oldh = this.height;
            this.heightUsed = this.height = this.doLayout();
            if (oldh != this.height) {
                DesktopPane.mySizeChanged(this);
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text1) {
        this.sortedElemsList.removeAllElements();
        this.lineFragments.removeAllElements();
        this.focusableElems.removeAllElements();
        this.widthUsed = -1;
        this.heightUsed = -1;
        if (text1.startsWith("<html>")) {
            this.text = "";
            XHTMLLoader loader = new XHTMLLoader();
            loader.gotResult(this, text1);
        } else {
            this.text = text1;
        }
    }

    public void setValue(Object obj) {
        if (obj instanceof String) {
            this.setText((String)obj);
        }
    }

    public void append(String text1) {
        this.widthUsed = -1;
        if (text1.startsWith("<html>")) {
            XHTMLLoader loader = new XHTMLLoader();
            loader.gotResult(this, text1);
        } else {
            this.text = this.text + text1;
        }
    }

    public void setCharacterAttributes(int offset, int length, TextStyle style) {
        if (offset >= 0 && length >= 1 && this.text != null && offset < this.text.length()) {
            int endOffset = Math.min(offset + length, this.text.length());
            Element elem = new Element(style, offset, endOffset);
            this.insertSortedElement(this.sortedElemsList, elem);
        }
    }

    public void setParagraphAttributes(int offset, int length, TextStyle style) {
        if (offset >= 0 && length >= 0 && this.text != null && offset < this.text.length()) {
            int lowerLfIdx = 0;
            int higherLfIdx = this.text.length();
            int lineFeedIdx = 0;
            while ((lineFeedIdx = this.text.indexOf(10, lineFeedIdx)) > 0) {
                if (lineFeedIdx < offset) {
                    lowerLfIdx = lineFeedIdx;
                } else if (lineFeedIdx > offset + length) {
                    higherLfIdx = lineFeedIdx + 1;
                    break;
                }
                ++lineFeedIdx;
            }
            Element elem = new Element(style, lowerLfIdx, higherLfIdx);
            elem.isParagraph = true;
            this.insertSortedElement(this.sortedElemsList, elem);
        }
    }

    public void setActionListener(ActionListener l) {
        this.actionListener = l;
    }

    public void focusLost() {
        super.focusLost();
        this.repaint();
    }

    public void focusGained() {
        super.focusGained();
        this.makeVisible(this.focusComponentIdx, false);
    }

    public boolean processKeyEvent(KeyEvent event) {
        int key = event.getIsDownKey();
        if (key == 0) {
            return false;
        }
        int action = event.getKeyAction(key);
        if (action == 8) {
            TextStyle style = this.getFocusElementStyle();
            if (style != null && this.actionListener != null) {
                this.actionListener.actionPerformed(style.getAction());
            }
            return true;
        }
        int next = this.focusComponentIdx;
        int n = action == 6 || action == 5 ? next + 1 : (next = action == 1 || action == 2 ? next - 1 : next);
        int n2 = next < 0 ? 0 : (next = next >= this.focusableElems.size() ? this.focusableElems.size() - 1 : next);
        if (next != this.focusComponentIdx) {
            if (this.makeVisible(next, true)) {
                this.focusComponentIdx = next;
            }
            this.repaint();
            return true;
        }
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.sortedElemsList != null) {
            for (int i = 0; i < this.sortedElemsList.size(); ++i) {
                Element elem = (Element)this.sortedElemsList.elementAt(i);
                elem.style.updateUI();
            }
            this.widthUsed = -1;
            this.heightUsed = -1;
        }
    }

    private boolean makeVisible(int styleIdx, boolean smart) {
        int MAX;
        if (this.focusableElems.size() == 0) {
            return false;
        }
        int leftX = MAX = Integer.MAX_VALUE;
        int rightX = 0;
        int topY = MAX;
        int bottomY = 0;
        TextStyle style = (TextStyle)this.focusableElems.elementAt(styleIdx);
        for (int i = 0; i < this.lineFragments.size(); ++i) {
            LineFragment frag = (LineFragment)this.lineFragments.elementAt(i);
            if (frag.style == style) {
                leftX = Math.min(leftX, frag.x);
                rightX = Math.max(rightX, frag.x + frag.w);
                topY = Math.min(topY, frag.y);
                bottomY = Math.max(bottomY, frag.y + frag.h);
                continue;
            }
            if (leftX < MAX) break;
        }
        return this.scrollRectToVisible(leftX, topY, rightX - leftX, bottomY - topY, smart);
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (type == 1 && this.isFocusOwner()) {
            for (int i = 0; i < this.lineFragments.size(); ++i) {
                LineFragment frag = (LineFragment)this.lineFragments.elementAt(i);
                if (x < frag.x || x > frag.x + frag.w || y < frag.y || y > frag.y + frag.h) continue;
                this.pressLink(frag);
                break;
            }
        }
    }

    public boolean pressLink(String linkText) {
        if (this.actionListener != null) {
            for (int i = 0; i < this.lineFragments.size(); ++i) {
                LineFragment frag = (LineFragment)this.lineFragments.elementAt(i);
                String txt = this.text.substring(frag.startOffset, frag.endOffset);
                if (!linkText.equalsIgnoreCase(txt) || !this.pressLink(frag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pressLink(LineFragment frag) {
        TextStyle style = frag.style;
        if (style.getAction() != null) {
            int focusIdx = this.focusableElems.indexOf(style);
            this.makeVisible(focusIdx, false);
            if (focusIdx != this.focusComponentIdx) {
                this.focusComponentIdx = focusIdx;
                this.repaint();
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(style.getAction());
            }
            return true;
        }
        return false;
    }

    private TextStyle getFocusElementStyle() {
        int idx = this.focusComponentIdx;
        return idx < 0 || idx >= this.focusableElems.size() || !this.isFocusOwner() ? null : (TextStyle)this.focusableElems.elementAt(idx);
    }

    private int doLayout() {
        this.widthUsed = this.width;
        this.lineFragments.removeAllElements();
        this.focusableElems.removeAllElements();
        if (this.text == null || this.text.length() == 0 || this.width <= 0) {
            return 0;
        }
        this.lastLineX = 0;
        Vector<Element> elemStyleSortedStack = new Vector<Element>();
        int startFragIdx = 0;
        int numElems = this.sortedElemsList.size();
        for (int i = 0; i < numElems; ++i) {
            Element currentElem = (Element)this.sortedElemsList.elementAt(i);
            int nextStartFragIdx = currentElem.startOffset;
            if (nextStartFragIdx == startFragIdx) {
                elemStyleSortedStack.addElement(currentElem);
                continue;
            }
            startFragIdx = this.addClosingLineFragments(elemStyleSortedStack, startFragIdx, nextStartFragIdx);
            startFragIdx = this.addLineFragments(elemStyleSortedStack, startFragIdx, nextStartFragIdx);
            this.insertSortedElement(elemStyleSortedStack, currentElem);
        }
        startFragIdx = this.addClosingLineFragments(elemStyleSortedStack, startFragIdx, this.text.length());
        this.addLineFragments(elemStyleSortedStack, startFragIdx, this.text.length());
        this.focusable = this.focusableElems.size() > 0;
        return this.layoutVerticaly();
    }

    private int addClosingLineFragments(Vector elemStyleSortedStack, int startFragIdx, int nextStartFragIdx) {
        int nClosesFound;
        do {
            nClosesFound = 0;
            int smallerEndOffset = nextStartFragIdx;
            int smallerEndOffsetIdx = -1;
            for (int j = elemStyleSortedStack.size() - 1; j >= 0; --j) {
                Element elem = (Element)elemStyleSortedStack.elementAt(j);
                int elemEndOffset = elem.endOffset;
                if (elemEndOffset <= nextStartFragIdx) {
                    ++nClosesFound;
                }
                if (elemEndOffset > smallerEndOffset) continue;
                smallerEndOffset = elemEndOffset;
                smallerEndOffsetIdx = j;
            }
            if (nClosesFound <= 0) continue;
            startFragIdx = this.addLineFragments(elemStyleSortedStack, startFragIdx, smallerEndOffset);
            elemStyleSortedStack.removeElementAt(smallerEndOffsetIdx);
        } while (nClosesFound > 1);
        return startFragIdx;
    }

    private int addLineFragments(Vector currentElemStack, int startIndex, int endIndex) {
        if (startIndex >= endIndex) {
            return startIndex;
        }
        TextStyle style = this.getCombinedStyle(currentElemStack);
        int nOldFragments = this.lineFragments.size();
        String elemText = this.text.substring(startIndex, endIndex);
        if (style.getIcon() == null) {
            this.addLineTextFragments(elemText, style, startIndex);
        } else {
            this.addLineImageFragments(style);
        }
        if (style.getAction() != null && nOldFragments != this.lineFragments.size()) {
            this.focusableElems.addElement(style);
        }
        return endIndex;
    }

    private void addLineTextFragments(String elemText, TextStyle style, int startIndex) {
        Font f = this.getFont(style, 0);
        int borderH = this.getBorderHeight(style);
        int borderW = this.getBorderWidth(style);
        int fragH = f.getHeight() + borderH;
        int[] lines = this.getLines(elemText, f, this.lastLineX, this.width - borderW);
        int startFragIdx = startIndex;
        for (int j = 0; j < lines.length + 1; ++j) {
            int endFragIdx;
            int n = endFragIdx = j == lines.length ? elemText.length() : lines[j];
            if ((endFragIdx += startIndex) > startFragIdx) {
                String lastLineText = this.text.substring(startFragIdx, endFragIdx);
                if ("\n".equals(lastLineText)) {
                    if (this.lastLineX <= 0) {
                        this.lineFragments.addElement(new LineFragment(0, 0, 0, fragH, style, 0, 0));
                    }
                    this.lastLineX = 0;
                } else {
                    boolean trimSpace = j < lines.length;
                    int fragW = f.getWidth(lastLineText = this.trimStringRightSide(lastLineText, trimSpace));
                    if (fragW > 0) {
                        LineFragment lineFrag = new LineFragment(this.lastLineX, 0, fragW += borderW, fragH, style, startFragIdx, startFragIdx + lastLineText.length());
                        this.lineFragments.addElement(lineFrag);
                    }
                    this.lastLineX = j == lines.length ? this.lastLineX + fragW : 0;
                }
            } else {
                this.lastLineX = 0;
            }
            startFragIdx = endFragIdx;
        }
    }

    private int getBorderWidth(TextStyle style) {
        Border b = style.getBorder(0);
        return b == null ? 0 : b.getLeft() + b.getRight();
    }

    private int getBorderHeight(TextStyle style) {
        Border b = style.getBorder(0);
        return b == null ? 0 : b.getTop() + b.getBottom();
    }

    private void addLineImageFragments(TextStyle style) {
        Icon icon = style.getIcon();
        int imgW = icon.getIconWidth();
        int imgH = icon.getIconHeight();
        if (imgH > 0 && imgW > 0) {
            imgH += this.getBorderHeight(style);
            if (this.lastLineX + (imgW += this.getBorderWidth(style)) > this.width) {
                this.lastLineX = 0;
            }
            LineFragment lineFrag = new LineFragment(this.lastLineX, 0, imgW, imgH, style, 0, 0);
            this.lineFragments.addElement(lineFrag);
            this.lastLineX += imgW;
            if (this.lastLineX >= this.width || imgW >= this.width) {
                this.lastLineX = 0;
            }
        }
    }

    private int layoutVerticaly() {
        int numFrags = this.lineFragments.size();
        if (numFrags == 0) {
            return 0;
        }
        int padding = 2;
        int lineY = -padding;
        int lineH = 0;
        int lineW = 0;
        int startLineFragIdx = 0;
        LineFragment lineFrag = null;
        for (int i = 0; i <= numFrags; ++i) {
            if (i < numFrags) {
                lineFrag = (LineFragment)this.lineFragments.elementAt(i);
            }
            if (lineFrag.x <= 0 || i == numFrags) {
                int lineX = 0;
                for (int j = startLineFragIdx; j < i; ++j) {
                    LineFragment frag = (LineFragment)this.lineFragments.elementAt(j);
                    int leftPadding = this.getParagraphLeftPadding(frag.style, lineW);
                    int fragW = frag.w;
                    frag.y = lineY + (lineH - frag.h);
                    frag.x = lineX + leftPadding;
                    Border b = frag.style.getBorder(0);
                    if (b != null) {
                        frag.y += b.getTop();
                        frag.x += b.getLeft();
                        frag.h -= b.getTop() + b.getBottom();
                        frag.w -= b.getLeft() + b.getRight();
                    }
                    lineX += fragW;
                }
                lineY += lineH + padding;
                startLineFragIdx = i;
                lineH = lineFrag.h;
                lineW = lineFrag.w;
                continue;
            }
            lineH = Math.max(lineH, lineFrag.h);
            lineW += lineFrag.w;
        }
        return lineY;
    }

    private int getParagraphLeftPadding(TextStyle style, int lineW) {
        int align = style.getAlignment();
        return align == 1 ? (this.width - lineW) / 2 : (align == 2 ? this.width - lineW : 0);
    }

    private String trimStringRightSide(String str, boolean trimSpace) {
        int startLen = str.length();
        int endLen = startLen;
        if (endLen > 0 && str.charAt(endLen - 1) == '\n') {
            --endLen;
        }
        if (trimSpace && endLen > 0 && str.charAt(endLen - 1) == ' ') {
            --endLen;
        }
        return endLen != startLen ? str.substring(0, endLen) : str;
    }

    private TextStyle getCombinedStyle(Vector elemList) {
        TextStyle paragStyle = new TextStyle();
        TextStyle charsStyle = new TextStyle();
        paragStyle.setBackground(this.getBackground());
        paragStyle.setForeground(this.getForeground());
        paragStyle.setAlignment(0);
        for (int i = 0; i < elemList.size(); ++i) {
            Element elem = (Element)elemList.elementAt(i);
            TextStyle s = elem.isParagraph ? paragStyle : charsStyle;
            s.putAll(elem.style);
        }
        paragStyle.setIcon(null);
        int align = paragStyle.getAlignment();
        paragStyle.putAll(charsStyle);
        paragStyle.setAlignment(align);
        return paragStyle;
    }

    private int[] getLines(String str, Font f, int startX, int w) {
        return TextArea.getLines(str, f, 0, w - startX, w);
    }

    private void insertSortedElement(Vector v, Element elem) {
        int low = 0;
        int high = v.size();
        while (low < high) {
            int midle = (low + high) / 2;
            Element midElem = (Element)v.elementAt(midle);
            if (elem.startOffset < midElem.startOffset) {
                high = midle;
                continue;
            }
            low = midle + 1;
        }
        v.insertElementAt(elem, low);
    }

    private Font getFont(TextStyle ts, int state) {
        Font f = ts.getFont(state);
        if (f != null) {
            return f;
        }
        f = this.theme.getFont(state);
        int face = 0;
        int size = 0;
        javax.microedition.lcdui.Font sysf = f.getFont();
        if (sysf != null) {
            face = sysf.getFace();
            size = sysf.getSize();
        }
        int style = 0;
        if (ts.isBold()) {
            style |= 1;
        }
        if (ts.isItalic()) {
            style |= 2;
        }
        if (ts.isUnderline()) {
            style |= 4;
        }
        if (style != 0) {
            return new Font(face, style, size);
        }
        return f;
    }

    public String toString() {
        return super.toString() + "[" + this.text + "]";
    }

    private static class LineFragment {
        int x;
        int y;
        int w;
        int h;
        TextStyle style;
        int startOffset;
        int endOffset;

        public LineFragment(int x, int y, int w, int h, TextStyle style, int startOffset, int endOffset) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.style = style;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }

    private static class Element {
        boolean isParagraph;
        private TextStyle style;
        private int startOffset;
        private int endOffset;

        public Element(TextStyle style, int startOffset, int endOffset) {
            this.style = style;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }

    public static class TextStyle
    extends Style {
        private int alignment = -1;
        private byte textStyle;
        private Icon icon;
        private String action;
        private String name;
        public static final int ALIGN_CENTER = 1;
        public static final int ALIGN_JUSTIFIED = 3;
        public static final int ALIGN_LEFT = 0;
        public static final int ALIGN_RIGHT = 2;

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int alignment) {
            if (alignment < 0 || alignment > 3) {
                throw new IllegalArgumentException("setAlignment");
            }
            this.alignment = alignment;
        }

        public int getBackground() {
            return this.getBackground(0);
        }

        public void setBackground(int c) {
            this.addBackground(c, 0);
        }

        public int getForeground() {
            return this.getForeground(0);
        }

        public void setForeground(int c) {
            this.addForeground(c, 0);
        }

        private boolean isBitSet(byte b, int pos) {
            return (b >> pos & 1) == 1;
        }

        private byte setBit(byte b, int pos, boolean val) {
            byte bit = (byte)(1 << pos);
            return val ? (byte)(b | bit) : (byte)((b ^ 0xFF) & bit);
        }

        public boolean isBold() {
            return this.isBitSet(this.textStyle, 0);
        }

        public void setBold(boolean b) {
            this.textStyle = this.setBit(this.textStyle, 0, b);
        }

        public boolean isItalic() {
            return this.isBitSet(this.textStyle, 1);
        }

        public void setItalic(boolean b) {
            this.textStyle = this.setBit(this.textStyle, 1, b);
        }

        public boolean isUnderline() {
            return this.isBitSet(this.textStyle, 2);
        }

        public void setUnderline(boolean b) {
            this.textStyle = this.setBit(this.textStyle, 2, b);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void putAll(Style attributes) {
            super.putAll(attributes);
            if (attributes instanceof TextStyle) {
                TextStyle a = (TextStyle)attributes;
                this.textStyle = (byte)(this.textStyle | a.textStyle);
                if (a.alignment != -1) {
                    this.alignment = a.alignment;
                }
                if (a.action != null) {
                    this.action = a.action;
                }
                if (a.icon != null) {
                    this.icon = a.icon;
                }
                if (a.name != null) {
                    this.name = a.name;
                }
            }
        }

        public void updateUI() {
            Style newStyle;
            if (this.name != null && (newStyle = DesktopPane.getDesktopPane().getLookAndFeel().getStyle(this.name)) != null) {
                this.reset();
                super.putAll(newStyle);
            }
        }
    }
}

