/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.util.Vector;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.Layout;

public class BoxLayout
implements Layout {
    private int axis;

    public BoxLayout(int axis) {
        this.axis = axis;
    }

    public void layoutPanel(Panel panel) {
        Vector components = panel.getComponents();
        int height = panel.getHeight();
        int width = panel.getWidth();
        int offset = 0;
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            comp.setBounds(this.axis == 1 ? offset : 0, this.axis == 1 ? 0 : offset, this.axis == 1 ? comp.getWidthWithBorder() : width, this.axis == 1 ? height : comp.getHeightWithBorder());
            offset += this.axis == 1 ? comp.getWidthWithBorder() : comp.getHeightWithBorder();
        }
    }

    public int getPreferredHeight(Panel panel) {
        Vector components = panel.getComponents();
        int height = 0;
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            if (this.axis == 1) {
                if (height >= comp.getHeightWithBorder()) continue;
                height = comp.getHeightWithBorder();
                continue;
            }
            height += comp.getHeightWithBorder();
        }
        return height;
    }

    public int getPreferredWidth(Panel panel) {
        Vector components = panel.getComponents();
        int width = 0;
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            if (this.axis == 1) {
                width += comp.getWidthWithBorder();
                continue;
            }
            if (width >= comp.getWidthWithBorder()) continue;
            width = comp.getWidthWithBorder();
        }
        return width;
    }
}

