/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.components.TextPane;
import net.yura.mobile.gui.layout.Layout;

public class FlowLayout
implements Layout {
    private int padding;
    private int align;

    public FlowLayout() {
        this(1);
    }

    public FlowLayout(int a) {
        this(a, DesktopPane.getDesktopPane().defaultSpace);
    }

    public FlowLayout(int a, int p) {
        this.align = a;
        this.padding = p;
    }

    public static int getVisibleComponents(Panel panel) {
        Vector components = panel.getComponents();
        int num = 0;
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            ++num;
        }
        return num;
    }

    public void layoutPanel(Panel panel) {
        int width = panel.getWidth();
        int height = panel.getHeight();
        Vector components = panel.getComponents();
        if (this.align == 1) {
            int fullwidth = this.getPreferredWidth(panel);
            int offset = (width - fullwidth) / 2 + this.padding;
            int num = FlowLayout.getVisibleComponents(panel);
            for (int c = 0; c < components.size(); ++c) {
                Component comp = (Component)components.elementAt(c);
                if (!comp.isVisible()) continue;
                int cwidth = comp instanceof TextComponent ? width / num : comp.getWidthWithBorder();
                comp.setBounds(offset, (height - comp.getHeightWithBorder()) / 2, cwidth, comp.getHeightWithBorder());
                offset = offset + comp.getWidthWithBorder() + this.padding;
            }
        } else {
            int down = this.padding;
            for (int c = 0; c < components.size(); ++c) {
                int cwidth;
                Component comp = (Component)components.elementAt(c);
                if (!comp.isVisible()) continue;
                int cheight = comp.getHeightWithBorder();
                if (comp instanceof TextArea || comp instanceof TextPane) {
                    cwidth = width - 2 * this.padding;
                } else if (comp instanceof TextComponent) {
                    cwidth = (int)((double)width * 0.6);
                } else {
                    cwidth = comp.getWidthWithBorder();
                    if (comp instanceof Panel && cwidth < width) {
                        cwidth = width;
                    }
                }
                int offset = (width - cwidth) / 2;
                comp.setBounds(offset, down, cwidth, cheight);
                if (cheight == 0) continue;
                down = down + cheight + this.padding;
            }
        }
    }

    public int getPreferredHeight(Panel panel) {
        Vector components = panel.getComponents();
        if (this.align == 1) {
            int fullheight = 0;
            for (int c = 0; c < components.size(); ++c) {
                Component comp = (Component)components.elementAt(c);
                if (!comp.isVisible() || fullheight >= comp.getHeightWithBorder() + this.padding * 2) continue;
                fullheight = comp.getHeightWithBorder() + this.padding * 2;
            }
            return fullheight;
        }
        int fullheight = components.size() > 0 ? (components.size() + 1) * this.padding : 0;
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            fullheight += comp.getHeightWithBorder();
        }
        return fullheight;
    }

    public int getPreferredWidth(Panel panel) {
        Vector components = panel.getComponents();
        if (this.align == 1) {
            int num = FlowLayout.getVisibleComponents(panel);
            int fullwidth = num > 0 ? (num + 1) * this.padding : 0;
            for (int c = 0; c < components.size(); ++c) {
                Component comp = (Component)components.elementAt(c);
                if (!comp.isVisible()) continue;
                if (comp instanceof TextComponent) {
                    fullwidth += panel.getWidth() / num;
                    continue;
                }
                fullwidth += comp.getWidthWithBorder();
            }
            return fullwidth;
        }
        int fullwidth = 0;
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible() || comp.getWidthWithBorder() <= fullwidth) continue;
            fullwidth = comp.getWidthWithBorder();
        }
        return fullwidth;
    }
}

