/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import java.awt.image.RGBImageFilter;

public class ColorMatrix
extends RGBImageFilter {
    private final float[] mArray = new float[20];

    public ColorMatrix() {
        this.reset();
    }

    public ColorMatrix(float[] src) {
        System.arraycopy(src, 0, this.mArray, 0, 20);
    }

    public ColorMatrix(ColorMatrix src) {
        System.arraycopy(src.mArray, 0, this.mArray, 0, 20);
    }

    public final float[] getArray() {
        return this.mArray;
    }

    public void reset() {
        float[] a = this.mArray;
        for (int i = 19; i > 0; --i) {
            a[i] = 0.0f;
        }
        a[18] = 1.0f;
        a[12] = 1.0f;
        a[6] = 1.0f;
        a[0] = 1.0f;
    }

    public void set(ColorMatrix src) {
        System.arraycopy(src.mArray, 0, this.mArray, 0, 20);
    }

    public void set(float[] src) {
        System.arraycopy(src, 0, this.mArray, 0, 20);
    }

    public void setScale(float rScale, float gScale, float bScale, float aScale) {
        float[] a = this.mArray;
        for (int i = 19; i > 0; --i) {
            a[i] = 0.0f;
        }
        a[0] = rScale;
        a[6] = gScale;
        a[12] = bScale;
        a[18] = aScale;
    }

    public void setRotate(int axis, float degrees) {
        this.reset();
        float radians = degrees * (float)Math.PI / 180.0f;
        float cosine = (float)Math.cos(radians);
        float sine = (float)Math.sin(radians);
        switch (axis) {
            case 0: {
                this.mArray[6] = this.mArray[12] = cosine;
                this.mArray[7] = sine;
                this.mArray[11] = -sine;
                break;
            }
            case 1: {
                this.mArray[0] = this.mArray[17] = cosine;
                this.mArray[2] = sine;
                this.mArray[15] = -sine;
                break;
            }
            case 2: {
                this.mArray[0] = this.mArray[6] = cosine;
                this.mArray[1] = sine;
                this.mArray[5] = -sine;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void setConcat(ColorMatrix matA, ColorMatrix matB) {
        float[] tmp = null;
        tmp = matA == this || matB == this ? new float[20] : this.mArray;
        float[] a = matA.mArray;
        float[] b = matB.mArray;
        int index = 0;
        for (int j = 0; j < 20; j += 5) {
            for (int i = 0; i < 4; ++i) {
                tmp[index++] = a[j + 0] * b[i + 0] + a[j + 1] * b[i + 5] + a[j + 2] * b[i + 10] + a[j + 3] * b[i + 15];
            }
            tmp[index++] = a[j + 0] * b[4] + a[j + 1] * b[9] + a[j + 2] * b[14] + a[j + 3] * b[19] + a[j + 4];
        }
        if (tmp != this.mArray) {
            System.arraycopy(tmp, 0, this.mArray, 0, 20);
        }
    }

    public void preConcat(ColorMatrix prematrix) {
        this.setConcat(this, prematrix);
    }

    public void postConcat(ColorMatrix postmatrix) {
        this.setConcat(postmatrix, this);
    }

    public void setSaturation(float sat) {
        this.reset();
        float[] m = this.mArray;
        float invSat = 1.0f - sat;
        float R = 0.213f * invSat;
        float G = 0.715f * invSat;
        float B = 0.072f * invSat;
        m[0] = R + sat;
        m[1] = G;
        m[2] = B;
        m[5] = R;
        m[6] = G + sat;
        m[7] = B;
        m[10] = R;
        m[11] = G;
        m[12] = B + sat;
    }

    public void setRGB2YUV() {
        this.reset();
        float[] m = this.mArray;
        m[0] = 0.299f;
        m[1] = 0.587f;
        m[2] = 0.114f;
        m[5] = -0.16874f;
        m[6] = -0.33126f;
        m[7] = 0.5f;
        m[10] = 0.5f;
        m[11] = -0.41869f;
        m[12] = -0.08131f;
    }

    public void setYUV2RGB() {
        this.reset();
        float[] m = this.mArray;
        m[2] = 1.402f;
        m[5] = 1.0f;
        m[6] = -0.34414f;
        m[7] = -0.71414f;
        m[10] = 1.0f;
        m[11] = 1.772f;
        m[12] = 0.0f;
    }

    public int filterRGB(int x, int y, int rgb) {
        int R = rgb >> 16 & 0xFF;
        int G = rgb >> 8 & 0xFF;
        int B = rgb >> 0 & 0xFF;
        int A = rgb >> 24 & 0xFF;
        int r = ColorMatrix.clamp(this.mArray[0] * (float)R + this.mArray[1] * (float)G + this.mArray[2] * (float)B + this.mArray[3] * (float)A + this.mArray[4]);
        int g = ColorMatrix.clamp(this.mArray[5] * (float)R + this.mArray[6] * (float)G + this.mArray[7] * (float)B + this.mArray[8] * (float)A + this.mArray[9]);
        int b = ColorMatrix.clamp(this.mArray[10] * (float)R + this.mArray[11] * (float)G + this.mArray[12] * (float)B + this.mArray[13] * (float)A + this.mArray[14]);
        int a = ColorMatrix.clamp(this.mArray[15] * (float)R + this.mArray[16] * (float)G + this.mArray[17] * (float)B + this.mArray[18] * (float)A + this.mArray[19]);
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    private static int clamp(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 255.0f) {
            value = 255.0f;
        }
        return (int)value;
    }
}

