/*
 * Decompiled with CFR 0.152.
 */
package net.yura.me4se;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import javax.microedition.midlet.ApplicationManager;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.yura.me4se.SingleFrameApplication;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.gui.plaf.LookAndFeel;
import net.yura.mobile.gui.plaf.nimbus.NimbusLookAndFeel;
import org.me4se.JadFile;

public class ME4SEPanel
extends Container {
    private ApplicationManager manager;
    private ApplicationManager oldManager;
    private DesktopPane desktop;
    private DesktopPane oldDesktop;
    private net.yura.mobile.gui.components.Frame swingMEFrame;

    public DesktopPane getDesktopPane() {
        return this.desktop;
    }

    public ME4SEPanel() {
        this.setLayout(new BorderLayout());
        this.oldManager = ApplicationManager.isInitialized() ? ApplicationManager.getInstance() : null;
        this.oldDesktop = DesktopPane.getDesktopPane();
        this.manager = ApplicationManager.createInstance(this, null);
        JadFile jad = new JadFile();
        jad.setValue("MIDlet-1", ",," + SingleFrameApplication.class.getName());
        this.manager.launch(jad, 0);
        this.desktop = DesktopPane.getDesktopPane();
        this.desktop.setLookAndFeel((LookAndFeel)new NimbusLookAndFeel());
        this.desktop.defaultSpace = XULLoader.adjustSizeToDensity((int)5);
        DesktopPane.put((Object)"okText", (Object)UIManager.getString("OptionPane.okButtonText"));
        DesktopPane.put((Object)"cancelText", (Object)UIManager.getString("OptionPane.cancelButtonText"));
        DesktopPane.put((Object)"yesText", (Object)UIManager.getString("OptionPane.yesButtonText"));
        DesktopPane.put((Object)"noText", (Object)UIManager.getString("OptionPane.noButtonText"));
    }

    public ApplicationManager getApplicationManager() {
        return this.manager;
    }

    public void destroy() {
        try {
            Field man = ApplicationManager.class.getDeclaredField("manager");
            man.setAccessible(true);
            if (man.get(null) == this.manager) {
                System.out.println("[ME4SEPanel] setting manager to old manager " + this.oldManager);
                man.set(null, this.oldManager);
                this.oldManager = null;
            }
            ((SingleFrameApplication)((Object)this.manager.active)).destroyApp(true);
            if (this.oldDesktop != null) {
                this.oldDesktop.showNotify();
                this.oldDesktop = null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Component getComponent() {
        return this.getComponents()[0];
    }

    public void add(net.yura.mobile.gui.components.Component panel) {
        if (this.swingMEFrame != null) {
            this.desktop.remove((net.yura.mobile.gui.components.Window)this.swingMEFrame);
        }
        this.swingMEFrame = new net.yura.mobile.gui.components.Frame(){

            public void setVisible(boolean b) {
                if (b) {
                    super.setVisible(b);
                } else {
                    SwingUtilities.getWindowAncestor(ME4SEPanel.this).setVisible(b);
                }
            }
        };
        this.swingMEFrame.setUndecorated(true);
        this.swingMEFrame.getContentPane().add(panel);
        this.swingMEFrame.setMaximum(true);
        this.desktop.add((net.yura.mobile.gui.components.Window)this.swingMEFrame);
    }

    public void showDialog(Window parent, String title) {
        JDialog dialog = parent instanceof Frame ? new JDialog((Frame)parent, title, true) : new JDialog((Dialog)parent, title, true);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ME4SEPanel.this.desktop.keyPressed(-11);
                ME4SEPanel.this.desktop.keyReleased(-11);
            }
        });
        dialog.getContentPane().add(this);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        dialog.dispose();
        this.destroy();
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getPreferredSize();
        if (this.swingMEFrame != null) {
            Dimension originalSize = new Dimension(this.swingMEFrame.getWidth(), this.swingMEFrame.getHeight());
            this.swingMEFrame.pack();
            Dimension packedSize = new Dimension(this.swingSizeFromj2MESize(this.swingMEFrame.getWidth()), this.swingSizeFromj2MESize(this.swingMEFrame.getHeight()));
            this.swingMEFrame.setSize(originalSize.width, originalSize.height);
            return packedSize;
        }
        return d;
    }

    public int swingSizeFromj2MESize(int size) {
        return (int)((float)size * this.manager.wrapper.scale);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d == null || d.width == 0 || d.height == 0) {
            return this.getMinimumSize();
        }
        return d;
    }
}

