/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.media.Control;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;

public class BasicMMDataSource
extends DataSource {
    private String contentType;
    private InputStream is;
    private StreamConnection con;
    private byte[] data;

    public BasicMMDataSource(String locator) {
        super(locator);
        if ("device://tone".equals(locator)) {
            this.contentType = "audio/x-tone-seq";
        } else if ("device://midi".equals(locator)) {
            this.contentType = "audio/midi";
        }
        if (this.contentType == null && locator.startsWith("file:")) {
            if ((locator = locator.toLowerCase()).endsWith(".mid")) {
                this.contentType = "audio/midi";
            } else if (locator.endsWith(".mp3")) {
                this.contentType = "audio/mpeg";
            } else if (locator.endsWith(".png")) {
                this.contentType = "image/png";
            } else if (locator.endsWith(".wav")) {
                this.contentType = "audio/x-wav";
            } else if (locator.endsWith(".au")) {
                this.contentType = "audio/basic";
            }
        }
    }

    public void connect() throws IOException {
        if (this.data == null) {
            int count;
            if (this.is == null) {
                ContentConnection cc;
                String type;
                String loc = this.getLocator();
                if (loc.startsWith("device://")) {
                    return;
                }
                this.con = (StreamConnection)Connector.open(loc);
                if (this.con instanceof ContentConnection && (type = (cc = (ContentConnection)this.con).getType()) != null) {
                    this.contentType = type;
                }
                this.is = this.con.openInputStream();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((count = this.is.read(buf)) > 0) {
                baos.write(buf, 0, count);
            }
            this.data = baos.toByteArray();
            this.is.close();
            this.is = null;
        }
    }

    public void disconnect() {
        if (this.con != null) {
            try {
                this.is.close();
                this.con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public Control getControl(String s) {
        return null;
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public SourceStream[] getStreams() {
        return null;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void setInputStream(InputStream is) {
        this.data = null;
        this.is = is;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getData());
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public byte[] getData() {
        if (this.data == null) {
            try {
                this.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.data;
    }
}

