/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.media.audio;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.midlet.ApplicationManager;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.me4se.impl.BasicMMPlayer;
import org.me4se.psi.java1.gcf.file.FileConnectionImpl;

public class WavePlayerImpl
extends BasicMMPlayer
implements LineListener {
    private static final Logger LOGGER = Logger.getLogger(WavePlayerImpl.class.getName());
    private static boolean useDefaultMixer;
    private static final Set clipTooLong;
    Clip clip;
    AudioInputStream audioInputStream;
    AudioFormat audioFormat;
    DataLine.Info info;

    public WavePlayerImpl() {
        super(true);
    }

    private AudioInputStream getAudioInputStream() throws Exception {
        if (this.audioInputStream == null) {
            String url = this.dataSource.getLocator();
            try {
                this.audioInputStream = AudioSystem.getAudioInputStream(new URL(url));
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Failed to load with url: " + url, ex);
                try {
                    this.audioInputStream = url.startsWith("file:/") ? AudioSystem.getAudioInputStream(FileConnectionImpl.urlToFile(url)) : AudioSystem.getAudioInputStream(new URI(url).toURL());
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.WARNING, "Failed to load with file, falling back to loading all data.", ex2);
                    this.audioInputStream = AudioSystem.getAudioInputStream(this.dataSource.getInputStream());
                }
            }
        }
        return this.audioInputStream;
    }

    public void realizeImpl() throws Exception {
        this.getAudioInputStream();
        this.audioFormat = this.audioInputStream.getFormat();
        LOGGER.fine("AudioFormat = " + this.audioFormat.toString());
        this.info = new DataLine.Info(Clip.class, this.audioInputStream.getFormat(), (int)this.audioInputStream.getFrameLength() * this.audioFormat.getFrameSize());
        if (this.audioFormat.getFrameRate() != -1.0f) {
            this.duration = (long)((float)(this.audioInputStream.getFrameLength() * 1000000L) / this.audioFormat.getFrameRate());
        }
    }

    public void startImpl() throws Exception {
        LOGGER.fine("Start called for clip: " + this.clip);
        if (this.clip == null) {
            this.getAudioInputStream();
            if (AudioSystem.isLineSupported(this.info)) {
                this.clip = (Clip)AudioSystem.getLine(this.info);
            } else if (useDefaultMixer) {
                this.clip = AudioSystem.getClip(null);
            } else {
                try {
                    this.clip = AudioSystem.getClip();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "failed to getClip()", ex);
                    useDefaultMixer = true;
                    this.clip = AudioSystem.getClip(null);
                }
                if (!useDefaultMixer && "org.classpath.icedtea.pulseaudio.PulseAudioClip".equals(this.clip.getClass().getName())) {
                    try {
                        this.clip.close();
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    useDefaultMixer = true;
                    this.clip = AudioSystem.getClip(null);
                }
            }
            if (AudioSystem.isLineSupported(new DataLine.Info(SourceDataLine.class, this.audioInputStream.getFormat(), -1))) {
                this.clip.open(this.audioInputStream);
            } else {
                String filename = this.dataSource.getLocator();
                int ch = this.audioFormat.getChannels();
                float rate = this.audioFormat.getSampleRate();
                AudioFormat af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
                if (AudioSystem.isConversionSupported(af, this.audioFormat)) {
                    try {
                        this.audioInputStream = AudioSystem.getAudioInputStream(af, this.audioInputStream);
                        if (clipTooLong.contains(filename)) {
                            this.audioInputStream = new AudioInputStream(this.audioInputStream, af, 1000000L);
                        }
                        this.clip.open(this.audioInputStream);
                    }
                    catch (LineUnavailableException ex) {
                        LOGGER.info("CLIP TOO LONG, TRYING SHORTER CLIP " + filename + " " + ex);
                        if (filename != null) {
                            clipTooLong.add(filename);
                        }
                        this.audioInputStream.close();
                        this.audioInputStream = null;
                        this.getAudioInputStream();
                        this.audioInputStream = AudioSystem.getAudioInputStream(af, this.audioInputStream);
                        this.audioInputStream = new AudioInputStream(this.audioInputStream, af, 1000000L);
                        this.clip.open(this.audioInputStream);
                    }
                } else {
                    LOGGER.info("WARN: standard open and conversion failed, trying fallback for " + this.dataSource.getLocator());
                    this.clip.open(this.audioInputStream);
                }
            }
            this.clip.addLineListener(this);
        }
        if (this.desiredTime != -1L) {
            this.clip.setMicrosecondPosition(this.desiredTime);
        }
        this.desiredTime = 0L;
        this.clip.start();
    }

    public void stopImpl() throws Exception {
        LOGGER.fine("stopImpl: " + this.clip);
        if (this.clip != null) {
            this.desiredTime = this.clip.getMicrosecondPosition();
            if (this.desiredTime >= this.clip.getMicrosecondLength()) {
                this.desiredTime = 0L;
            }
            this.clip.stop();
        }
    }

    public void closeImpl() {
        LOGGER.info("closeImpl: " + this.clip);
        if (this.clip != null) {
            this.clip.close();
            this.clip = null;
        }
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.audioInputStream = null;
        }
    }

    public void update(LineEvent event) {
        LOGGER.fine("Event: " + event + ";  clip: " + this.clip);
        LineEvent.Type type = event.getType();
        if (type.equals(LineEvent.Type.STOP) && this.state == 400) {
            if (this.clip != null && (this.loopCount > 1 || this.loopCount == -1)) {
                this.notifyListeners("endOfMedia", null);
                this.clip.setMicrosecondPosition(0L);
                this.clip.start();
                if (this.loopCount > 1) {
                    --this.loopCount;
                }
            } else {
                this.state = 300;
                ApplicationManager.getInstance().activePlayers.removeElement(this);
                this.notifyListeners("endOfMedia", null);
            }
        }
    }

    public long getMediaTime() {
        return this.clip == null ? this.desiredTime : this.clip.getMicrosecondPosition();
    }

    public String getContentType() {
        return this.dataSource.getContentType();
    }

    static {
        clipTooLong = new HashSet();
    }
}

