package net.yura.domination.lobby.mini;

import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.yura.domination.LoadingManager;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.mini.MiniLobbyGame;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Application;
import net.yura.mobile.util.Properties;
import net.yura.swingme.core.CoreUtil;

/**
 * @author Yura Mamyrin
 * @see net.yura.domination.lobby.client.ClientGameRisk
 */
public abstract class MiniLobbyRisk implements MiniLobbyGame,OnlineRisk {

    private static final Logger logger = Logger.getLogger( MiniLobbyRisk.class.getName() );

    private Risk myrisk;
    protected MiniLobbyClient lobby;

    public MiniLobbyRisk(Risk risk) {
        myrisk = risk;

        GameSound.INSTANCE.setLobbyOpen(true);
    }

    public void addLobbyGameMoveListener(MiniLobbyClient lgl) {
        lobby = lgl;
    }

    public Properties getProperties() {
        return CoreUtil.wrap( TranslationBundle.getBundle() );
    }
    
    public void openChat() {
        Application.openURL("http://domination.sourceforge.net/chat.shtml");
    }

    public boolean isMyGameType(GameType gametype) {
        return RiskUtil.GAME_NAME.equals(gametype.getName());
    }

    @Override
    public void prepareAndOpenGame(final Game game) {
        LoadingManager.showLoadingScreen(true);

        final String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());

        // TODO check if we are already in the process of downloading this map

        // check if we have this map already & if we need to do a update for the map
        if (MapPreview.haveLocalMap(mapUID) && !MapUpdateService.getInstance().contains(mapUID)) {
            lobby.mycom.playGame(game.getId());
        }
        else {
            net.yura.domination.mapstore.GetMap.getMap(mapUID, new Observer() {
                @Override
                public void update(Observable observable, Object data) {
                    if (data == RiskUtil.SUCCESS) {
                        lobby.mycom.playGame(game.getId());
                    }
                    else {
                        LoadingManager.showLoadingScreen(false);
                        lobby.error("map download failed for: " + mapUID);
                    }
                }
            });
        }
    }

    private boolean openGame;

    /**
     * @see net.yura.domination.lobby.client.ClientGameRisk#gameObject(java.lang.Object)
     */
    public void objectForGame(Object object) {
        try {
            if (object instanceof RiskGame) {
                RiskGame thegame = (RiskGame) object;
                Player player = thegame.getPlayer(lobby.whoAmI());
                String address = player == null ? "_watch_" : player.getAddress();
                myrisk.setOnlinePlay(this);
                myrisk.setAddress(address);
                myrisk.setGame(thegame);
                openGame = true;
            }
// TODO remove this legacy message system
            else if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map) object;

                String command = (String) map.get("command");
                if ("game".equals(command)) {
                    String address = (String) map.get("playerId");
                    RiskGame thegame = (RiskGame) map.get("game");
                    myrisk.setOnlinePlay(this);
                    myrisk.setAddress(address);
                    myrisk.setGame(thegame);
                    openGame = true;
                } else {
                    System.out.println("MiniLobbyRisk unknown command " + command + " " + map);
                }
            }
// END TODO
            else {
                System.out.println("MiniLobbyRisk unknown object " + object);
            }
        }
        finally {
            LoadingManager.showLoadingScreen(false);
        }
    }

    /**
     * @see net.yura.domination.lobby.client.ClientGameRisk#gameString(java.lang.String)
     */
    public void stringForGame(String message) {
        if (openGame) {
            myrisk.parserFromNetwork(message);
        }
        else {
            logger.info("GAME NOT OPEN SO IGNORING: "+message);
        }
    }

    public void disconnected() {
        LoadingManager.showLoadingScreen(false);
        myrisk.disconnected();
    }

    public void connected(String username) {
        GameSound.INSTANCE.playSound(GameSound.LOBBY_SET_NICK);
    }
    public void loginGoogle() {
    }
    public void gameStarted(int id) {
    }

    public void gameActionPerformed(int action) {
        String sound = null;
        switch (action) {
            case Game.STATE_CAN_JOIN: sound = GameSound.LOBBY_JOIN; break;
            case Game.STATE_CAN_LEAVE: sound = GameSound.LOBBY_LEAVE; break;
            case Game.STATE_CAN_WATCH: sound = GameSound.LOBBY_WATCH; break;
            case Game.STATE_CAN_PLAY: sound = GameSound.LOBBY_PLAY; break;
        }
        if (sound != null) {
            GameSound.INSTANCE.playSound(sound);
        }
    }


    WeakHashMap mapping = new WeakHashMap();
    MapPreviewClient mapPreviewClient = new MapPreviewClient() {
        public void publishMap(Map map) {
            mapMetaData(map);
        }
        public void publishImg(String mapUID) {
            lobby.getRoot().repaint();
        }
    };
    
    protected void mapMetaData(Map map) {
        // we do not care about the map metadata
    }

    public Icon getIconForGame(Game game) {
        String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());
        mapping.put(game, mapUID); // keep a strong ref to the mapUID as long as we have a strong ref to the game

        return mapPreviewClient.getIconForMap(mapUID);
    }

    public void lobbyShutdown() {
        mapPreviewClient.shutdown();

        GameSound.INSTANCE.setLobbyOpen(false);
    }

    public String getGameDescription(Game game) {
        return OnlineUtil.getGameDescriptionFromLobbyStartGameOption( game.getOptions() );
    }



    // WMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMW
    // WMWMWMWMWMWMWMWMWMWMWMWMWMW OnlineRisk MWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMW
    // WMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMWMW

    public void sendUserCommand(String messagefromgui) {
        lobby.sendGameMessage(messagefromgui);
    }

    public void sendGameCommand(String gameCommand) {
	// this happens for game commands on my go
        logger.info("ignore GameCommand " + gameCommand);
    }

    public void closeGame() {
        openGame = false;
        lobby.closeGame();
    }

    public void playerRenamed(String oldName, String newName, String newAddress, int newType) {
        if (oldName.equals(lobby.whoAmI())) {
            myrisk.setAddress("_watch_");
        }
        if (newName.equals(lobby.whoAmI())) {
            myrisk.setAddress(newAddress);
        }
    }
}
