// Yura Mamyrin, Group D

package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.RootPaneContainer;
import javax.swing.event.MouseInputListener;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.guishared.AboutDialog;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.ImageIcon;
import net.yura.domination.engine.translation.TranslationBundle;

/**
 * <p> Main Menu for FlashGUI </p>
 * @author Yura Mamyrin <yura@yura.net>
 * @author Christian Weiske <cweiske@cweiske.de>
 */
public class MainMenu extends JPanel implements MouseInputListener, KeyListener {

        /**
         * @see net.yura.domination.mobile.flashgui.DominationMain#product
         */
	private final static String product = "GameGUI for " + RiskUtil.GAME_NAME;
	private final static String version = "2";

	private Image MenuImage;
	private Image Server;
	private Risk myrisk;
	private FlashRiskAdapter fra;
	private boolean serverRunning;

	private JoinDialog joinDialog;

	private final static int BUTTON_EXIT		= 100;

	private final static int BUTTON_NEW		= 1;
	private final static int BUTTON_SERVER		= 2;
	private final static int BUTTON_LOADGAME	= 3;
	private final static int BUTTON_HELP		= 4;
	private final static int BUTTON_JOIN		= 5;
	private final static int BUTTON_ABOUT		= 6;
	private final static int BUTTON_LOBBY		= 7;
	private final static int BUTTON_DONATE		= 8;

	private JLabel lobby;

	private java.util.ResourceBundle resBundle = TranslationBundle.getBundle();

	private Cursor hand;
	private Cursor defaultCursor;

        private Frame window;
        private RootPaneContainer root;
        
	/**
	 * Creates a new MainMenu
	 * @param r the risk main program
	 */
	public MainMenu(Risk r,Frame gui,RootPaneContainer root) {
		myrisk = r;
                window = gui;
                this.root = root;

		fra = new FlashRiskAdapter(this, myrisk);

		MenuImage = RiskUIUtil.getUIImage(this.getClass(),"menu.jpg");

		Server = GraphicsUtil.getSubimage(MenuImage, 400, 490, 60, 60);

		Dimension menuSize = GraphicsUtil.newDimension(400, 550);

		addMouseListener(this);
		addMouseMotionListener(this);
		setPreferredSize(menuSize);
		setMinimumSize(menuSize);
		setMaximumSize(menuSize);

		//key control

		highlightButton=0;
		serverRunning = false;

		gui.setFocusTraversalKeysEnabled( false);
		gui.addKeyListener( this );

		setLayout(null);

		// (Risk.applet == null)?"mainmenu.online":"mainmenu.loading"

		lobby = new JLabel(resBundle.getString("mainmenu.globe.playonline"), new ImageIcon(getClass().getResource("earth.gif")), JLabel.CENTER);
		GraphicsUtil.setBounds(lobby, 152, 409, 95, 95);
		lobby.setHorizontalTextPosition(JLabel.CENTER);
                try {
                    lobby.setFont(new java.awt.Font("Arial", java.awt.Font.BOLD, getFont().getSize() + 5)); // 13 + 5 = 18
                }
                catch (Throwable th) {
                    Logger.getLogger(MainMenu.class.getName()).log(Level.INFO, "set font error", th);
                }

		lobby.setVisible( RiskUIUtil.checkForNoSandbox() );

		lobby.setForeground( Color.WHITE );
		add(lobby);

		hand = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);
		defaultCursor = getCursor();
                
                JPopupMenu rightClickMenu = new JPopupMenu();
                rightClickMenu.add(resBundle.getString("swing.menu.options")).addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fra.getGameFrame().openOptions();
                    }
                });
                rightClickMenu.add("+").addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fontSize(1);
                    }
                });
                rightClickMenu.add("-").addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fontSize(-1);
                    }
                });
                setComponentPopupMenu(rightClickMenu);
                
                showMainMenu();
	}
        
        private void fontSize(int num) {
            RiskUIUtil.fontSize(num);
            fra.updateLookAndFeel();
        }

	/**
	 * Checks the server's state
	 * @param s The server's state
	 */
	public void setServerRunning(boolean s) {
		serverRunning = s;
		repaint();
	}

	public void hideJoinDialog(boolean a) {

		if (!a) {
			joinDialog.exitForm();
			joinDialog = null;
		}

		addMouseListener(this);
		addMouseMotionListener(this);

		//loading.setVisible(false);

		setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}

	public void paintComponent(Graphics g) {

			GraphicsUtil.drawImage(g, MenuImage, 0, 0, 400, 550, 	0, 0, 400, 550, this);

			if (highlightButton==BUTTON_NEW) {
				GraphicsUtil.drawImage(g, MenuImage, 57, 219, 187, 269,	400, 0, 530, 50, this);
			}
			else if (highlightButton==BUTTON_SERVER) {
				GraphicsUtil.drawImage(g, MenuImage, 212, 219, 342, 269,	400, 50, 530, 100, this);
			}
			else if (highlightButton==BUTTON_LOADGAME) {
				GraphicsUtil.drawImage(g, MenuImage, 57, 279, 187, 329,	400, 100, 530, 150, this);
			}
			else if (highlightButton==BUTTON_JOIN) {
				GraphicsUtil.drawImage(g, MenuImage, 212, 279, 342, 329,	400, 150, 530, 200, this);
			}
			else if (highlightButton==BUTTON_HELP) {
				GraphicsUtil.drawImage(g, MenuImage, 57, 339, 187, 389,	400, 200, 530, 250, this);
			}
			else if (highlightButton==BUTTON_ABOUT) {
				GraphicsUtil.drawImage(g, MenuImage, 212, 339, 342, 389,	400, 250, 530, 300, this);
			}
			//else if (highlightButton==BUTTON_LOBBY) {
			//	drawImage(g, MenuImage, 145, 401, 255, 511,	400, 300, 510, 410, this);
			//}


			else if (button==BUTTON_NEW) {
				GraphicsUtil.drawImage(g, MenuImage, 57, 219, 187, 269,	530, 0, 660, 50, this);
			}
			else if (button==BUTTON_SERVER) {
				GraphicsUtil.drawImage(g, MenuImage, 212, 219, 342, 269,	530, 50, 660, 100, this);
			}
			else if (button==BUTTON_LOADGAME) {
				GraphicsUtil.drawImage(g, MenuImage, 57, 279, 187, 329,	530, 100, 660, 150, this);
			}
			else if (button==BUTTON_JOIN) {
				GraphicsUtil.drawImage(g, MenuImage, 212, 279, 342, 329,	530, 150, 660, 200, this);
			}
			else if (button==BUTTON_HELP) {
				GraphicsUtil.drawImage(g, MenuImage, 57, 339, 187, 389,	530, 200, 660, 250, this);
			}
			else if (button==BUTTON_ABOUT) {
				GraphicsUtil.drawImage(g, MenuImage, 212, 339, 342, 389,	530, 250, 660, 300, this);
			}
			//else if (button==BUTTON_LOBBY) {
			//	drawImage(g, MenuImage, 145, 401, 255, 511,	530, 300, 640, 410, this);
			//}

			Graphics2D g2 = (Graphics2D)g;

			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

			g2.setColor( Color.black );

			/* This adds underlines to the strings, but it doesn't look good and is too much effort for that
			java.text.AttributedString as = new java.text.AttributedString(resBundle.getString( "mainmenu.newgame"));
			as.addAttribute(java.awt.font.TextAttribute.UNDERLINE, java.awt.font.TextAttribute.UNDERLINE_ON, 0,1);
			as.addAttribute(java.awt.font.TextAttribute.FONT, font);
			tl = new TextLayout( as.getIterator(), frc);
			*/
			
                        GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.newgame"), 'N', 122, 247);

			if (serverRunning) {
                                GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.stopserver"), 'S', 277, 247);
				GraphicsUtil.drawImage(g, Server, 340, 490, this);
			}
			else {
                                GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.startserver"), 'S', 277, 247);
			}

                        GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.loadgame"), 'L', 122, 309);

                        GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.joingame"), 'J', 277, 309);

                        GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.help"), 'H', 122, 369);

                        GraphicsUtil.drawStringCenteredAt(g2, resBundle.getString("mainmenu.about"), 'A', 277, 369);

			//font = new java.awt.Font("Arial", java.awt.Font.BOLD, 24);
			//tl = new TextLayout( resBundle.getString( "mainmenu.quit") , font, frc);
			//tl.draw( g2, (float) (200-tl.getBounds().getWidth()/2), (float)465 );
	}

	private int button;
	private int currentButton;
	private int pressedButton;
	private int highlightButton;

	//**********************************************************************
	//                     MouseListener Interface
	//**********************************************************************

        /**
         * WARNING! This method does not work on macOS High Sierra, java 1.8
         */
	public void mouseClicked(MouseEvent e) { }

	public void mouseEntered(MouseEvent e) { }

	public void mouseExited(MouseEvent e) { }

	/**
	 * Works out what to do when the move has been presed
	 * @param e A mouse event
	 */
	public void mousePressed(MouseEvent e) {

		highlightButton = 0;
		currentButton=insideButton(e.getX(),e.getY());

		if (currentButton != 0) {
			pressedButton = currentButton;
			button = currentButton;
			repaint();
		}

	}

	/**
	 * Works out what to do when a mouse has been released
	 * @param e A mouse event
	 */
	public void mouseReleased(MouseEvent e) {
		int thebutton=0;

		if (pressedButton == currentButton) {
			thebutton = pressedButton;
		}

		if (button != 0) {
			button=0;
		}

		highlightButton=currentButton;
		repaint();
		activateButton( thebutton);
	}//public void mouseReleased(MouseEvent e)

	/**
	 * a button shall be activated
	 */
	private void activateButton(int thebutton) {
		if (thebutton != 0) {
                    
                        GameSound.INSTANCE.playSound(thebutton == MainMenu.BUTTON_LOBBY ? GameSound.LOBBY_START : GameSound.MENU_BUTTON);
                    
			switch (thebutton) {
				case MainMenu.BUTTON_NEW:{

					myrisk.parser("newgame");

					setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

					removeMouseListener(this);
					removeMouseMotionListener(this);

					//loading.setVisible(true);

					break;
				}
				case MainMenu.BUTTON_SERVER: {

					if (serverRunning) {
						myrisk.parser("killserver");
					}
					else {
						myrisk.parser("startserver");
					}
					break;
				}
				case MainMenu.BUTTON_LOADGAME: {

					String name = RiskUIUtil.getLoadFileName(
						window
						//RiskUtil.SAVES_DIR,
						//RiskFileFilter.RISK_SAVE_FILES
					);

					if (name!=null) {
						myrisk.parser("loadgame " + name );
					}
					break;
				}
				case MainMenu.BUTTON_HELP: {

					try {
						RiskUtil.openDocs( TranslationBundle.getBundle().getString( "helpfiles.flash" ) );
					}
					catch(Exception e) {
						JOptionPane.showMessageDialog(window ,"Unable to open manual: "+e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
					}

					break;
				}
				case MainMenu.BUTTON_JOIN: {

					joinDialog = new JoinDialog(window, true, myrisk);
					Dimension frameSize = window.getSize();
					Dimension aboutSize = joinDialog.getPreferredSize();
					int x = window.getLocation().x + (frameSize.width - aboutSize.width) / 2;
					int y = window.getLocation().y + (frameSize.height - aboutSize.height) / 2;
					if (x < 0) x = 0;
					if (y < 0) y = 0;
					joinDialog.setLocation(x, y+10);

					joinDialog.setVisible(true);
					break;
				}
				case MainMenu.BUTTON_LOBBY: {
					if (lobby.isVisible()) {
						try {
							//RiskUIUtil.runLobby(myrisk);
							fra.showMiniLobby(root, window);
						}
						catch(Throwable e) {
							JOptionPane.showMessageDialog(window, "Unable to run lobby: " + e, "Error", JOptionPane.ERROR_MESSAGE);
                                                        // TODO when does this happen? why did we ignore this error?
                                                        RiskUtil.printStackTrace(e);
						}
					}
					break;
				}
				case MainMenu.BUTTON_ABOUT: {
					openAbout();
					break;
				}
				case MainMenu.BUTTON_EXIT: {
					exit();
					break;
				}
				case MainMenu.BUTTON_DONATE: {
					RiskUIUtil.donate(this);
					break;
				}
			}//switch end

			currentButton=0;
			//do we need this?
//			highlightButton=currentButton;
			repaint();

		}
	}//private void activateButton(int thebutton)
        
        void openAbout() {
            RiskUIUtil.openAbout(window, product, version);
        }

	/**
	 * Checks if highlighting is needed
	 * @param e A mouse event
	 */
	public void mouseMoved(MouseEvent e) {

		int oldhighlightButton = highlightButton;
		int newhighlightButton = insideButton(e.getX(),e.getY());

		if (oldhighlightButton != newhighlightButton) {
			highlightButton = newhighlightButton;
			repaint();
		}

		if (newhighlightButton==BUTTON_DONATE) {
			if (getCursor()==defaultCursor) {
				setCursor(hand);
			}
		}
		else if (getCursor()==hand) {
			setCursor(defaultCursor);
		}
	}

	/**
	 * Works out what to do when the mouse is dragged
	 * @param e A mouse event
	 */
	public void mouseDragged(MouseEvent e) {

		currentButton = insideButton(e.getX(),e.getY());

		if (pressedButton == currentButton ) {
			if (button!=pressedButton) {
				button=pressedButton;
				repaint();
			}
		}
		else {
			if (button !=0) {
				button = 0;
				repaint();
			}
		}
	}

	/**
	 * Works out what button has been pressed
	 * @param x x co-ordinate
	 * @param y y co-ordinate
	 * @return int The type of button presssed
	 */
	public int insideButton(int x, int y) {
		int W=116;
		int H=31;
		int r = lobby.getWidth() / 2;

		if (GraphicsUtil.insideButton(x, y, 65, 228, W, H)) {
			return BUTTON_NEW;
		}
		if (GraphicsUtil.insideButton(x, y, 220, 228, W, H)) {
			return BUTTON_SERVER;
		}
		if (GraphicsUtil.insideButton(x, y, 65, 289, W, H)) {
			return BUTTON_LOADGAME;
		}
		if (GraphicsUtil.insideButton(x, y, 220, 289, W, H)) {
			return BUTTON_JOIN;
		}
		if (GraphicsUtil.insideButton(x, y, 65, 350, W, H)) {
			return BUTTON_HELP;
		}
		if (GraphicsUtil.insideButton(x, y, 220, 350, W, H)) {
			return BUTTON_ABOUT;
		}
		if (GraphicsUtil.insideButton(x, y, 0, 500, 130, 50)) {
			return BUTTON_DONATE;
		}
                // check if we are in the circle lobby button
		if (Math.sqrt(Math.pow(x - (lobby.getX() + r), 2) + Math.pow(y - (lobby.getY() + r), 2)) < r) {
			return BUTTON_LOBBY;
		}
                return 0;
	}

	/**
	 * key control
	 * the user has released a key
	 */
	public void keyReleased( KeyEvent event ) {
		switch (event.getKeyCode()) {
			//tab to the next button
			case KeyEvent.VK_TAB:
				if (event.isShiftDown()) {
					//Shift + Tab -> backwards
					highlightButton--;
				} else {
					//tab only -> forward
					highlightButton++;
				}
				if (highlightButton > 7) {
					highlightButton = 1;
				} else if (highlightButton < 1) {
					highlightButton = 7;
				}
				repaint();
				break;

			//activate the current button
			case KeyEvent.VK_SPACE:
			case KeyEvent.VK_ENTER:
				activateButton( highlightButton);
				break;

			//new game
			case KeyEvent.VK_N:
				activateButton( MainMenu.BUTTON_NEW);
				break;

			//load game
			case KeyEvent.VK_L:
				activateButton( MainMenu.BUTTON_LOADGAME);
				break;

			//exit
			case KeyEvent.VK_Q:
			case KeyEvent.VK_ESCAPE:
				activateButton( MainMenu.BUTTON_EXIT);
				break;

			//join game
			case KeyEvent.VK_J:
				activateButton(MainMenu.BUTTON_JOIN);
				break;

			//about
			case KeyEvent.VK_A:
				activateButton( MainMenu.BUTTON_ABOUT);
				break;

			//server
			case KeyEvent.VK_S:
				activateButton( MainMenu.BUTTON_SERVER);
				break;

			//help
			case KeyEvent.VK_H:
				activateButton(MainMenu.BUTTON_HELP);
				break;

			// lobby
			case KeyEvent.VK_O:
				activateButton( MainMenu.BUTTON_LOBBY);
				break;

			case KeyEvent.VK_PLUS:
			case KeyEvent.VK_EQUALS:
				fontSize(1);
				break;

			case KeyEvent.VK_MINUS:
				fontSize(-1);
				break;
		}//switch keycode
	}//public void keyReleased( KeyEvent event )

	//I don't want these, but we implement the interface
	public void keyPressed( KeyEvent event ) {}
	public void keyTyped( KeyEvent event ) {}

	private void exit() {

		//Frame frame = RiskUtil.findParentFrame(this);
		//
		//if ( frame instanceof JFrame && ((JFrame)frame).getDefaultCloseOperation() == JFrame.EXIT_ON_CLOSE && RiskUtil.checkForNoSandbox()) {
		//
		//	// not actually needed as it will auto be done
		//	System.exit(0);
		//}

		myrisk.deleteRiskListener(fra);

		//frame.setVisible(false);
		//frame.dispose();
	}

        public void hide() {
            window.setVisible(false);
        }
        public void show() {
            window.setVisible(true);
        }
        
        void showMainMenu() {
            root.setContentPane( this );
            window.setTitle( TranslationBundle.getBundle().getString( "mainmenu.title"));
            window.setResizable(false);
            window.pack();
        }

	/**
	 * This runs the program
	 * @param argv
	 */
	public static void main(String[] argv) {

                // we HAVE to set this before any swing components are created
                System.setProperty( "apple.awt.application.name", RiskUtil.GAME_NAME);

                // we do this before graasshopper init as we set the app locale here
		RiskUIUtil.parseArgs(argv);

                try {
                    BugLogger.initGrasshopper();
                }
                catch(Throwable th) {
                    System.out.println("Grasshopper not loaded " + th);
                }

                Risk risk = new Risk();

                // before we create any UI, we want to load up all settings
                Preferences prefs = RiskSettings.getPreferences(MainMenu.class);
                RiskSettings.loadSettingsFromPrefs(prefs);
                RiskUIUtil.setColorBlindMode(prefs);

                RiskUIUtil.initAudio(risk);

		final MainMenu mainMneu = newMainMenuFrame(risk, JFrame.EXIT_ON_CLOSE );

                try {
                    // as we still release for java 1.5+ use reflection to call this
                    //Desktop desktop = Desktop.getDesktop();
                    //if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                    //    desktop.setAboutHandler(new AboutHandler() {
                    //        @Override
                    //        public void handleAbout(AboutEvent e) {
                    //            mainMneu.openAbout();
                    //        }
                    //    });
                    //}
                    
                    // we can NOT make a local variable 'desktop' as this will fail on java 1.5 NoClassDefFoundError
                    //java.awt.Desktop desktop = java.awt.Desktop.getDesktop();
                    if (java.awt.Desktop.getDesktop().isSupported(java.awt.Desktop.Action.valueOf("APP_ABOUT"))) {
                        JavaCompatUtil.setLambda(java.awt.Desktop.getDesktop(), "setAboutHandler", "java.awt.desktop.AboutHandler", new Runnable() {
                            @Override
                            public void run() {
                                mainMneu.openAbout();
                            }
                        });
                    }
                }
                catch(Throwable th) {
                    // ignore
                }

                try {
                    if (java.awt.Desktop.getDesktop().isSupported(java.awt.Desktop.Action.valueOf("APP_PREFERENCES"))) {
                        JavaCompatUtil.setLambda(java.awt.Desktop.getDesktop(), "setPreferencesHandler", "java.awt.desktop.PreferencesHandler", new Runnable() {
                            @Override
                            public void run() {
                                mainMneu.fra.getGameFrame().openOptions();
                            }
                        });
                    }
                }
                catch(Throwable th) {
                    // ignore
                }
                
                RiskUIUtil.openFile(argv, risk);

		RiskUIUtil.checkForUpdates(risk);
	}

	public static MainMenu newMainMenuFrame(Risk risk, int defaultCloseOperation) {

		JFrame gui = new JFrame();

                gui.setIconImage(Toolkit.getDefaultToolkit().getImage( AboutDialog.class.getResource("icon.gif") ));

		final MainMenu mm = new MainMenu(risk, gui, gui);

                gui.setDefaultCloseOperation(defaultCloseOperation);
		gui.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent evt) {                        
                        mm.exit();
                    }
		});

                RiskUIUtil.center(gui);
		mm.show();

		return mm;
	}
}
