# Contributing

Contributions are always welcomed, so start sending some PRs!

## Getting Started

Clone the repository:

    git clone https://github.com/HarveyHunt/i3situation.git
  
Change to the develop branch:

    git checkout develop
  
Hack away until your heart is content.

## Code Style

I try to follow the [PEP8](http://legacy.python.org/dev/peps/pep-0008/) as closely as sanely possible.

Running a code linter, such as [PyFlakes](https://launchpad.net/pyflakes) is always a nice idea- try to minimise errors.

The hard rules are as follows:

  * 4 spaces per tab
  * use_of_underscores_for_functions_variables_etc
  * Code should be pythonic.
  
## What comes after code?

You have written an awesome new feature and want to get it merged straight away- have you forgotten something?

Documentation is an important part of any project, i3situation is no different. Document all new features, as has been done
in the README already.

If you're feeling especially kind and in a Python mood, try to add some unit tests for your new feature- or even more parts of i3situation in general.

## Sending PRs
  
Once you have made some cool changes, push to github and send a PR.

Make sure that the PR is targeted at the develop branch, as packages are built from the master branch.

