# DSE Typewriter

<https://webonastick.com/fonts/dse-typewriter/>

![Printed Example](images/dse-typewriter-printed.jpg)

A project to create a coding font inspired by early 20th-century
typewriters.

And to practice editing fonts directly in FontForge.

## About This Font

This font is not the result of any scans or traces of samples,
specimens, or other output from an actual typewriter.  I personally
eyeballed and drew everything in FontForge.

DSE Typewriter is more like an amalgamation of old-school typewriter
fonts with features semi-arbitrarily picked from each one, as well as
a few coding-friendly features that were not in use on actual
typewriters of the period.

Though this is intended to be useful as a coding font, I emphasized on
aesthetics while maintaining some degree of readability.  There is
room for improvement.  I may create a version of this that borrows
from old "reproducing typewriter" fonts (e.g., Monotype No. 72L,
Reproducing Typewriter).

## Features and Characteristics

-   Relatively low ex-height.

-   Lining numerals, i.e., all start at the baseline and end at the
    same height.

-   Full ASCII and Latin-1 coverage, along with selected extended
    Latin, punctuation, graphic, and currency symbols.

    Includes every character you can type in the US International
    Layout in Windows.

    Includes every character you can type on a Mac when the input
    source is U.S.

    Includes all box drawing characters.

    Supports most western European languages.

    Includes basic Cyrillic.

-   Coding-friendly distinctive characters: `li1|` `Oo0` `` `'" ``

-   Elite scale typeface (12 characters per inch at 12-point font
    size).

-   Perfectly useful as a traditional typewriter face for other
    purposes, if you don&rsquo;t mind the zero (0) having a dot in the
    middle.

## Caveats and Answers to Questions You Might Ask

-   There aren't any hints, so on certain platforms, this font may not
    be readable at lower font sizes.  Auto-hints seem to work okay-ish
    in Windows Google Chrome.

    Chances are, at any particular point in time, my brain is too mush
    to learn how to do those.

-   This is most definitely a work in progress.

## Variants

-   `dse-typewriter-font.ttf` is the base variant.

-   `dse-typewriter-font-lh.ttf` adds metrics based on a 1.2-em line
    height.

## See Also

See <https://github.com/dse/dse-typewriter-bitmap-font/> for DSE
Typewriter Bitmap, a couple bitmap fonts I created **long** ago.  They
also have coding-friendly features, but only cover ASCII and Latin-1.
There is a `.bdf` version for use in the X Window System and other
environments that support it, and there is a `.ttf` version.

## License

[SIL OFL 1.1](LICENSE.md)

## Bug fixes?

Open an issue in Github or email me.  Either way is fine.

## Shoutouts, Thanks, etc.

-   **Guy Ollerearnshaw**, for pointing out a bug in U+2567.

## Preview

![Sample (Mac)](images/sample-mac.png)

![Sample (Windows)](images/sample-windows.png)

![Coding (Mac)](images/coding-mac.png)

![Coding (Windows)](images/coding-windows.png)
