# Choosing an issue to work on

So you want to contribute to Element Web? That is awesome!

If you're not sure where to start, make sure you read
[CONTRIBUTING.md](../CONTRIBUTING.md), and the
[Development](../README.md#development) and
[Setting up a dev environment](../README.md#setting-up-a-dev-environment)
sections of the README.

Maybe you've got something specific you'd like to work on? If so, make sure you
create an issue and
[discuss it with the developers](https://matrix.to/#/#element-dev:matrix.org)
before you put a lot of time into it.

If you're looking for inspiration on where to start, keep reading!

## Finding a good first issue

All the issues for Element Web live in the
[element-web](https://github.com/element-hq/element-web) repository, including
issues that actually need fixing in one of the related repos.

The first place to look is for
[issues tagged with "good first issue"](https://github.com/element-hq/element-web/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22).

Look through that list and find something that catches your interest. If there
is nothing, there, try gently asking in
[#element-dev:matrix.org](https://matrix.to/#/#element-dev:matrix.org) for
someone to add something.

When you're looking through the list, here are some things that might make an
issue a **GOOD** choice:

- It is a problem or feature you care about.
- It concerns a type of code you know a little about.
- You think you can understand what's needed.
- It already has approval from Element Web's designers (look for comments from
  members of the
  [Product](https://github.com/orgs/element-hq/teams/product/members) or
  [Design](https://github.com/orgs/element-hq/teams/design/members) teams).

Here are some things that might make it a **BAD** choice:

- You don't understand it (maybe add a comment asking a clarifying question).
- It sounds difficult, or is part of a larger change you don't know about.
- **It is tagged with `X-Needs-Design` or `X-Needs-Product`.**

**Element Web's Design and Product teams tend to be very busy**, so if you make
changes that require approval from one of those teams, you will probably have
to wait a very long time. The kind of change affected by this is changing the
way the product works, or how it looks in a specific area.

## Finding a good second issue

Once you've fixed a few small things, you can consider taking on something a
little larger. This should mostly be driven by what you find interesting, but
you may also find the
[Help Wanted](https://github.com/element-hq/element-web/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3A%22Help+Wanted%22)
label useful.

Note that the same comment applies as in the previous section: if you want to
work in areas that require Design or Product approval, you should look to join
existing work that is already designed, as getting approval for your random
change will take a very long time.

So you should **always avoid issues tagged with `X-Needs-Design` or
`X-Needs-Product`**.

## Asking questions

Feel free to ask questions about the issues or how to choose them in the
[#element-dev:matrix.org](https://matrix.to/#/#element-dev:matrix.org) Matrix
room.

## Thank you

Thank you again for contributing to Element Web. We welcome your contributions
and are grateful for your work. We find working on it great fun, and we hope
you do too!
