# oscar64

Oscar64 is a C/C++ cross compiler running on a modern system (such as a Windows PC, Mac or Linux machine) and targets the classic 6502 family of processors.  It is mainly focused on Commodore systems such as the C64, PET or VIC20.  The compiler supports C99 and many C++ features up to variadic templates and lambda functions.

The purpose of this compiler is to eliminate the need to write 6502 assembler code to achieve high code density and fast execution speed.  It continues to improve with all the games, demos and tools written by it.  It supports disk overlays and banked cartridges for larger projects.

The C64 executes 442 dhrystone V2.2 iteration per second, when compiled with Oscar64 and -O3 (which shows that the ancient dhrystone benchmark is no match to an optimizing compiler).

[Full reference manual](oscar64.md)
[Additional samples and tutorials](https://github.com/drmortalwombat/OscarTutorials)

# References

This is a list of the games written with Oscar64, have a look if you are not convinced that fast paced action games can be written in C/C++ on a C64 (they are all free).

[Ball and Chain](https://drmortalwombat.itch.io/ball-and-chain)

[Balls like a Frog](https://drmortalwombat.itch.io/balls-like-a-frog)

![cores4](https://github.com/user-attachments/assets/15c2bcc7-eafb-44fb-aec2-e5cb101c687b)
[Corescape](https://drmortalwombat.itch.io/corescape)

[MetalMayhem](https://drmortalwombat.itch.io/metal-mayhem)

[Mineshaft Gap](https://drmortalwombat.itch.io/mineshaft-gap)

[Minotrace](https://drmortalwombat.itch.io/minotrace)

[Missile Defence](https://drmortalwombat.itch.io/missile-defence)

![cl1b](https://github.com/user-attachments/assets/0d249274-6dab-4284-89e5-ada07fac1986)
[Portal Buster](https://drmortalwombat.itch.io/portal-buster)

[Roguebot](https://drmortalwombat.itch.io/roguebot)

[Shallow Domains](https://drmortalwombat.itch.io/shallow-domains)

[Veggies vs Undead](https://drmortalwombat.itch.io/veggies-vs-undead)


