#ifndef CRT_H
#define CRT_H

extern char spentry;

enum ByteCode
{
	BC_NOP,
	BC_EXIT,

	BC_CONST_8,
	BC_CONST_P8,
	BC_CONST_N8,
	BC_CONST_16,
	BC_CONST_32,

	BC_LOAD_REG_8,
	BC_STORE_REG_8,
	BC_LOAD_REG_16,
	BC_STORE_REG_16,
	BC_ADDR_REG,
	BC_LOAD_REG_32,
	BC_STORE_REG_32,

	BC_LOAD_ABS_8,
	BC_LOAD_ABS_U8,
	BC_LOAD_ABS_16,
	BC_LOAD_ABS_32,
	BC_LOAD_ABS_ADDR,

	BC_STORE_ABS_8,
	BC_STORE_ABS_16,
	BC_STORE_ABS_32,

	BC_LEA_ABS,
	BC_LEA_ABS_INDEX,
	BC_LEA_ABS_INDEX_U8,
	BC_LEA_ACCU_INDEX,

	BC_LOAD_LOCAL_8,
	BC_LOAD_LOCAL_U8,
	BC_LOAD_LOCAL_16,
	BC_LOAD_LOCAL_32,

	BC_STORE_LOCAL_8,
	BC_STORE_LOCAL_16,
	BC_STORE_LOCAL_32,

	BC_LEA_LOCAL,

	BC_STORE_FRAME_8,
	BC_STORE_FRAME_16,
	BC_STORE_FRAME_32,

	BC_LEA_FRAME,

	BC_LOAD_ADDR_8,
	BC_LOAD_ADDR_U8,
	BC_LOAD_ADDR_16,
	BC_LOAD_ADDR_32,

	BC_STORE_ADDR_8,
	BC_STORE_ADDR_16,
	BC_STORE_ADDR_32,

	BC_BINOP_ADDR_16,
	BC_BINOP_SUBR_16,
	BC_BINOP_ANDR_16,
	BC_BINOP_ORR_16,
	BC_BINOP_XORR_16,
	BC_BINOP_MULR_16,
	BC_BINOP_DIVR_U16,
	BC_BINOP_MODR_U16,
	BC_BINOP_DIVR_I16,
	BC_BINOP_MODR_I16,
	BC_BINOP_SHLR_16,
	BC_BINOP_SHRR_U16,
	BC_BINOP_SHRR_I16,

	BC_BINOP_ADDA_16,

	BC_BINOP_ADDI_16,
	BC_BINOP_SUBI_16,
	BC_BINOP_ANDI_16,
	BC_BINOP_ORI_16,
	BC_BINOP_MULI8_16,

	BC_BINOP_ADDI_8,
	BC_BINOP_ANDI_8,
	BC_BINOP_ORI_8,

	BC_BINOP_SHLI_16,
	BC_BINOP_SHRI_U16,
	BC_BINOP_SHRI_I16,

	BC_BINOP_CMPUR_16,
	BC_BINOP_CMPSR_16,
	
	BC_BINOP_CMPUI_16,
	BC_BINOP_CMPSI_16,

	BC_BINOP_CMPUR_8,
	BC_BINOP_CMPSR_8,
	
	BC_BINOP_CMPUI_8,
	BC_BINOP_CMPSI_8,

	BC_OP_NEGATE_16,
	BC_OP_INVERT_16,

	BC_BINOP_ADD_F32,
	BC_BINOP_SUB_F32,
	BC_BINOP_MUL_F32,
	BC_BINOP_DIV_F32,
	BC_BINOP_CMP_F32,
	BC_OP_NEGATE_F32,
	BC_OP_ABS_F32,
	BC_OP_FLOOR_F32,
	BC_OP_CEIL_F32,

	BC_CONV_U16_F32,
	BC_CONV_I16_F32,
	BC_CONV_F32_U16,
	BC_CONV_F32_I16,

	BC_CONV_I8_I16,

	BC_JUMPS,
	BC_BRANCHS_EQ,
	BC_BRANCHS_NE,
	BC_BRANCHS_GT,
	BC_BRANCHS_GE,
	BC_BRANCHS_LT,
	BC_BRANCHS_LE,

	BC_JUMPF,
	BC_BRANCHF_EQ,
	BC_BRANCHF_NE,
	BC_BRANCHF_GT,
	BC_BRANCHF_GE,
	BC_BRANCHF_LT,
	BC_BRANCHF_LE,

	BC_LOOP_U8,
	BC_MALLOC,
	BC_FREE,
	BC_FILL,
	BC_FILL_LONG,
	BC_UNUSED_6,

	BC_JSR,

	BC_NATIVE = 0x75,

	BC_ENTER,
	BC_RETURN,
	BC_CALL_ADDR,
	BC_CALL_ABS,
	BC_PUSH_FRAME,
	BC_POP_FRAME,

	BC_COPY,
	BC_COPY_LONG,
	BC_STRCPY,

	BC_EXTRT,

	BC_CONV_I16_I32 = 0x80,
	BC_CONV_U16_U32,

	BC_OP_NEGATE_32,
	BC_OP_INVERT_32,

	BC_BINOP_ADD_L32,
	BC_BINOP_SUB_L32,	
	BC_BINOP_AND_L32,
	BC_BINOP_OR_L32,
	BC_BINOP_XOR_L32,	
	BC_BINOP_MUL_L32,
	BC_BINOP_DIV_U32,
	BC_BINOP_MOD_U32,
	BC_BINOP_DIV_I32,
	BC_BINOP_MOD_I32,
	BC_BINOP_SHL_L32,
	BC_BINOP_SHR_U32,
	BC_BINOP_SHR_I32,
	BC_BINOP_CMP_U32,
	BC_BINOP_CMP_S32,

	BC_CONV_U32_F32,
	BC_CONV_I32_F32,
	BC_CONV_F32_U32,
	BC_CONV_F32_I32,
};

#endif
