package locales

var dict_ashkenazi = map[string]string{
	"Achrei Mot": "Achrei Mos",
	"Alot HaShachar": "Alos HaShachar",
	"Asara B'Tevet": "Asara B’Teves",
	"Asara B'Tevet (Mincha)": "Asara B’Teves (Mincha)",
	"Avot": "Avos",
	"Baba Batra": "Baba Basra",
	"Bechorot": "Bechoros",
	"Bechukotai": "Bechukosai",
	"Beha'alotcha": "Beha’aloscha",
	"Bekhorot": "Bekhoros",
	"Berachot": "Berachos",
	"Berakhot": "Berakhos",
	"Bereshit": "Bereshis",
	"Birkat Hachamah": "Birkas Hachamah",
	"Chanukah Day 1 (on Shabbat)": "Chanukah Day 1 (on Shabbos)",
	"Chanukah Day 2 (on Shabbat)": "Chanukah Day 2 (on Shabbos)",
	"Chanukah Day 3 (on Shabbat)": "Chanukah Day 3 (on Shabbos)",
	"Chanukah Day 4 (on Shabbat)": "Chanukah Day 4 (on Shabbos)",
	"Chanukah Day 5 (on Shabbat)": "Chanukah Day 5 (on Shabbos)",
	"Chanukah Day 7 (on Shabbat)": "Chanukah Day 7 (on Shabbos)",
	"Chanukah Day 8 (on Shabbat)": "Chanukah Day 8 (on Shabbos)",
	"Chatzot HaLailah": "Chatzos HaLailah",
	"Chatzot hayom": "Chatzos",
	"Chukat": "Chukas",
	"Eduyot": "Eduyos",
	"Erev Shavuot": "Erev Shavuos",
	"Erev Sukkot": "Erev Sukkos",
	"Horayot": "Horayos",
	"Keritot": "Kerisos",
	"Ketubot": "Kesubos",
	"Ki Tavo": "Ki Savo",
	"Ki Teitzei": "Ki Seitzei",
	"Ki Tisa": "Ki Sisa",
	"Kriat Shema, sof zeman": "Krias Shema, sof zman",
	"Kriat Shema, sof zeman (MGA)": "Krias Shema, sof zman (MGA)",
	"Leil Selichot": "Leil Selichos",
	"Maasrot": "Maasros",
	"Makkot": "Makkos",
	"Matot": "Matos",
	"Menachot": "Menachos",
	"Middot": "Middos",
	"Midot": "Midos",
	"Mikvaot": "Mikvaos",
	"Oholot": "Oholos",
	"Parashat": "Parshas",
	"Pesach I (on Shabbat)": "Pesach I (on Shabbos)",
	"Pesach Shabbat Chol ha-Moed": "Pesach Shabbos Chol ha-Moed",
	"Pesach VII (on Shabbat)": "Pesach VII (on Shabbos)",
	"Pesach VIII (on Shabbat)": "Pesach VIII (on Shabbos)",
	"Purim Katan": "Purim Koton",
	"Rosh Hashana I (on Shabbat)": "Rosh Hashana I (on Shabbos)",
	"Shabbat": "Shabbos",
	"Shabbat Chazon": "Shabbos Chazon",
	"Shabbat HaChodesh": "Shabbos HaChodesh",
	"Shabbat HaGadol": "Shabbos HaGadol",
	"Shabbat Machar Chodesh": "Shabbos Machar Chodesh",
	"Shabbat Mevarchim Chodesh": "Shabbos Mevorchim Chodesh",
	"Shabbat Nachamu": "Shabbos Nachamu",
	"Shabbat Parah": "Shabbos Parah",
	"Shabbat Rosh Chodesh": "Shabbos Rosh Chodesh",
	"Shabbat Rosh Chodesh Chanukah": "Shabbos Rosh Chodesh Chanukah",
	"Shabbat Shekalim": "Shabbos Shekalim",
	"Shabbat Shirah": "Shabbos Shirah",
	"Shabbat Shuva": "Shabbos Shuvah",
	"Shabbat Zachor": "Shabbos Zachor",
	"Shavuot": "Shavuos",
	"Shavuot I": "Shavuos I",
	"Shavuot II": "Shavuos II",
	"Shavuot II (on Shabbat)": "Shavuos II (on Shabbos)",
	"Shemot": "Shemos",
	"Sheviit": "Sheviis",
	"Shevuot": "Shevuos",
	"Shmini Atzeret": "Shmini Atzeres",
	"Shmini Atzeret (on Shabbat)": "Shmini Atzeres (on Shabbos)",
	"Shushan Purim Katan": "Shushan Purim Koton",
	"Simchat Torah": "Simchas Torah",
	"Sukkot": "Sukkos",
	"Sukkot Chol ha-Moed Day 1": "Sukkos Chol ha-Moed Day 1",
	"Sukkot Chol ha-Moed Day 2": "Sukkos Chol ha-Moed Day 2",
	"Sukkot Chol ha-Moed Day 3": "Sukkos Chol ha-Moed Day 3",
	"Sukkot Chol ha-Moed Day 4": "Sukkos Chol ha-Moed Day 4",
	"Sukkot Chol ha-Moed Day 5": "Sukkos Chol ha-Moed Day 5",
	"Sukkot Final Day (Hoshana Raba)": "Sukkos Final Day (Hoshana Raba)",
	"Sukkot I": "Sukkos I",
	"Sukkot I (on Shabbat)": "Sukkos I (on Shabbos)",
	"Sukkot II": "Sukkos II",
	"Sukkot II (CH''M)": "Sukkos II (CH’’M)",
	"Sukkot III (CH''M)": "Sukkos III (CH’’M)",
	"Sukkot IV (CH''M)": "Sukkos IV (CH’’M)",
	"Sukkot Shabbat Chol ha-Moed": "Sukkos Shabbos Chol ha-Moed",
	"Sukkot V (CH''M)": "Sukkos V (CH’’M)",
	"Sukkot VI (CH''M)": "Sukkos VI (CH’’M)",
	"Sukkot VII (Hoshana Raba)": "Sukkos VII (Hoshana Raba)",
	"Ta'anit Bechorot": "Ta’anis Bechoros",
	"Ta'anit Bechorot (Mincha)": "Ta’anis Bechorot (Mincha)",
	"Ta'anit Esther": "Ta’anis Esther",
	"Ta'anit Esther (Mincha)": "Ta’anis Esther (Mincha)",
	"Taanit": "Taanis",
	"Tahorot": "Tahoros",
	"Tefilah, sof zeman": "Tefilah, sof zman",
	"Tefilah, sof zeman (MGA)": "Tefilah, sof zman (MGA)",
	"Terumot": "Terumos",
	"Tevet": "Teves",
	"Toldot": "Toldos",
	"Tzeit HaKochavim": "Tzeis HaKochavim",
	"Vaetchanan": "Vaeschanan",
	"Vezot Haberakhah": "Vezos Haberakhah",
	"Yevamot": "Yevamos",
	"Yitro": "Yisro",
	"Yom Kippur (on Shabbat)": "Yom Kippur (on Shabbos)",
}

func Lookup_ashkenazi(s string) (string, bool) {
	v, ok := dict_ashkenazi[s]
	if ok {
		return v, true
	}
	return s, false
}
