package locales

var dict_ashkenazi_litvish = map[string]string{
	"Achrei Mot": "Achrei",
	"Adar": "Odor",
	"Adar I": "Odor Aleph",
	"Adar II": "Odor Beis",
	"Arachin": "Arochin",
	"Asara B'Tevet": "Asoro Beteyves",
	"Av": "Ov",
	"Avodah Zarah": "Aveydo Zoro",
	"Baba Batra": "Bovo Basro",
	"Baba Kamma": "Bovo Kamo",
	"Baba Metzia": "Bovo Metzio",
	"Balak": "Bolok",
	"Bamidbar": "Bamidbor",
	"Bechorot": "Bcheiros",
	"Bechukotai": "Bechukeisai",
	"Beha'alotcha": "Bahaaloscho",
	"Beitzah": "Beitzo",
	"Berachot": "Brochos",
	"Bereshit": "Breishis",
	"Bo": "Bei",
	"Candle lighting": "Hadlokas neyros",
	"Chagigah": "Chagigo",
	"Chanukah": "Chanukko",
	"Chanukah: 1 Candle": "Chanukko: 1 Candle",
	"Chanukah: 2 Candles": "Chanukko: 2 Candles",
	"Chanukah: 3 Candles": "Chanukko: 3 Candles",
	"Chanukah: 4 Candles": "Chanukko: 4 Candles",
	"Chanukah: 5 Candles": "Chanukko: 5 Candles",
	"Chanukah: 6 Candles": "Chanukko: 6 Candles",
	"Chanukah: 7 Candles": "Chanukko: 7 Candles",
	"Chanukah: 8 Candles": "Chanukko: 8 Candles",
	"Chanukah: 8th Day": "Chanukko: 8th Day",
	"Chayei Sara": "Chayei Soro",
	"Cheshvan": "Cheshvon",
	"Chukat": "Chukas",
	"Daf Yomi": "Daf Yeimi",
	"Days of the Omer": "Eimer",
	"Devarim": "Dvorim",
	"Erev Pesach": "Erev Peisach",
	"Erev Reish Hashana": "Erev Reish-Hashono",
	"Erev Shavuot": "Erev Shvuos",
	"Erev Simchat Torah": "Erev Simchas Teiro",
	"Erev Sukkot": "Erev Sukkos",
	"Erev Tish'a B'Av": "Erev Tisho Bov",
	"Eruvin": "Eiruvin",
	"Ha'azinu": "Haazinu",
	"Havdalah": "Havdolo",
	"Horayot": "Heiroyos",
	"Iyyar": "Iyyor",
	"Kedoshim": "Kdeishim",
	"Keritot": "Krisos",
	"Ketubot": "Ksubos",
	"Ki Tavo": "Ki-Sovo",
	"Ki Teitzei": "Ki-Seitzei",
	"Ki Tisa": "Ki-Siso",
	"Korach": "Keirach",
	"Lag BaOmer": "Lag Beimer",
	"Lech-Lecha": "Lech-Lecho",
	"Leil Selichot": "Slichos",
	"Makkot": "Makkos",
	"Matot": "Matos",
	"Megillah": "Megillo",
	"Meilah": "Meilo",
	"Menachot": "Menochos",
	"Metzora": "Metzeiro",
	"Midot": "Midos",
	"Miketz": "Mikeitz",
	"Mishpatim": "Mishpotim",
	"Moed Katan": "Meyed Koton",
	"Nasso": "Nosso",
	"Nazir": "Nozir",
	"Nedarim": "Nedorim",
	"Niddah": "Niddo",
	"Nisan": "Nison",
	"Nitzavim": "Nitzovim",
	"Noach": "Neiach",
	"Parashat": "Parshas",
	"Pekudei": "Pkudey",
	"Pesach": "Peisach",
	"Pesach I": "Peisach I",
	"Pesach II": "Peisach II",
	"Pesach II (CH''M)": "Peisach II (CH''M)",
	"Pesach III (CH''M)": "Peisach III (CH''M)",
	"Pesach IV (CH''M)": "Peisach IV (CH''M)",
	"Pesach Sheni": "Peisach Sheini",
	"Pesach V (CH''M)": "Peisach V (CH''M)",
	"Pesach VI (CH''M)": "Peisach VI (CH''M)",
	"Pesach VII": "Peisach VII",
	"Pesach VIII": "Peisach VIII",
	"Pesachim": "Psochim",
	"Pinchas": "Pinchos",
	"Purim Katan": "Purim Koton",
	"Re'eh": "Reei",
	"Reish Chodesh %s": "Reish Cheidesh %s",
	"Reish Hashana": "Reish Hashono",
	"Reish Hashana I": "Reish Hashono I",
	"Reish Hashana II": "Reish Hashono II",
	"Sh'lach": "Shlach",
	"Sh'vat": "Shvat",
	"Shabbat": "Shabbos",
	"Shabbat Chazon": "Shabbos Chazon",
	"Shabbat HaChodesh": "Shabbos HaCheidesh",
	"Shabbat HaGadol": "Shabbos HaGodol",
	"Shabbat Machar Chodesh": "Shabbos Mochor Cheidesh",
	"Shabbat Nachamu": "Shabbos Nachamu",
	"Shabbat Parah": "Shabbos Poro",
	"Shabbat Reish Chodesh": "Shabbos Reish Cheidesh",
	"Shabbat Shekalim": "Shabbos Shkolim",
	"Shabbat Shuva": "Shabbos Shuvo",
	"Shabbat Zachor": "Shabbos Zochor",
	"Shavuot": "Shvuos",
	"Shavuot I": "Shvuos I",
	"Shavuot II": "Shvuos II",
	"Shekalim": "Shkolim",
	"Shemot": "Shmeis",
	"Shevuot": "Shvuos",
	"Shmini Atzeret": "Shmini Atzeres",
	"Shushan Purim": "Shushon Purim",
	"Simchat Torah": "Simchas Teiro",
	"Sivan": "Sivon",
	"Sotah": "Seito",
	"Sukkah": "Sukko",
	"Sukkot": "Sukkos",
	"Sukkot I": "Sukkos I",
	"Sukkot II": "Sukkos II",
	"Sukkot II (CH''M)": "Sukkos II (CH''M)",
	"Sukkot III (CH''M)": "Sukkos III (CH''M)",
	"Sukkot IV (CH''M)": "Sukkos IV (CH''M)",
	"Sukkot V (CH''M)": "Sukkos V (CH''M)",
	"Sukkot VI (CH''M)": "Sukkos VI (CH''M)",
	"Sukkot VII (Hoshana Raba)": "Sukkos VII (Heishano Rabo)",
	"Ta'anit Bechorot": "Taanis Bchoros",
	"Ta'anit Esther": "Taanis Ester",
	"Taanit": "Taanis",
	"Tamid": "Tomid",
	"Temurah": "Tmuro",
	"Terumah": "Trumo",
	"Tetzaveh": "Tetzave",
	"Tevet": "Teyves",
	"Tish'a B'Av": "Tisho B'ov",
	"Tish'a B'Av (observed)": "Tisho B'ov (observed)",
	"Toldot": "Toldos",
	"Tu B'Av": "Tu B'ov",
	"Tu B'Shvat": "Tu BiShvat",
	"Tzom Gedaliah": "Tzom Gdalyo",
	"Vaera": "Voeiro",
	"Vaetchanan": "Voeschanan",
	"Vayera": "Vayeiro",
	"Vayeshev": "Vayeishev",
	"Vayetzei": "Vayeitzei",
	"Vayikra": "Vayikro",
	"Vezot Haberakhah": "Zeis Habrocho",
	"Yevamot": "Yevomos",
	"Yitro": "Yisro",
	"Yom Kippur Katan": "Yom Kippur Koton",
	"Yom Yerushalayim": "Yom Yerusholayim",
	"Yoma": "Yumo",
	"Zevachim": "Zvochim",
}

func Lookup_ashkenazi_litvish(s string) (string, bool) {
	v, ok := dict_ashkenazi_litvish[s]
	if ok {
		return v, true
	}
	return s, false
}
