package locales

var dict_ashkenazi_poylish = map[string]string{
	"Achrei Mot": "Achrai",
	"Adar": "Odor",
	"Adar I": "Odor Aleph",
	"Adar II": "Odor Beis",
	"Arachin": "Aruchin",
	"Asara B'Tevet": "Asoro Beteyves",
	"Av": "Ov",
	"Avodah Zarah": "Avoydu Zuru",
	"Baba Batra": "Buvu Basru",
	"Baba Kamma": "Buvu Kamu",
	"Baba Metzia": "Buvu Metziu",
	"Balak": "Bulok",
	"Bamidbar": "Bamidbor",
	"Bechorot": "Bchoyros",
	"Bechukotai": "Bechikoysai",
	"Beha'alotcha": "Bahaaloschu",
	"Beitzah": "Baitzu",
	"Berachot": "Bruchos",
	"Bereshit": "Braishis",
	"Bo": "Boy",
	"Candle lighting": "Hadlokas neyros",
	"Chagigah": "Chagigu",
	"Chanukah": "Chanukko",
	"Chanukah: 1 Candle": "Chanukko: 1 Candle",
	"Chanukah: 2 Candles": "Chanukko: 2 Candles",
	"Chanukah: 3 Candles": "Chanukko: 3 Candles",
	"Chanukah: 4 Candles": "Chanukko: 4 Candles",
	"Chanukah: 5 Candles": "Chanukko: 5 Candles",
	"Chanukah: 6 Candles": "Chanukko: 6 Candles",
	"Chanukah: 7 Candles": "Chanukko: 7 Candles",
	"Chanukah: 8 Candles": "Chanukko: 8 Candles",
	"Chanukah: 8th Day": "Chanukko: 8th Day",
	"Chayei Sara": "Chayei Suru",
	"Cheshvan": "Cheshvon",
	"Chukat": "Chikas",
	"Chullin": "Chillin",
	"Daf Yomi": "Daf Yoymi",
	"Days of the Omer": "Oymer",
	"Devarim": "Dvurim",
	"Eikev": "Aikev",
	"Emor": "Emoyr",
	"Erev Pesach": "Erev Peisach",
	"Erev Rosh Hashana": "Erev Rosh-Hashono",
	"Erev Shavuot": "Erev Shvuos",
	"Erev Simchat Torah": "Erev Simchas Toyro",
	"Erev Sukkot": "Erev Sukkos",
	"Erev Tish'a B'Av": "Erev Tisho Bov",
	"Eruvin": "Airivin",
	"Ha'azinu": "Haazini",
	"Havdalah": "Havdolo",
	"Horayot": "Hoyroyos",
	"Iyyar": "Iyyor",
	"Kedoshim": "Kdoyshim",
	"Keritot": "Krisos",
	"Ketubot": "Ksibos",
	"Ki Tavo": "Ki-Sovo",
	"Ki Teitzei": "Ki-Seitzei",
	"Ki Tisa": "Ki-Siso",
	"Kiddushin": "Kiddishin",
	"Korach": "Koyrach",
	"Lag BaOmer": "Lag Boymer",
	"Lech-Lecha": "Lech-Lecho",
	"Leil Selichot": "Slichos",
	"Makkot": "Makkos",
	"Matot": "Matos",
	"Megillah": "Megillu",
	"Meilah": "Meilu",
	"Menachot": "Menuchos",
	"Metzora": "Metzoyro",
	"Midot": "Midos",
	"Miketz": "Mikeitz",
	"Mishpatim": "Mishpotim",
	"Moed Katan": "Moyed Koton",
	"Nasso": "Nosso",
	"Nazir": "Nuzir",
	"Nedarim": "Nedurim",
	"Niddah": "Niddu",
	"Nisan": "Nison",
	"Nitzavim": "Nitzovim",
	"Noach": "Noyach",
	"Parashat": "Parshas",
	"Pekudei": "Pkudey",
	"Pesach": "Peisach",
	"Pesach I": "Peisach I",
	"Pesach II": "Peisach II",
	"Pesach II (CH''M)": "Peisach II (CH''M)",
	"Pesach III (CH''M)": "Peisach III (CH''M)",
	"Pesach IV (CH''M)": "Peisach IV (CH''M)",
	"Pesach Sheni": "Peisach Sheini",
	"Pesach V (CH''M)": "Peisach V (CH''M)",
	"Pesach VI (CH''M)": "Peisach VI (CH''M)",
	"Pesach VII": "Peisach VII",
	"Pesach VIII": "Peisach VIII",
	"Pesachim": "Psuchim",
	"Pinchas": "Pinchos",
	"Purim Katan": "Purim Koton",
	"Re'eh": "Reei",
	"Rosh Chodesh": "Rosh Choydesh",
	"Rosh Chodesh %s": "Rosh Choydesh %s",
	"Rosh Hashana": "Rosh Hashono",
	"Rosh Hashana I": "Rosh Hashono I",
	"Rosh Hashana II": "Rosh Hashono II",
	"Sh'lach": "Shlach",
	"Sh'vat": "Shvat",
	"Shabbat": "Shabbos",
	"Shabbat Chazon": "Shabbos Chazon",
	"Shabbat HaChodesh": "Shabbos HaChoydesh",
	"Shabbat HaGadol": "Shabbos HaGodol",
	"Shabbat Machar Chodesh": "Shabbos Mochor Choydesh",
	"Shabbat Nachamu": "Shabbos Nachamu",
	"Shabbat Parah": "Shabbos Poro",
	"Shabbat Rosh Chodesh": "Shabbos Rosh Choydesh",
	"Shabbat Shekalim": "Shabbos Shkolim",
	"Shabbat Shuva": "Shabbos Shuvo",
	"Shabbat Zachor": "Shabbos Zochor",
	"Shavuot": "Shvuos",
	"Shavuot I": "Shvuos I",
	"Shavuot II": "Shvuos II",
	"Shekalim": "Shkulim",
	"Shemot": "Shmoys",
	"Shevuot": "Shvios",
	"Shmini Atzeret": "Shmini Atzeres",
	"Shushan Purim": "Shushon Purim",
	"Simchat Torah": "Simchas Toyro",
	"Sivan": "Sivon",
	"Sotah": "Soytu",
	"Sukkah": "Sikku",
	"Sukkot": "Sukkos",
	"Sukkot I": "Sukkos I",
	"Sukkot II": "Sukkos II",
	"Sukkot II (CH''M)": "Sukkos II (CH''M)",
	"Sukkot III (CH''M)": "Sukkos III (CH''M)",
	"Sukkot IV (CH''M)": "Sukkos IV (CH''M)",
	"Sukkot V (CH''M)": "Sukkos V (CH''M)",
	"Sukkot VI (CH''M)": "Sukkos VI (CH''M)",
	"Sukkot VII (Hoshana Raba)": "Sukkos VII (Hoyshano Rabo)",
	"Ta'anit Bechorot": "Taanis Bchoros",
	"Ta'anit Esther": "Taanis Ester",
	"Taanit": "Taanis",
	"Tamid": "Tumid",
	"Temurah": "Tmiru",
	"Terumah": "Trumo",
	"Tetzaveh": "Tetzave",
	"Tevet": "Teyves",
	"Tish'a B'Av": "Tisho B'ov",
	"Tish'a B'Av (observed)": "Tisho B'ov (observed)",
	"Toldot": "Toldos",
	"Tu B'Av": "Tu B'ov",
	"Tu B'Shvat": "Tu BiShvat",
	"Tzom Gedaliah": "Tzom Gdalyo",
	"Vaera": "Voeiro",
	"Vaetchanan": "Voeschanan",
	"Vayera": "Vayeiro",
	"Vayeshev": "Vayeishev",
	"Vayetzei": "Vayeitzei",
	"Vayikra": "Vayikro",
	"Vezot Haberakhah": "Zoys Habrocho",
	"Yevamot": "Yevumos",
	"Yitro": "Yisro",
	"Yom Kippur Katan": "Yom Kippur Koton",
	"Yom Yerushalayim": "Yom Yerusholayim",
	"Yoma": "Yimu",
	"Zevachim": "Zvuchim",
}

func Lookup_ashkenazi_poylish(s string) (string, bool) {
	v, ok := dict_ashkenazi_poylish[s]
	if ok {
		return v, true
	}
	return s, false
}
