package locales

var dict_fi = map[string]string{
	"Achrei Mot": "Achrei mot",
	"Asara B'Tevet": "Asara betevet",
	"Avodah Zarah": "Avoda zara",
	"Baba Batra": "Bava batra",
	"Baba Kamma": "Bava kama",
	"Baba Metzia": "Bava metsia",
	"Beha'alotcha": "Behalotcha",
	"Beitzah": "Beitsa",
	"Berachot": "Brachot",
	"Candle lighting": "Kynttilöiden sytytys",
	"Chagigah": "Chagiga",
	"Chanukah": "Hanuka",
	"Chanukah: 1 Candle": "Hanuka 1. kynttilä",
	"Chanukah: 2 Candles": "Hanuka 2. kynttilä",
	"Chanukah: 3 Candles": "Hanuka 3. kynttilä",
	"Chanukah: 4 Candles": "Hanuka 4. kynttilä",
	"Chanukah: 5 Candles": "Hanuka 5. kynttilä",
	"Chanukah: 6 Candles": "Hanuka 6. kynttilä",
	"Chanukah: 7 Candles": "Hanuka 7. kynttilä",
	"Chanukah: 8 Candles": "Hanuka 8. kynttilä",
	"Chanukah: 8th Day": "Hanuka 8. päivä",
	"Chayei Sara": "Chajei Sara",
	"Chullin": "Chulin",
	"Daf Yomi": "Daf jomi",
	"Days of the Omer": "Omerin päivä",
	"Devarim": "Dvarim",
	"Erev Pesach": "Pesach aatto",
	"Erev Purim": "Purim aatto",
	"Erev Rosh Hashana": "Rosh hashana aatto",
	"Erev Shavuot": "Shavuot aatto",
	"Erev Simchat Torah": "Simchat toora -aatto",
	"Erev Sukkot": "Sukot-aatto",
	"Erev Tish'a B'Av": "Tisha beav -aatto",
	"Erev Yom Kippur": "Jom kipur -aatto",
	"Fast begins": "Paasto alkaa",
	"Fast ends": "Paasto päättyy",
	"Havdalah": "Havdala",
	"Horayot": "Horajot",
	"Iyyar": "Ijar",
	"Keritot": "Kritot",
	"Ki Tavo": "Ki tavo",
	"Ki Teitzei": "Ki tetse",
	"Kiddushin": "Kidushin",
	"Kinnim": "Kinim",
	"Lag BaOmer": "Lag baomer",
	"Lech-Lecha": "Lech lecha",
	"Leil Selichot": "Slichot-ilta (aatto)",
	"Makkot": "Makot",
	"Megillah": "Megila",
	"Meilah": "Meila",
	"Metzora": "Metsora",
	"Miketz": "Mikets",
	"Moed Katan": "Moed katan",
	"Nasso": "Naso",
	"Niddah": "Nida",
	"Nitzavim": "Nitsavim",
	"Parashat": "Parshat",
	"Pesach I": "Pesach 1. päivä",
	"Pesach II": "Pesach 2. päivä",
	"Pesach II (CH''M)": "Pesach 2. päivä (Chol hamoed)",
	"Pesach III (CH''M)": "Pesach 3. päivä (Chol hamoed)",
	"Pesach IV (CH''M)": "Pesach 4. päivä (Chol hamoed)",
	"Pesach V (CH''M)": "Pesach 5. päivä (Chol hamoed)",
	"Pesach VI (CH''M)": "Pesach 6. päivä (Chol hamoed)",
	"Pesach VII": "Pesach 7. päivä",
	"Pesach VIII": "Pesach 8. päivä",
	"Pesachim": "Psachim",
	"Purim Katan": "Purim katan",
	"Re'eh": "Re'e",
	"Rosh Chodesh": "Rosh chodesh",
	"Rosh Chodesh %s": "Rosh chodesh %s",
	"Rosh Hashana": "Rosh hashana",
	"Rosh Hashana I": "Rosh hashana 1. päivä",
	"Rosh Hashana II": "Rosh hashana 2. päivä",
	"Sh'lach": "Shlach",
	"Sh'vat": "Shvat",
	"Shabbat": "Shabat",
	"Shabbat Chazon": "Shabat chazon",
	"Shabbat HaChodesh": "Shabat hachodesh",
	"Shabbat HaGadol": "Shabat hagadol",
	"Shabbat Machar Chodesh": "Shabat machar chodesh",
	"Shabbat Nachamu": "Shabat nechamu",
	"Shabbat Parah": "Shabat para",
	"Shabbat Rosh Chodesh": "Shabat rosh chodesh",
	"Shabbat Shekalim": "Shabat shkalim",
	"Shabbat Shuva": "Shabat shuva",
	"Shabbat Zachor": "Shabat zachor",
	"Shavuot I": "Shavuot 1. päivä",
	"Shavuot II": "Shavuot 2. päivä",
	"Shekalim": "Shkalim",
	"Shemot": "Shmot",
	"Shevuot": "Shavuot",
	"Shmini Atzeret": "Shmini atseret",
	"Shushan Purim": "Shushan purim",
	"Simchat Torah": "Simchat toora",
	"Sotah": "Sota",
	"Sukkah": "Suka",
	"Sukkot": "Sukot",
	"Sukkot I": "Sukot 1. päivä",
	"Sukkot II": "Sukot 2. päivä",
	"Sukkot II (CH''M)": "Sukot 2. päivä (Chol hamoed)",
	"Sukkot III (CH''M)": "Sukot 3. päivä (Chol hamoed)",
	"Sukkot IV (CH''M)": "Sukot 4. päivä (Chol hamoed)",
	"Sukkot V (CH''M)": "Sukot 5. päivä (Chol hamoed)",
	"Sukkot VI (CH''M)": "Sukot 6. päivä (Chol hamoed)",
	"Sukkot VII (Hoshana Raba)": "Sukot 7. päivä (Hoshana raba)",
	"Ta'anit Bechorot": "Ta'anit bechorot",
	"Ta'anit Esther": "Ta'anit Ester",
	"Temurah": "Tmura",
	"Terumah": "Truma",
	"Tetzaveh": "Tetsave",
	"Tish'a B'Av": "Tisha beav",
	"Tish'a B'Av (observed)": "Tisha beav (vietetään)",
	"Tu B'Av": "Tu beav",
	"Tu B'Shvat": "Tu bishvat",
	"Tu BiShvat": "Tu bishvat",
	"Tzav": "Tsav",
	"Tzom Gedaliah": "Tzom Gedalja",
	"Tzom Tammuz": "Tzom tamuz",
	"Vayakhel": "Vajakel",
	"Vayechi": "Vajechi",
	"Vayeilech": "Vajelech",
	"Vayera": "Vajera",
	"Vayeshev": "Vajeshev",
	"Vayetzei": "Vajetse",
	"Vayigash": "Vajigash",
	"Vayikra": "Vajikra",
	"Vayishlach": "Vajishlach",
	"Vezot Haberakhah": "Vezot habracha",
	"Yevamot": "Jevamot",
	"Yitro": "Jitro",
	"Yom HaAliyah": "Jom ha'alija",
	"Yom HaAtzma'ut": "Jom ha'atsmaut",
	"Yom HaShoah": "Jom hashoa",
	"Yom HaZikaron": "Jom hazikaron",
	"Yom Kippur": "Jom kipur",
	"Yom Kippur Katan": "Jom kipur katan",
	"Yom Yerushalayim": "Jom Jerushalaim",
	"Yoma": "Joma",
	"Zevachim": "Zvachim",
	"day": "päivä",
	"min": "minuuttia",
}

func Lookup_fi(s string) (string, bool) {
	v, ok := dict_fi[s]
	if ok {
		return v, true
	}
	return s, false
}
