package locales

var dict_fr = map[string]string{
	"Achrei Mot": "Ah̲aré Mot",
	"Arachin": "Arah̲in",
	"Asara B'Tevet": "Assarah beTévet",
	"Baba Metzia": "Baba Métzia",
	"Bechorot": "Bekhorot",
	"Bechukotai": "Beh̲oukotaï",
	"Beha'alotcha": "Beha'alotkha",
	"Beitzah": "Bétzah",
	"Berachot": "Berakhot",
	"Bereshit": "Berechit",
	"Beshalach": "Bechalah̲",
	"Candle lighting": "Allumage des bougies",
	"Chagigah": "H̲aguigah",
	"Chanukah": "H̲anoukah",
	"Chanukah: 1 Candle": "H̲anoukah: 1 Bougie",
	"Chanukah: 2 Candles": "H̲anoukah: 2 Bougies",
	"Chanukah: 3 Candles": "H̲anoukah: 3 Bougies",
	"Chanukah: 4 Candles": "H̲anoukah: 4 Bougies",
	"Chanukah: 5 Candles": "H̲anoukah: 5 Bougies",
	"Chanukah: 6 Candles": "H̲anoukah: 6 Bougies",
	"Chanukah: 7 Candles": "H̲anoukah: 7 Bougies",
	"Chanukah: 8 Candles": "H̲anoukah: 8 Bougies",
	"Chanukah: 8th Day": "H̲anoukah: 8ème jour",
	"Chayei Sara": "H̲ayé Sarah",
	"Cheshvan": "H̲echvan",
	"Chukat": "H̲oukat",
	"Chullin": "H̲oulin",
	"Date out of range in input file. Skipping line %s": "Date hors de portée dans le fichier. Ignore la ligne %s",
	"Date out of range in yahrtzeit file. Skipping line %s": "Date hors de portée dans le fichier des Yahrzeit. Ignore la ligne %s",
	"Days of the Omer": "Jours de l'Omer",
	"Eikev": "Ekev",
	"Elul": "Eloul",
	"Erev Pesach": "Erev Pessah̲",
	"Erev Purim": "Erev Pourim",
	"Erev Rosh Hashana": "Erev Roch Hachanah",
	"Erev Shavuot": "Erev Chavou'ot",
	"Erev Simchat Torah": "Erev Simh̲at Torah",
	"Erev Sukkot": "Erev Soukkot",
	"Erev Tish'a B'Av": "Erev Tich'ah beAv",
	"Erev Yom Kippur": "Erev Yom Kippour",
	"Error in input file.  Skipping line %s": "Erreur dans le fichier d'entrée. Ignore la ligne %s",
	"Error in yahrtzeit file.  Skipping line %s": "Erreur dans le fichier des yahrzeit. Ignore la ligne %s",
	"Eruvin": "Erouvin",
	"Fast begins": "Début du jeûne",
	"Fast ends": "Fin du jeûne",
	"Gitin": "Guitin",
	"Ha'azinu": "Ha'Azinou",
	"Iyyar": "Iyar",
	"Kedoshim": "Kedochim",
	"Ketubot": "Ketoubot",
	"Ki Teitzei": "Ki Tétzé",
	"Ki Tisa": "Ki Tissa",
	"Kiddushin": "Kiddouchin",
	"Kislev": "Kislav",
	"Korach": "Korah̲",
	"Lag BaOmer": "Lag ba'Omer",
	"Lech-Lecha": "Lekh Lekha",
	"Leil Selichot": "Lel Selih̲ot",
	"Makkot": "Makot",
	"Masei": "Massé",
	"Matot": "Mattot",
	"Megillah": "Meguilah",
	"Meilah": "Me'ilah",
	"Menachot": "Menah̲ot",
	"Mishpatim": "Michpatim",
	"Moed Katan": "Mo'ed Katan",
	"Nisan": "Nissan",
	"Noach": "Noah̲",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Mois non numérique dans le fichier des yahrzeit. Ignore la ligne %s",
	"Numeric hebrew month in input file.  Skipping line %s": "Mois hébraïque numérique dans le fichier d'entrée. Ignore la ligne %s",
	"Parashat": "Parachah",
	"Pekudei": "Pekoudé",
	"Pesach": "Pessah̲",
	"Pesach I": "Pessah̲ I",
	"Pesach II": "Pessah̲ II",
	"Pesach II (CH''M)": "Pessah̲ II (H̲''M)",
	"Pesach III (CH''M)": "Pessah̲ III (H̲''M)",
	"Pesach IV (CH''M)": "Pessah̲ IV (H̲''M)",
	"Pesach Sheni": "Pessah̲ Cheni",
	"Pesach V (CH''M)": "Pessah̲ V (H̲''M)",
	"Pesach VI (CH''M)": "Pessah̲ VI (H̲''M)",
	"Pesach VII": "Pessah̲ VII",
	"Pesach VIII": "Pessah̲ VIII",
	"Pesachim": "Pessah̲im",
	"Pinchas": "Pinh̲as",
	"Purim": "Pourim",
	"Purim Katan": "Pourim Katan",
	"Re'eh": "Reéh",
	"Rosh Chodesh": "Roch H̲odech",
	"Rosh Chodesh %s": "Roch H̲odech %s",
	"Rosh Hashana": "Roch Hachanah",
	"Rosh Hashana I": "Roch Hachanah I",
	"Rosh Hashana II": "Roch Hachanah II",
	"Sanhedrin": "Sanhédrin",
	"Sh'lach": "Chelah̲ Lekha",
	"Sh'vat": "Chevat",
	"Shabbat": "Chabbat",
	"Shabbat Chazon": "Chabbat H̲azon",
	"Shabbat HaChodesh": "Chabbat haH̲odech",
	"Shabbat HaGadol": "Chabbat haGadol",
	"Shabbat Machar Chodesh": "Chabbat Mah̲ar H̲odech",
	"Shabbat Nachamu": "Chabbat Nah̲amou",
	"Shabbat Parah": "Chabbat Parah",
	"Shabbat Rosh Chodesh": "Chabbat Roch H̲odech",
	"Shabbat Shekalim": "Chabbat Chekalim",
	"Shabbat Shuva": "Chabbat Chouvah",
	"Shabbat Zachor": "Chabbat Zakhor",
	"Shavuot": "Chavou'ot",
	"Shavuot I": "Chavou'ot I",
	"Shavuot II": "Chavou'ot II",
	"Shekalim": "Chekalim",
	"Shemot": "Chemot",
	"Shevuot": "Chevou'ot",
	"Shmini": "Chemini",
	"Shmini Atzeret": "Chemini Atzéret",
	"Shoftim": "Choftim",
	"Shushan Purim": "Chouchan Pourim",
	"Simchat Torah": "Simh̲at Torah",
	"Sukkah": "Soukkah",
	"Sukkot": "Soukkot",
	"Sukkot I": "Soukkot I",
	"Sukkot II": "Soukkot II",
	"Sukkot II (CH''M)": "Soukkot II (H̲''M)",
	"Sukkot III (CH''M)": "Soukkot III (H̲''M)",
	"Sukkot IV (CH''M)": "Soukkot IV (H̲''M)",
	"Sukkot V (CH''M)": "Soukkot V (H̲''M)",
	"Sukkot VI (CH''M)": "Soukkot VI (H̲''M)",
	"Sukkot VII (Hoshana Raba)": "Soukkot VII (Hochanah Rabbah)",
	"Ta'anit Bechorot": "Ta'anit Bekhorot",
	"Taanit": "Ta'anit",
	"Tamuz": "Tammouz",
	"Tazria": "Tazri'a",
	"Temurah": "Temourah",
	"Terumah": "Teroumah",
	"Tetzaveh": "Tétzaveh",
	"Tevet": "Tévet",
	"Tish'a B'Av": "Tich'ah beAv",
	"Tish'a B'Av (observed)": "Tich'ah beAv (observé)",
	"Toldot": "Toledot",
	"Tu B'Av": "Tou beAv",
	"Tu B'Shvat": "Tou biChvat",
	"Tu BiShvat": "Tou biChvat",
	"Tzom Gedaliah": "Tzom Guedalyah",
	"Tzom Tammuz": "Tzom Tammouz",
	"Unable to allocate memory for holiday.": "Impossible d'allouer de la mémoire pour la fête.",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Mois hébraïque non reconnu dans ke fichier d'entrée. Ignore la ligne %s",
	"Vaera": "Vaéra",
	"Vaetchanan": "Vaèth̲anan",
	"Vayakhel": "Vayak'hel",
	"Vayechi": "Vayeh̲i",
	"Vayeilech": "Vayelekh",
	"Vayera": "Vayéra",
	"Vayeshev": "Vayéchev",
	"Vayetzei": "Vayétzé",
	"Vayigash": "Vayigach",
	"Vayishlach": "Vayichlah̲",
	"Yom HaAliyah": "Yom ha'Alyah",
	"Yom HaAtzma'ut": "Yom ha'Atzmaout",
	"Yom HaShoah": "Yom haShoah",
	"Yom HaZikaron": "Yom haZikaron",
	"Yom Kippur": "Yom Kippour",
	"Yom Kippur Katan": "Yom Kippour Katan",
	"Yom Yerushalayim": "Yom Yerouchalayim",
	"Zevachim": "Zevah̲im",
	"after": "après",
	"and": "et",
	"chalakim": "'halakim",
	"day": "jour",
	"improper sedra year type calculated.": "mauvais calcul de type d'année de sidra.",
	"input file read error. Skipping line %s": "erreur de lecture du fichier d'entrée. Ignore la ligne %s",
	"min": "minutes",
	"yahrtzeit file read error. Skipping line %s": "Erreur de lecture du fichier des yahrzeit. Ignore la ligne %s",
}

func Lookup_fr(s string) (string, bool) {
	v, ok := dict_fr[s]
	if ok {
		return v, true
	}
	return s, false
}
