package locales

var dict_he = map[string]string{
	"Achrei Mot": "אַחֲרֵי מוֹת",
	"Adar": "אֲדָר",
	"Adar I": "אֲדָר א׳",
	"Adar II": "אֲדָר ב׳",
	"Admission into the Sanctuary": "הלכות ביאת מקדש",
	"Agents and Partners": "הלכות שלוחין ושותפין",
	"Amos": "עָמוּס",
	"Appraisals and Devoted Property": "הלכות ערכים וחרמין",
	"Arachin": "ערכין",
	"Arakhin": "ערכין",
	"Arukh HaShulchan": "ערוך השולחן",
	"Arurin": "ארורין",
	"Asara B'Tevet": "עֲשָׂרָה בְּטֵבֵת",
	"Asara B'Tevet (Mincha)": "עֲשָׂרָה בְּטֵבֵת מִנחָה",
	"Asin": "עשיין",
	"Av": "אָב",
	"Avodah Zarah": "עבודה זרה",
	"Avot": "אבות",
	"Baba Batra": "בבא בתרא",
	"Baba Kamma": "בבא קמא",
	"Baba Metzia": "בבא מציעא",
	"Balak": "בָּלָק",
	"Bamidbar": "בְּמִדְבַּר",
	"Bava Batra": "בבא בתרא",
	"Bava Kamma": "בבא קמא",
	"Bava Metzia": "בבא מציעא",
	"Beauty": "תִּפְאֶרֶת",
	"Bechorot": "בכורות",
	"Bechukotai": "בְּחֻקֹּתַי",
	"Beha'alotcha": "בְּהַעֲלֹתְךָ",
	"Behar": "בְּהַר",
	"Beitzah": "ביצה",
	"Bekhorot": "בכורות",
	"Ben-Gurion Day": "יוֹם בן־גוריון",
	"Berachot": "ברכות",
	"Berakhot": "ברכות",
	"Bereshit": "בְּרֵאשִׁית",
	"Beshalach": "בְּשַׁלַּח",
	"Bikkurim": "ביכורים",
	"Birkat Hachamah": "בִּרְכַּת הַחַמָּה",
	"Blessings": "הלכות ברכות",
	"Bo": "בֹּא",
	"Borrowing and Deposit": "הלכות שאלה ופיקדון",
	"Candle lighting": "הַדְלָקַת נֵרוֹת",
	"Chag HaBanot": "חַג הַבָּנוֹת",
	"Chagigah": "חגיגה",
	"Challah": "חלה",
	"Chanukah": "חֲנוּכָּה",
	"Chanukah Day 1": "חֲנוּכָּה יוֹם א׳",
	"Chanukah Day 1 (on Shabbat)": "חֲנוּכָּה יוֹם א׳ (בְּשַׁבָּת)",
	"Chanukah Day 2": "חֲנוּכָּה יוֹם ב׳",
	"Chanukah Day 2 (on Shabbat)": "חֲנוּכָּה יוֹם ב׳ (בְּשַׁבָּת)",
	"Chanukah Day 3": "חֲנוּכָּה יוֹם ג׳",
	"Chanukah Day 3 (on Shabbat)": "חֲנוּכָּה יוֹם ג׳ (בְּשַׁבָּת)",
	"Chanukah Day 4": "חֲנוּכָּה יוֹם ד׳",
	"Chanukah Day 4 (on Shabbat)": "חֲנוּכָּה יוֹם ד׳ (בְּשַׁבָּת)",
	"Chanukah Day 5": "חֲנוּכָּה יוֹם ה׳",
	"Chanukah Day 5 (on Shabbat)": "חֲנוּכָּה יוֹם ה׳ (בְּשַׁבָּת)",
	"Chanukah Day 6": "חֲנוּכָּה יוֹם ו׳",
	"Chanukah Day 7": "חֲנוּכָּה יוֹם ז׳",
	"Chanukah Day 7 (on Rosh Chodesh)": "חֲנוּכָּה יוֹם ז׳ (רֹאשׁ חוֹדֶשׁ)",
	"Chanukah Day 7 (on Shabbat)": "חֲנוּכָּה יוֹם ז׳ (בְּשַׁבָּת)",
	"Chanukah Day 8": "חֲנוּכָּה יוֹם ח׳",
	"Chanukah Day 8 (on Shabbat)": "חֲנוּכָּה יוֹם ח׳ (בְּשַׁבָּת)",
	"Chanukah: 1 Candle": "חֲנוּכָּה: א׳ נֵר",
	"Chanukah: 2 Candles": "חֲנוּכָּה: ב׳ נֵרוֹת",
	"Chanukah: 3 Candles": "חֲנוּכָּה: ג׳ נֵרוֹת",
	"Chanukah: 4 Candles": "חֲנוּכָּה: ד׳ נֵרוֹת",
	"Chanukah: 5 Candles": "חֲנוּכָּה: ה׳ נֵרוֹת",
	"Chanukah: 6 Candles": "חֲנוּכָּה: ו׳ נֵרוֹת",
	"Chanukah: 7 Candles": "חֲנוּכָּה: ז׳ נֵרוֹת",
	"Chanukah: 8 Candles": "חֲנוּכָּה: ח׳ נֵרוֹת",
	"Chanukah: 8th Day": "חֲנוּכָּה: יוֹם ח׳",
	"Chasimas Hasefer": "חתימת הספר",
	"Chayei Sara": "חַיֵּי שָֹרָה",
	"Cheshvan": "חֶשְׁוָן",
	"Chofetz Chaim": "חָפֵץ חַיִּים",
	"Choshen Mishpat": "חושן משפט",
	"Chronicles": "דִברֵי הַיָמִים",
	"Chukat": "חֻקַּת",
	"Chullin": "חולין",
	"Circumcision": "הלכות מילה",
	"Creditor and Debtor": "הלכות מלווה ולווה",
	"Daf Weekly": "דַף שְׁבוּעִי",
	"Daf Yomi": "דַּף יוֹמִי",
	"Daily Offerings and Additional Offerings": "הלכות תמידים ומוספין",
	"Daily Rambam": "רמב״ם יוֹמִי",
	"Damages to Property": "הלכות נזקי ממון",
	"Daniel": "דָּנִיֵּאל",
	"Days of the Omer": "סְפִירַת הָעוֹמֶר",
	"Defilement by Leprosy": "הלכות טומאת צרעת",
	"Defilement by a Corpse": "הלכות טומאת מת",
	"Defilement of Foods": "הלכות טומאת אוכלים",
	"Demai": "דמאי",
	"Devarim": "דְּבָרִים",
	"Diverse Species": "הלכות כלאים",
	"Divorce": "הלכות גירושין",
	"Ecclesiastes": "קֹהֶלֶת",
	"Eduyot": "עדיות",
	"Eikev": "עֵקֶב",
	"Elul": "אֱלוּל",
	"Emor": "אֱמוֹר",
	"Erev Pesach": "עֶרֶב פֶּסַח",
	"Erev Purim": "עֶרֶב פּוּרִים",
	"Erev Rosh Hashana": "עֶרֶב רֹאשׁ הַשָּׁנָה",
	"Erev Shavuot": "עֶרֶב שָׁבוּעוֹת",
	"Erev Simchat Torah": "עֶרֶב שִׂמְחַת תּוֹרָה",
	"Erev Sukkot": "עֶרֶב סוּכּוֹת",
	"Erev Tish'a B'Av": "עֶרֶב תִּשְׁעָה בְּאָב",
	"Erev Yom Kippur": "עֶרֶב יוֹם כִּפּוּר",
	"Eruvin": "עירובין",
	"Esther": "אֶסְתֵּר",
	"Eternity": "נֶּצַח",
	"Even HaEzer": "אבן העזר",
	"Ezekiel": "יְחֶזְקֵאל",
	"Ezra": "עֶזְרָא",
	"Ezra and Nehemiah": "עֶזְרָא וְנְחֶמְיָה",
	"Family Day": "יוֹם הַמִּשׁפָּחָה",
	"Fast begins": "תְּחִילַּת הַצוֹם",
	"Fast ends": "סִיּוּם הַצוֹם",
	"Fasts": "הלכות תעניות",
	"Festival Offering": "הלכות חגיגה",
	"First Fruits and other Gifts to Priests Outside the Sanctuary": "הלכות ביכורים ושאר מתנות כהונה שבגבולין",
	"Firstlings": "הלכות בכורות",
	"Forbidden Foods": "הלכות מאכלות אסורות",
	"Forbidden Intercourse": "הלכות איסורי ביאה",
	"Foreign Worship and Customs of the Nations": "הלכות עבודה זרה וחוקות הגויים",
	"Foundation": "יְּסוֹד",
	"Foundations of the Torah": "הלכות יסודי התורה",
	"Fringes": "הלכות ציצית",
	"Gifts to the Poor": "הלכות מתנות עניים",
	"Gitin": "גיטין",
	"Gittin": "גיטין",
	"Ha'azinu": "הַאֲזִינוּ",
	"Habakkuk": "חֲבַקּוּק",
	"Haggai": "חַגַּי",
	"Hakdamah": "הקדמה",
	"Havdalah": "הַבְדָּלָה",
	"Heave Offerings": "הלכות תרומות",
	"Hebrew Language Day": "יוֹם הַשָׂפָה הַעִברִית",
	"Herzl Day": "יוֹם הֵרְצְל",
	"Hilchos LH": "הלכות לשון הרע",
	"Hilchos Rechilus": "הלכות רכילות",
	"Hilchot Brachot v'Tefilah": "הלכות ברכות ותפלה",
	"Hilchot Shmita v'Terumah": "הלכות שמיטה ותרו״מ",
	"Hiring": "הלכות שכירות",
	"Horayot": "הוריות",
	"Hosea": "הוֹשֵׁעַ",
	"Human Dispositions": "הלכות דעות",
	"I Chronicles": "דִברֵי הַיָמִים א׳",
	"I Kings": "מְלָכִים א׳",
	"I Samuel": "שְׁמוּאֵל א׳",
	"II Chronicles": "דִברֵי הַיָמִים ב׳",
	"II Kings": "מְלָכִים ב׳",
	"II Samuel": "שְׁמוּאֵל ב׳",
	"Immersion Pools": "הלכות מקואות",
	"Inheritances": "הלכות נחלות",
	"Isaiah": "יְשַׁעְיָהוּ",
	"Iyyar": "אִיָּיר",
	"Jabotinsky Day": "יוֹם זַ׳בּוֹטִינְסְקִי",
	"Jeremiah": "יִרְמְיָהוּ",
	"Job": "אִיּוֹב",
	"Joel": "יוֹאֵל",
	"Jonah": "יוֹנָה",
	"Joshua": "יְהוֹשֻׁעַ",
	"Judges": "שׁוֹפְטִים",
	"Kedoshim": "קְדשִׁים",
	"Kelim": "כלים",
	"Keritot": "כריתות",
	"Ketubot": "כתובות",
	"Ki Tavo": "כִּי־תָבוֹא",
	"Ki Teitzei": "כִּי־תֵצֵא",
	"Ki Tisa": "כִּי תִשָּׂא",
	"Kiddushin": "קידושין",
	"Kilayim": "כלאים",
	"Kings": "מְלָכִים",
	"Kings and Wars": "הלכות מלכים ומלחמות",
	"Kinnim": "קינים",
	"Kislev": "כִּסְלֵו",
	"Klalim": "כללים",
	"Korach": "קֹרַח",
	"Lag BaOmer": "ל״ג בָּעוֹמֶר",
	"Lamentations": "אֵיכָה",
	"Lavin": "לאווין",
	"Leavened and Unleavened Bread": "הלכות חמץ ומצה",
	"Lech-Lecha": "לֶךְ־לְךָ",
	"Leil Selichot": "סְלִיחוֹת",
	"Levirate Marriage and Release": "הלכות יבום וחליצה",
	"Lovingkindness": "חֶסֶד",
	"Maaser Sheni": "מעשר שני",
	"Maasrot": "מעשרות",
	"Majesty": "מַּלְכוּת",
	"Makhshirin": "מכשירין",
	"Makkot": "מכות",
	"Malachi": "מַלְאָכִי",
	"Marriage": "הלכות אישות",
	"Masei": "מַסְעֵי",
	"Matot": "מַטּוֹת",
	"Megillah": "מגילה",
	"Meilah": "מעילה",
	"Menachot": "מנחות",
	"Metzora": "מְצֹרָע",
	"Micah": "מִיכָה",
	"Middot": "מדות",
	"Midot": "מדות",
	"Might": "גְּבוּרָה",
	"Miketz": "מִקֵּץ",
	"Mikvaot": "מקוואות",
	"Minor Prophets": "תְּרֵי עֲשַׂר",
	"Mishna Yomi": "מִשְׁנָה יוֹמִי",
	"Mishpatim": "מִשְׁפָּטִים",
	"Moed Katan": "מועד קטן",
	"Molad": "מוֹלָד הָלְּבָנָה",
	"Mourning": "הלכות אבל",
	"Murderer and the Preservation of Life": "הלכות רוצח ושמירת נפש",
	"Nach Yomi": "נ״ך יוֹמִי",
	"Nachum": "נַחוּם",
	"Nasso": "נָשׂא",
	"Nazariteship": "הלכות נזירות",
	"Nazir": "נזיר",
	"Nedarim": "נדרים",
	"Negaim": "נגעים",
	"Negative Mitzvot": "מצוות לא תעשה",
	"Nehemiah": "נְחֶמְיָה",
	"Neighbors": "הלכות שכנים",
	"Niddah": "נדה",
	"Nisan": "נִיסָן",
	"Nitzavim": "נִצָּבִים",
	"Noach": "נֹחַ",
	"Oaths": "הלכות שבועות",
	"Obadiah": "עוֹבַדְיָה",
	"Offerings for Those with Incomplete Atonement": "הלכות מחוסרי כפרה",
	"Offerings for Unintentional Transgressions": "הלכות שגגות",
	"Oholot": "אהלות",
	"Oktzin": "עוקצים",
	"Omer": "עוֹמֶר",
	"One Who Injures a Person or Property": "הלכות חובל ומזיק",
	"Orach Chaim": "אורח חיים",
	"Orlah": "ערלה",
	"Other Sources of Defilement": "הלכות שאר אבות הטומאות",
	"Overview of Mishneh Torah Contents": "תוכן החיבור",
	"Ownerless Property and Gifts": "הלכות זכייה ומתנה",
	"Parah": "פרה",
	"Parashat": "פָּרָשַׁת",
	"Paschal Offering": "הלכות קרבן פסח",
	"Peah": "פאה",
	"Pekudei": "פְקוּדֵי",
	"Pesach": "פֶּסַח",
	"Pesach Chol ha-Moed Day 1": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם א׳",
	"Pesach Chol ha-Moed Day 2": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם ב׳",
	"Pesach Chol ha-Moed Day 2 on Sunday": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם ב׳ (בְּיוֹם רִאשׁוֹן)",
	"Pesach Chol ha-Moed Day 3": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם ג׳",
	"Pesach Chol ha-Moed Day 3 on Monday": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם ג׳ (בְּיוֹם שָׁנִי)",
	"Pesach Chol ha-Moed Day 4": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם ד׳",
	"Pesach Chol ha-Moed Day 5": "פֶּסַח חוֹל הַמּוֹעֵד יוֹם ה׳",
	"Pesach I": "פֶּסַח א׳",
	"Pesach I (on Shabbat)": "פֶּסַח יוֹם א׳ (בְּשַׁבָּת)",
	"Pesach II": "פֶּסַח ב׳",
	"Pesach II (CH''M)": "פֶּסַח ב׳ (חוה״מ)",
	"Pesach III (CH''M)": "פֶּסַח ג׳ (חוה״מ)",
	"Pesach IV (CH''M)": "פֶּסַח ד׳ (חוה״מ)",
	"Pesach Shabbat Chol ha-Moed": "פֶּסַח שַׁבָּת חוֹל הַמּוֹעֵד",
	"Pesach Sheni": "פֶּסַח שֵׁנִי",
	"Pesach V (CH''M)": "פֶּסַח ה׳ (חוה״מ)",
	"Pesach VI (CH''M)": "פֶּסַח ו׳ (חוה״מ)",
	"Pesach VII": "פֶּסַח ז׳",
	"Pesach VII (on Shabbat)": "פֶּסַח ז׳ (בְּשַׁבָּת)",
	"Pesach VIII": "פֶּסַח ח׳",
	"Pesach VIII (on Shabbat)": "פֶּסַח ח׳ (בְּשַׁבָּת)",
	"Pesachim": "פסחים",
	"Pinchas": "פִּינְחָס",
	"Pirkei Avot": "פִּרְקֵי אָבוֹת",
	"Plaintiff and Defendant": "הלכות טוען ונטען",
	"Positive Mitzvot": "מצוות עשה",
	"Prayer and the Priestly Blessing": "הלכות תפילה וברכת כהנים",
	"Proverbs": "מִשְׁלֵי",
	"Psalms": "תְּהִלִּים",
	"Psichah": "פתיחה",
	"Purim": "פּוּרִים",
	"Purim Katan": "פּוּרִים קָטָן",
	"Purim Meshulash": "פּוּרִים מְשׁוּלָּשׁ",
	"Re'eh": "רְאֵה",
	"Reading the Shema": "הלכות קריאת שמע",
	"Rebels": "הלכות ממרים",
	"Red Heifer": "הלכות פרה אדומה",
	"Repentance": "הלכות תשובה",
	"Rest on a Holiday": "הלכות שביתת יום טוב",
	"Rest on the Tenth of Tishrei": "הלכות שביתת עשור",
	"Ritual Slaughter": "הלכות שחיטה",
	"Robbery and Lost Property": "הלכות גזילה ואבידה",
	"Rosh Chodesh": "רֹאשׁ חוֹדֶשׁ",
	"Rosh Chodesh %s": "רֹאשׁ חוֹדֶשׁ %s",
	"Rosh Chodesh Adar": "רֹאשׁ חוֹדֶשׁ אֲדָר",
	"Rosh Chodesh Adar I": "רֹאשׁ חוֹדֶשׁ אֲדָר א׳",
	"Rosh Chodesh Adar II": "רֹאשׁ חוֹדֶשׁ אֲדָר ב׳",
	"Rosh Chodesh Av": "רֹאשׁ חוֹדֶשׁ אָב",
	"Rosh Chodesh Cheshvan": "רֹאשׁ חוֹדֶשׁ חֶשְׁוָן",
	"Rosh Chodesh Elul": "רֹאשׁ חוֹדֶשׁ אֱלוּל",
	"Rosh Chodesh Iyyar": "רֹאשׁ חוֹדֶשׁ אִיָּיר",
	"Rosh Chodesh Kislev": "רֹאשׁ חוֹדֶשׁ כִּסְלֵו",
	"Rosh Chodesh Nisan": "רֹאשׁ חוֹדֶשׁ נִיסָן",
	"Rosh Chodesh Sh'vat": "רֹאשׁ חוֹדֶשׁ שְׁבָט",
	"Rosh Chodesh Sivan": "רֹאשׁ חוֹדֶשׁ סִיוָן",
	"Rosh Chodesh Tammuz": "רֹאשׁ חוֹדֶשׁ תַּמּוּז",
	"Rosh Chodesh Tamuz": "רֹאשׁ חוֹדֶשׁ תַּמּוּז",
	"Rosh Chodesh Tevet": "רֹאשׁ חוֹדֶשׁ טֵבֵת",
	"Rosh Hashana": "רֹאשׁ הַשָּׁנָה",
	"Rosh Hashana I": "רֹאשׁ הַשָּׁנָה א׳",
	"Rosh Hashana I (on Shabbat)": "רֹאשׁ הַשָּׁנָה יוֹם א׳ (בְּשַׁבָּת)",
	"Rosh Hashana II": "רֹאשׁ הַשָּׁנָה ב׳",
	"Rosh Hashana LaBehemot": "רֹאשׁ הַשָּׁנָה לְמַעְשַׂר בְּהֵמָה",
	"Rosh Hashanah": "ראש השנה",
	"Ruth": "רוּת",
	"Sabbath": "הלכות שבת",
	"Sabbatical Year and the Jubilee": "הלכות שמיטה ויובל",
	"Sacrifices Rendered Unfit": "הלכות פסולי המוקדשין",
	"Sacrificial Procedure": "הלכות מעשה הקרבנות",
	"Sales": "הלכות מכירה",
	"Samuel": "שְׁמוּאֵל",
	"Sanctification of the New Month": "הלכות קידוש החודש",
	"Sanhedrin": "סנהדרין",
	"Scroll of Esther and Hanukkah": "הלכות מגילה וחנוכה",
	"Second Tithes and Fourth Year's Fruit": "הלכות מעשר שני ונטע רבעי",
	"Service on the Day of Atonement": "הלכות עבודת יום הכפורים",
	"Sh'lach": "שְׁלַח־לְךָ",
	"Sh'vat": "שְׁבָט",
	"Shabbat": "שַׁבָּת",
	"Shabbat Chazon": "שַׁבַּת חֲזוֹן",
	"Shabbat HaChodesh": "שַׁבַּת הַחֹדֶשׁ",
	"Shabbat HaGadol": "שַׁבַּת הַגָּדוֹל",
	"Shabbat Machar Chodesh": "שַׁבָּת מָחָר חוֹדֶשׁ",
	"Shabbat Mevarchim Chodesh": "שַׁבַּת מְבָרְכִים חוֹדֶשׁ",
	"Shabbat Nachamu": "שַׁבַּת נַחֲמוּ",
	"Shabbat Parah": "שַׁבַּת פָּרָה",
	"Shabbat Rosh Chodesh": "שַׁבָּת רֹאשׁ חוֹדֶשׁ",
	"Shabbat Rosh Chodesh Chanukah": "שַׁבָּת רֹאשׁ חוֹדֶשׁ חֲנוּכָּה",
	"Shabbat Shekalim": "שַׁבַּת שְׁקָלִים",
	"Shabbat Shirah": "שַׁבַּת שִׁירָה",
	"Shabbat Shuva": "שַׁבַּת שׁוּבָה",
	"Shabbat Zachor": "שַׁבַּת זָכוֹר",
	"Shabbat times for": "זמני שַׁבָּת",
	"Shar Hatorah": "שער התורה",
	"Shar Hatvuna": "שער התבונה",
	"Shar Hazechira": "שער הזכירה",
	"Shavuot": "שָׁבוּעוֹת",
	"Shavuot I": "שָׁבוּעוֹת א׳",
	"Shavuot II": "שָׁבוּעוֹת ב׳",
	"Shavuot II (on Shabbat)": "שָׁבוּעוֹת יוֹם ב׳ (בְּשַׁבָּת)",
	"Shekalim": "שקלים",
	"Shemirat HaLashon": "שְׁמִירַת הַלָּשׁוֹן",
	"Shemot": "שְׁמוֹת",
	"Sheqel Dues": "הלכות שקלים",
	"Sheviit": "שביעית",
	"Shevuot": "שבועות",
	"Shmini": "שְּׁמִינִי",
	"Shmini Atzeret": "שְׁמִינִי עֲצֶרֶת",
	"Shmini Atzeret (on Shabbat)": "שְׁמִינִי עֲצֶרֶת (בְּשַׁבָּת)",
	"Shofar, Sukkah and Lulav": "הלכות שופר וסוכה ולולב",
	"Shoftim": "שׁוֹפְטִים",
	"Shushan Purim": "שׁוּשָׁן פּוּרִים",
	"Shushan Purim Katan": "שׁוּשָׁן פּוּרִים קָטָן",
	"Sigd": "חַג הַסִּיגְד",
	"Simchat Torah": "שִׂמְחַת תּוֹרָה",
	"Sivan": "סִיוָן",
	"Slaves": "הלכות עבדים",
	"Song of Songs": "שִׁיר הַשִּׁירִים",
	"Sotah": "סוטה",
	"Splendor": "הוֹד",
	"Substitution": "הלכות תמורה",
	"Sukkah": "סוכה",
	"Sukkot": "סוּכּוֹת",
	"Sukkot Chol ha-Moed Day 1": "סוּכּוֹת חוֹל הַמּוֹעֵד יוֹם א׳",
	"Sukkot Chol ha-Moed Day 2": "סוּכּוֹת חוֹל הַמּוֹעֵד יוֹם ב׳",
	"Sukkot Chol ha-Moed Day 3": "סוּכּוֹת חוֹל הַמּוֹעֵד יוֹם ג׳",
	"Sukkot Chol ha-Moed Day 4": "סוּכּוֹת חוֹל הַמּוֹעֵד יוֹם ד׳",
	"Sukkot Chol ha-Moed Day 5": "סוּכּוֹת חוֹל הַמּוֹעֵד יוֹם ה׳",
	"Sukkot Final Day (Hoshana Raba)": "סוּכּוֹת ז׳ (הוֹשַׁעְנָא רַבָּה)",
	"Sukkot I": "סוּכּוֹת א׳",
	"Sukkot I (on Shabbat)": "סוּכּוֹת יוֹם א׳ (בְּשַׁבָּת)",
	"Sukkot II": "סוּכּוֹת ב׳",
	"Sukkot II (CH''M)": "סוּכּוֹת ב׳ (חוה״מ)",
	"Sukkot III (CH''M)": "סוּכּוֹת ג׳ (חוה״מ)",
	"Sukkot IV (CH''M)": "סוּכּוֹת ד׳ (חוה״מ)",
	"Sukkot Shabbat Chol ha-Moed": "סוּכּוֹת שַׁבָּת חוֹל הַמּוֹעֵד",
	"Sukkot V (CH''M)": "סוּכּוֹת ה׳ (חוה״מ)",
	"Sukkot VI (CH''M)": "סוּכּוֹת ו׳ (חוה״מ)",
	"Sukkot VII (Hoshana Raba)": "סוּכּוֹת ז׳ (הוֹשַׁעְנָא רַבָּה)",
	"Ta'anit Bechorot": "תַּעֲנִית בְּכוֹרוֹת",
	"Ta'anit Bechorot (Mincha)": "תַּעֲנִית בְּכוֹרוֹת מִנחָה",
	"Ta'anit Esther": "תַּעֲנִית אֶסְתֵּר",
	"Ta'anit Esther (Mincha)": "תַּעֲנִית אֶסְתֵּר מִנחָה",
	"Taanit": "תענית",
	"Tahorot": "טהרות",
	"Tamid": "תמיד",
	"Tammuz": "תַּמּוּז",
	"Tamuz": "תַּמּוּז",
	"Tanakh Yomi": "תנ״ך יוֹמִי",
	"Tazria": "תַזְרִיעַ",
	"Tefillin, Mezuzah and the Torah Scroll": "הלכות תפילין ומזוזה וספר תורה",
	"Temurah": "תמורה",
	"Terumah": "תְּרוּמָה",
	"Terumot": "תרומות",
	"Testimony": "הלכות עדות",
	"Tetzaveh": "תְּצַוֶּה",
	"Tevet": "טֵבֵת",
	"Tevul Yom": "טבול יום",
	"The Chosen Temple": "הלכות בית הבחירה",
	"The Order of Prayer": "סדר התפילה",
	"The Sanhedrin and the Penalties within their Jurisdiction": "הלכות סנהדרין והעונשין המסורין להם",
	"Theft": "הלכות גניבה",
	"Things Forbidden on the Altar": "הלכות איסורי המזבח",
	"This week's Torah portion is": "פָּרָשַׁת הַשָּׁבוּעַ הִיא",
	"Those Who Defile Bed or Seat": "הלכות מטמאי משכב ומושב",
	"Tish'a B'Av": "תִּשְׁעָה בְּאָב",
	"Tish'a B'Av (Mincha)": "תִּשְׁעָה בְּאָב מִנחָה",
	"Tish'a B'Av (observed)": "(תִּשְׁעָה בְּאָב (נִדְחָה",
	"Tishrei": "תִּשְׁרֵי",
	"Tithes": "הלכות מעשרות",
	"Toldot": "תּוֹלְדוֹת",
	"Torah Study": "הלכות תלמוד תורה",
	"Transmission of the Oral Law": "מסירת תורה שבעל פה",
	"Trespass": "הלכות מעילה",
	"Tu B'Av": "ט״וּ בְּאָב",
	"Tu B'Shvat": "ט״וּ בִּשְׁבָט",
	"Tu BiShvat": "ט״וּ בִּשְׁבָט",
	"Tzav": "צַו",
	"Tziyurim": "ציורים",
	"Tzom Gedaliah": "צוֹם גְּדַלְיָה",
	"Tzom Gedaliah (Mincha)": "צוֹם גְּדַלְיָה מִנחָה",
	"Tzom Tammuz": "צוֹם י״ז בְּתַמּוּז",
	"Tzom Tammuz (Mincha)": "צוֹם י״ז בְּתַמּוּז מִנחָה",
	"Vaera": "וָאֵרָא",
	"Vaetchanan": "וָאֶתְחַנַּן",
	"Vayakhel": "וַיַּקְהֵל",
	"Vayechi": "וַיְחִי",
	"Vayeilech": "וַיֵּלֶךְ",
	"Vayera": "וַיֵּרָא",
	"Vayeshev": "וַיֵּשֶׁב",
	"Vayetzei": "וַיֵּצֵא",
	"Vayigash": "וַיִּגַּשׁ",
	"Vayikra": "וַיִּקְרָא",
	"Vayishlach": "וַיִּשְׁלַח",
	"Vessels": "הלכות כלים",
	"Vessels of the Sanctuary and Those who Serve Therein": "הלכות כלי המקדש והעובדין בו",
	"Vezot Haberakhah": "וְזֹאת הַבְּרָכָה",
	"Virgin Maiden": "הלכות נערה בתולה",
	"Vows": "הלכות נדרים",
	"Woman Suspected of Infidelity": "הלכות סוטה",
	"Yadayim": "ידים",
	"Yerushalmi": "יְרוּשַׁלְמִי",
	"Yerushalmi Yomi": "יְרוּשַׁלְמִי יוֹמִי",
	"Yevamot": "יבמות",
	"Yitro": "יִתְרוֹ",
	"Yitzhak Rabin Memorial Day": "יוֹם הַזִּכָּרוֹן לְיִצְחָק רַבִּין",
	"Yizkor": "יִזְכּוֹר",
	"Yom HaAliyah": "יוֹם הַעֲלִיָּה",
	"Yom HaAliyah School Observance": "שְׁמִירָת בֵּית הַסֵפֶר לְיוֹם הַעֲלִיָּה",
	"Yom HaAtzma'ut": "יוֹם הָעַצְמָאוּת",
	"Yom HaShoah": "יוֹם הַשּׁוֹאָה",
	"Yom HaZikaron": "יוֹם הַזִּכָּרוֹן",
	"Yom Kippur": "יוֹם כִּפּוּר",
	"Yom Kippur (Mincha)": "יוֹם כִּפּוּר מִנחָה",
	"Yom Kippur (Mincha, Alternate)": "יוֹם כִּפּוּר מִנחָה",
	"Yom Kippur (Mincha, Traditional)": "יוֹם כִּפּוּר מִנחָה",
	"Yom Kippur (on Shabbat)": "יוֹם כִּפּוּר (בְּשַׁבָּת)",
	"Yom Kippur Katan": "יוֹם כִּפּוּר קָטָן",
	"Yom Yerushalayim": "יוֹם יְרוּשָׁלַיִם",
	"Yoma": "יומא",
	"Yoreh De'ah": "יורה דעה",
	"Zavim": "זבים",
	"Zechariah": "זְכַרְיָה",
	"Zephaniah": "צְפַנְיָה",
	"Zevachim": "זבחים",
	"chalakim": "חֲלָקִים",
	"day": "יוֹם",
	"day of the Omer": "בָּעוֹמֶר",
	"min": "דַּקּוֹת",
	"occurs on": "חָל",
}

func Lookup_he(s string) (string, bool) {
	v, ok := dict_he[s]
	if ok {
		return v, true
	}
	return s, false
}
