package locales

var dict_ro = map[string]string{
	"Achrei Mot": "Aĥrei Mot",
	"Arachin": "Araĥin",
	"Baba Kamma": "Baba Cama",
	"Baba Metzia": "Baba Meţia",
	"Bechorot": "Beĥorot",
	"Bechukotai": "Beĥucoitai",
	"Beha'alotcha": "Behaalotĥa",
	"Beitzah": "Beiţah",
	"Berachot": "Beraĥot",
	"Bereshit": "Bereşit",
	"Beshalach": "Beşalah",
	"Bo": "Boe",
	"Candle lighting": "Lunânare Candelă",
	"Chagigah": "Chaguigah",
	"Chanukah": "Ĥánuca",
	"Chanukah: 1 Candle": "Ĥanucá: 1 candela",
	"Chanukah: 2 Candles": "Ĥanucá: 2 candele",
	"Chanukah: 3 Candles": "Ĥanucá: 3 candele",
	"Chanukah: 4 Candles": "Ĥanucá: 4 candele",
	"Chanukah: 5 Candles": "Ĥanucá: 5 candele",
	"Chanukah: 6 Candles": "Ĥanucá: 6 candele",
	"Chanukah: 7 Candles": "Ĥanucá: 7 candele",
	"Chanukah: 8 Candles": "Ĥanucá: 8 candele",
	"Chanukah: 8th Day": "Ĥanucá: a 8-a zi",
	"Chayei Sara": "Ĥaiei Sara",
	"Cheshvan": "Ĥeşvan",
	"Chukat": "Ĥukat",
	"Chullin": "Ĥulin",
	"Daf Yomi": "Daf Ioimi",
	"Date out of range in input file. Skipping line %s": "Fecha fuera de rango en el archivo de entrada. Saltando la línea %s",
	"Date out of range in yahrtzeit file. Skipping line %s": "Dată în afara gamei în fişierul iahrţeit. Trecere peste linia %s",
	"Days of the Omer": "Zilele de Omer",
	"Devarim": "Davarim",
	"Eikev": "Eiqev",
	"Erev Pesach": "Erev Peisaĥ",
	"Erev Rosh Hashana": "Erev Roş Haşana",
	"Erev Shavuot": "Erev Şavuot",
	"Erev Simchat Torah": "Erev Simĥat Tora",
	"Erev Sukkot": "Erev Sucot",
	"Erev Yom Kippur": "Erev Iom Chipur",
	"Error in input file.  Skipping line %s": "Eroare în fişier de intrare.  Trecere peste linia %s",
	"Error in yahrtzeit file.  Skipping line %s": "Eroare în fişierul iahrţeit.  Trecere peste linia %s",
	"Fast begins": "Postul începe",
	"Fast ends": "Postul se încheie",
	"Ha'azinu": "Haazinu",
	"Horayot": "Horaiot",
	"Iyyar": "Aiar",
	"Kedoshim": "Qâdoşim",
	"Keritot": "Cheritot",
	"Ketubot": "Chetubot",
	"Ki Tavo": "Chi Tavo",
	"Ki Teitzei": "Chi Teiţei",
	"Ki Tisa": "Chi Tisa",
	"Kiddushin": "Chiduşin",
	"Kinnim": "Chinim",
	"Kislev": "Chislev",
	"Korach": "Coraĥ",
	"Lech-Lecha": "Lecî-Leka",
	"Leil Selichot": "Leil Seliĥot",
	"Makkot": "Makot",
	"Meilah": "Meila",
	"Menachot": "Menajot",
	"Metzora": "Meţora",
	"Miketz": "Miqeţ",
	"Mishpatim": "Mişpatim",
	"Moed Katan": "Moed Catan",
	"Nasso": "Naso",
	"Niddah": "Nida",
	"Nitzavim": "Niţavim",
	"Noach": "Noaĥ",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Lună non-numerică în fişierul iahrţeit. Trecere peste linia %s",
	"Numeric hebrew month in input file.  Skipping line %s": "Lună ebraică în fişier intrare.  Trecere peste linia %s",
	"Parashat": "Paraşat",
	"Pekudei": "Pequdei",
	"Pesach": "Pesaĥ",
	"Pesach Chol ha-Moed Day 1": "Pesaĥ Cal ha-Moed Ziua 1",
	"Pesach Chol ha-Moed Day 2": "Pesaĥ Cal ha-Moed Ziua 2",
	"Pesach Chol ha-Moed Day 3": "Pesaĥ Cal ha-Moed Ziua 3",
	"Pesach Chol ha-Moed Day 4": "Pesaĥ Cal ha-Moed Ziua 4",
	"Pesach I": "Pesaĥ I",
	"Pesach I (on Shabbat)": "Pesaĥ I (în sabat)",
	"Pesach II": "Pesaĥ II",
	"Pesach II (CH''M)": "Pesaĥ II (Ca''M)",
	"Pesach III (CH''M)": "Pesaĥ III (Ca''M)",
	"Pesach IV (CH''M)": "Pesaĥ IV (Ca''M)",
	"Pesach Shabbat Chol ha-Moed": "Pesaĥ Şavat Cal ha-Moed",
	"Pesach Sheni": "Pesaĥ Şeni",
	"Pesach V (CH''M)": "Pesaĥ V (Ca''M)",
	"Pesach VI (CH''M)": "Pesaĥ VI (Ca''M)",
	"Pesach VII": "Pesaĥ VII",
	"Pesach VIII": "Pesaĥ VIII",
	"Pesachim": "Pesaĥim",
	"Pinchas": "Pinĥas",
	"Re'eh": "Re´eh",
	"Rosh Chodesh": "Roş Ĥodeş",
	"Rosh Chodesh %s": "Roş Ĥodeş %s",
	"Rosh Chodesh Adar": "Roş Ĥodeş Adar",
	"Rosh Chodesh Adar I": "Roş Ĥodeş Adar I",
	"Rosh Chodesh Adar II": "Roş Ĥodeş Adar II",
	"Rosh Chodesh Av": "Roş Ĥodeş Av",
	"Rosh Chodesh Cheshvan": "Roş Ĥodeş Ĥeşvan",
	"Rosh Chodesh Elul": "Roş Ĥodeş Elul",
	"Rosh Chodesh Iyyar": "Roş Ĥodeş Aiar",
	"Rosh Chodesh Kislev": "Roş Ĥodeş Chislev",
	"Rosh Chodesh Nisan": "Roş Ĥodeş Nisan",
	"Rosh Chodesh Sh'vat": "Roş Ĥodeş Şâvat",
	"Rosh Chodesh Sivan": "Roş Ĥodeş Sivan",
	"Rosh Chodesh Tamuz": "Roş Ĥodeş Tamuz",
	"Rosh Chodesh Tevet": "Roş Ĥodeş Tevet",
	"Rosh Hashana": "Roş Haşana",
	"Rosh Hashana I": "Roş Haşana I",
	"Rosh Hashana I (on Shabbat)": "Roş Haşana I (în sabat)",
	"Rosh Hashana II": "Roş Haşana II",
	"Sanhedrin": "Sanedrin",
	"Sh'lach": "Şâlaĥ",
	"Sh'vat": "Şâvat",
	"Shabbat": "Şavat",
	"Shabbat Chazon": "Şavat Ĥazon",
	"Shabbat HaChodesh": "Şavat HaĤodeş",
	"Shabbat HaGadol": "Şavat HaGadol",
	"Shabbat Machar Chodesh": "Şavat Maĥar Ĥodeş",
	"Shabbat Nachamu": "Şavat Naĥamu",
	"Shabbat Parah": "Şavat Parah",
	"Shabbat Rosh Chodesh": "Şavat Roş Ĥodeş",
	"Shabbat Shekalim": "Şavat Şeqalim",
	"Shabbat Shuva": "Şavat Şuvah",
	"Shabbat Zachor": "Şavat Zaĥor",
	"Shavuot": "Şavuot",
	"Shavuot I": "Şavuot I",
	"Shavuot II": "Şavuot II",
	"Shavuot II (on Shabbat)": "Şavuot II (în sabat)",
	"Shekalim": "Şeqalim",
	"Shemot": "Şemot",
	"Shevuot": "Şavuot",
	"Shmini": "Şmini",
	"Shmini Atzeret": "Şâmini Aţeret",
	"Shoftim": "Şoftim",
	"Shushan Purim": "Şuşan Purim",
	"Simchat Torah": "Simĥat Tora",
	"Sukkah": "Suca",
	"Sukkot": "Sucot",
	"Sukkot Chol ha-Moed Day 1": "Sucot Cal ha-Moed Ziua 1",
	"Sukkot Chol ha-Moed Day 2": "Sucot Cal ha-Moed Ziua 2",
	"Sukkot Chol ha-Moed Day 3": "Sucot Cal ha-Moed Ziua 3",
	"Sukkot Chol ha-Moed Day 4": "Sucot Cal ha-Moed Ziua 4",
	"Sukkot Final Day (Hoshana Raba)": "Ziua finală de Sucot (Hoşana Raba)",
	"Sukkot I": "Sucot I",
	"Sukkot I (on Shabbat)": "Sucot I (în sabat)",
	"Sukkot II": "Sucot II",
	"Sukkot II (CH''M)": "Sucot II (Ca''M)",
	"Sukkot III (CH''M)": "Sukot III (Ca''M)",
	"Sukkot IV (CH''M)": "Sukot IV (Ca''M)",
	"Sukkot Shabbat Chol ha-Moed": "Sucot Şavat Cal ha-Moed",
	"Sukkot V (CH''M)": "Sukot V (Ca''M)",
	"Sukkot VI (CH''M)": "Sukot VI (Ca''M)",
	"Sukkot VII (Hoshana Raba)": "Sukot VII (Hoşana Raba)",
	"Ta'anit Bechorot": "Ta'anit Beĥorot",
	"Ta'anit Esther": "Ta'anit Ester",
	"Taanit": "Tanit",
	"Tetzaveh": "Teţaveh",
	"Tish'a B'Av (observed)": "Tish'a B'Av (observat)",
	"Tishrei": "Tişrei",
	"Tu B'Shvat": "Tu BîShâvat",
	"Tu BiShvat": "Tu BiŞâvat",
	"Tzav": "Ţav",
	"Tzom Gedaliah": "Ţom Gedaliah",
	"Tzom Tammuz": "Ţom Tamuz",
	"Unable to allocate memory for holiday.": "Imposibil de alocat memorie pemtru sărbătorea.",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Lună ebraică nerecunoscută în fişier intrare.  Trecere peste linia %s",
	"Vaera": "Uaera",
	"Vaetchanan": "Uâetĥanen",
	"Vayakhel": "Uaiaqâhel",
	"Vayechi": "Uaieĥi",
	"Vayeilech": "Uaieleĥ",
	"Vayera": "Uaiera",
	"Vayeshev": "Uaieşev",
	"Vayetzei": "Uaieţe",
	"Vayigash": "Uaiigaş",
	"Vayikra": "Uaiiqra",
	"Vayishlach": "Uaişâlaĥ",
	"Vezot Haberakhah": "Uezot Haberaha",
	"Yevamot": "Ievamot",
	"Yitro": "Iitro",
	"Yom HaAliyah": "Iom Ieruşalaiim",
	"Yom HaAtzma'ut": "Iom HaAţma'ut",
	"Yom HaShoah": "Iom HaŞoah",
	"Yom HaZikaron": "Iom HaZikaron",
	"Yom Kippur": "Iom Chipur",
	"Yom Kippur (Mincha, Alternate)": "Iom Chipur (Minĥa, Alternare)",
	"Yom Kippur (Mincha, Traditional)": "Iom Chipur (Minĥa, Tradiţional)",
	"Yom Kippur (on Shabbat)": "Iom Chipur (în sabat)",
	"Yom Kippur Katan": "Iom Chipur Catan",
	"Yom Yerushalayim": "Iom Ieruşalaiim",
	"Yoma": "Ioma",
	"Zevachim": "Zevahim",
	"day": "zi",
	"day of the Omer": "ziuă de Omer",
	"improper sedra year type calculated.": "tip de an sedra inpropriu calculat.",
	"input file read error. Skipping line %s": "eroare citire fişier de intrare. Trecere peste linia %s",
	"yahrtzeit file read error. Skipping line %s": "eroare citire fişier iahrţeit. Trecere peste linia %s",
}

func Lookup_ro(s string) (string, bool) {
	v, ok := dict_ro[s]
	if ok {
		return v, true
	}
	return s, false
}
