#####################################################################
# c2man_pkg.mk

# Prerequisite: create_am_macros.mk

# The caller must specify the following variables:
#	C2MAN_DESTDIR - where the output will go

# The caller may specify the following variables:
#	C2MAN_SEC_LEVEL - defaults to 2
#       C2MAN_DEPS      - extra things that the stamp file will depend upon

#####################################################################

# hokey, but c2man relies upon the name of the file on the command
# line being the same as what's spit out by the preprocessor, and gcc
# removes any './' path chunks, which causes c2man to produce no
# output whatsoever if the filename begins with ./. of course, that's
# what $(srcdir) might be...
$(C2MAN_STAMP): $(C2MAN_SRCS) $(C2MAN_DEPS)
	if test -z "$(C2MAN_DESTDIR)"; then \
	  echo 'ERROR: must set C2MAN_DESTDIR variable: see snippets/c2man_pkg.mk' ;\
	  exit 1 ;\
	fi
	test -d $(C2MAN_DESTDIR) || install-sh -d $(C2MAN_DESTDIR)
	@rm -f $@.tmp
	@touch $@.tmp
	C2MAN_SEC_LEVEL="$(C2MAN_SEC_LEVEL)"; \
	if test -z "$$C2MAN_SEC_LEVEL"; then \
	  C2MAN_SEC_LEVEL=2; \
	fi ;\
	for src in $(C2MAN_SRCS) ; do\
	  c2man -e -T t,t,n,s$$C2MAN_SEC_LEVEL,C -k \
              -x 'SEE ALSO'  -l n \
              -s -F"int f(\n  a,\n  b\n)" \
	      -o $(C2MAN_DESTDIR) $(C2MAN_FLAGS) \
			`echo $$src | sed 's:^./::g'` ;\
	done
	@mv -f $@.tmp $@

MAINTAINERCLEANFILES	+= $(C2MAN_STAMP)
EXTRA_DIST		+= $(C2MAN_STAMP)
#####################################################################
