#============================================================================
# install_dir.mk

# this snippet defines a sequence of shell commands which will
#
#  * recursively copy a directory to a destination.
#  * uninstall an installed directory

# during the install it first checks for the directory in the current
# directory; if it is not found there, it assumes it is in $srcdir.

# during the uninstall it removes only those files which are found in
# the provided original source directory.  that directory may be in
# the current directory, else it is assumed to be in $srcdir

# To use this, set these shell variables
#
#  src_dir - the directory holding the original files
#  dst_dir - the directory where the files are to be installed
#
# and then interpolate $(install_dir) and $(uninstall_dir).  For example
#
#  src_dir=$(_HTML); dst_dir=$(htmldir); $(install_dir)

install_dir =	\
	$(mkinstalldirs) $(DESTDIR)$${dst_dir}; \
	if test -d "$${src_dir}"; then d=; else d="$(srcdir)/"; fi; \
	for p in $$d$${src_dir}/*; do \
	  f=$(strip_dir) \
	  echo " cp -R $$p $(DESTDIR)$${dst_dir}/$$f"; \
	  cp -R $$p $(DESTDIR)$${dst_dir}/$$f; \
	done

uninstall_dir =	\
	if test -d "$${src_dir}"; then d=; else d="$(srcdir)/"; fi; \
	for p in $$d$${src_dir}/*; do \
	  f=$(strip_dir) \
	  echo " rm -rf $(DESTDIR)$${dst_dir}/$$f"; \
	  rm -rf $(DESTDIR)$${dst_dir}/$$f; \
	done
