/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of tracefct
 *
 * tracefct is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * tracefct is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <stdio.h>
#include <stddef.h>
#include "tracefct.h"


static
void f2( void )
{
#ifndef F2NOENTER
  tf_enter( "f2" );
#endif

  tf_message( "message test: %g\n", 33.2 );
  tf_message( "f2 stack dump:\n" );
  tf_dump_stack( );

#ifdef F2EXIT
  tf_exit( 1, "f2 exit: line1\nf2 exit: line2" );
#endif

#ifndef F2NOLEAVE
  tf_leave( );
#endif
}

static
void f1( void )
{
#ifndef F1NOENTER
  tf_enter( "f1" );
#endif

  f2();

#ifdef F1EXIT
  tf_exit( 1, "f1 exit: line1\nf1 exit: line2, extra newline\n" );
#endif

#ifndef F1NOLEAVE
  tf_leave( );
#endif
}

int main( int argc, char * argv[] )
{
  int print_it = 0 ;
  int num_fct_to_print = -1 ;
  char *logfile = NULL;

  if ( argc > 1 )
    print_it = atoi(argv[1]);

  if ( argc > 2 )
    num_fct_to_print = atoi(argv[2]);


  if ( argc > 3 )
    logfile = argv[3];

#ifndef NOINIT
  tf_init( "foo", print_it, num_fct_to_print );
#endif

  if ( logfile )
    tf_open( logfile );
  
  f1();

#ifdef MAINEXIT
  tf_exit( 1, "main exit" );
#endif

#ifdef XTRALEAVE
  tf_message( "extra leave:\n" );
  tf_leave();
#endif

  tf_close( );
  
  tf_message( "main stack dump\n" );
  tf_dump_stack( );

  return EXIT_SUCCESS;
}

