#ifndef tracefct_h_INCLUDED
#define tracefct_h_INCLUDED

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of tracefct
 *
 * tracefct is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * tracefct is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <stdlib.h>
#include <stdarg.h>

#ifdef __cplusplus

# define tf_assert(tf,ex)     _tf_assert(tf,ex)

#ifdef TF_ASSERT_LEVEL
#  if TF_ASSERT_LEVEL > 0
#    define tf_assert1(tf,ex)     _tf_assert(tf,ex)
#    if TF_ASSERT_LEVEL > 1
#      define tf_assert2(tf,ex)     _tf_assert(tf,ex)
#      if TF_ASSERT_LEVEL > 2
#        define tf_assert3(tf,ex)     _tf_assert(tf,ex)
#        if TF_ASSERT_LEVEL > 3
#          define tf_assert4(tf,ex)     _tf_assert(tf,ex)
#          if TF_ASSERT_LEVEL > 4
#            define tf_assert5(tf,ex)     _tf_assert(tf,ex)
#          endif  /* TF_ASSERT_LEVEL > 4 */
#        endif  /* TF_ASSERT_LEVEL > 3 */
#      endif  /* TF_ASSERT_LEVEL > 2 */
#    endif  /* TF_ASSERT_LEVEL > 1 */
#  endif  /* TF_ASSERT_LEVEL > 0 */
#endif  /* TF_ASSERT_LEVEL     */

#ifndef tf_assert1
#  define tf_assert1(tf,ex)
#endif

#ifndef tf_assert2
#  define tf_assert2(tf,ex)
#endif

#ifndef tf_assert3
#  define tf_assert3(tf,ex)
#endif

#ifndef tf_assert4
#  define tf_assert4(tf,ex)
#endif

#ifndef tf_assert5
#  define tf_assert5(tf,ex)
#endif


# define _tf_assert(tf,ex)    \
  do									\
  {									\
    if (!(ex))								\
      tf.exit( -3, "Assertion failed: file\"%s\", line %d\n%s\n",	\
	    __FILE__, __LINE__, #ex);					\
  } while(0)

class TraceFct {
 public:
  TraceFct( const char * name );
  TraceFct( const char *name, int print_it, int num_fct_to_print );
  ~TraceFct( );

  void exit (int exit_code, const char *format, ...);
  void message (const char *format, ...);
  void vmessage (const char *format, va_list args);
  void dump_stack (void);
  int  open( const char *filename );
  void close(void);

 private:
  static char *progname;
  
  void init (const char *name, int print_it, int num_fct_to_print);
  void enter (const char *name);
  void leave( void );
};

#else /* __cplusplus */

# define tf_assert(ex)     _tf_assert(ex)

#ifdef TF_ASSERT_LEVEL
#  if TF_ASSERT_LEVEL > 0
#    define tf_assert1(ex)     _tf_assert(ex)
#    if TF_ASSERT_LEVEL > 1
#      define tf_assert2(ex)     _tf_assert(ex)
#      if TF_ASSERT_LEVEL > 2
#        define tf_assert3(ex)     _tf_assert(ex)
#        if TF_ASSERT_LEVEL > 3
#          define tf_assert4(ex)     _tf_assert(ex)
#          if TF_ASSERT_LEVEL > 4
#            define tf_assert5(ex)     _tf_assert(ex)
#          endif  /* TF_ASSERT_LEVEL > 4 */
#        endif  /* TF_ASSERT_LEVEL > 3 */
#      endif  /* TF_ASSERT_LEVEL > 2 */
#    endif  /* TF_ASSERT_LEVEL > 1 */
#  endif  /* TF_ASSERT_LEVEL > 0 */
#endif  /* TF_ASSERT_LEVEL     */

#ifndef tf_assert1
#  define tf_assert1(ex)
#endif

#ifndef tf_assert2
#  define tf_assert2(ex)
#endif

#ifndef tf_assert3
#  define tf_assert3(ex)
#endif

#ifndef tf_assert4
#  define tf_assert4(ex)
#endif

#ifndef tf_assert5
#  define tf_assert5(ex)
#endif


# define _tf_assert(ex)    \
  do									\
  {									\
    if (!(ex))								\
      tf_exit( -3, "Assertion failed: file\"%s\", line %d\n%s\n",	\
	    __FILE__, __LINE__, #ex);					\
  } while(0)

extern void tf_init (const char *name, int print_it, int num_fct_to_print);
extern void tf_enter (const char *name);
extern void tf_leave (void);
extern void tf_exit (int exit_code, const char *format, ...);
extern void tf_die (const char *format, ...);

extern void tf_message (const char *format, ...);
extern void tf_vmessage (const char *format, va_list args);
extern void tf_dump_stack (void);
extern int  tf_open( const char *filename );
extern void tf_close(void);

#endif /* __cplusplus */


#endif  /* ! tracefct_h_INCLUDED */
